/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.ChangesetCellRenderer;
import org.openstreetmap.josm.gui.io.ChangesetCommentModel;
import org.openstreetmap.josm.gui.io.CloseChangesetTask;
import org.openstreetmap.josm.gui.io.DownloadOpenChangesetsTask;
import org.openstreetmap.josm.gui.io.OpenChangesetComboBoxModel;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ChangesetManagementPanel
extends JPanel
implements ListDataListener {
    static final String SELECTED_CHANGESET_PROP = ChangesetManagementPanel.class.getName() + ".selectedChangeset";
    static final String CLOSE_CHANGESET_AFTER_UPLOAD = ChangesetManagementPanel.class.getName() + ".closeChangesetAfterUpload";
    private JRadioButton rbUseNew;
    private JRadioButton rbExisting;
    private JosmComboBox<Changeset> cbOpenChangesets;
    private JCheckBox cbCloseAfterUpload;
    private OpenChangesetComboBoxModel model;

    public ChangesetManagementPanel(ChangesetCommentModel changesetCommentModel) {
        CheckParameterUtil.ensureParameterNotNull(changesetCommentModel, "changesetCommentModel");
        this.build();
        this.refreshGUI();
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        ButtonGroup bgUseNewOrExisting = new ButtonGroup();
        gc.gridwidth = 4;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(0, 0, 5, 0);
        this.add((Component)new JMultilineLabel(I18n.tr("Please decide what changeset the data is uploaded to and whether to close the changeset after the next upload.", new Object[0])), gc);
        gc.gridwidth = 4;
        gc.gridy = 1;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(0, 0, 0, 0);
        gc.anchor = 23;
        this.rbUseNew = new JRadioButton(I18n.tr("Upload to a new changeset", new Object[0]));
        this.rbUseNew.setToolTipText(I18n.tr("Open a new changeset and use it in the next upload", new Object[0]));
        bgUseNewOrExisting.add(this.rbUseNew);
        this.add((Component)this.rbUseNew, gc);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        gc.fill = 2;
        this.rbExisting = new JRadioButton(I18n.tr("Upload to an existing changeset", new Object[0]));
        this.rbExisting.setToolTipText(I18n.tr("Upload data to an already existing and open changeset", new Object[0]));
        bgUseNewOrExisting.add(this.rbExisting);
        this.add((Component)this.rbExisting, gc);
        gc.gridx = 1;
        gc.gridy = 2;
        gc.gridwidth = 1;
        gc.weightx = 1.0;
        this.model = new OpenChangesetComboBoxModel();
        ChangesetCache.getInstance().addChangesetCacheListener(this.model);
        this.cbOpenChangesets = new JosmComboBox<Changeset>(this.model);
        this.cbOpenChangesets.setToolTipText(I18n.tr("Select an open changeset", new Object[0]));
        this.cbOpenChangesets.setRenderer(new ChangesetCellRenderer());
        this.cbOpenChangesets.addItemListener(new ChangesetListItemStateListener());
        Dimension d = this.cbOpenChangesets.getPreferredSize();
        d.width = 200;
        this.cbOpenChangesets.setPreferredSize(d);
        d.width = 100;
        this.cbOpenChangesets.setMinimumSize(d);
        this.model.addListDataListener(this);
        this.add(this.cbOpenChangesets, gc);
        gc.gridx = 2;
        gc.gridy = 2;
        gc.weightx = 0.0;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        JButton btnRefresh = new JButton(new RefreshAction());
        btnRefresh.setMargin(new Insets(0, 0, 0, 0));
        this.add((Component)btnRefresh, gc);
        gc.gridx = 3;
        gc.gridy = 2;
        gc.gridwidth = 1;
        CloseChangesetAction closeChangesetAction = new CloseChangesetAction();
        JButton btnClose = new JButton(closeChangesetAction);
        btnClose.setMargin(new Insets(0, 0, 0, 0));
        this.cbOpenChangesets.addItemListener(closeChangesetAction);
        this.rbExisting.addItemListener(closeChangesetAction);
        this.add((Component)btnClose, gc);
        gc.gridx = 0;
        gc.gridy = 3;
        gc.gridwidth = 4;
        gc.weightx = 1.0;
        this.cbCloseAfterUpload = new JCheckBox(I18n.tr("Close changeset after upload", new Object[0]));
        this.cbCloseAfterUpload.setToolTipText(I18n.tr("Select to close the changeset after the next upload", new Object[0]));
        this.add((Component)this.cbCloseAfterUpload, gc);
        this.cbCloseAfterUpload.setSelected(Config.getPref().getBoolean("upload.changeset.close", true));
        this.cbCloseAfterUpload.addItemListener(new CloseAfterUploadItemStateListener());
        gc.gridx = 0;
        gc.gridy = 5;
        gc.gridwidth = 4;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        this.add((Component)new JPanel(), gc);
        this.rbUseNew.getModel().addItemListener(new RadioButtonHandler());
        this.rbExisting.getModel().addItemListener(new RadioButtonHandler());
    }

    protected void refreshGUI() {
        this.rbExisting.setEnabled(this.model.getSize() > 0);
        if (this.model.getSize() == 0 && !this.rbUseNew.isSelected()) {
            this.rbUseNew.setSelected(true);
        }
        this.cbOpenChangesets.setEnabled(this.model.getSize() > 0 && this.rbExisting.isSelected());
    }

    public void setSelectedChangesetForNextUpload(Changeset cs) {
        int idx = this.model.getIndexOf(cs);
        if (idx >= 0) {
            this.rbExisting.setSelected(true);
            this.model.setSelectedItem(cs);
        }
    }

    public Changeset getSelectedChangeset() {
        if (this.rbUseNew.isSelected()) {
            return null;
        }
        return (Changeset)this.cbOpenChangesets.getSelectedItem();
    }

    public boolean isCloseChangesetAfterUpload() {
        return this.cbCloseAfterUpload.isSelected();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.refreshGUI();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.refreshGUI();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.refreshGUI();
    }

    class CloseChangesetAction
    extends AbstractAction
    implements ItemListener {
        CloseChangesetAction() {
            this.putValue("SmallIcon", ImageProvider.get("closechangeset"));
            this.putValue("ShortDescription", I18n.tr("Close the currently selected open changeset", new Object[0]));
            this.refreshEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Changeset cs = (Changeset)ChangesetManagementPanel.this.cbOpenChangesets.getSelectedItem();
            if (cs == null) {
                return;
            }
            MainApplication.worker.submit(new CloseChangesetTask(Collections.singletonList(cs)));
        }

        protected void refreshEnabledState() {
            this.setEnabled(ChangesetManagementPanel.this.cbOpenChangesets.getModel().getSize() > 0 && ChangesetManagementPanel.this.cbOpenChangesets.getSelectedItem() != null && ChangesetManagementPanel.this.rbExisting.isSelected());
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.refreshEnabledState();
        }
    }

    class RefreshAction
    extends AbstractAction {
        RefreshAction() {
            this.putValue("ShortDescription", I18n.tr("Load the list of your open changesets from the server", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "refresh"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainApplication.worker.submit(new DownloadOpenChangesetsTask(ChangesetManagementPanel.this));
        }
    }

    class RadioButtonHandler
    implements ItemListener {
        RadioButtonHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (ChangesetManagementPanel.this.rbUseNew.isSelected()) {
                ChangesetManagementPanel.this.cbOpenChangesets.setEnabled(false);
                ChangesetManagementPanel.this.firePropertyChange(SELECTED_CHANGESET_PROP, null, null);
            } else if (ChangesetManagementPanel.this.rbExisting.isSelected()) {
                Changeset cs;
                ChangesetManagementPanel.this.cbOpenChangesets.setEnabled(true);
                if (ChangesetManagementPanel.this.cbOpenChangesets.getSelectedItem() == null) {
                    ChangesetManagementPanel.this.model.selectFirstChangeset();
                }
                if ((cs = (Changeset)ChangesetManagementPanel.this.cbOpenChangesets.getSelectedItem()) == null) {
                    return;
                }
                ChangesetManagementPanel.this.firePropertyChange(SELECTED_CHANGESET_PROP, null, cs);
            }
        }
    }

    class CloseAfterUploadItemStateListener
    implements ItemListener {
        CloseAfterUploadItemStateListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getItemSelectable() != ChangesetManagementPanel.this.cbCloseAfterUpload) {
                return;
            }
            switch (e.getStateChange()) {
                case 1: {
                    ChangesetManagementPanel.this.firePropertyChange(CLOSE_CHANGESET_AFTER_UPLOAD, false, true);
                    Config.getPref().putBoolean("upload.changeset.close", true);
                    break;
                }
                case 2: {
                    ChangesetManagementPanel.this.firePropertyChange(CLOSE_CHANGESET_AFTER_UPLOAD, true, false);
                    Config.getPref().putBoolean("upload.changeset.close", false);
                    break;
                }
            }
        }
    }

    class ChangesetListItemStateListener
    implements ItemListener {
        ChangesetListItemStateListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Changeset cs = (Changeset)ChangesetManagementPanel.this.cbOpenChangesets.getSelectedItem();
            if (cs == null) {
                return;
            }
            if (ChangesetManagementPanel.this.rbExisting.isSelected()) {
                ChangesetManagementPanel.this.firePropertyChange(SELECTED_CHANGESET_PROP, null, cs);
            }
        }
    }
}

