/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Objects;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.styleelement.BoxTextElement;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class MapImage {
    private static final int MAX_SIZE = 48;
    private Image img;
    public int alpha = 255;
    public String name;
    public StyleSource source;
    public boolean autoRescale;
    public int width = -1;
    public int height = -1;
    public int offsetX;
    public int offsetY;
    private boolean temporary;
    private BufferedImage disabledImgCache;

    public MapImage(String name, StyleSource source) {
        this(name, source, true);
    }

    public MapImage(String name, StyleSource source, boolean autoRescale) {
        this.name = name;
        this.source = source;
        this.autoRescale = autoRescale;
    }

    public Image getImage(boolean disabled) {
        if (disabled) {
            return this.getDisabled();
        }
        return this.getImage();
    }

    private Image getDisabled() {
        Image disImg;
        if (this.disabledImgCache != null) {
            return this.disabledImgCache;
        }
        if (this.img == null) {
            this.getImage();
        }
        if ((disImg = GuiHelper.getDisabledImage(this.img)) instanceof BufferedImage) {
            this.disabledImgCache = (BufferedImage)disImg;
        } else {
            this.disabledImgCache = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            Graphics g = this.disabledImgCache.getGraphics();
            g.drawImage(disImg, 0, 0, null);
            g.dispose();
        }
        return this.disabledImgCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image getImage() {
        if (this.img != null) {
            return this.img;
        }
        this.temporary = false;
        new ImageProvider(this.name).setDirs(MapPaintStyles.getIconSourceDirs(this.source)).setId("mappaint." + this.source.getPrefName()).setArchive(this.source.zipIcons).setInArchiveDir(this.source.getZipEntryDirName()).setWidth(this.width).setHeight(this.height).setOptional(true).getAsync().thenAccept(result -> {
            MapImage mapImage = this;
            synchronized (mapImage) {
                if (result == null) {
                    this.source.logWarning(I18n.tr("Failed to locate image ''{0}''", this.name));
                    ImageIcon noIcon = MapPaintStyles.getNoIconIcon(this.source);
                    this.img = noIcon == null ? null : noIcon.getImage();
                } else {
                    this.img = this.rescale(result.getImage());
                }
                if (this.temporary) {
                    this.disabledImgCache = null;
                    MapView mapView = MainApplication.getMap().mapView;
                    mapView.preferenceChanged(null);
                    mapView.repaint();
                }
                this.temporary = false;
            }
        });
        MapImage mapImage = this;
        synchronized (mapImage) {
            if (this.img == null) {
                this.img = ImageProvider.get("clock").getImage();
                this.temporary = true;
            }
        }
        return this.img;
    }

    public int getWidth() {
        return this.getImage().getWidth(null);
    }

    public int getHeight() {
        return this.getImage().getHeight(null);
    }

    public float getAlphaFloat() {
        return Utils.colorInt2float(this.alpha).floatValue();
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public BoxTextElement.BoxProvider getBoxProvider() {
        return new MapImageBoxProvider();
    }

    private Image rescale(Image image) {
        if (image == null) {
            return null;
        }
        if (this.mustRescale(image)) {
            return ImageProvider.createBoundedImage(image, 16);
        }
        return image;
    }

    private boolean mustRescale(Image image) {
        return this.autoRescale && this.width == -1 && image.getWidth(null) > 48 && this.height == -1 && image.getHeight(null) > 48;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MapImage mapImage = (MapImage)obj;
        return this.alpha == mapImage.alpha && this.autoRescale == mapImage.autoRescale && this.width == mapImage.width && this.height == mapImage.height && Objects.equals(this.name, mapImage.name) && Objects.equals(this.source, mapImage.source);
    }

    public int hashCode() {
        return Objects.hash(this.alpha, this.name, this.source, this.autoRescale, this.width, this.height);
    }

    public String toString() {
        return this.name;
    }

    protected class MapImageBoxProvider
    implements BoxTextElement.BoxProvider {
        protected MapImageBoxProvider() {
        }

        @Override
        public BoxTextElement.BoxProviderResult get() {
            return new BoxTextElement.BoxProviderResult(this.box(), MapImage.this.temporary);
        }

        private Rectangle box() {
            int w = MapImage.this.getWidth();
            int h = MapImage.this.getHeight();
            if (MapImage.this.mustRescale(MapImage.this.getImage())) {
                w = 16;
                h = 16;
            }
            return new Rectangle(-w / 2, -h / 2, w, h);
        }

        private MapImage getParent() {
            return MapImage.this;
        }

        public int hashCode() {
            return MapImage.this.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BoxTextElement.BoxProvider)) {
                return false;
            }
            if (obj instanceof MapImageBoxProvider) {
                MapImageBoxProvider other = (MapImageBoxProvider)obj;
                return MapImage.this.equals(other.getParent());
            }
            if (MapImage.this.temporary) {
                return false;
            }
            BoxTextElement.BoxProvider other = (BoxTextElement.BoxProvider)obj;
            BoxTextElement.BoxProviderResult resultOther = other.get();
            if (resultOther.isTemporary()) {
                return false;
            }
            return this.box().equals(resultOther.getBox());
        }
    }
}

