/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.repl;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.repl.BasicReplStageHistory;
import org.jetbrains.kotlin.cli.common.repl.ILineId;
import org.jetbrains.kotlin.cli.common.repl.LineId;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.jvm.repl.GenericReplCompilerState;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0010\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/ReplCompilerStageHistory;", "Lorg/jetbrains/kotlin/cli/common/repl/BasicReplStageHistory;", "Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;", "state", "Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplCompilerState;", "(Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplCompilerState;)V", "checkConsistent", "", "removedCompiledLines", "", "Lorg/jetbrains/kotlin/cli/common/repl/ILineId;", "removedAnalyzedLines", "", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "reset", "resetTo", "id", "cli"})
public final class ReplCompilerStageHistory
extends BasicReplStageHistory<ScriptDescriptor> {
    private final GenericReplCompilerState state;

    @Override
    @NotNull
    public Iterable<ILineId> reset() {
        Iterable<ILineId> removedCompiledLines = super.reset();
        List<ReplCodeLine> removedAnalyzedLines = this.state.getAnalyzerEngine().reset();
        this.checkConsistent(removedCompiledLines, removedAnalyzedLines);
        return removedCompiledLines;
    }

    @Override
    @NotNull
    public Iterable<ILineId> resetTo(@NotNull ILineId id) {
        Intrinsics.checkParameterIsNotNull(id, "id");
        Iterable<ILineId> removedCompiledLines = super.resetTo(id);
        List<ReplCodeLine> removedAnalyzedLines = this.state.getAnalyzerEngine().resetToLine(id);
        this.checkConsistent(removedCompiledLines, removedAnalyzedLines);
        return removedCompiledLines;
    }

    private final void checkConsistent(Iterable<? extends ILineId> removedCompiledLines, List<ReplCodeLine> removedAnalyzedLines) {
        Iterable $receiver$iv = CollectionsKt.zip(removedCompiledLines, (Iterable)removedAnalyzedLines);
        for (Object element$iv : $receiver$iv) {
            Pair it = (Pair)element$iv;
            if (!(Intrinsics.areEqual((ILineId)it.getFirst(), new LineId((ReplCodeLine)it.getSecond())) ^ true)) continue;
            throw (Throwable)new IllegalStateException("History mismatch when resetting lines: " + ((ILineId)it.getFirst()).getNo() + " != " + (ReplCodeLine)it.getSecond());
        }
    }

    public ReplCompilerStageHistory(@NotNull GenericReplCompilerState state2) {
        Intrinsics.checkParameterIsNotNull(state2, "state");
        super(state2.getLock());
        this.state = state2;
    }
}

