/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.InlineFunctionsMap;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.incremental.storage.StringToLongMapExternalizer;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00032\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0014J*\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/incremental/InlineFunctionsMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "", "storageFile", "Ljava/io/File;", "(Ljava/io/File;)V", "dumpValue", "value", "process", "", "srcFile", "newMap", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "remove", "sourceFile", "kotlin-build-common"})
final class InlineFunctionsMap
extends BasicStringMap<Map<String, ? extends Long>> {
    public final void process(@NotNull File srcFile, @NotNull Map<String, Long> newMap, @NotNull ChangesCollector changesCollector) {
        Intrinsics.checkParameterIsNotNull(srcFile, "srcFile");
        Intrinsics.checkParameterIsNotNull(newMap, "newMap");
        Intrinsics.checkParameterIsNotNull(changesCollector, "changesCollector");
        String key = srcFile.getCanonicalPath();
        LazyStorage lazyStorage = this.getStorage();
        String string = key;
        Intrinsics.checkExpressionValueIsNotNull(string, "key");
        Map map2 = (Map)lazyStorage.get(string);
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        Map oldMap = map2;
        Map<String, Long> map3 = newMap;
        if (!map3.isEmpty()) {
            this.getStorage().set(key, newMap);
        } else {
            this.getStorage().remove(key);
        }
        for (String fn : SetsKt.plus(oldMap.keySet(), (Iterable)newMap.keySet())) {
            List fqNameSegments = StringsKt.split$default((CharSequence)StringsKt.removePrefix(StringsKt.removePrefix(fn, (CharSequence)"<get>"), (CharSequence)"<set>"), new String[]{"."}, false, 0, 6, null);
            FqName fqName2 = FqName.fromSegments(fqNameSegments);
            FqName fqName3 = fqName2.parent();
            Intrinsics.checkExpressionValueIsNotNull(fqName3, "fqName.parent()");
            String string2 = fqName2.shortName().asString();
            Intrinsics.checkExpressionValueIsNotNull(string2, "fqName.shortName().asString()");
            changesCollector.collectMemberIfValueWasChanged(fqName3, string2, oldMap.get(fn), newMap.get(fn));
        }
    }

    public final void remove(@NotNull File sourceFile) {
        Intrinsics.checkParameterIsNotNull(sourceFile, "sourceFile");
        LazyStorage lazyStorage = this.getStorage();
        String string = sourceFile.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull(string, "sourceFile.canonicalPath");
        lazyStorage.remove(string);
    }

    @Override
    @NotNull
    protected String dumpValue(@NotNull Map<String, Long> value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        return IncrementalJvmCacheKt.dumpMap(value, dumpValue.1.INSTANCE);
    }

    public InlineFunctionsMap(@NotNull File storageFile) {
        Intrinsics.checkParameterIsNotNull(storageFile, "storageFile");
        super(storageFile, StringToLongMapExternalizer.INSTANCE);
    }
}

