/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.utils.InlineUtils;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0006\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\n\u001a\u00020\u0006\u001a\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0010"}, d2={"transitiveStaticRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "getTransitiveStaticRef", "(Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;)Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "getCallerQualifier", "invocation", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "getCallerQualifierImpl", "getSimpleIdent", "", "call", "getSimpleName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "hasCallerQualifier", "", "isCallInvocation", "js.translator"})
public final class InvocationUtilsKt {
    @Nullable
    public static final JsName getSimpleName(@NotNull JsInvocation call2) {
        Intrinsics.checkParameterIsNotNull(call2, "call");
        JsExpression qualifier = call2.getQualifier();
        JsExpression jsExpression = qualifier;
        if (!(jsExpression instanceof JsNameRef)) {
            jsExpression = null;
        }
        JsNameRef jsNameRef = (JsNameRef)jsExpression;
        return jsNameRef != null ? jsNameRef.getName() : null;
    }

    @Nullable
    public static final String getSimpleIdent(@NotNull JsInvocation call2) {
        Intrinsics.checkParameterIsNotNull(call2, "call");
        JsExpression qualifier = call2.getQualifier();
        while (qualifier != null) {
            JsExpression jsExpression = qualifier;
            if (jsExpression instanceof JsInvocation) {
                JsExpression callableQualifier = qualifier;
                qualifier = ((JsInvocation)callableQualifier).getQualifier();
                if (!InvocationUtilsKt.isCallInvocation((JsInvocation)callableQualifier)) continue;
                JsExpression jsExpression2 = qualifier;
                if (!(jsExpression2 instanceof JsNameRef)) {
                    jsExpression2 = null;
                }
                JsNameRef jsNameRef = (JsNameRef)jsExpression2;
                qualifier = jsNameRef != null ? jsNameRef.getQualifier() : null;
                continue;
            }
            if (!(jsExpression instanceof HasName)) break;
            JsName jsName = ((HasName)((Object)qualifier)).getName();
            return jsName != null ? jsName.getIdent() : null;
        }
        return null;
    }

    public static final boolean isCallInvocation(@NotNull JsInvocation invocation) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull(invocation, "invocation");
        JsExpression jsExpression = invocation.getQualifier();
        if (!(jsExpression instanceof JsNameRef)) {
            jsExpression = null;
        }
        JsNameRef qualifier = (JsNameRef)jsExpression;
        List<JsExpression> arguments2 = invocation.getArguments();
        JsName jsName = InlineUtils.getName(qualifier);
        if ((jsName != null ? MetadataProperties.getDescriptor(jsName) : null) != null) {
            return false;
        }
        JsNameRef jsNameRef = qualifier;
        return Intrinsics.areEqual(jsNameRef != null ? jsNameRef.getIdent() : null, "call") && !(collection = (Collection)arguments2).isEmpty();
    }

    public static final boolean hasCallerQualifier(@NotNull JsInvocation invocation) {
        Intrinsics.checkParameterIsNotNull(invocation, "invocation");
        return InvocationUtilsKt.getCallerQualifierImpl(invocation) != null;
    }

    @NotNull
    public static final JsExpression getCallerQualifier(@NotNull JsInvocation invocation) {
        Intrinsics.checkParameterIsNotNull(invocation, "invocation");
        JsExpression jsExpression = InvocationUtilsKt.getCallerQualifierImpl(invocation);
        if (jsExpression == null) {
            throw (Throwable)((Object)new AssertionError((Object)"must check hasQualifier() before calling getQualifier"));
        }
        return jsExpression;
    }

    private static final JsExpression getCallerQualifierImpl(JsInvocation invocation) {
        JsExpression jsExpression = invocation.getQualifier();
        if (!(jsExpression instanceof JsNameRef)) {
            jsExpression = null;
        }
        JsNameRef jsNameRef = (JsNameRef)jsExpression;
        return jsNameRef != null ? jsNameRef.getQualifier() : null;
    }

    @NotNull
    public static final JsExpression getTransitiveStaticRef(@NotNull JsExpression $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        JsExpression qualifier = $receiver;
        while (true) {
            JsExpression jsExpression;
            JsExpression jsExpression2;
            if ((jsExpression2 = qualifier) instanceof JsNameRef) {
                JsName jsName = ((JsNameRef)qualifier).getName();
                JsNode jsNode = jsName != null ? MetadataProperties.getStaticRef(jsName) : null;
                if (!(jsNode instanceof JsExpression)) {
                    jsNode = null;
                }
                if ((jsExpression = (JsExpression)jsNode) == null) {
                    break;
                }
            } else {
                if (!(jsExpression2 instanceof JsInvocation)) break;
                JsName jsName = InvocationUtilsKt.getSimpleName((JsInvocation)qualifier);
                JsNode jsNode = jsName != null ? MetadataProperties.getStaticRef(jsName) : null;
                if (!(jsNode instanceof JsExpression)) {
                    jsNode = null;
                }
                if ((jsExpression = (JsExpression)jsNode) == null) {
                    break;
                }
            }
            qualifier = jsExpression;
        }
        return qualifier;
    }
}

