/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.patterns.PatternBuilder;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsicWithReceiverComputed;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.CompositeFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.NumberAndCharConversionFIF;
import org.jetbrains.kotlin.utils.FunctionsKt;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/NumberAndCharConversionFIF;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/CompositeFIF;", "()V", "USE_AS_IS", "Ljava/util/function/Predicate;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getUSE_AS_IS", "()Ljava/util/function/Predicate;", "convertOperations", "", "", "Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/NumberAndCharConversionFIF$ConversionUnaryIntrinsic;", "ConversionUnaryIntrinsic", "js.translator"})
public final class NumberAndCharConversionFIF
extends CompositeFIF {
    @NotNull
    private static final Predicate<FunctionDescriptor> USE_AS_IS;
    private static final Map<String, ConversionUnaryIntrinsic> convertOperations;
    public static final NumberAndCharConversionFIF INSTANCE;

    @NotNull
    public final Predicate<FunctionDescriptor> getUSE_AS_IS() {
        return USE_AS_IS;
    }

    private NumberAndCharConversionFIF() {
        INSTANCE = this;
        Predicate predicate = PatternBuilder.pattern("Int.toInt|toFloat|toDouble").or(PatternBuilder.pattern("Short.toShort|toInt|toFloat|toDouble")).or(PatternBuilder.pattern("Byte.toByte|toShort|toInt|toFloat|toDouble")).or(PatternBuilder.pattern("Float|Double.toFloat|toDouble")).or(PatternBuilder.pattern("Long.toLong")).or(PatternBuilder.pattern("Char.toChar"));
        Intrinsics.checkExpressionValueIsNotNull(predicate, "pattern(\"Int.toInt|toFlo\u2026r(pattern(\"Char.toChar\"))");
        USE_AS_IS = predicate;
        convertOperations = MapsKt.mapOf(TuplesKt.to("Float|Double.toInt", new ConversionUnaryIntrinsic(convertOperations.1.INSTANCE)), TuplesKt.to("Int|Float|Double.toShort", new ConversionUnaryIntrinsic(convertOperations.2.INSTANCE)), TuplesKt.to("Short|Int|Float|Double.toByte", new ConversionUnaryIntrinsic(convertOperations.3.INSTANCE)), TuplesKt.to("Int|Short|Byte.toLong", new ConversionUnaryIntrinsic(convertOperations.4.INSTANCE)), TuplesKt.to("Float|Double.toLong", new ConversionUnaryIntrinsic(convertOperations.5.INSTANCE)), TuplesKt.to("Char.toDouble|toFloat|toInt", new ConversionUnaryIntrinsic(convertOperations.6.INSTANCE)), TuplesKt.to("Char.toShort", new ConversionUnaryIntrinsic(convertOperations.7.INSTANCE)), TuplesKt.to("Char.toByte", new ConversionUnaryIntrinsic(convertOperations.8.INSTANCE)), TuplesKt.to("Char.toLong", new ConversionUnaryIntrinsic(convertOperations.9.INSTANCE)), TuplesKt.to("Number.toInt", new ConversionUnaryIntrinsic(convertOperations.10.INSTANCE)), TuplesKt.to("Number.toShort", new ConversionUnaryIntrinsic(convertOperations.11.INSTANCE)), TuplesKt.to("Number.toByte", new ConversionUnaryIntrinsic(convertOperations.12.INSTANCE)), TuplesKt.to("Number.toChar", new ConversionUnaryIntrinsic(convertOperations.13.INSTANCE)), TuplesKt.to("Number.toFloat|toDouble", new ConversionUnaryIntrinsic(convertOperations.14.INSTANCE)), TuplesKt.to("Number.toLong", new ConversionUnaryIntrinsic(convertOperations.15.INSTANCE)), TuplesKt.to("Int|Short|Byte|Float|Double.toChar", new ConversionUnaryIntrinsic(convertOperations.16.INSTANCE)), TuplesKt.to("Long.toFloat|toDouble", new ConversionUnaryIntrinsic(convertOperations.17.INSTANCE)), TuplesKt.to("Long.toInt", new ConversionUnaryIntrinsic(convertOperations.18.INSTANCE)), TuplesKt.to("Long.toShort", new ConversionUnaryIntrinsic(convertOperations.19.INSTANCE)), TuplesKt.to("Long.toByte", new ConversionUnaryIntrinsic(convertOperations.20.INSTANCE)), TuplesKt.to("Long.toChar", new ConversionUnaryIntrinsic(convertOperations.21.INSTANCE)));
        this.add(USE_AS_IS, new ConversionUnaryIntrinsic(FunctionsKt.identity()));
        Map<String, ConversionUnaryIntrinsic> map2 = convertOperations;
        Iterator<Map.Entry<String, ConversionUnaryIntrinsic>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, ConversionUnaryIntrinsic> entry;
            Map.Entry<String, ConversionUnaryIntrinsic> entry2 = entry = iterator2.next();
            String stringPattern = entry2.getKey();
            entry2 = entry;
            ConversionUnaryIntrinsic intrinsic = entry2.getValue();
            this.add(PatternBuilder.pattern(stringPattern), intrinsic);
        }
    }

    static {
        new NumberAndCharConversionFIF();
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B(\u0012!\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\bJ(\u0010\u000b\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R,\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/NumberAndCharConversionFIF$ConversionUnaryIntrinsic;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/basic/FunctionIntrinsicWithReceiverComputed;", "applyFun", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "Lkotlin/ParameterName;", "name", "receiver", "(Lkotlin/jvm/functions/Function1;)V", "getApplyFun", "()Lkotlin/jvm/functions/Function1;", "apply", "arguments", "", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "js.translator"})
    public static final class ConversionUnaryIntrinsic
    extends FunctionIntrinsicWithReceiverComputed {
        @NotNull
        private final Function1<JsExpression, JsExpression> applyFun;

        @Override
        @NotNull
        public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
            Intrinsics.checkParameterIsNotNull(context, "context");
            boolean bl2 = bl = receiver != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            bl = arguments2.isEmpty();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            JsExpression jsExpression = receiver;
            if (jsExpression == null) {
                Intrinsics.throwNpe();
            }
            return this.applyFun.invoke(jsExpression);
        }

        @NotNull
        public final Function1<JsExpression, JsExpression> getApplyFun() {
            return this.applyFun;
        }

        public ConversionUnaryIntrinsic(@NotNull Function1<? super JsExpression, ? extends JsExpression> applyFun) {
            Intrinsics.checkParameterIsNotNull(applyFun, "applyFun");
            this.applyFun = applyFun;
        }
    }
}

