/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.stubs.PsiClassHolderFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.io.StringRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.KotlinImportAliasStub;
import org.jetbrains.kotlin.psi.stubs.KotlinImportDirectiveStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtFileElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\b\u0012\u0004\u0012\u00020\u00020\u0004B!\b\u0016\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u001f\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u000b\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0013\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u0019\u001a\u00020\u0007H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinFileStubImpl;", "Lcom/intellij/psi/stubs/PsiFileStubImpl;", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lorg/jetbrains/kotlin/psi/stubs/KotlinFileStub;", "Lcom/intellij/psi/stubs/PsiClassHolderFileStub;", "jetFile", "packageName", "", "isScript", "", "(Lorg/jetbrains/kotlin/psi/KtFile;Ljava/lang/String;Z)V", "Lcom/intellij/util/io/StringRef;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/util/io/StringRef;Z)V", "findImportsByAlias", "", "Lorg/jetbrains/kotlin/psi/stubs/KotlinImportDirectiveStub;", "alias", "getClasses", "", "Lcom/intellij/psi/PsiClass;", "()[Lcom/intellij/psi/PsiClass;", "getPackageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getType", "Lcom/intellij/psi/tree/IStubFileElementType;", "toString", "frontend"})
public class KotlinFileStubImpl
extends PsiFileStubImpl<KtFile>
implements PsiClassHolderFileStub<KtFile>,
KotlinFileStub {
    private final StringRef packageName;
    private final boolean isScript;

    @Override
    @NotNull
    public FqName getPackageFqName() {
        String string = StringRef.toString(this.packageName);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return new FqName(string);
    }

    @Override
    public boolean isScript() {
        return this.isScript;
    }

    @Override
    @NotNull
    public IStubFileElementType<KotlinFileStub> getType() {
        KtFileElementType ktFileElementType = KtStubElementTypes.FILE;
        Intrinsics.checkExpressionValueIsNotNull(ktFileElementType, "FILE");
        return ktFileElementType;
    }

    @Override
    @NotNull
    public String toString() {
        return "PsiJetFileStubImpl[package=" + this.getPackageFqName().asString() + "]";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PsiClass[] getClasses() {
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.getChildrenStubs();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof PsiClassStub)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            PsiClassStub $i$f$filterIsInstanceTo = (PsiClassStub)item$iv$iv;
            Collection collection = destination$iv$iv;
            PsiClass psiClass = (PsiClass)it.getPsi();
            collection.add(psiClass);
        }
        $receiver$iv = (List)destination$iv$iv;
        Iterable thisCollection$iv = $receiver$iv;
        PsiClass[] psiClassArray = thisCollection$iv.toArray(new PsiClass[thisCollection$iv.size()]);
        if (psiClassArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public List<KotlinImportDirectiveStub> findImportsByAlias(@NotNull String alias) {
        Iterable $receiver$iv$iv;
        Object v0;
        Iterable $receiver$iv;
        block5: {
            Intrinsics.checkParameterIsNotNull(alias, "alias");
            $receiver$iv = this.getChildrenStubs();
            for (Object element$iv : $receiver$iv) {
                StubElement it = (StubElement)element$iv;
                if (!Intrinsics.areEqual(it.getStubType(), KtStubElementTypes.IMPORT_LIST)) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        StubElement stubElement = v0;
        if (stubElement == null) {
            return CollectionsKt.emptyList();
        }
        StubElement importList = stubElement;
        $receiver$iv = importList.getChildrenStubs();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof KotlinImportDirectiveStub)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Object v2;
            block6: {
                KotlinImportDirectiveStub it = (KotlinImportDirectiveStub)element$iv$iv;
                Iterable $receiver$iv2 = it.getChildrenStubs();
                for (Object element$iv : $receiver$iv2) {
                    if (!(element$iv instanceof KotlinImportAliasStub)) continue;
                    v2 = element$iv;
                    break block6;
                }
                v2 = null;
            }
            KotlinImportAliasStub kotlinImportAliasStub = v2;
            if (!Intrinsics.areEqual(kotlinImportAliasStub != null ? kotlinImportAliasStub.getName() : null, alias)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public KotlinFileStubImpl(@Nullable KtFile jetFile, @NotNull StringRef packageName, boolean isScript) {
        Intrinsics.checkParameterIsNotNull(packageName, "packageName");
        super((PsiFile)jetFile);
        this.packageName = packageName;
        this.isScript = isScript;
    }

    public KotlinFileStubImpl(@Nullable KtFile jetFile, @NotNull String packageName, boolean isScript) {
        Intrinsics.checkParameterIsNotNull(packageName, "packageName");
        StringRef stringRef = StringRef.fromString(packageName);
        if (stringRef == null) {
            Intrinsics.throwNpe();
        }
        this(jetFile, stringRef, isScript);
    }
}

