/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DeprecationResolver;
import org.jetbrains.kotlin.resolve.SinceKotlinUtilKt;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ApiVersionClassifierUsageChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "()V", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "Lcom/intellij/psi/PsiElement;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "deprecationResolver", "Lorg/jetbrains/kotlin/resolve/DeprecationResolver;", "frontend"})
public final class ApiVersionClassifierUsageChecker
implements ClassifierUsageChecker {
    public static final ApiVersionClassifierUsageChecker INSTANCE;

    @Override
    public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull BindingTrace trace, @NotNull PsiElement element, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DeprecationResolver deprecationResolver) {
        Intrinsics.checkParameterIsNotNull(targetDescriptor, "targetDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(element, "element");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkParameterIsNotNull(deprecationResolver, "deprecationResolver");
        SinceKotlinUtilKt.checkSinceKotlinVersionAccessibility(targetDescriptor, languageVersionSettings, (Function1<? super ApiVersion, Unit>)new Function1<ApiVersion, Unit>(trace, element, languageVersionSettings){
            final /* synthetic */ BindingTrace $trace;
            final /* synthetic */ PsiElement $element;
            final /* synthetic */ LanguageVersionSettings $languageVersionSettings;

            public final void invoke(@NotNull ApiVersion version) {
                Intrinsics.checkParameterIsNotNull(version, "version");
                this.$trace.report(Errors.API_NOT_AVAILABLE.on(this.$element, version.getVersionString(), this.$languageVersionSettings.getApiVersion().getVersionString()));
            }
            {
                this.$trace = bindingTrace;
                this.$element = psiElement;
                this.$languageVersionSettings = languageVersionSettings;
                super(1);
            }
        });
    }

    private ApiVersionClassifierUsageChecker() {
        INSTANCE = this;
    }

    static {
        new ApiVersionClassifierUsageChecker();
    }
}

