/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.LiteralFormatUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.BinaryOperationKey;
import org.jetbrains.kotlin.resolve.constants.evaluate.CompileTimeType;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorKt;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorKt$WhenMappings;
import org.jetbrains.kotlin.resolve.constants.evaluate.UnaryOperationKey;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.utils.NumberWithRadix;
import org.jetbrains.kotlin.utils.NumbersKt;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=2, d1={"\u0000\u00aa\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u00b8\u0001\u0010\"\u001aN\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u0002H&0$\u00128\u00126\u0012\u001a\u0012\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00020'\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020(0'0#0#\"\u0004\b\u0000\u0010%\"\u0004\b\u0001\u0010&2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H%0\u00012\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H&0\u00012\u0006\u0010+\u001a\u00020\u00102\u0018\u0010,\u001a\u0014\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u0002H&\u0012\u0004\u0012\u00020\u00020'2\u0018\u0010-\u001a\u0014\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020(0'H\u0001\u001a(\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010/2\b\u00100\u001a\u0004\u0018\u00010\u00022\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002\u001a(\u00105\u001a\b\u0012\u0002\b\u0003\u0018\u00010/2\b\u00100\u001a\u0004\u0018\u00010\u00022\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002\u001a\u0016\u00106\u001a\u0004\u0018\u0001072\n\u00108\u001a\u0006\u0012\u0002\b\u000309H\u0002\u001a\u0010\u0010:\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u0010H\u0002\u001a\u0010\u0010<\u001a\u00020\u00062\b\u0010=\u001a\u0004\u0018\u00010\u0002\u001a\u0010\u0010>\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u0010H\u0002\u001a\u0017\u0010?\u001a\u0004\u0018\u00010\u00122\u0006\u0010;\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010@\u001a\u0017\u0010A\u001a\u0004\u0018\u00010\u00152\u0006\u0010;\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010B\u001a\u0012\u0010C\u001a\u0004\u0018\u00010\u00022\u0006\u0010;\u001a\u00020\u0010H\u0002\u001a\u0017\u0010D\u001a\u0004\u0018\u00010\u001b2\u0006\u0010;\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010E\u001a\u001a\u0010F\u001a\u0004\u0018\u00010\u00022\u0006\u0010;\u001a\u00020\u00102\u0006\u0010G\u001a\u00020HH\u0002\u001a\u0084\u0001\u0010I\u001a:\u0012\n\u0012\b\u0012\u0004\u0012\u0002H%0J\u0012*\u0012(\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00020K\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0K0#0#\"\u0004\b\u0000\u0010%2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H%0\u00012\u0006\u0010+\u001a\u00020\u00102\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u00020\u00020K2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0KH\u0001\u001a\u000e\u0010L\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030M\u001a\u000e\u0010L\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030/\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0004\"\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0004\"\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0004\"\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0004\"\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0004\"\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0004\"\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0004\"\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0004\"\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0004\u00a8\u0006N"}, d2={"ANY", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "", "getANY", "()Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "BOOLEAN", "", "getBOOLEAN", "BYTE", "", "getBYTE", "CHAR", "", "getCHAR", "DIVISION_OPERATION_NAMES", "", "", "DOUBLE", "", "getDOUBLE", "FLOAT", "", "getFLOAT", "INT", "", "getINT", "LONG", "", "getLONG", "SHORT", "", "getSHORT", "STRING", "getSTRING", "binaryOperation", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/BinaryOperationKey;", "A", "B", "Lkotlin/Function2;", "Ljava/math/BigInteger;", "a", "b", "functionName", "operation", "checker", "createCompileTimeConstantForCompareTo", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "result", "operationReference", "Lorg/jetbrains/kotlin/psi/KtExpression;", "factory", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValueFactory;", "createCompileTimeConstantForEquals", "getReceiverExpressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "hasLongSuffix", "text", "isIntegerType", "value", "parseBoolean", "parseDouble", "(Ljava/lang/String;)Ljava/lang/Double;", "parseFloat", "(Ljava/lang/String;)Ljava/lang/Float;", "parseFloatingLiteral", "parseLong", "(Ljava/lang/String;)Ljava/lang/Long;", "parseNumericLiteral", "type", "Lcom/intellij/psi/tree/IElementType;", "unaryOperation", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/UnaryOperationKey;", "Lkotlin/Function1;", "isStandaloneOnlyConstant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "frontend"})
public final class ConstantExpressionEvaluatorKt {
    private static final Set<String> DIVISION_OPERATION_NAMES;
    @NotNull
    private static final CompileTimeType<Byte> BYTE;
    @NotNull
    private static final CompileTimeType<Short> SHORT;
    @NotNull
    private static final CompileTimeType<Integer> INT;
    @NotNull
    private static final CompileTimeType<Long> LONG;
    @NotNull
    private static final CompileTimeType<Double> DOUBLE;
    @NotNull
    private static final CompileTimeType<Float> FLOAT;
    @NotNull
    private static final CompileTimeType<Character> CHAR;
    @NotNull
    private static final CompileTimeType<Boolean> BOOLEAN;
    @NotNull
    private static final CompileTimeType<String> STRING;
    @NotNull
    private static final CompileTimeType<Object> ANY;

    private static final boolean hasLongSuffix(String text2) {
        return StringsKt.endsWith$default((CharSequence)text2, 'l', false, 2, null) || StringsKt.endsWith$default((CharSequence)text2, 'L', false, 2, null);
    }

    private static final Object parseNumericLiteral(String text2, IElementType type2) {
        Object object;
        String canonicalText = LiteralFormatUtil.removeUnderscores(text2);
        IElementType iElementType = type2;
        if (Intrinsics.areEqual(iElementType, KtNodeTypes.INTEGER_CONSTANT)) {
            String string = canonicalText;
            Intrinsics.checkExpressionValueIsNotNull(string, "canonicalText");
            object = ConstantExpressionEvaluatorKt.parseLong(string);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.FLOAT_CONSTANT)) {
            String string = canonicalText;
            Intrinsics.checkExpressionValueIsNotNull(string, "canonicalText");
            object = ConstantExpressionEvaluatorKt.parseFloatingLiteral(string);
        } else {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final Long parseLong(String text2) {
        try {
            void number;
            Function1<String, String> substringLongSuffix$ = new Function1<String, String>(text2){
                final /* synthetic */ String $text;

                @NotNull
                public final String invoke(@NotNull String s) {
                    String string;
                    Intrinsics.checkParameterIsNotNull(s, "s");
                    if (ConstantExpressionEvaluatorKt.access$hasLongSuffix(this.$text)) {
                        String string2 = s;
                        int n = 0;
                        int n2 = s.length() - 1;
                        String string3 = string2.substring(n, n2);
                        string = string3;
                        Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    } else {
                        string = s;
                    }
                    return string;
                }
                {
                    this.$text = string;
                    super(1);
                }
            };
            Function2<String, Integer, Long> parseLong$ = new Function2<String, Integer, Long>(substringLongSuffix$){
                final /* synthetic */ parseLong.1 $substringLongSuffix;

                public final long invoke(@NotNull String text2, int radix) {
                    Intrinsics.checkParameterIsNotNull(text2, "text");
                    return Long.parseLong(this.$substringLongSuffix.invoke(text2), radix);
                }
                {
                    this.$substringLongSuffix = var1_1;
                    super(2);
                }
            };
            NumberWithRadix numberWithRadix = NumbersKt.extractRadix(text2);
            String string = numberWithRadix.component1();
            int radix = numberWithRadix.component2();
            return parseLong$.invoke((String)number, radix);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static final Object parseFloatingLiteral(String text2) {
        String string;
        String string2 = string = text2;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).toLowerCase()");
        if (StringsKt.endsWith$default((CharSequence)string3, 'f', false, 2, null)) {
            return ConstantExpressionEvaluatorKt.parseFloat(text2);
        }
        return ConstantExpressionEvaluatorKt.parseDouble(text2);
    }

    private static final Double parseDouble(String text2) {
        try {
            return Double.parseDouble(text2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static final Float parseFloat(String text2) {
        try {
            return Float.valueOf(Float.parseFloat(text2));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static final boolean parseBoolean(String text2) {
        if ("true".equals(text2)) {
            return true;
        }
        if ("false".equals(text2)) {
            return false;
        }
        throw (Throwable)new IllegalStateException("Must not happen. A boolean literal has text: " + text2);
    }

    private static final ConstantValue<?> createCompileTimeConstantForEquals(Object result2, KtExpression operationReference, ConstantValueFactory factory2) {
        if (result2 instanceof Boolean) {
            boolean bl;
            boolean bl2 = operationReference instanceof KtSimpleNameExpression;
            if (_Assertions.ENABLED && !bl2) {
                String string = "This method should be called only for equals operations";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            KtExpression ktExpression = operationReference;
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSimpleNameExpression");
            }
            IElementType operationToken = ((KtSimpleNameExpression)ktExpression).getReferencedNameElementType();
            IElementType iElementType = operationToken;
            if (Intrinsics.areEqual(iElementType, KtTokens.EQEQ)) {
                bl = (Boolean)result2;
            } else if (Intrinsics.areEqual(iElementType, KtTokens.EXCLEQ)) {
                bl = !((Boolean)result2).booleanValue();
            } else if (Intrinsics.areEqual(iElementType, KtTokens.IDENTIFIER)) {
                boolean bl3 = Intrinsics.areEqual(((KtSimpleNameExpression)operationReference).getReferencedNameAsName(), OperatorNameConventions.EQUALS);
                if (_Assertions.ENABLED && !bl3) {
                    String string = "This method should be called only for equals operations";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                bl = (Boolean)result2;
            } else {
                throw (Throwable)new IllegalStateException("Unknown equals operation token: " + operationToken + ' ' + ((KtSimpleNameExpression)operationReference).getText());
            }
            boolean value = bl;
            return factory2.createBooleanValue(value);
        }
        return null;
    }

    private static final ConstantValue<?> createCompileTimeConstantForCompareTo(Object result2, KtExpression operationReference, ConstantValueFactory factory2) {
        if (result2 instanceof Integer) {
            ConstantValue constantValue;
            boolean bl = operationReference instanceof KtSimpleNameExpression;
            if (_Assertions.ENABLED && !bl) {
                String string = "This method should be called only for compareTo operations";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            KtExpression ktExpression = operationReference;
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSimpleNameExpression");
            }
            IElementType operationToken = ((KtSimpleNameExpression)ktExpression).getReferencedNameElementType();
            IElementType iElementType = operationToken;
            if (Intrinsics.areEqual(iElementType, KtTokens.LT)) {
                constantValue = factory2.createBooleanValue(((Number)result2).intValue() < 0);
            } else if (Intrinsics.areEqual(iElementType, KtTokens.LTEQ)) {
                constantValue = factory2.createBooleanValue(((Number)result2).intValue() <= 0);
            } else if (Intrinsics.areEqual(iElementType, KtTokens.GT)) {
                constantValue = factory2.createBooleanValue(((Number)result2).intValue() > 0);
            } else if (Intrinsics.areEqual(iElementType, KtTokens.GTEQ)) {
                constantValue = factory2.createBooleanValue(((Number)result2).intValue() >= 0);
            } else {
                if (Intrinsics.areEqual(iElementType, KtTokens.IDENTIFIER)) {
                    boolean bl2 = Intrinsics.areEqual(((KtSimpleNameExpression)operationReference).getReferencedNameAsName(), OperatorNameConventions.COMPARE_TO);
                    if (_Assertions.ENABLED && !bl2) {
                        String string = "This method should be called only for compareTo operations";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    return factory2.createIntValue(((Number)result2).intValue());
                }
                throw (Throwable)new IllegalStateException("Unknown compareTo operation token: " + operationToken);
            }
            return constantValue;
        }
        return null;
    }

    public static final boolean isIntegerType(@Nullable Object value) {
        return value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long;
    }

    private static final KotlinType getReceiverExpressionType(ResolvedCall<?> resolvedCall2) {
        KotlinType kotlinType;
        switch (ConstantExpressionEvaluatorKt$WhenMappings.$EnumSwitchMapping$0[resolvedCall2.getExplicitReceiverKind().ordinal()]) {
            case 1: {
                ReceiverValue receiverValue = resolvedCall2.getDispatchReceiver();
                if (receiverValue == null) {
                    Intrinsics.throwNpe();
                }
                kotlinType = receiverValue.getType();
                break;
            }
            case 2: {
                ReceiverValue receiverValue = resolvedCall2.getExtensionReceiver();
                if (receiverValue == null) {
                    Intrinsics.throwNpe();
                }
                kotlinType = receiverValue.getType();
                break;
            }
            case 3: {
                kotlinType = null;
                break;
            }
            case 4: {
                kotlinType = null;
                break;
            }
            default: {
                kotlinType = null;
            }
        }
        return kotlinType;
    }

    @NotNull
    public static final CompileTimeType<Byte> getBYTE() {
        return BYTE;
    }

    @NotNull
    public static final CompileTimeType<Short> getSHORT() {
        return SHORT;
    }

    @NotNull
    public static final CompileTimeType<Integer> getINT() {
        return INT;
    }

    @NotNull
    public static final CompileTimeType<Long> getLONG() {
        return LONG;
    }

    @NotNull
    public static final CompileTimeType<Double> getDOUBLE() {
        return DOUBLE;
    }

    @NotNull
    public static final CompileTimeType<Float> getFLOAT() {
        return FLOAT;
    }

    @NotNull
    public static final CompileTimeType<Character> getCHAR() {
        return CHAR;
    }

    @NotNull
    public static final CompileTimeType<Boolean> getBOOLEAN() {
        return BOOLEAN;
    }

    @NotNull
    public static final CompileTimeType<String> getSTRING() {
        return STRING;
    }

    @NotNull
    public static final CompileTimeType<Object> getANY() {
        return ANY;
    }

    @NotNull
    public static final <A, B> Pair<BinaryOperationKey<A, B>, Pair<Function2<Object, Object, Object>, Function2<BigInteger, BigInteger, BigInteger>>> binaryOperation(@NotNull CompileTimeType<A> a, @NotNull CompileTimeType<B> b, @NotNull String functionName, @NotNull Function2<? super A, ? super B, ? extends Object> operation, @NotNull Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger> checker) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(functionName, "functionName");
        Intrinsics.checkParameterIsNotNull(operation, "operation");
        Intrinsics.checkParameterIsNotNull(checker, "checker");
        return TuplesKt.to(new BinaryOperationKey<A, B>(a, b, functionName), new Pair<Function2<? super A, ? super B, ? extends Object>, Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>>(operation, checker));
    }

    @NotNull
    public static final <A> Pair<UnaryOperationKey<A>, Pair<Function1<Object, Object>, Function1<Long, Long>>> unaryOperation(@NotNull CompileTimeType<A> a, @NotNull String functionName, @NotNull Function1<? super A, ? extends Object> operation, @NotNull Function1<? super Long, Long> checker) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(functionName, "functionName");
        Intrinsics.checkParameterIsNotNull(operation, "operation");
        Intrinsics.checkParameterIsNotNull(checker, "checker");
        return TuplesKt.to(new UnaryOperationKey<A>(a, functionName), new Pair<Function1<? super A, ? extends Object>, Function1<? super Long, Long>>(operation, checker));
    }

    public static final boolean isStandaloneOnlyConstant(@NotNull ConstantValue<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver instanceof KClassValue || $receiver instanceof EnumValue || $receiver instanceof AnnotationValue || $receiver instanceof ArrayValue;
    }

    public static final boolean isStandaloneOnlyConstant(@NotNull CompileTimeConstant<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        CompileTimeConstant<?> compileTimeConstant = $receiver;
        if (!(compileTimeConstant instanceof TypedCompileTimeConstant)) {
            return false;
        }
        return ConstantExpressionEvaluatorKt.isStandaloneOnlyConstant(((TypedCompileTimeConstant)$receiver).getConstantValue());
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var2_2;
        void $receiver$iv$iv;
        Iterable $receiver$iv = CollectionsKt.listOf(new Name[]{OperatorNameConventions.DIV, OperatorNameConventions.REM, OperatorNameConventions.MOD});
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p1;
            Name name = (Name)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = p1.asString();
            collection.add(string);
        }
        DIVISION_OPERATION_NAMES = CollectionsKt.toSet((List)var2_2);
        BYTE = new CompileTimeType("Byte");
        SHORT = new CompileTimeType("Short");
        INT = new CompileTimeType("Int");
        LONG = new CompileTimeType("Long");
        DOUBLE = new CompileTimeType("Double");
        FLOAT = new CompileTimeType("Float");
        CHAR = new CompileTimeType("Char");
        BOOLEAN = new CompileTimeType("Boolean");
        STRING = new CompileTimeType("String");
        ANY = new CompileTimeType("Any");
    }

    @Nullable
    public static final /* synthetic */ Object access$parseNumericLiteral(@NotNull String text2, @NotNull IElementType type2) {
        return ConstantExpressionEvaluatorKt.parseNumericLiteral(text2, type2);
    }

    public static final /* synthetic */ boolean access$parseBoolean(@NotNull String text2) {
        return ConstantExpressionEvaluatorKt.parseBoolean(text2);
    }

    public static final /* synthetic */ boolean access$hasLongSuffix(@NotNull String text2) {
        return ConstantExpressionEvaluatorKt.hasLongSuffix(text2);
    }

    @Nullable
    public static final /* synthetic */ ConstantValue access$createCompileTimeConstantForCompareTo(@Nullable Object result2, @NotNull KtExpression operationReference, @NotNull ConstantValueFactory factory2) {
        return ConstantExpressionEvaluatorKt.createCompileTimeConstantForCompareTo(result2, operationReference, factory2);
    }

    @Nullable
    public static final /* synthetic */ ConstantValue access$createCompileTimeConstantForEquals(@Nullable Object result2, @NotNull KtExpression operationReference, @NotNull ConstantValueFactory factory2) {
        return ConstantExpressionEvaluatorKt.createCompileTimeConstantForEquals(result2, operationReference, factory2);
    }

    @NotNull
    public static final /* synthetic */ Set access$getDIVISION_OPERATION_NAMES$p() {
        return DIVISION_OPERATION_NAMES;
    }

    @Nullable
    public static final /* synthetic */ KotlinType access$getReceiverExpressionType(@NotNull ResolvedCall resolvedCall2) {
        return ConstantExpressionEvaluatorKt.getReceiverExpressionType(resolvedCall2);
    }
}

