/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.tree.IElementType;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.StatementFilterKt;
import org.jetbrains.kotlin.resolve.calls.KotlinResolutionConfigurationKt;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.TraceBasedLocalRedeclarationChecker;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingComponents;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingFacade;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitorDispatcher;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

public class ExpressionTypingServices {
    private final ExpressionTypingFacade expressionTypingFacade;
    private final ExpressionTypingComponents expressionTypingComponents;
    @NotNull
    private final AnnotationChecker annotationChecker;
    @NotNull
    private final StatementFilter statementFilter;

    public ExpressionTypingServices(@NotNull ExpressionTypingComponents components, @NotNull AnnotationChecker annotationChecker, @NotNull StatementFilter statementFilter, @NotNull ExpressionTypingVisitorDispatcher.ForDeclarations facade) {
        this.expressionTypingComponents = components;
        this.annotationChecker = annotationChecker;
        this.statementFilter = statementFilter;
        this.expressionTypingFacade = facade;
    }

    @NotNull
    public LanguageVersionSettings getLanguageVersionSettings() {
        return this.expressionTypingComponents.languageVersionSettings;
    }

    @NotNull
    public StatementFilter getStatementFilter() {
        return this.statementFilter;
    }

    @NotNull
    public KotlinType safeGetType(@NotNull LexicalScope scope, @NotNull KtExpression expression2, @NotNull KotlinType expectedType2, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        KotlinType type2 = this.getType(scope, expression2, expectedType2, dataFlowInfo, trace);
        return type2 != null ? type2 : ErrorUtils.createErrorType("Type for " + expression2.getText());
    }

    @NotNull
    public KotlinTypeInfo getTypeInfo(@NotNull LexicalScope scope, @NotNull KtExpression expression2, @NotNull KotlinType expectedType2, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace, boolean isStatement) {
        return this.getTypeInfo(scope, expression2, expectedType2, dataFlowInfo, trace, isStatement, expression2, ContextDependency.INDEPENDENT);
    }

    @NotNull
    public KotlinTypeInfo getTypeInfo(@NotNull LexicalScope scope, @NotNull KtExpression expression2, @NotNull KotlinType expectedType2, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace, boolean isStatement, @NotNull KtExpression contextExpression, @NotNull ContextDependency contextDependency) {
        ExpressionTypingContext context = ExpressionTypingContext.newContext(trace, scope, dataFlowInfo, expectedType2, contextDependency, this.statementFilter, this.getLanguageVersionSettings());
        if (contextExpression != expression2) {
            context = (ExpressionTypingContext)context.replaceExpressionContextProvider(arg -> arg == expression2 ? contextExpression : null);
        }
        return this.expressionTypingFacade.getTypeInfo(expression2, context, isStatement);
    }

    @NotNull
    public KotlinTypeInfo getTypeInfo(@NotNull KtExpression expression2, @NotNull ResolutionContext resolutionContext) {
        return this.expressionTypingFacade.getTypeInfo(expression2, ExpressionTypingContext.newContext(resolutionContext));
    }

    @Nullable
    public KotlinType getType(@NotNull LexicalScope scope, @NotNull KtExpression expression2, @NotNull KotlinType expectedType2, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        return this.getTypeInfo(scope, expression2, expectedType2, dataFlowInfo, trace, false).getType();
    }

    public void checkFunctionReturnType(@NotNull LexicalScope functionInnerScope, @NotNull KtDeclarationWithBody function2, @NotNull FunctionDescriptor functionDescriptor, @NotNull DataFlowInfo dataFlowInfo, @Nullable KotlinType expectedReturnType, BindingTrace trace) {
        if (expectedReturnType == null) {
            expectedReturnType = functionDescriptor.getReturnType();
            if (!function2.hasBlockBody() && !function2.hasDeclaredReturnType()) {
                expectedReturnType = TypeUtils.NO_EXPECTED_TYPE;
            }
        }
        this.checkFunctionReturnType(function2, ExpressionTypingContext.newContext(trace, functionInnerScope, dataFlowInfo, expectedReturnType != null ? expectedReturnType : TypeUtils.NO_EXPECTED_TYPE, this.getLanguageVersionSettings()));
    }

    void checkFunctionReturnType(KtDeclarationWithBody function2, ExpressionTypingContext context) {
        KtExpression bodyExpression = function2.getBodyExpression();
        if (bodyExpression == null) {
            return;
        }
        boolean blockBody = function2.hasBlockBody();
        ExpressionTypingContext newContext = blockBody ? (ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE) : context;
        this.expressionTypingFacade.getTypeInfo(bodyExpression, newContext, blockBody);
    }

    @NotNull
    public KotlinTypeInfo getBlockReturnedType(KtBlockExpression expression2, ExpressionTypingContext context, boolean isStatement) {
        return this.getBlockReturnedType(expression2, isStatement ? CoercionStrategy.COERCION_TO_UNIT : CoercionStrategy.NO_COERCION, context);
    }

    @NotNull
    public KotlinTypeInfo getBlockReturnedType(@NotNull KtBlockExpression expression2, @NotNull CoercionStrategy coercionStrategyForLastExpression, @NotNull ExpressionTypingContext context) {
        List<KtExpression> block = StatementFilterKt.filterStatements(this.statementFilter, expression2);
        DeclarationDescriptor containingDescriptor = context.scope.getOwnerDescriptor();
        TraceBasedLocalRedeclarationChecker redeclarationChecker = new TraceBasedLocalRedeclarationChecker(context.trace, this.expressionTypingComponents.overloadChecker);
        LexicalWritableScope scope = new LexicalWritableScope(context.scope, containingDescriptor, false, redeclarationChecker, LexicalScopeKind.CODE_BLOCK);
        KotlinTypeInfo r = block.isEmpty() ? this.expressionTypingComponents.dataFlowAnalyzer.createCheckedTypeInfo(this.expressionTypingComponents.builtIns.getUnitType(), context, expression2) : this.getBlockReturnedTypeWithWritableScope(scope, block, coercionStrategyForLastExpression, (ExpressionTypingContext)context.replaceStatementFilter(this.statementFilter));
        scope.freeze();
        if (containingDescriptor instanceof ScriptDescriptor) {
            context.trace.record(BindingContext.SCRIPT_SCOPE, (ScriptDescriptor)containingDescriptor, scope);
        }
        return r;
    }

    @NotNull
    public KotlinType getBodyExpressionType(@NotNull BindingTrace trace, @NotNull LexicalScope outerScope, @NotNull DataFlowInfo dataFlowInfo, @NotNull KtDeclarationWithBody function2, @NotNull FunctionDescriptor functionDescriptor) {
        KtExpression bodyExpression = function2.getBodyExpression();
        assert (bodyExpression != null);
        LexicalScope functionInnerScope = FunctionDescriptorUtil.getFunctionInnerScope(outerScope, functionDescriptor, trace, this.expressionTypingComponents.overloadChecker);
        ExpressionTypingContext context = ExpressionTypingContext.newContext(trace, functionInnerScope, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE, this.getLanguageVersionSettings());
        KotlinTypeInfo typeInfo = this.expressionTypingFacade.getTypeInfo(bodyExpression, context, function2.hasBlockBody());
        KotlinType type2 = typeInfo.getType();
        if (type2 != null) {
            return type2;
        }
        return ErrorUtils.createErrorType("Error function type");
    }

    KotlinTypeInfo getBlockReturnedTypeWithWritableScope(@NotNull LexicalWritableScope scope, @NotNull List<? extends KtElement> block, @NotNull CoercionStrategy coercionStrategyForLastExpression, @NotNull ExpressionTypingContext context) {
        if (block.isEmpty()) {
            return TypeInfoFactoryKt.createTypeInfo((KotlinType)this.expressionTypingComponents.builtIns.getUnitType(), context);
        }
        ExpressionTypingVisitorDispatcher.ForBlock blockLevelVisitor = new ExpressionTypingVisitorDispatcher.ForBlock(this.expressionTypingComponents, this.annotationChecker, scope);
        ExpressionTypingContext newContext = (ExpressionTypingContext)((ExpressionTypingContext)context.replaceScope(scope)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        KotlinTypeInfo result2 = TypeInfoFactoryKt.noTypeInfo(context);
        DataFlowInfo beforeJumpInfo = newContext.dataFlowInfo;
        boolean jumpOutPossible = false;
        Iterator<? extends KtElement> iterator2 = block.iterator();
        while (iterator2.hasNext()) {
            KtElement statement2 = iterator2.next();
            if (!(statement2 instanceof KtExpression)) continue;
            KtExpression statementExpression = (KtExpression)statement2;
            if (!iterator2.hasNext()) {
                result2 = this.getTypeOfLastExpressionInBlock(statementExpression, (ExpressionTypingContext)newContext.replaceExpectedType(context.expectedType), coercionStrategyForLastExpression, blockLevelVisitor);
                if (result2.getType() != null && statementExpression.getParent() instanceof KtBlockExpression) {
                    DataFlowValue lastExpressionValue = DataFlowValueFactory.createDataFlowValue(statementExpression, result2.getType(), context);
                    DataFlowValue blockExpressionValue = DataFlowValueFactory.createDataFlowValue((KtBlockExpression)statementExpression.getParent(), result2.getType(), context);
                    result2 = result2.replaceDataFlowInfo(result2.getDataFlowInfo().assign(blockExpressionValue, lastExpressionValue, this.expressionTypingComponents.languageVersionSettings));
                }
            } else {
                result2 = blockLevelVisitor.getTypeInfo(statementExpression, (ExpressionTypingContext)newContext.replaceContextDependency(ContextDependency.INDEPENDENT), true);
            }
            DataFlowInfo newDataFlowInfo = result2.getDataFlowInfo();
            if (!jumpOutPossible) {
                beforeJumpInfo = result2.getJumpFlowInfo();
                jumpOutPossible = result2.getJumpOutPossible();
            }
            if (newDataFlowInfo != context.dataFlowInfo) {
                newContext = (ExpressionTypingContext)newContext.replaceDataFlowInfo(newDataFlowInfo);
            }
            blockLevelVisitor = new ExpressionTypingVisitorDispatcher.ForBlock(this.expressionTypingComponents, this.annotationChecker, scope);
        }
        return result2.replaceJumpOutPossible(jumpOutPossible).replaceJumpFlowInfo(beforeJumpInfo);
    }

    private KotlinTypeInfo getTypeOfLastExpressionInBlock(@NotNull KtExpression statementExpression, @NotNull ExpressionTypingContext context, @NotNull CoercionStrategy coercionStrategyForLastExpression, @NotNull ExpressionTypingInternals blockLevelVisitor) {
        if (context.expectedType != TypeUtils.NO_EXPECTED_TYPE) {
            KotlinType expectedType2 = context.expectedType == TypeUtils.UNIT_EXPECTED_TYPE || coercionStrategyForLastExpression == CoercionStrategy.COERCION_TO_UNIT && KotlinBuiltIns.isUnit(context.expectedType) ? TypeUtils.UNIT_EXPECTED_TYPE : context.expectedType;
            ContextDependency dependency = context.contextDependency;
            if (KotlinResolutionConfigurationKt.getUSE_NEW_INFERENCE()) {
                dependency = ContextDependency.INDEPENDENT;
            }
            return blockLevelVisitor.getTypeInfo(statementExpression, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(expectedType2)).replaceContextDependency(dependency), true);
        }
        KotlinTypeInfo result2 = blockLevelVisitor.getTypeInfo(statementExpression, context, true);
        if (coercionStrategyForLastExpression == CoercionStrategy.COERCION_TO_UNIT) {
            KtBinaryExpression binaryExpression;
            IElementType operationType;
            boolean mightBeUnit = false;
            if (statementExpression instanceof KtDeclaration && (!(statementExpression instanceof KtNamedFunction) || statementExpression.getName() != null)) {
                mightBeUnit = true;
            }
            if (statementExpression instanceof KtBinaryExpression && ((operationType = (binaryExpression = (KtBinaryExpression)statementExpression).getOperationToken()) == KtTokens.EQ || OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(operationType))) {
                mightBeUnit = true;
            }
            if (mightBeUnit) {
                assert (result2.getType() == null || KotlinBuiltIns.isUnit(result2.getType()));
                result2 = result2.replaceType(this.expressionTypingComponents.builtIns.getUnitType());
            }
        }
        return result2;
    }
}

