/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.datatransfer;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import org.jhotdraw.gui.datatransfer.AWTClipboard;
import org.jhotdraw.gui.datatransfer.JNLPClipboard;
import org.jhotdraw.gui.datatransfer.OSXClipboard;

public class ClipboardUtil {
    private static Clipboard instance;

    public static Clipboard getClipboard() {
        if (instance != null) {
            return instance;
        }
        try {
            instance = new OSXClipboard(Toolkit.getDefaultToolkit().getSystemClipboard());
        }
        catch (SecurityException securityException) {
            try {
                Class<?> clazz = Class.forName("javax.jnlp.ServiceManager");
                instance = new JNLPClipboard(clazz.getMethod("lookup", String.class).invoke(null, "javax.jnlp.ClipboardService"));
            }
            catch (Exception exception) {
                instance = new AWTClipboard(new Clipboard("JVM Local Clipboard"));
            }
        }
        return instance;
    }

    public static void setClipboard(Clipboard clipboard) {
        instance = clipboard;
    }
}

