/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import java.io.Serializable;

public class Rational
extends Number
implements Serializable {
    private static final long serialVersionUID = 510688928138848770L;
    private final long _numerator;
    private final long _denominator;

    public Rational(long numerator, long denominator) {
        this._numerator = numerator;
        this._denominator = denominator;
    }

    @Override
    public double doubleValue() {
        return this._numerator == 0L ? 0.0 : (double)this._numerator / (double)this._denominator;
    }

    @Override
    public float floatValue() {
        return this._numerator == 0L ? 0.0f : (float)this._numerator / (float)this._denominator;
    }

    @Override
    public final byte byteValue() {
        return (byte)this.doubleValue();
    }

    @Override
    public final int intValue() {
        return (int)this.doubleValue();
    }

    @Override
    public final long longValue() {
        return (long)this.doubleValue();
    }

    @Override
    public final short shortValue() {
        return (short)this.doubleValue();
    }

    public final long getDenominator() {
        return this._denominator;
    }

    public final long getNumerator() {
        return this._numerator;
    }

    @NotNull
    public Rational getReciprocal() {
        return new Rational(this._denominator, this._numerator);
    }

    public boolean isInteger() {
        return this._denominator == 1L || this._denominator != 0L && this._numerator % this._denominator == 0L || this._denominator == 0L && this._numerator == 0L;
    }

    @NotNull
    public String toString() {
        return this._numerator + "/" + this._denominator;
    }

    @NotNull
    public String toSimpleString(boolean allowDecimal) {
        String doubleString;
        if (this._denominator == 0L && this._numerator != 0L) {
            return this.toString();
        }
        if (this.isInteger()) {
            return Integer.toString(this.intValue());
        }
        if (this._numerator != 1L && this._denominator % this._numerator == 0L) {
            long newDenominator = this._denominator / this._numerator;
            return new Rational(1L, newDenominator).toSimpleString(allowDecimal);
        }
        Rational simplifiedInstance = this.getSimplifiedInstance();
        if (allowDecimal && (doubleString = Double.toString(simplifiedInstance.doubleValue())).length() < 5) {
            return doubleString;
        }
        return simplifiedInstance.toString();
    }

    private boolean tooComplexForSimplification() {
        double maxPossibleCalculations = (double)(Math.min(this._denominator, this._numerator) - 1L) / 5.0 + 2.0;
        int maxSimplificationCalculations = 1000;
        return maxPossibleCalculations > 1000.0;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null || !(obj instanceof Rational)) {
            return false;
        }
        Rational that = (Rational)obj;
        return this.doubleValue() == that.doubleValue();
    }

    public int hashCode() {
        return 23 * (int)this._denominator + (int)this._numerator;
    }

    @NotNull
    public Rational getSimplifiedInstance() {
        if (this.tooComplexForSimplification()) {
            return this;
        }
        int factor = 2;
        while ((long)factor <= Math.min(this._denominator, this._numerator)) {
            if (!(factor % 2 == 0 && factor > 2 || factor % 5 == 0 && factor > 5 || this._denominator % (long)factor != 0L || this._numerator % (long)factor != 0L)) {
                return new Rational(this._numerator / (long)factor, this._denominator / (long)factor);
            }
            ++factor;
        }
        return this;
    }
}

