/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public abstract class AbstractMergeAction
extends JosmAction {
    public AbstractMergeAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean register) {
        super(name, iconName, tooltip, shortcut, register);
    }

    public AbstractMergeAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean register, String toolbar, boolean installAdapters) {
        super(name, iconName, tooltip, shortcut, register, toolbar, installAdapters);
    }

    protected static Layer askTargetLayer(List<Layer> targetLayers) {
        return AbstractMergeAction.askTargetLayer((Layer[])targetLayers.toArray(new Layer[targetLayers.size()]), (String)I18n.tr("Please select the target layer.", new Object[0]), (String)I18n.tr("Select target layer", new Object[0]), (String)I18n.tr("Merge", new Object[0]), (String)"dialogs/mergedown");
    }

    public static <T extends Layer> T askTargetLayer(T[] targetLayers, String label, String title, String buttonText, String buttonIcon) {
        JosmComboBox<T> layerList = new JosmComboBox<T>(targetLayers);
        layerList.setRenderer(new LayerListCellRenderer());
        layerList.setSelectedIndex(0);
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.add((Component)new JLabel(label), GBC.eol());
        pnl.add(layerList, GBC.eol());
        if (GraphicsEnvironment.isHeadless()) {
            return targetLayers[0];
        }
        ExtendedDialog ed = new ExtendedDialog(Main.parent, title, buttonText, I18n.tr("Cancel", new Object[0]));
        ed.setButtonIcons(buttonIcon, "cancel");
        ed.setContent(pnl);
        ed.showDialog();
        if (ed.getValue() != 1) {
            return null;
        }
        return (T)((Layer)layerList.getSelectedItem());
    }

    protected void warnNoTargetLayersForSourceLayer(Layer sourceLayer) {
        String message = I18n.tr("<html>There are no layers the source layer<br>''{0}''<br>could be merged to.</html>", Utils.escapeReservedCharactersHTML(sourceLayer.getName()));
        if (!GraphicsEnvironment.isHeadless()) {
            JOptionPane.showMessageDialog(Main.parent, message, I18n.tr("No target layers", new Object[0]), 2);
        }
    }

    public static class LayerListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Layer layer = (Layer)value;
            JLabel label = (JLabel)super.getListCellRendererComponent(list, layer.getName(), index, isSelected, cellHasFocus);
            label.setIcon(layer.getIcon());
            label.setToolTipText(layer.getToolTipText());
            return label;
        }
    }
}

