/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ToggleUploadDiscouragedLayerAction
extends AbstractAction
implements Layer.LayerAction {
    private final transient OsmDataLayer layer;

    public ToggleUploadDiscouragedLayerAction(OsmDataLayer layer) {
        super(I18n.tr("Discourage upload", new Object[0]), ImageProvider.get("no_upload"));
        this.layer = layer;
        this.setEnabled(layer.isUploadable());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.layer.setUploadDiscouraged(!this.layer.isUploadDiscouraged());
        LayerListDialog.getInstance().repaint();
    }

    @Override
    public Component createMenuComponent() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(this);
        item.setSelected(this.layer.isUploadDiscouraged() || !this.layer.isUploadable());
        return item;
    }

    @Override
    public boolean supportLayers(List<Layer> layers) {
        return layers.size() == 1 && layers.get(0) instanceof OsmDataLayer;
    }
}

