/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.io.XmlWriter;

public abstract class AbstractDownloadTask<T>
implements DownloadTask {
    private final List<Object> errorMessages = new ArrayList<Object>();
    private boolean canceled;
    private boolean failed;
    protected T downloadedData;
    protected boolean zoomAfterDownload = true;

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    protected final void rememberErrorMessage(String message) {
        this.errorMessages.add(message);
    }

    protected final void rememberException(Exception exception) {
        this.errorMessages.add(exception);
    }

    protected final void rememberDownloadedData(T data) {
        this.downloadedData = data;
    }

    public final T getDownloadedData() {
        return this.downloadedData;
    }

    public final void setZoomAfterDownload(boolean zoomAfterDownload) {
        this.zoomAfterDownload = zoomAfterDownload;
    }

    @Override
    public List<Object> getErrorObjects() {
        return this.errorMessages;
    }

    @Override
    public String acceptsDocumentationSummary() {
        StringBuilder buff = new StringBuilder(128).append("<tr><td>").append(this.getTitle()).append(":</td><td>");
        String[] patterns = this.getPatterns();
        if (patterns.length > 0) {
            buff.append("<ul>");
            for (String pattern : patterns) {
                buff.append("<li>").append(XmlWriter.encode(pattern)).append("</li>");
            }
            buff.append("</ul>");
        }
        buff.append("</td></tr>");
        return buff.toString();
    }

    public boolean acceptsUrl(String url) {
        if (url == null) {
            return false;
        }
        for (String p : this.getPatterns()) {
            if (!url.matches(p)) continue;
            return true;
        }
        return false;
    }

    public boolean isSafeForRemotecontrolRequests() {
        return false;
    }

    @Override
    public boolean acceptsUrl(String url, boolean isRemotecontrol) {
        if (isRemotecontrol && !this.isSafeForRemotecontrolRequests()) {
            return false;
        }
        return this.acceptsUrl(url);
    }

    @Override
    public String getTitle() {
        return this.getClass().getName();
    }

    public String toString() {
        return this.getTitle();
    }

    @Override
    public String[] getPatterns() {
        return new String[0];
    }

    public ProjectionBounds getDownloadProjectionBounds() {
        return null;
    }
}

