/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.awt.Component;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.AbstractChangesetDownloadTask;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class ChangesetHeaderDownloadTask
extends AbstractChangesetDownloadTask {
    public ChangesetHeaderDownloadTask(Collection<Integer> ids) {
        this(Main.parent, ids, false);
    }

    public ChangesetHeaderDownloadTask(Component dialogParent, Collection<Integer> ids) {
        this(dialogParent, ids, false);
    }

    public ChangesetHeaderDownloadTask(Component dialogParent, Collection<Integer> ids, boolean includeDiscussion) {
        this.setDownloadTask(new DownloadTask(dialogParent, ids, includeDiscussion));
    }

    public static ChangesetHeaderDownloadTask buildTaskForChangesets(Collection<Changeset> changesets) {
        return ChangesetHeaderDownloadTask.buildTaskForChangesets(Main.parent, changesets);
    }

    public static ChangesetHeaderDownloadTask buildTaskForChangesets(Component parent, Collection<Changeset> changesets) {
        CheckParameterUtil.ensureParameterNotNull(parent, "parent");
        HashSet<Integer> ids = new HashSet<Integer>();
        for (Changeset cs : changesets != null ? changesets : Collections.emptyList()) {
            if (cs == null || cs.isNew()) continue;
            ids.add(cs.getId());
        }
        return new ChangesetHeaderDownloadTask(parent, ids);
    }

    class DownloadTask
    extends AbstractChangesetDownloadTask.RunnableDownloadTask {
        private final Set<Integer> toDownload;
        private final boolean includeDiscussion;

        DownloadTask(Component parent, Collection<Integer> ids, boolean includeDiscussion) {
            super(ChangesetHeaderDownloadTask.this, parent, I18n.tr("Download changesets", new Object[0]));
            this.toDownload = new HashSet<Integer>();
            this.includeDiscussion = includeDiscussion;
            for (int id : ids != null ? ids : Collections.emptyList()) {
                if (id <= 0) continue;
                this.toDownload.add(id);
            }
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                this.downloadedChangesets.addAll(this.reader.readChangesets(this.toDownload, this.includeDiscussion, this.getProgressMonitor().createSubTaskMonitor(0, false)));
            }
            catch (OsmTransferException e) {
                if (ChangesetHeaderDownloadTask.this.isCanceled()) {
                    return;
                }
                this.rememberLastException(e);
            }
        }

        @Override
        protected void finish() {
            ChangesetHeaderDownloadTask.this.rememberDownloadedData(this.downloadedChangesets);
            if (ChangesetHeaderDownloadTask.this.isCanceled()) {
                return;
            }
            if (this.lastException != null) {
                ExceptionDialogUtil.explainException(this.lastException);
            }
            this.updateChangesets();
        }
    }
}

