/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import org.openstreetmap.josm.data.UserIdentityManager;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.notes.NoteComment;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.tools.ListenerList;
import org.openstreetmap.josm.tools.Logging;

public class NoteData {
    private long newNoteId = -1L;
    private final Storage<Note> noteList;
    private Note selectedNote;
    private Comparator<Note> comparator = Note.DEFAULT_COMPARATOR;
    private final ListenerList<NoteDataUpdateListener> listeners = ListenerList.create();

    public NoteData(Collection<Note> notes) {
        this.noteList = new Storage();
        if (notes != null) {
            for (Note note : notes) {
                this.noteList.add(note);
                if (note.getId() > this.newNoteId) continue;
                this.newNoteId = note.getId() - 1L;
            }
        }
    }

    public Collection<Note> getNotes() {
        return Collections.unmodifiableCollection(this.noteList);
    }

    public Collection<Note> getSortedNotes() {
        ArrayList<Note> list = new ArrayList<Note>(this.noteList);
        list.sort(this.comparator);
        return list;
    }

    public Note getSelectedNote() {
        return this.selectedNote;
    }

    public void setSelectedNote(Note note) {
        this.selectedNote = note;
        this.listeners.fireEvent(l -> l.selectedNoteChanged(this));
    }

    public synchronized boolean isModified() {
        for (Note note : this.noteList) {
            if (note.getId() < 0L) {
                return true;
            }
            for (NoteComment comment : note.getComments()) {
                if (!comment.isNew()) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized void addNotes(Collection<Note> newNotes) {
        for (Note newNote : newNotes) {
            if (!this.noteList.contains(newNote)) {
                this.noteList.add(newNote);
            } else {
                Note existingNote = this.noteList.get(newNote);
                boolean isDirty = existingNote.getComments().stream().anyMatch(NoteComment::isNew);
                if (!isDirty) {
                    this.noteList.put(newNote);
                } else {
                    Logging.info("Keeping existing note id={0} with uncommitted changes", String.valueOf(newNote.getId()));
                }
            }
            if (newNote.getId() > this.newNoteId) continue;
            this.newNoteId = newNote.getId() - 1L;
        }
        this.dataUpdated();
    }

    public synchronized void createNote(LatLon location, String text) {
        if (text == null || text.isEmpty()) {
            throw new IllegalArgumentException("Comment can not be blank when creating a note");
        }
        Note note = new Note(location);
        note.setCreatedAt(new Date());
        note.setState(Note.State.OPEN);
        note.setId(this.newNoteId--);
        NoteComment comment = new NoteComment(new Date(), NoteData.getCurrentUser(), text, NoteComment.Action.OPENED, true);
        note.addComment(comment);
        if (Logging.isDebugEnabled()) {
            Logging.debug("Created note {0} with comment: {1}", note.getId(), text);
        }
        this.noteList.add(note);
        this.dataUpdated();
    }

    public synchronized void addCommentToNote(Note note, String text) {
        if (!this.noteList.contains(note)) {
            throw new IllegalArgumentException("Note to modify must be in layer");
        }
        if (note.getState() == Note.State.CLOSED) {
            throw new IllegalStateException("Cannot add a comment to a closed note");
        }
        if (Logging.isDebugEnabled()) {
            Logging.debug("Adding comment to note {0}: {1}", note.getId(), text);
        }
        NoteComment comment = new NoteComment(new Date(), NoteData.getCurrentUser(), text, NoteComment.Action.COMMENTED, true);
        note.addComment(comment);
        this.dataUpdated();
    }

    public synchronized void closeNote(Note note, String text) {
        if (!this.noteList.contains(note)) {
            throw new IllegalArgumentException("Note to close must be in layer");
        }
        if (note.getState() != Note.State.OPEN) {
            throw new IllegalStateException("Cannot close a note that isn't open");
        }
        if (Logging.isDebugEnabled()) {
            Logging.debug("closing note {0} with comment: {1}", note.getId(), text);
        }
        NoteComment comment = new NoteComment(new Date(), NoteData.getCurrentUser(), text, NoteComment.Action.CLOSED, true);
        note.addComment(comment);
        note.setState(Note.State.CLOSED);
        note.setClosedAt(new Date());
        this.dataUpdated();
    }

    public synchronized void reOpenNote(Note note, String text) {
        if (!this.noteList.contains(note)) {
            throw new IllegalArgumentException("Note to reopen must be in layer");
        }
        if (note.getState() != Note.State.CLOSED) {
            throw new IllegalStateException("Cannot reopen a note that isn't closed");
        }
        Logging.debug("reopening note {0} with comment: {1}", note.getId(), text);
        NoteComment comment = new NoteComment(new Date(), NoteData.getCurrentUser(), text, NoteComment.Action.REOPENED, true);
        note.addComment(comment);
        note.setState(Note.State.OPEN);
        this.dataUpdated();
    }

    private void dataUpdated() {
        this.listeners.fireEvent(l -> l.noteDataUpdated(this));
    }

    private static User getCurrentUser() {
        UserIdentityManager userMgr = UserIdentityManager.getInstance();
        return User.createOsmUser(userMgr.getUserId(), userMgr.getUserName());
    }

    public synchronized void updateNotes(Map<Note, Note> updatedNotes) {
        for (Map.Entry<Note, Note> entry : updatedNotes.entrySet()) {
            boolean reindex;
            Note oldNote = entry.getKey();
            Note newNote = entry.getValue();
            boolean bl = reindex = oldNote.hashCode() != newNote.hashCode();
            if (reindex) {
                this.noteList.removeElem(oldNote);
            }
            oldNote.updateWith(newNote);
            if (!reindex) continue;
            this.noteList.add(oldNote);
        }
        this.dataUpdated();
    }

    public Comparator<Note> getCurrentSortMethod() {
        return this.comparator;
    }

    public void setSortMethod(Comparator<Note> comparator) {
        this.comparator = comparator;
        this.dataUpdated();
    }

    public void addNoteDataUpdateListener(NoteDataUpdateListener listener) {
        this.listeners.addListener(listener);
    }

    public void removeNoteDataUpdateListener(NoteDataUpdateListener listener) {
        this.listeners.removeListener(listener);
    }

    public static interface NoteDataUpdateListener {
        public void noteDataUpdated(NoteData var1);

        public void selectedNoteChanged(NoteData var1);
    }
}

