/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictResolverModel;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolverModel;

public class CombinePrimitiveResolver {
    private final TagConflictResolverModel modelTagConflictResolver;
    private final RelationMemberConflictResolverModel modelRelConflictResolver;

    public CombinePrimitiveResolver(TagConflictResolverModel tagModel, RelationMemberConflictResolverModel relModel) {
        this.modelTagConflictResolver = tagModel;
        this.modelRelConflictResolver = relModel;
    }

    public List<Command> buildResolutionCommands(OsmPrimitive targetPrimitive) {
        LinkedList<Command> cmds = new LinkedList<Command>();
        TagCollection allResolutions = this.modelTagConflictResolver.getAllResolutions();
        if (!allResolutions.isEmpty()) {
            cmds.addAll(this.buildTagChangeCommand(targetPrimitive, allResolutions));
        }
        for (String p : OsmPrimitive.getDiscardableKeys()) {
            if (targetPrimitive.get(p) == null) continue;
            cmds.add(new ChangePropertyCommand(targetPrimitive, p, null));
        }
        if (this.modelRelConflictResolver.getNumDecisions() > 0) {
            cmds.addAll(this.modelRelConflictResolver.buildResolutionCommands(targetPrimitive));
        }
        return cmds;
    }

    protected List<Command> buildTagChangeCommand(OsmPrimitive primitive, TagCollection tc) {
        LinkedList<Command> cmds = new LinkedList<Command>();
        for (String key : tc.getKeys()) {
            if (tc.hasUniqueEmptyValue(key)) {
                if (primitive.get(key) == null) continue;
                cmds.add(new ChangePropertyCommand(primitive, key, null));
                continue;
            }
            String value = tc.getJoinedValues(key);
            if (value.equals(primitive.get(key))) continue;
            cmds.add(new ChangePropertyCommand(primitive, key, value));
        }
        return cmds;
    }
}

