/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.DropMode;
import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.ZoomToAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.relation.IMemberModelListener;
import org.openstreetmap.josm.gui.dialogs.relation.MemberRoleCellEditor;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableColumnModel;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTransferHandler;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.HighlightHelper;
import org.openstreetmap.josm.gui.widgets.OsmPrimitivesTable;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;

public class MemberTable
extends OsmPrimitivesTable
implements IMemberModelListener {
    private ZoomToGapAction zoomToGap;
    private final transient HighlightHelper highlightHelper = new HighlightHelper();
    private boolean highlightEnabled;
    private transient ListSelectionListener highlighterListener = lse -> {
        if (MainApplication.isDisplayingMapView()) {
            Collection<RelationMember> sel = this.getMemberTableModel().getSelectedMembers();
            HashSet<OsmPrimitive> toHighlight = new HashSet<OsmPrimitive>();
            for (RelationMember r : sel) {
                if (!r.getMember().isUsable()) continue;
                toHighlight.add(r.getMember());
            }
            SwingUtilities.invokeLater(() -> {
                if (MainApplication.isDisplayingMapView() && this.highlightHelper.highlightOnly(toHighlight)) {
                    MainApplication.getMap().mapView.repaint();
                }
            });
        }
    };

    public MemberTable(OsmDataLayer layer, Relation relation, MemberTableModel model) {
        super(model, (TableColumnModel)new MemberTableColumnModel(layer.data, relation), (ListSelectionModel)model.getSelectionModel());
        this.setLayer(layer);
        model.addMemberModelListener(this);
        MemberRoleCellEditor ce = (MemberRoleCellEditor)this.getColumnModel().getColumn(0).getCellEditor();
        this.setRowHeight(ce.getEditor().getPreferredSize().height);
        this.setAutoResizeMode(4);
        this.setSelectionMode(2);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.installCustomNavigation(0);
        this.initHighlighting();
        if (!GraphicsEnvironment.isHeadless()) {
            this.setTransferHandler(new MemberTransferHandler());
            this.setFillsViewportHeight(true);
            if (!GraphicsEnvironment.isHeadless()) {
                this.setDragEnabled(true);
            }
            this.setDropMode(DropMode.INSERT_ROWS);
        }
    }

    @Override
    protected ZoomToAction buildZoomToAction() {
        return new ZoomToAction(this);
    }

    @Override
    protected JPopupMenu buildPopupMenu() {
        JPopupMenu menu = super.buildPopupMenu();
        this.zoomToGap = new ZoomToGapAction();
        this.registerListeners();
        menu.addSeparator();
        this.getSelectionModel().addListSelectionListener(this.zoomToGap);
        menu.add(this.zoomToGap);
        menu.addSeparator();
        menu.add(new SelectPreviousGapAction());
        menu.add(new SelectNextGapAction());
        return menu;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getPreferredFullWidthSize();
    }

    @Override
    public void makeMemberVisible(int index) {
        this.scrollRectToVisible(this.getCellRect(index, 0, true));
    }

    private void initHighlighting() {
        this.highlightEnabled = Config.getPref().getBoolean("draw.target-highlight", true);
        if (!this.highlightEnabled) {
            return;
        }
        this.getMemberTableModel().getSelectionModel().addListSelectionListener(this.highlighterListener);
        if (MainApplication.isDisplayingMapView()) {
            HighlightHelper.clearAllHighlighted();
            MainApplication.getMap().mapView.repaint();
        }
    }

    @Override
    public void registerListeners() {
        MainApplication.getLayerManager().addLayerChangeListener(this.zoomToGap);
        MainApplication.getLayerManager().addActiveLayerChangeListener(this.zoomToGap);
        super.registerListeners();
    }

    @Override
    public void unregisterListeners() {
        super.unregisterListeners();
        MainApplication.getLayerManager().removeLayerChangeListener(this.zoomToGap);
        MainApplication.getLayerManager().removeActiveLayerChangeListener(this.zoomToGap);
    }

    public void stopHighlighting() {
        if (this.highlighterListener == null) {
            return;
        }
        if (!this.highlightEnabled) {
            return;
        }
        this.getMemberTableModel().getSelectionModel().removeListSelectionListener(this.highlighterListener);
        this.highlighterListener = null;
        if (MainApplication.isDisplayingMapView()) {
            HighlightHelper.clearAllHighlighted();
            MainApplication.getMap().mapView.repaint();
        }
    }

    protected MemberTableModel getMemberTableModel() {
        return (MemberTableModel)this.getModel();
    }

    private class ZoomToGapAction
    extends AbstractAction
    implements LayerManager.LayerChangeListener,
    MainLayerManager.ActiveLayerChangeListener,
    ListSelectionListener {
        private final Collection<WayConnectionType.Direction> connectionTypesOfInterest = Arrays.asList(WayConnectionType.Direction.FORWARD, WayConnectionType.Direction.BACKWARD);

        ZoomToGapAction() {
            this.putValue("Name", I18n.tr("Zoom to Gap", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Zoom to the gap in the way sequence", new Object[0]));
            this.updateEnabledState();
        }

        private WayConnectionType getConnectionType() {
            return MemberTable.this.getMemberTableModel().getWayConnection(MemberTable.this.getSelectedRows()[0]);
        }

        private boolean hasGap() {
            WayConnectionType connectionType = this.getConnectionType();
            return this.connectionTypesOfInterest.contains((Object)connectionType.direction) && (!connectionType.linkNext || !connectionType.linkPrev);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WayConnectionType connectionType = this.getConnectionType();
            Way way = (Way)MemberTable.this.getMemberTableModel().getReferredPrimitive(MemberTable.this.getSelectedRows()[0]);
            if (!connectionType.linkPrev) {
                MemberTable.this.getLayer().data.setSelected(WayConnectionType.Direction.FORWARD.equals((Object)connectionType.direction) ? way.firstNode() : way.lastNode());
                AutoScaleAction.autoScale("selection");
            } else if (!connectionType.linkNext) {
                MemberTable.this.getLayer().data.setSelected(WayConnectionType.Direction.FORWARD.equals((Object)connectionType.direction) ? way.lastNode() : way.firstNode());
                AutoScaleAction.autoScale("selection");
            }
        }

        private void updateEnabledState() {
            this.setEnabled(Main.main != null && MainApplication.getLayerManager().getEditLayer() == MemberTable.this.getLayer() && MemberTable.this.getSelectedRowCount() == 1 && this.hasGap());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void layerAdded(LayerManager.LayerAddEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void layerRemoving(LayerManager.LayerRemoveEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
        }
    }

    private class SelectNextGapAction
    extends AbstractAction {
        SelectNextGapAction() {
            this.putValue("Name", I18n.tr("Select next Gap", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Select the next relation member which gives rise to a gap", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            for (i = MemberTable.this.getSelectedRow() + 1; i < MemberTable.this.getRowCount() && MemberTable.this.getMemberTableModel().getWayConnection((int)i).linkNext; ++i) {
            }
            if (i < MemberTable.this.getRowCount()) {
                MemberTable.this.getSelectionModel().setSelectionInterval(i, i);
            }
        }
    }

    private class SelectPreviousGapAction
    extends AbstractAction {
        SelectPreviousGapAction() {
            this.putValue("Name", I18n.tr("Select previous Gap", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Select the previous relation member which gives rise to a gap", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            for (i = MemberTable.this.getSelectedRow() - 1; i >= 0 && MemberTable.this.getMemberTableModel().getWayConnection((int)i).linkPrev; --i) {
            }
            if (i >= 0) {
                MemberTable.this.getSelectionModel().setSelectionInterval(i, i);
            }
        }
    }
}

