/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.ac;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import java.util.Objects;
import javax.swing.ComboBoxEditor;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleConstants;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.util.CellEditorSupport;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;

public class AutoCompletingTextField
extends JosmTextField
implements ComboBoxEditor,
TableCellEditor {
    private Integer maxChars;
    protected AutoCompletionList autoCompletionList;
    protected String noAutoCompletionString;
    private transient CellEditorSupport tableCellEditorSupport;
    private String originalValue;

    @Override
    protected Document createDefaultModel() {
        return new AutoCompletionDocument();
    }

    protected final void init() {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AutoCompletingTextField.this.selectAll();
                AutoCompletingTextField.this.applyFilter(AutoCompletingTextField.this.getText());
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (AutoCompletingTextField.this.getText().isEmpty()) {
                    AutoCompletingTextField.this.applyFilter("");
                }
            }
        });
        this.tableCellEditorSupport = new CellEditorSupport(this);
    }

    public AutoCompletingTextField() {
        this(0);
    }

    public AutoCompletingTextField(int columns) {
        this(columns, true);
    }

    public AutoCompletingTextField(int columns, boolean undoRedo) {
        super(null, null, columns, undoRedo);
        this.init();
    }

    protected void applyFilter(String filter) {
        if (this.autoCompletionList != null) {
            this.autoCompletionList.applyFilter(filter);
        }
    }

    public AutoCompletionList getAutoCompletionList() {
        return this.autoCompletionList;
    }

    public void setAutoCompletionList(AutoCompletionList autoCompletionList) {
        this.autoCompletionList = autoCompletionList;
    }

    @Override
    public Component getEditorComponent() {
        return this;
    }

    @Override
    public Object getItem() {
        return this.getText();
    }

    @Override
    public void setItem(Object anObject) {
        if (anObject == null) {
            this.setText("");
        } else {
            this.setText(anObject.toString());
        }
    }

    @Override
    public void setText(String t) {
        this.noAutoCompletionString = t;
        super.setText(t);
    }

    public void setMaxChars(Integer max) {
        this.maxChars = max;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.tableCellEditorSupport.addCellEditorListener(l);
    }

    protected void rememberOriginalValue(String value) {
        this.originalValue = value;
    }

    protected void restoreOriginalValue() {
        this.setText(this.originalValue);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.tableCellEditorSupport.removeCellEditorListener(l);
    }

    @Override
    public void cancelCellEditing() {
        this.restoreOriginalValue();
        this.tableCellEditorSupport.fireEditingCanceled();
    }

    @Override
    public Object getCellEditorValue() {
        return this.getText();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.tableCellEditorSupport.fireEditingStopped();
        return true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.setText(value == null ? "" : value.toString());
        this.rememberOriginalValue(this.getText());
        return this;
    }

    class AutoCompletionDocument
    extends PlainDocument {
        AutoCompletionDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (AutoCompletingTextField.this.maxChars != null && str != null && this.getLength() + str.length() > AutoCompletingTextField.this.maxChars) {
                int allowedLength = AutoCompletingTextField.this.maxChars - this.getLength();
                if (allowedLength > 0) {
                    str = str.substring(0, allowedLength);
                } else {
                    return;
                }
            }
            if (AutoCompletingTextField.this.autoCompletionList == null) {
                super.insertString(offs, str, a);
                return;
            }
            if (a != null && a.isDefined(StyleConstants.ComposedTextAttribute)) {
                super.insertString(offs, str, a);
                return;
            }
            if (offs < this.getLength()) {
                super.insertString(offs, str, a);
                return;
            }
            String currentText = this.getText(0, this.getLength());
            if (Config.getPref().getBoolean("autocomplete.dont_complete_numbers", true)) {
                try {
                    Long.parseLong(str);
                    if (currentText.isEmpty()) {
                        super.insertString(offs, str, a);
                        return;
                    }
                    Long.parseLong(currentText);
                    super.insertString(offs, str, a);
                    return;
                }
                catch (NumberFormatException e) {
                    Logging.trace(e);
                }
            }
            String prefix = currentText.substring(0, offs);
            AutoCompletingTextField.this.autoCompletionList.applyFilter(prefix + str);
            if (AutoCompletingTextField.this.autoCompletionList.getFilteredSize() > 0 && !Objects.equals(str, AutoCompletingTextField.this.noAutoCompletionString)) {
                String matchingString = AutoCompletingTextField.this.autoCompletionList.getFilteredItemAt(0).getValue();
                this.remove(0, this.getLength());
                super.insertString(0, matchingString, a);
                AutoCompletingTextField.this.setCaretPosition(offs + str.length());
                AutoCompletingTextField.this.moveCaretPosition(this.getLength());
            } else {
                String newText = prefix + str;
                this.remove(0, this.getLength());
                super.insertString(0, newText, a);
                AutoCompletingTextField.this.setCaretPosition(this.getLength());
            }
        }
    }
}

