/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.heapwalk.HeapWalkerManager;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.ui.Bundle;
import org.openide.windows.WindowManager;

public final class OpenHeapWalkerAction
implements ActionListener {
    private static File importDir;

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        final File file = OpenHeapWalkerAction.getHeapDumpFile();
        BrowserUtils.performTask(new Runnable(){

            @Override
            public void run() {
                if (file != null) {
                    HeapWalkerManager.getDefault().openHeapWalker(file);
                }
            }
        });
    }

    private static File getHeapDumpFile() {
        JFileChooser jFileChooser = new JFileChooser();
        if (importDir != null) {
            jFileChooser.setCurrentDirectory(importDir);
        }
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setDialogType(0);
        jFileChooser.removeChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
        jFileChooser.addChoosableFileFilter(new FileFilterImpl());
        jFileChooser.setDialogTitle(Bundle.OpenHeapWalkerAction_DialogCaption());
        if (jFileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow()) == 0) {
            importDir = jFileChooser.getCurrentDirectory();
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    private static class FileFilterImpl
    extends FileFilter {
        private FileFilterImpl() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return ResultsManager.checkHprofFile((File)file);
        }

        @Override
        public String getDescription() {
            return Bundle.FileDescription();
        }
    }
}

