/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.AdobeMarkerSegment;
import com.sun.imageio.plugins.jpeg.COMMarkerSegment;
import com.sun.imageio.plugins.jpeg.DHTMarkerSegment;
import com.sun.imageio.plugins.jpeg.DQTMarkerSegment;
import com.sun.imageio.plugins.jpeg.DRIMarkerSegment;
import com.sun.imageio.plugins.jpeg.JFIFMarkerSegment;
import com.sun.imageio.plugins.jpeg.JPEG;
import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import com.sun.imageio.plugins.jpeg.JPEGImageReader;
import com.sun.imageio.plugins.jpeg.JPEGImageWriter;
import com.sun.imageio.plugins.jpeg.MarkerSegment;
import com.sun.imageio.plugins.jpeg.SOFMarkerSegment;
import com.sun.imageio.plugins.jpeg.SOSMarkerSegment;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.imageio.IIOException;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JPEGMetadata
extends IIOMetadata
implements Cloneable {
    private static final boolean debug = false;
    private List resetSequence;
    private boolean inThumb;
    private boolean hasAlpha;
    List markerSequence;
    final boolean isStream;
    private boolean transparencyDone;

    JPEGMetadata(boolean isStream, boolean inThumb) {
        super(true, "javax_imageio_jpeg_image_1.0", "com.sun.imageio.plugins.jpeg.JPEGImageMetadataFormat", null, null);
        this.resetSequence = null;
        this.inThumb = false;
        this.markerSequence = new ArrayList();
        this.inThumb = inThumb;
        this.isStream = isStream;
        if (isStream) {
            this.nativeMetadataFormatName = "javax_imageio_jpeg_stream_1.0";
            this.nativeMetadataFormatClassName = "com.sun.imageio.plugins.jpeg.JPEGStreamMetadataFormat";
        }
    }

    JPEGMetadata(boolean isStream, boolean isThumb, ImageInputStream iis, JPEGImageReader reader) throws IOException {
        this(isStream, isThumb);
        JPEGBuffer buffer = new JPEGBuffer(iis);
        buffer.loadBuf(0);
        if ((buffer.buf[0] & 0xFF) != 255 || (buffer.buf[1] & 0xFF) != 216 || (buffer.buf[2] & 0xFF) != 255) {
            throw new IIOException("Image format error");
        }
        boolean done = false;
        buffer.bufAvail -= 2;
        buffer.bufPtr = 2;
        MarkerSegment newGuy = null;
        while (!done) {
            buffer.loadBuf(1);
            buffer.scanForFF(reader);
            switch (buffer.buf[buffer.bufPtr] & 0xFF) {
                case 0: {
                    --buffer.bufAvail;
                    ++buffer.bufPtr;
                    break;
                }
                case 192: 
                case 193: 
                case 194: {
                    if (isStream) {
                        throw new IIOException("SOF not permitted in stream metadata");
                    }
                    newGuy = new SOFMarkerSegment(buffer);
                    break;
                }
                case 219: {
                    newGuy = new DQTMarkerSegment(buffer);
                    break;
                }
                case 196: {
                    newGuy = new DHTMarkerSegment(buffer);
                    break;
                }
                case 221: {
                    newGuy = new DRIMarkerSegment(buffer);
                    break;
                }
                case 224: {
                    JFIFMarkerSegment jfif;
                    buffer.loadBuf(8);
                    byte[] buf = buffer.buf;
                    int ptr = buffer.bufPtr;
                    if (buf[ptr + 3] == 74 && buf[ptr + 4] == 70 && buf[ptr + 5] == 73 && buf[ptr + 6] == 70 && buf[ptr + 7] == 0) {
                        if (this.inThumb) {
                            reader.warningOccurred(1);
                            JFIFMarkerSegment jFIFMarkerSegment = new JFIFMarkerSegment(buffer);
                            break;
                        }
                        if (isStream) {
                            throw new IIOException("JFIF not permitted in stream metadata");
                        }
                        if (!this.markerSequence.isEmpty()) {
                            throw new IIOException("JFIF APP0 must be first marker after SOI");
                        }
                        newGuy = new JFIFMarkerSegment(buffer);
                        break;
                    }
                    if (buf[ptr + 3] == 74 && buf[ptr + 4] == 70 && buf[ptr + 5] == 88 && buf[ptr + 6] == 88 && buf[ptr + 7] == 0) {
                        if (isStream) {
                            throw new IIOException("JFXX not permitted in stream metadata");
                        }
                        if (this.inThumb) {
                            throw new IIOException("JFXX markers not allowed in JFIF JPEG thumbnail");
                        }
                        jfif = (JFIFMarkerSegment)this.findMarkerSegment(JFIFMarkerSegment.class, true);
                        if (jfif == null) {
                            throw new IIOException("JFXX encountered without prior JFIF!");
                        }
                        jfif.addJFXX(buffer, reader);
                        break;
                    }
                    newGuy = new MarkerSegment(buffer);
                    newGuy.loadData(buffer);
                    break;
                }
                case 226: {
                    JFIFMarkerSegment jfif;
                    buffer.loadBuf(15);
                    if (buffer.buf[buffer.bufPtr + 3] == 73 && buffer.buf[buffer.bufPtr + 4] == 67 && buffer.buf[buffer.bufPtr + 5] == 67 && buffer.buf[buffer.bufPtr + 6] == 95 && buffer.buf[buffer.bufPtr + 7] == 80 && buffer.buf[buffer.bufPtr + 8] == 82 && buffer.buf[buffer.bufPtr + 9] == 79 && buffer.buf[buffer.bufPtr + 10] == 70 && buffer.buf[buffer.bufPtr + 11] == 73 && buffer.buf[buffer.bufPtr + 12] == 76 && buffer.buf[buffer.bufPtr + 13] == 69 && buffer.buf[buffer.bufPtr + 14] == 0) {
                        if (isStream) {
                            throw new IIOException("ICC profiles not permitted in stream metadata");
                        }
                        jfif = (JFIFMarkerSegment)this.findMarkerSegment(JFIFMarkerSegment.class, true);
                        if (jfif == null) {
                            newGuy = new MarkerSegment(buffer);
                            newGuy.loadData(buffer);
                            break;
                        }
                        jfif.addICC(buffer);
                        break;
                    }
                    newGuy = new MarkerSegment(buffer);
                    newGuy.loadData(buffer);
                    break;
                }
                case 238: {
                    buffer.loadBuf(8);
                    if (buffer.buf[buffer.bufPtr + 3] == 65 && buffer.buf[buffer.bufPtr + 4] == 100 && buffer.buf[buffer.bufPtr + 5] == 111 && buffer.buf[buffer.bufPtr + 6] == 98 && buffer.buf[buffer.bufPtr + 7] == 101) {
                        if (isStream) {
                            throw new IIOException("Adobe APP14 markers not permitted in stream metadata");
                        }
                        newGuy = new AdobeMarkerSegment(buffer);
                        break;
                    }
                    newGuy = new MarkerSegment(buffer);
                    newGuy.loadData(buffer);
                    break;
                }
                case 254: {
                    newGuy = new COMMarkerSegment(buffer);
                    break;
                }
                case 218: {
                    if (isStream) {
                        throw new IIOException("SOS not permitted in stream metadata");
                    }
                    newGuy = new SOSMarkerSegment(buffer);
                    break;
                }
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 212: 
                case 213: 
                case 214: 
                case 215: {
                    ++buffer.bufPtr;
                    --buffer.bufAvail;
                    break;
                }
                case 217: {
                    done = true;
                    ++buffer.bufPtr;
                    --buffer.bufAvail;
                    break;
                }
                default: {
                    newGuy = new MarkerSegment(buffer);
                    newGuy.loadData(buffer);
                    newGuy.unknown = true;
                }
            }
            if (newGuy == null) continue;
            this.markerSequence.add(newGuy);
            newGuy = null;
        }
        buffer.pushBack();
        if (!this.isConsistent()) {
            throw new IIOException("Inconsistent metadata read from stream");
        }
    }

    JPEGMetadata(ImageWriteParam param, JPEGImageWriter writer) {
        this(true, false);
        JPEGImageWriteParam jparam = null;
        if (param != null && param instanceof JPEGImageWriteParam && !(jparam = (JPEGImageWriteParam)param).areTablesSet()) {
            jparam = null;
        }
        if (jparam != null) {
            this.markerSequence.add(new DQTMarkerSegment(jparam.getQTables()));
            this.markerSequence.add(new DHTMarkerSegment(jparam.getDCHuffmanTables(), jparam.getACHuffmanTables()));
        } else {
            this.markerSequence.add(new DQTMarkerSegment(JPEG.getDefaultQTables()));
            this.markerSequence.add(new DHTMarkerSegment(JPEG.getDefaultHuffmanTables(true), JPEG.getDefaultHuffmanTables(false)));
        }
        if (!this.isConsistent()) {
            throw new InternalError("Default stream metadata is inconsistent");
        }
    }

    JPEGMetadata(ImageTypeSpecifier imageType, ImageWriteParam param, JPEGImageWriter writer) {
        ColorSpace cs;
        int numComponents;
        byte[] componentIDs;
        float quality;
        boolean wantHTables;
        boolean wantQTables;
        boolean wantExtended;
        boolean wantProg;
        boolean wantICC;
        boolean willSubsample;
        int transform;
        boolean wantAdobe;
        boolean wantJFIF;
        block39: {
            ColorModel cm;
            block38: {
                this(false, false);
                wantJFIF = true;
                wantAdobe = false;
                transform = 0;
                willSubsample = true;
                wantICC = false;
                wantProg = false;
                boolean wantOptimized = false;
                wantExtended = false;
                wantQTables = true;
                wantHTables = true;
                quality = 0.75f;
                componentIDs = new byte[]{1, 2, 3, 4};
                numComponents = 0;
                ImageTypeSpecifier destType = null;
                if (param != null) {
                    destType = param.getDestinationType();
                    if (destType != null && imageType != null) {
                        writer.warningOccurred(0);
                        destType = null;
                    }
                    if (param.canWriteProgressive() && param.getProgressiveMode() == 1) {
                        wantProg = true;
                        wantOptimized = true;
                        wantHTables = false;
                    }
                    if (param instanceof JPEGImageWriteParam) {
                        JPEGImageWriteParam jparam = (JPEGImageWriteParam)param;
                        if (jparam.areTablesSet()) {
                            wantQTables = false;
                            wantHTables = false;
                            if (jparam.getDCHuffmanTables().length > 2 || jparam.getACHuffmanTables().length > 2) {
                                wantExtended = true;
                            }
                        }
                        if (!wantProg && (wantOptimized = jparam.getOptimizeHuffmanTables())) {
                            wantHTables = false;
                        }
                    }
                    if (param.canWriteCompressed() && param.getCompressionMode() == 2) {
                        quality = param.getCompressionQuality();
                    }
                }
                cs = null;
                if (destType == null) break block38;
                cm = destType.getColorModel();
                numComponents = cm.getNumComponents();
                boolean hasExtraComponents = cm.getNumColorComponents() != numComponents;
                boolean hasAlpha = cm.hasAlpha();
                cs = cm.getColorSpace();
                int type = cs.getType();
                switch (type) {
                    case 6: {
                        willSubsample = false;
                        if (hasExtraComponents) {
                            wantJFIF = false;
                            break;
                        }
                        break block39;
                    }
                    case 13: {
                        if (cs == JPEG.JCS.getYCC()) {
                            wantJFIF = false;
                            componentIDs[0] = 89;
                            componentIDs[1] = 67;
                            componentIDs[2] = 99;
                            if (hasAlpha) {
                                componentIDs[3] = 65;
                                break;
                            }
                        }
                        break block39;
                    }
                    case 3: {
                        if (hasExtraComponents) {
                            wantJFIF = false;
                            if (!hasAlpha) {
                                wantAdobe = true;
                                transform = 2;
                                break;
                            }
                        }
                        break block39;
                    }
                    case 5: {
                        wantJFIF = false;
                        wantAdobe = true;
                        willSubsample = false;
                        componentIDs[0] = 82;
                        componentIDs[1] = 71;
                        componentIDs[2] = 66;
                        if (hasAlpha) {
                            componentIDs[3] = 65;
                            break;
                        }
                        break block39;
                    }
                    default: {
                        wantJFIF = false;
                        willSubsample = false;
                        break;
                    }
                }
                break block39;
            }
            if (imageType != null) {
                cm = imageType.getColorModel();
                numComponents = cm.getNumComponents();
                boolean hasExtraComponents = cm.getNumColorComponents() != numComponents;
                boolean hasAlpha = cm.hasAlpha();
                cs = cm.getColorSpace();
                int type = cs.getType();
                switch (type) {
                    case 6: {
                        willSubsample = false;
                        if (!hasExtraComponents) break;
                        wantJFIF = false;
                        break;
                    }
                    case 5: {
                        if (!hasAlpha) break;
                        wantJFIF = false;
                        break;
                    }
                    case 13: {
                        wantJFIF = false;
                        willSubsample = false;
                        if (!cs.equals(ColorSpace.getInstance(1002))) break;
                        willSubsample = true;
                        wantAdobe = true;
                        componentIDs[0] = 89;
                        componentIDs[1] = 67;
                        componentIDs[2] = 99;
                        if (!hasAlpha) break;
                        componentIDs[3] = 65;
                        break;
                    }
                    case 3: {
                        if (!hasExtraComponents) break;
                        wantJFIF = false;
                        if (hasAlpha) break;
                        wantAdobe = true;
                        transform = 2;
                        break;
                    }
                    case 9: {
                        wantJFIF = false;
                        wantAdobe = true;
                        transform = 2;
                        break;
                    }
                    default: {
                        wantJFIF = false;
                        willSubsample = false;
                    }
                }
            }
        }
        if (wantJFIF && JPEG.isNonStandardICC(cs)) {
            wantICC = true;
        }
        if (wantJFIF) {
            JFIFMarkerSegment jfif = new JFIFMarkerSegment();
            this.markerSequence.add(jfif);
            if (wantICC) {
                try {
                    jfif.addICC((ICC_ColorSpace)cs);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (wantAdobe) {
            this.markerSequence.add(new AdobeMarkerSegment(transform));
        }
        if (wantQTables) {
            this.markerSequence.add(new DQTMarkerSegment(quality, willSubsample));
        }
        if (wantHTables) {
            this.markerSequence.add(new DHTMarkerSegment(willSubsample));
        }
        this.markerSequence.add(new SOFMarkerSegment(wantProg, wantExtended, willSubsample, componentIDs, numComponents));
        if (!wantProg) {
            this.markerSequence.add(new SOSMarkerSegment(willSubsample, componentIDs, numComponents));
        }
        if (!this.isConsistent()) {
            throw new InternalError("Default image metadata is inconsistent");
        }
    }

    MarkerSegment findMarkerSegment(int tag) {
        for (MarkerSegment seg : this.markerSequence) {
            if (seg.tag != tag) continue;
            return seg;
        }
        return null;
    }

    MarkerSegment findMarkerSegment(Class cls, boolean first) {
        if (first) {
            for (MarkerSegment seg : this.markerSequence) {
                if (!cls.isInstance(seg)) continue;
                return seg;
            }
        } else {
            ListIterator iter = this.markerSequence.listIterator(this.markerSequence.size());
            while (iter.hasPrevious()) {
                MarkerSegment seg = (MarkerSegment)iter.previous();
                if (!cls.isInstance(seg)) continue;
                return seg;
            }
        }
        return null;
    }

    private int findMarkerSegmentPosition(Class cls, boolean first) {
        if (first) {
            ListIterator iter = this.markerSequence.listIterator();
            int i = 0;
            while (iter.hasNext()) {
                MarkerSegment seg = (MarkerSegment)iter.next();
                if (cls.isInstance(seg)) {
                    return i;
                }
                ++i;
            }
        } else {
            ListIterator iter = this.markerSequence.listIterator(this.markerSequence.size());
            int i = this.markerSequence.size() - 1;
            while (iter.hasPrevious()) {
                MarkerSegment seg = (MarkerSegment)iter.previous();
                if (cls.isInstance(seg)) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    private int findLastUnknownMarkerSegmentPosition() {
        ListIterator iter = this.markerSequence.listIterator(this.markerSequence.size());
        int i = this.markerSequence.size() - 1;
        while (iter.hasPrevious()) {
            MarkerSegment seg = (MarkerSegment)iter.previous();
            if (seg.unknown) {
                return i;
            }
            --i;
        }
        return -1;
    }

    protected Object clone() {
        JPEGMetadata newGuy = null;
        try {
            newGuy = (JPEGMetadata)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (this.markerSequence != null) {
            newGuy.markerSequence = this.cloneSequence();
        }
        newGuy.resetSequence = null;
        return newGuy;
    }

    private List cloneSequence() {
        if (this.markerSequence == null) {
            return null;
        }
        ArrayList<Object> retval = new ArrayList<Object>(this.markerSequence.size());
        for (MarkerSegment seg : this.markerSequence) {
            retval.add(seg.clone());
        }
        return retval;
    }

    @Override
    public Node getAsTree(String formatName) {
        if (formatName == null) {
            throw new IllegalArgumentException("null formatName!");
        }
        if (this.isStream) {
            if (formatName.equals("javax_imageio_jpeg_stream_1.0")) {
                return this.getNativeTree();
            }
        } else {
            if (formatName.equals("javax_imageio_jpeg_image_1.0")) {
                return this.getNativeTree();
            }
            if (formatName.equals("javax_imageio_1.0")) {
                return this.getStandardTree();
            }
        }
        throw new IllegalArgumentException("Unsupported format name: " + formatName);
    }

    IIOMetadataNode getNativeTree() {
        IIOMetadataNode top;
        IIOMetadataNode root;
        Iterator iter = this.markerSequence.iterator();
        if (this.isStream) {
            top = root = new IIOMetadataNode("javax_imageio_jpeg_stream_1.0");
        } else {
            IIOMetadataNode sequence = new IIOMetadataNode("markerSequence");
            if (!this.inThumb) {
                root = new IIOMetadataNode("javax_imageio_jpeg_image_1.0");
                IIOMetadataNode header = new IIOMetadataNode("JPEGvariety");
                root.appendChild(header);
                JFIFMarkerSegment jfif = (JFIFMarkerSegment)this.findMarkerSegment(JFIFMarkerSegment.class, true);
                if (jfif != null) {
                    iter.next();
                    header.appendChild(jfif.getNativeNode());
                }
                root.appendChild(sequence);
            } else {
                root = sequence;
            }
            top = sequence;
        }
        while (iter.hasNext()) {
            MarkerSegment seg = (MarkerSegment)iter.next();
            top.appendChild(seg.getNativeNode());
        }
        return root;
    }

    @Override
    protected IIOMetadataNode getStandardChromaNode() {
        this.hasAlpha = false;
        SOFMarkerSegment sof = (SOFMarkerSegment)this.findMarkerSegment(SOFMarkerSegment.class, true);
        if (sof == null) {
            return null;
        }
        IIOMetadataNode chroma = new IIOMetadataNode("Chroma");
        IIOMetadataNode csType = new IIOMetadataNode("ColorSpaceType");
        chroma.appendChild(csType);
        int numChannels = sof.componentSpecs.length;
        IIOMetadataNode numChanNode = new IIOMetadataNode("NumChannels");
        chroma.appendChild(numChanNode);
        numChanNode.setAttribute("value", Integer.toString(numChannels));
        if (this.findMarkerSegment(JFIFMarkerSegment.class, true) != null) {
            if (numChannels == 1) {
                csType.setAttribute("name", "GRAY");
            } else {
                csType.setAttribute("name", "YCbCr");
            }
            return chroma;
        }
        AdobeMarkerSegment adobe = (AdobeMarkerSegment)this.findMarkerSegment(AdobeMarkerSegment.class, true);
        if (adobe != null) {
            switch (adobe.transform) {
                case 2: {
                    csType.setAttribute("name", "YCCK");
                    break;
                }
                case 1: {
                    csType.setAttribute("name", "YCbCr");
                    break;
                }
                case 0: {
                    if (numChannels == 3) {
                        csType.setAttribute("name", "RGB");
                        break;
                    }
                    if (numChannels != 4) break;
                    csType.setAttribute("name", "CMYK");
                }
            }
            return chroma;
        }
        if (numChannels < 3) {
            csType.setAttribute("name", "GRAY");
            if (numChannels == 2) {
                this.hasAlpha = true;
            }
            return chroma;
        }
        boolean idsAreJFIF = true;
        for (int i = 0; i < sof.componentSpecs.length; ++i) {
            int id = sof.componentSpecs[i].componentId;
            if (id >= 1 && id < sof.componentSpecs.length) continue;
            idsAreJFIF = false;
        }
        if (idsAreJFIF) {
            csType.setAttribute("name", "YCbCr");
            if (numChannels == 4) {
                this.hasAlpha = true;
            }
            return chroma;
        }
        if (sof.componentSpecs[0].componentId == 82 && sof.componentSpecs[1].componentId == 71 && sof.componentSpecs[2].componentId == 66) {
            csType.setAttribute("name", "RGB");
            if (numChannels == 4 && sof.componentSpecs[3].componentId == 65) {
                this.hasAlpha = true;
            }
            return chroma;
        }
        if (sof.componentSpecs[0].componentId == 89 && sof.componentSpecs[1].componentId == 67 && sof.componentSpecs[2].componentId == 99) {
            csType.setAttribute("name", "PhotoYCC");
            if (numChannels == 4 && sof.componentSpecs[3].componentId == 65) {
                this.hasAlpha = true;
            }
            return chroma;
        }
        boolean subsampled = false;
        int hfactor = sof.componentSpecs[0].HsamplingFactor;
        int vfactor = sof.componentSpecs[0].VsamplingFactor;
        for (int i = 1; i < sof.componentSpecs.length; ++i) {
            if (sof.componentSpecs[i].HsamplingFactor == hfactor && sof.componentSpecs[i].VsamplingFactor == vfactor) continue;
            subsampled = true;
            break;
        }
        if (subsampled) {
            csType.setAttribute("name", "YCbCr");
            if (numChannels == 4) {
                this.hasAlpha = true;
            }
            return chroma;
        }
        if (numChannels == 3) {
            csType.setAttribute("name", "RGB");
        } else {
            csType.setAttribute("name", "CMYK");
        }
        return chroma;
    }

    @Override
    protected IIOMetadataNode getStandardCompressionNode() {
        IIOMetadataNode compression = new IIOMetadataNode("Compression");
        IIOMetadataNode name = new IIOMetadataNode("CompressionTypeName");
        name.setAttribute("value", "JPEG");
        compression.appendChild(name);
        IIOMetadataNode lossless = new IIOMetadataNode("Lossless");
        lossless.setAttribute("value", "FALSE");
        compression.appendChild(lossless);
        int sosCount = 0;
        for (MarkerSegment ms : this.markerSequence) {
            if (ms.tag != 218) continue;
            ++sosCount;
        }
        if (sosCount != 0) {
            IIOMetadataNode prog = new IIOMetadataNode("NumProgressiveScans");
            prog.setAttribute("value", Integer.toString(sosCount));
            compression.appendChild(prog);
        }
        return compression;
    }

    @Override
    protected IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode dim = new IIOMetadataNode("Dimension");
        IIOMetadataNode orient = new IIOMetadataNode("ImageOrientation");
        orient.setAttribute("value", "normal");
        dim.appendChild(orient);
        JFIFMarkerSegment jfif = (JFIFMarkerSegment)this.findMarkerSegment(JFIFMarkerSegment.class, true);
        if (jfif != null) {
            float aspectRatio = jfif.resUnits == 0 ? (float)jfif.Xdensity / (float)jfif.Ydensity : (float)jfif.Ydensity / (float)jfif.Xdensity;
            IIOMetadataNode aspect = new IIOMetadataNode("PixelAspectRatio");
            aspect.setAttribute("value", Float.toString(aspectRatio));
            dim.insertBefore(aspect, orient);
            if (jfif.resUnits != 0) {
                float scale = jfif.resUnits == 1 ? 25.4f : 10.0f;
                IIOMetadataNode horiz = new IIOMetadataNode("HorizontalPixelSize");
                horiz.setAttribute("value", Float.toString(scale / (float)jfif.Xdensity));
                dim.appendChild(horiz);
                IIOMetadataNode vert = new IIOMetadataNode("VerticalPixelSize");
                vert.setAttribute("value", Float.toString(scale / (float)jfif.Ydensity));
                dim.appendChild(vert);
            }
        }
        return dim;
    }

    @Override
    protected IIOMetadataNode getStandardTextNode() {
        IIOMetadataNode text = null;
        if (this.findMarkerSegment(254) != null) {
            text = new IIOMetadataNode("Text");
            for (MarkerSegment seg : this.markerSequence) {
                if (seg.tag != 254) continue;
                COMMarkerSegment com = (COMMarkerSegment)seg;
                IIOMetadataNode entry = new IIOMetadataNode("TextEntry");
                entry.setAttribute("keyword", "comment");
                entry.setAttribute("value", com.getComment());
                text.appendChild(entry);
            }
        }
        return text;
    }

    @Override
    protected IIOMetadataNode getStandardTransparencyNode() {
        IIOMetadataNode trans = null;
        if (this.hasAlpha) {
            trans = new IIOMetadataNode("Transparency");
            IIOMetadataNode alpha = new IIOMetadataNode("Alpha");
            alpha.setAttribute("value", "nonpremultiplied");
            trans.appendChild(alpha);
        }
        return trans;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        if (formatName == null) {
            throw new IllegalArgumentException("null formatName!");
        }
        if (root == null) {
            throw new IllegalArgumentException("null root!");
        }
        List copy = null;
        copy = this.resetSequence == null ? (this.resetSequence = this.cloneSequence()) : this.cloneSequence();
        if (this.isStream && formatName.equals("javax_imageio_jpeg_stream_1.0")) {
            this.mergeNativeTree(root);
        } else if (!this.isStream && formatName.equals("javax_imageio_jpeg_image_1.0")) {
            this.mergeNativeTree(root);
        } else if (!this.isStream && formatName.equals("javax_imageio_1.0")) {
            this.mergeStandardTree(root);
        } else {
            throw new IllegalArgumentException("Unsupported format name: " + formatName);
        }
        if (!this.isConsistent()) {
            this.markerSequence = copy;
            throw new IIOInvalidTreeException("Merged tree is invalid; original restored", root);
        }
    }

    private void mergeNativeTree(Node root) throws IIOInvalidTreeException {
        String name = root.getNodeName();
        if (name != (this.isStream ? "javax_imageio_jpeg_stream_1.0" : "javax_imageio_jpeg_image_1.0")) {
            throw new IIOInvalidTreeException("Invalid root node name: " + name, root);
        }
        if (root.getChildNodes().getLength() != 2) {
            throw new IIOInvalidTreeException("JPEGvariety and markerSequence nodes must be present", root);
        }
        this.mergeJFIFsubtree(root.getFirstChild());
        this.mergeSequenceSubtree(root.getLastChild());
    }

    private void mergeJFIFsubtree(Node JPEGvariety) throws IIOInvalidTreeException {
        if (JPEGvariety.getChildNodes().getLength() != 0) {
            Node jfifNode = JPEGvariety.getFirstChild();
            JFIFMarkerSegment jfifSeg = (JFIFMarkerSegment)this.findMarkerSegment(JFIFMarkerSegment.class, true);
            if (jfifSeg != null) {
                jfifSeg.updateFromNativeNode(jfifNode, false);
            } else {
                this.markerSequence.add(0, new JFIFMarkerSegment(jfifNode));
            }
        }
    }

    private void mergeSequenceSubtree(Node sequenceTree) throws IIOInvalidTreeException {
        NodeList children = sequenceTree.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            String name = node.getNodeName();
            if (name.equals("dqt")) {
                this.mergeDQTNode(node);
                continue;
            }
            if (name.equals("dht")) {
                this.mergeDHTNode(node);
                continue;
            }
            if (name.equals("dri")) {
                this.mergeDRINode(node);
                continue;
            }
            if (name.equals("com")) {
                this.mergeCOMNode(node);
                continue;
            }
            if (name.equals("app14Adobe")) {
                this.mergeAdobeNode(node);
                continue;
            }
            if (name.equals("unknown")) {
                this.mergeUnknownNode(node);
                continue;
            }
            if (name.equals("sof")) {
                this.mergeSOFNode(node);
                continue;
            }
            if (name.equals("sos")) {
                this.mergeSOSNode(node);
                continue;
            }
            throw new IIOInvalidTreeException("Invalid node: " + name, node);
        }
    }

    private void mergeDQTNode(Node node) throws IIOInvalidTreeException {
        ArrayList<MarkerSegment> oldDQTs = new ArrayList<MarkerSegment>();
        for (MarkerSegment seg : this.markerSequence) {
            if (!(seg instanceof DQTMarkerSegment)) continue;
            oldDQTs.add(seg);
        }
        if (!oldDQTs.isEmpty()) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                int childID = MarkerSegment.getAttributeValue(child, null, "qtableId", 0, 3, true);
                DQTMarkerSegment dqt = null;
                int tableIndex = -1;
                for (int j = 0; j < oldDQTs.size(); ++j) {
                    DQTMarkerSegment testDQT = (DQTMarkerSegment)oldDQTs.get(j);
                    for (int k = 0; k < testDQT.tables.size(); ++k) {
                        DQTMarkerSegment.Qtable testTable = (DQTMarkerSegment.Qtable)testDQT.tables.get(k);
                        if (childID != testTable.tableID) continue;
                        dqt = testDQT;
                        tableIndex = k;
                        break;
                    }
                    if (dqt != null) break;
                }
                if (dqt != null) {
                    dqt.tables.set(tableIndex, dqt.getQtableFromNode(child));
                    continue;
                }
                dqt = (DQTMarkerSegment)oldDQTs.get(oldDQTs.size() - 1);
                dqt.tables.add(dqt.getQtableFromNode(child));
            }
        } else {
            DQTMarkerSegment newGuy = new DQTMarkerSegment(node);
            int firstDHT = this.findMarkerSegmentPosition(DHTMarkerSegment.class, true);
            int firstSOF = this.findMarkerSegmentPosition(SOFMarkerSegment.class, true);
            int firstSOS = this.findMarkerSegmentPosition(SOSMarkerSegment.class, true);
            if (firstDHT != -1) {
                this.markerSequence.add(firstDHT, newGuy);
            } else if (firstSOF != -1) {
                this.markerSequence.add(firstSOF, newGuy);
            } else if (firstSOS != -1) {
                this.markerSequence.add(firstSOS, newGuy);
            } else {
                this.markerSequence.add(newGuy);
            }
        }
    }

    private void mergeDHTNode(Node node) throws IIOInvalidTreeException {
        ArrayList<MarkerSegment> oldDHTs = new ArrayList<MarkerSegment>();
        for (MarkerSegment seg : this.markerSequence) {
            if (!(seg instanceof DHTMarkerSegment)) continue;
            oldDHTs.add(seg);
        }
        if (!oldDHTs.isEmpty()) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                NamedNodeMap attrs = child.getAttributes();
                int childID = MarkerSegment.getAttributeValue(child, attrs, "htableId", 0, 3, true);
                int childClass = MarkerSegment.getAttributeValue(child, attrs, "class", 0, 1, true);
                DHTMarkerSegment dht = null;
                int tableIndex = -1;
                for (int j = 0; j < oldDHTs.size(); ++j) {
                    DHTMarkerSegment testDHT = (DHTMarkerSegment)oldDHTs.get(j);
                    for (int k = 0; k < testDHT.tables.size(); ++k) {
                        DHTMarkerSegment.Htable testTable = (DHTMarkerSegment.Htable)testDHT.tables.get(k);
                        if (childID != testTable.tableID || childClass != testTable.tableClass) continue;
                        dht = testDHT;
                        tableIndex = k;
                        break;
                    }
                    if (dht != null) break;
                }
                if (dht != null) {
                    dht.tables.set(tableIndex, dht.getHtableFromNode(child));
                    continue;
                }
                dht = (DHTMarkerSegment)oldDHTs.get(oldDHTs.size() - 1);
                dht.tables.add(dht.getHtableFromNode(child));
            }
        } else {
            DHTMarkerSegment newGuy = new DHTMarkerSegment(node);
            int lastDQT = this.findMarkerSegmentPosition(DQTMarkerSegment.class, false);
            int firstSOF = this.findMarkerSegmentPosition(SOFMarkerSegment.class, true);
            int firstSOS = this.findMarkerSegmentPosition(SOSMarkerSegment.class, true);
            if (lastDQT != -1) {
                this.markerSequence.add(lastDQT + 1, newGuy);
            } else if (firstSOF != -1) {
                this.markerSequence.add(firstSOF, newGuy);
            } else if (firstSOS != -1) {
                this.markerSequence.add(firstSOS, newGuy);
            } else {
                this.markerSequence.add(newGuy);
            }
        }
    }

    private void mergeDRINode(Node node) throws IIOInvalidTreeException {
        DRIMarkerSegment dri = (DRIMarkerSegment)this.findMarkerSegment(DRIMarkerSegment.class, true);
        if (dri != null) {
            dri.updateFromNativeNode(node, false);
        } else {
            DRIMarkerSegment newGuy = new DRIMarkerSegment(node);
            int firstSOF = this.findMarkerSegmentPosition(SOFMarkerSegment.class, true);
            int firstSOS = this.findMarkerSegmentPosition(SOSMarkerSegment.class, true);
            if (firstSOF != -1) {
                this.markerSequence.add(firstSOF, newGuy);
            } else if (firstSOS != -1) {
                this.markerSequence.add(firstSOS, newGuy);
            } else {
                this.markerSequence.add(newGuy);
            }
        }
    }

    private void mergeCOMNode(Node node) throws IIOInvalidTreeException {
        COMMarkerSegment newGuy = new COMMarkerSegment(node);
        this.insertCOMMarkerSegment(newGuy);
    }

    private void insertCOMMarkerSegment(COMMarkerSegment newGuy) {
        int lastCOM = this.findMarkerSegmentPosition(COMMarkerSegment.class, false);
        boolean hasJFIF = this.findMarkerSegment(JFIFMarkerSegment.class, true) != null;
        int firstAdobe = this.findMarkerSegmentPosition(AdobeMarkerSegment.class, true);
        if (lastCOM != -1) {
            this.markerSequence.add(lastCOM + 1, newGuy);
        } else if (hasJFIF) {
            this.markerSequence.add(1, newGuy);
        } else if (firstAdobe != -1) {
            this.markerSequence.add(firstAdobe + 1, newGuy);
        } else {
            this.markerSequence.add(0, newGuy);
        }
    }

    private void mergeAdobeNode(Node node) throws IIOInvalidTreeException {
        AdobeMarkerSegment adobe = (AdobeMarkerSegment)this.findMarkerSegment(AdobeMarkerSegment.class, true);
        if (adobe != null) {
            adobe.updateFromNativeNode(node, false);
        } else {
            AdobeMarkerSegment newGuy = new AdobeMarkerSegment(node);
            this.insertAdobeMarkerSegment(newGuy);
        }
    }

    private void insertAdobeMarkerSegment(AdobeMarkerSegment newGuy) {
        boolean hasJFIF = this.findMarkerSegment(JFIFMarkerSegment.class, true) != null;
        int lastUnknown = this.findLastUnknownMarkerSegmentPosition();
        if (hasJFIF) {
            this.markerSequence.add(1, newGuy);
        } else if (lastUnknown != -1) {
            this.markerSequence.add(lastUnknown + 1, newGuy);
        } else {
            this.markerSequence.add(0, newGuy);
        }
    }

    private void mergeUnknownNode(Node node) throws IIOInvalidTreeException {
        MarkerSegment newGuy = new MarkerSegment(node);
        int lastUnknown = this.findLastUnknownMarkerSegmentPosition();
        boolean hasJFIF = this.findMarkerSegment(JFIFMarkerSegment.class, true) != null;
        int firstAdobe = this.findMarkerSegmentPosition(AdobeMarkerSegment.class, true);
        if (lastUnknown != -1) {
            this.markerSequence.add(lastUnknown + 1, newGuy);
        } else if (hasJFIF) {
            this.markerSequence.add(1, newGuy);
        }
        if (firstAdobe != -1) {
            this.markerSequence.add(firstAdobe, newGuy);
        } else {
            this.markerSequence.add(0, newGuy);
        }
    }

    private void mergeSOFNode(Node node) throws IIOInvalidTreeException {
        SOFMarkerSegment sof = (SOFMarkerSegment)this.findMarkerSegment(SOFMarkerSegment.class, true);
        if (sof != null) {
            sof.updateFromNativeNode(node, false);
        } else {
            SOFMarkerSegment newGuy = new SOFMarkerSegment(node);
            int firstSOS = this.findMarkerSegmentPosition(SOSMarkerSegment.class, true);
            if (firstSOS != -1) {
                this.markerSequence.add(firstSOS, newGuy);
            } else {
                this.markerSequence.add(newGuy);
            }
        }
    }

    private void mergeSOSNode(Node node) throws IIOInvalidTreeException {
        SOSMarkerSegment firstSOS = (SOSMarkerSegment)this.findMarkerSegment(SOSMarkerSegment.class, true);
        SOSMarkerSegment lastSOS = (SOSMarkerSegment)this.findMarkerSegment(SOSMarkerSegment.class, false);
        if (firstSOS != null) {
            if (firstSOS != lastSOS) {
                throw new IIOInvalidTreeException("Can't merge SOS node into a tree with > 1 SOS node", node);
            }
            firstSOS.updateFromNativeNode(node, false);
        } else {
            this.markerSequence.add(new SOSMarkerSegment(node));
        }
    }

    private void mergeStandardTree(Node root) throws IIOInvalidTreeException {
        this.transparencyDone = false;
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            String name = node.getNodeName();
            if (name.equals("Chroma")) {
                this.mergeStandardChromaNode(node, children);
                continue;
            }
            if (name.equals("Compression")) {
                this.mergeStandardCompressionNode(node);
                continue;
            }
            if (name.equals("Data")) {
                this.mergeStandardDataNode(node);
                continue;
            }
            if (name.equals("Dimension")) {
                this.mergeStandardDimensionNode(node);
                continue;
            }
            if (name.equals("Document")) {
                this.mergeStandardDocumentNode(node);
                continue;
            }
            if (name.equals("Text")) {
                this.mergeStandardTextNode(node);
                continue;
            }
            if (name.equals("Transparency")) {
                this.mergeStandardTransparencyNode(node);
                continue;
            }
            throw new IIOInvalidTreeException("Invalid node: " + name, node);
        }
    }

    private void mergeStandardChromaNode(Node node, NodeList siblings) throws IIOInvalidTreeException {
        if (this.transparencyDone) {
            throw new IIOInvalidTreeException("Transparency node must follow Chroma node", node);
        }
        Node csType = node.getFirstChild();
        if (csType == null || !csType.getNodeName().equals("ColorSpaceType")) {
            return;
        }
        String csName = csType.getAttributes().getNamedItem("name").getNodeValue();
        int numChannels = 0;
        boolean wantJFIF = false;
        boolean wantAdobe = false;
        int transform = 0;
        boolean willSubsample = false;
        byte[] ids = new byte[]{1, 2, 3, 4};
        if (csName.equals("GRAY")) {
            numChannels = 1;
            wantJFIF = true;
        } else if (csName.equals("YCbCr")) {
            numChannels = 3;
            wantJFIF = true;
            willSubsample = true;
        } else if (csName.equals("PhotoYCC")) {
            numChannels = 3;
            wantAdobe = true;
            transform = 1;
            ids[0] = 89;
            ids[1] = 67;
            ids[2] = 99;
        } else if (csName.equals("RGB")) {
            numChannels = 3;
            wantAdobe = true;
            transform = 0;
            ids[0] = 82;
            ids[1] = 71;
            ids[2] = 66;
        } else if (csName.equals("XYZ") || csName.equals("Lab") || csName.equals("Luv") || csName.equals("YxY") || csName.equals("HSV") || csName.equals("HLS") || csName.equals("CMY") || csName.equals("3CLR")) {
            numChannels = 3;
        } else if (csName.equals("YCCK")) {
            numChannels = 4;
            wantAdobe = true;
            transform = 2;
            willSubsample = true;
        } else if (csName.equals("CMYK")) {
            numChannels = 4;
            wantAdobe = true;
            transform = 0;
        } else if (csName.equals("4CLR")) {
            numChannels = 4;
        } else {
            return;
        }
        boolean wantAlpha = false;
        for (int i = 0; i < siblings.getLength(); ++i) {
            Node trans = siblings.item(i);
            if (!trans.getNodeName().equals("Transparency")) continue;
            wantAlpha = this.wantAlpha(trans);
            break;
        }
        if (wantAlpha) {
            ++numChannels;
            wantJFIF = false;
            if (ids[0] == 82) {
                ids[3] = 65;
                wantAdobe = false;
            }
        }
        JFIFMarkerSegment jfif = (JFIFMarkerSegment)this.findMarkerSegment(JFIFMarkerSegment.class, true);
        AdobeMarkerSegment adobe = (AdobeMarkerSegment)this.findMarkerSegment(AdobeMarkerSegment.class, true);
        SOFMarkerSegment sof = (SOFMarkerSegment)this.findMarkerSegment(SOFMarkerSegment.class, true);
        SOSMarkerSegment sos = (SOSMarkerSegment)this.findMarkerSegment(SOSMarkerSegment.class, true);
        if (sof != null && sof.tag == 194 && sof.componentSpecs.length != numChannels && sos != null) {
            return;
        }
        if (!wantJFIF && jfif != null) {
            this.markerSequence.remove(jfif);
        }
        if (wantJFIF && !this.isStream) {
            this.markerSequence.add(0, new JFIFMarkerSegment());
        }
        if (wantAdobe) {
            if (adobe == null && !this.isStream) {
                adobe = new AdobeMarkerSegment(transform);
                this.insertAdobeMarkerSegment(adobe);
            } else {
                adobe.transform = transform;
            }
        } else if (adobe != null) {
            this.markerSequence.remove(adobe);
        }
        boolean updateQtables = false;
        boolean updateHtables = false;
        boolean progressive = false;
        int[] subsampledSelectors = new int[]{0, 1, 1, 0};
        int[] nonSubsampledSelectors = new int[]{0, 0, 0, 0};
        int[] newTableSelectors = willSubsample ? subsampledSelectors : nonSubsampledSelectors;
        SOFMarkerSegment.ComponentSpec[] oldCompSpecs = null;
        if (sof != null) {
            int i;
            oldCompSpecs = sof.componentSpecs;
            progressive = sof.tag == 194;
            this.markerSequence.set(this.markerSequence.indexOf(sof), new SOFMarkerSegment(progressive, false, willSubsample, ids, numChannels));
            for (i = 0; i < oldCompSpecs.length; ++i) {
                if (oldCompSpecs[i].QtableSelector == newTableSelectors[i]) continue;
                updateQtables = true;
            }
            if (progressive) {
                boolean idsDiffer = false;
                for (int i2 = 0; i2 < oldCompSpecs.length; ++i2) {
                    if (ids[i2] == oldCompSpecs[i2].componentId) continue;
                    idsDiffer = true;
                }
                if (idsDiffer) {
                    for (MarkerSegment seg : this.markerSequence) {
                        if (!(seg instanceof SOSMarkerSegment)) continue;
                        SOSMarkerSegment sOSMarkerSegment = (SOSMarkerSegment)seg;
                        for (int j = 0; j < sOSMarkerSegment.componentSpecs.length; ++j) {
                            int oldSelector = sOSMarkerSegment.componentSpecs[j].componentSelector;
                            for (int j2 = 0; j2 < oldCompSpecs.length; ++j2) {
                                if (oldCompSpecs[j2].componentId != oldSelector) continue;
                                sOSMarkerSegment.componentSpecs[j].componentSelector = ids[j2];
                            }
                        }
                    }
                }
            } else if (sos != null) {
                for (i = 0; i < sos.componentSpecs.length; ++i) {
                    if (sos.componentSpecs[i].dcHuffTable == newTableSelectors[i] && sos.componentSpecs[i].acHuffTable == newTableSelectors[i]) continue;
                    updateHtables = true;
                }
                this.markerSequence.set(this.markerSequence.indexOf(sos), new SOSMarkerSegment(willSubsample, ids, numChannels));
            }
        } else if (this.isStream) {
            updateQtables = true;
            updateHtables = true;
        }
        if (updateQtables) {
            ArrayList<MarkerSegment> tableSegments = new ArrayList<MarkerSegment>();
            for (MarkerSegment seg : this.markerSequence) {
                if (!(seg instanceof DQTMarkerSegment)) continue;
                tableSegments.add(seg);
            }
            if (!tableSegments.isEmpty() && willSubsample) {
                boolean found = false;
                for (DQTMarkerSegment dQTMarkerSegment : tableSegments) {
                    for (DQTMarkerSegment.Qtable tab : dQTMarkerSegment.tables) {
                        if (tab.tableID != 1) continue;
                        found = true;
                    }
                }
                if (!found) {
                    DQTMarkerSegment.Qtable table0 = null;
                    for (DQTMarkerSegment dQTMarkerSegment : tableSegments) {
                        for (DQTMarkerSegment.Qtable tab : dQTMarkerSegment.tables) {
                            if (tab.tableID != 0) continue;
                            table0 = tab;
                        }
                    }
                    DQTMarkerSegment dQTMarkerSegment = (DQTMarkerSegment)tableSegments.get(tableSegments.size() - 1);
                    dQTMarkerSegment.tables.add(dQTMarkerSegment.getChromaForLuma(table0));
                }
            }
        }
        if (updateHtables) {
            ArrayList<MarkerSegment> tableSegments = new ArrayList<MarkerSegment>();
            for (MarkerSegment seg : this.markerSequence) {
                if (!(seg instanceof DHTMarkerSegment)) continue;
                tableSegments.add(seg);
            }
            if (!tableSegments.isEmpty() && willSubsample) {
                boolean found = false;
                for (DHTMarkerSegment dHTMarkerSegment : tableSegments) {
                    for (DHTMarkerSegment.Htable tab : dHTMarkerSegment.tables) {
                        if (tab.tableID != 1) continue;
                        found = true;
                    }
                }
                if (!found) {
                    DHTMarkerSegment lastDHT = (DHTMarkerSegment)tableSegments.get(tableSegments.size() - 1);
                    lastDHT.addHtable(JPEGHuffmanTable.StdDCLuminance, true, 1);
                    lastDHT.addHtable(JPEGHuffmanTable.StdACLuminance, true, 1);
                }
            }
        }
    }

    private boolean wantAlpha(Node transparency) {
        String value;
        boolean returnValue = false;
        Node alpha = transparency.getFirstChild();
        if (alpha.getNodeName().equals("Alpha") && alpha.hasAttributes() && !(value = alpha.getAttributes().getNamedItem("value").getNodeValue()).equals("none")) {
            returnValue = true;
        }
        this.transparencyDone = true;
        return returnValue;
    }

    private void mergeStandardCompressionNode(Node node) throws IIOInvalidTreeException {
    }

    private void mergeStandardDataNode(Node node) throws IIOInvalidTreeException {
    }

    private void mergeStandardDimensionNode(Node node) throws IIOInvalidTreeException {
        JFIFMarkerSegment jfif = (JFIFMarkerSegment)this.findMarkerSegment(JFIFMarkerSegment.class, true);
        if (jfif == null) {
            int numChannels;
            boolean canHaveJFIF = false;
            SOFMarkerSegment sof = (SOFMarkerSegment)this.findMarkerSegment(SOFMarkerSegment.class, true);
            if (sof != null && ((numChannels = sof.componentSpecs.length) == 1 || numChannels == 3)) {
                canHaveJFIF = true;
                for (int i = 0; i < sof.componentSpecs.length; ++i) {
                    if (sof.componentSpecs[i].componentId == i + 1) continue;
                    canHaveJFIF = false;
                }
                AdobeMarkerSegment adobe = (AdobeMarkerSegment)this.findMarkerSegment(AdobeMarkerSegment.class, true);
                if (adobe != null && adobe.transform != (numChannels == 1 ? 0 : 1)) {
                    canHaveJFIF = false;
                }
            }
            if (canHaveJFIF) {
                jfif = new JFIFMarkerSegment();
                this.markerSequence.add(0, jfif);
            }
        }
        if (jfif != null) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                float value;
                String valueString;
                Node child = children.item(i);
                NamedNodeMap attrs = child.getAttributes();
                String name = child.getNodeName();
                if (name.equals("PixelAspectRatio")) {
                    valueString = attrs.getNamedItem("value").getNodeValue();
                    value = Float.parseFloat(valueString);
                    Point p = JPEGMetadata.findIntegerRatio(value);
                    jfif.resUnits = 0;
                    jfif.Xdensity = p.x;
                    jfif.Xdensity = p.y;
                    continue;
                }
                if (name.equals("HorizontalPixelSize")) {
                    valueString = attrs.getNamedItem("value").getNodeValue();
                    value = Float.parseFloat(valueString);
                    int dpcm = (int)Math.round(1.0 / ((double)value * 10.0));
                    jfif.resUnits = 2;
                    jfif.Xdensity = dpcm;
                    continue;
                }
                if (!name.equals("VerticalPixelSize")) continue;
                valueString = attrs.getNamedItem("value").getNodeValue();
                value = Float.parseFloat(valueString);
                int dpcm = (int)Math.round(1.0 / ((double)value * 10.0));
                jfif.resUnits = 2;
                jfif.Ydensity = dpcm;
            }
        }
    }

    private static Point findIntegerRatio(float value) {
        float epsilon = 0.005f;
        if ((value = Math.abs(value)) <= epsilon) {
            return new Point(1, 255);
        }
        if (value >= 255.0f) {
            return new Point(255, 1);
        }
        boolean inverted = false;
        if ((double)value < 1.0) {
            value = 1.0f / value;
            inverted = true;
        }
        int y = 1;
        int x = Math.round(value);
        float ratio = x;
        float delta = Math.abs(value - ratio);
        while (delta > epsilon) {
            x = Math.round((float)(++y) * value);
            ratio = (float)x / (float)y;
            delta = Math.abs(value - ratio);
        }
        return inverted ? new Point(y, x) : new Point(x, y);
    }

    private void mergeStandardDocumentNode(Node node) throws IIOInvalidTreeException {
    }

    private void mergeStandardTextNode(Node node) throws IIOInvalidTreeException {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String compString;
            Node child = children.item(i);
            NamedNodeMap attrs = child.getAttributes();
            Node comp = attrs.getNamedItem("compression");
            boolean copyIt = true;
            if (comp != null && !(compString = comp.getNodeValue()).equals("none")) {
                copyIt = false;
            }
            if (!copyIt) continue;
            String value = attrs.getNamedItem("value").getNodeValue();
            COMMarkerSegment com = new COMMarkerSegment(value);
            this.insertCOMMarkerSegment(com);
        }
    }

    private void mergeStandardTransparencyNode(Node node) throws IIOInvalidTreeException {
        if (!this.transparencyDone && !this.isStream) {
            boolean wantAlpha = this.wantAlpha(node);
            JFIFMarkerSegment jfif = (JFIFMarkerSegment)this.findMarkerSegment(JFIFMarkerSegment.class, true);
            AdobeMarkerSegment adobe = (AdobeMarkerSegment)this.findMarkerSegment(AdobeMarkerSegment.class, true);
            SOFMarkerSegment sof = (SOFMarkerSegment)this.findMarkerSegment(SOFMarkerSegment.class, true);
            SOSMarkerSegment sos = (SOSMarkerSegment)this.findMarkerSegment(SOSMarkerSegment.class, true);
            if (sof != null && sof.tag == 194) {
                return;
            }
            if (sof != null) {
                boolean hadAlpha;
                int numChannels = sof.componentSpecs.length;
                boolean bl = hadAlpha = numChannels == 2 || numChannels == 4;
                if (hadAlpha != wantAlpha) {
                    if (wantAlpha) {
                        ++numChannels;
                        if (jfif != null) {
                            this.markerSequence.remove(jfif);
                        }
                        if (adobe != null) {
                            adobe.transform = 0;
                        }
                        SOFMarkerSegment.ComponentSpec[] newSpecs = new SOFMarkerSegment.ComponentSpec[numChannels];
                        for (int i = 0; i < sof.componentSpecs.length; ++i) {
                            newSpecs[i] = sof.componentSpecs[i];
                        }
                        byte oldFirstID = (byte)sof.componentSpecs[0].componentId;
                        byte newID = (byte)(oldFirstID > 1 ? 65 : 4);
                        newSpecs[numChannels - 1] = sof.getComponentSpec(newID, sof.componentSpecs[0].HsamplingFactor, sof.componentSpecs[0].QtableSelector);
                        sof.componentSpecs = newSpecs;
                        SOSMarkerSegment.ScanComponentSpec[] newScanSpecs = new SOSMarkerSegment.ScanComponentSpec[numChannels];
                        for (int i = 0; i < sos.componentSpecs.length; ++i) {
                            newScanSpecs[i] = sos.componentSpecs[i];
                        }
                        newScanSpecs[numChannels - 1] = sos.getScanComponentSpec(newID, 0);
                        sos.componentSpecs = newScanSpecs;
                    } else {
                        SOFMarkerSegment.ComponentSpec[] newSpecs = new SOFMarkerSegment.ComponentSpec[--numChannels];
                        for (int i = 0; i < numChannels; ++i) {
                            newSpecs[i] = sof.componentSpecs[i];
                        }
                        sof.componentSpecs = newSpecs;
                        SOSMarkerSegment.ScanComponentSpec[] newScanSpecs = new SOSMarkerSegment.ScanComponentSpec[numChannels];
                        for (int i = 0; i < numChannels; ++i) {
                            newScanSpecs[i] = sos.componentSpecs[i];
                        }
                        sos.componentSpecs = newScanSpecs;
                    }
                }
            }
        }
    }

    @Override
    public void setFromTree(String formatName, Node root) throws IIOInvalidTreeException {
        if (formatName == null) {
            throw new IllegalArgumentException("null formatName!");
        }
        if (root == null) {
            throw new IllegalArgumentException("null root!");
        }
        if (this.isStream && formatName.equals("javax_imageio_jpeg_stream_1.0")) {
            this.setFromNativeTree(root);
        } else if (!this.isStream && formatName.equals("javax_imageio_jpeg_image_1.0")) {
            this.setFromNativeTree(root);
        } else if (!this.isStream && formatName.equals("javax_imageio_1.0")) {
            super.setFromTree(formatName, root);
        } else {
            throw new IllegalArgumentException("Unsupported format name: " + formatName);
        }
    }

    private void setFromNativeTree(Node root) throws IIOInvalidTreeException {
        if (this.resetSequence == null) {
            this.resetSequence = this.markerSequence;
        }
        this.markerSequence = new ArrayList();
        String name = root.getNodeName();
        if (name != (this.isStream ? "javax_imageio_jpeg_stream_1.0" : "javax_imageio_jpeg_image_1.0")) {
            throw new IIOInvalidTreeException("Invalid root node name: " + name, root);
        }
        if (!this.isStream) {
            if (root.getChildNodes().getLength() != 2) {
                throw new IIOInvalidTreeException("JPEGvariety and markerSequence nodes must be present", root);
            }
            Node JPEGvariety = root.getFirstChild();
            if (JPEGvariety.getChildNodes().getLength() != 0) {
                this.markerSequence.add(new JFIFMarkerSegment(JPEGvariety.getFirstChild()));
            }
        }
        Node markerSequenceNode = this.isStream ? root : root.getLastChild();
        this.setFromMarkerSequenceNode(markerSequenceNode);
    }

    void setFromMarkerSequenceNode(Node markerSequenceNode) throws IIOInvalidTreeException {
        NodeList children = markerSequenceNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            String childName = node.getNodeName();
            if (childName.equals("dqt")) {
                this.markerSequence.add(new DQTMarkerSegment(node));
                continue;
            }
            if (childName.equals("dht")) {
                this.markerSequence.add(new DHTMarkerSegment(node));
                continue;
            }
            if (childName.equals("dri")) {
                this.markerSequence.add(new DRIMarkerSegment(node));
                continue;
            }
            if (childName.equals("com")) {
                this.markerSequence.add(new COMMarkerSegment(node));
                continue;
            }
            if (childName.equals("app14Adobe")) {
                this.markerSequence.add(new AdobeMarkerSegment(node));
                continue;
            }
            if (childName.equals("unknown")) {
                this.markerSequence.add(new MarkerSegment(node));
                continue;
            }
            if (childName.equals("sof")) {
                this.markerSequence.add(new SOFMarkerSegment(node));
                continue;
            }
            if (childName.equals("sos")) {
                this.markerSequence.add(new SOSMarkerSegment(node));
                continue;
            }
            throw new IIOInvalidTreeException("Invalid " + (this.isStream ? "stream " : "image ") + "child: " + childName, node);
        }
    }

    private boolean isConsistent() {
        SOFMarkerSegment sof = (SOFMarkerSegment)this.findMarkerSegment(SOFMarkerSegment.class, true);
        JFIFMarkerSegment jfif = (JFIFMarkerSegment)this.findMarkerSegment(JFIFMarkerSegment.class, true);
        AdobeMarkerSegment adobe = (AdobeMarkerSegment)this.findMarkerSegment(AdobeMarkerSegment.class, true);
        boolean retval = true;
        if (!this.isStream) {
            if (sof != null) {
                int numSOFBands = sof.componentSpecs.length;
                int numScanBands = this.countScanBands();
                if (numScanBands != 0 && numScanBands != numSOFBands) {
                    retval = false;
                }
                if (jfif != null) {
                    if (numSOFBands != 1 && numSOFBands != 3) {
                        retval = false;
                    }
                    for (int i = 0; i < numSOFBands; ++i) {
                        if (sof.componentSpecs[i].componentId == i + 1) continue;
                        retval = false;
                    }
                    if (adobe != null && (numSOFBands == 1 && adobe.transform != 0 || numSOFBands == 3 && adobe.transform != 1)) {
                        retval = false;
                    }
                }
            } else {
                SOSMarkerSegment sos = (SOSMarkerSegment)this.findMarkerSegment(SOSMarkerSegment.class, true);
                if (jfif != null || adobe != null || sof != null || sos != null) {
                    retval = false;
                }
            }
        }
        return retval;
    }

    private int countScanBands() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (MarkerSegment seg : this.markerSequence) {
            if (!(seg instanceof SOSMarkerSegment)) continue;
            SOSMarkerSegment sos = (SOSMarkerSegment)seg;
            SOSMarkerSegment.ScanComponentSpec[] specs = sos.componentSpecs;
            for (int i = 0; i < specs.length; ++i) {
                Integer id = new Integer(specs[i].componentSelector);
                if (ids.contains(id)) continue;
                ids.add(id);
            }
        }
        return ids.size();
    }

    void writeToStream(ImageOutputStream ios, boolean ignoreJFIF, boolean forceJFIF, List thumbnails, ICC_Profile iccProfile, boolean ignoreAdobe, int newAdobeTransform, JPEGImageWriter writer) throws IOException {
        if (forceJFIF) {
            JFIFMarkerSegment.writeDefaultJFIF(ios, thumbnails, iccProfile, writer);
            if (!ignoreAdobe && newAdobeTransform != -1 && newAdobeTransform != 0 && newAdobeTransform != 1) {
                ignoreAdobe = true;
                writer.warningOccurred(13);
            }
        }
        for (MarkerSegment seg : this.markerSequence) {
            if (seg instanceof JFIFMarkerSegment) {
                if (ignoreJFIF) continue;
                JFIFMarkerSegment jfif = (JFIFMarkerSegment)seg;
                jfif.writeWithThumbs(ios, thumbnails, writer);
                if (iccProfile == null) continue;
                JFIFMarkerSegment.writeICC(iccProfile, ios);
                continue;
            }
            if (seg instanceof AdobeMarkerSegment) {
                if (ignoreAdobe) continue;
                if (newAdobeTransform != -1) {
                    AdobeMarkerSegment newAdobe = (AdobeMarkerSegment)seg.clone();
                    newAdobe.transform = newAdobeTransform;
                    newAdobe.write(ios);
                    continue;
                }
                if (forceJFIF) {
                    AdobeMarkerSegment adobe = (AdobeMarkerSegment)seg;
                    if (adobe.transform == 0 || adobe.transform == 1) {
                        adobe.write(ios);
                        continue;
                    }
                    writer.warningOccurred(13);
                    continue;
                }
                seg.write(ios);
                continue;
            }
            seg.write(ios);
        }
    }

    @Override
    public void reset() {
        if (this.resetSequence != null) {
            this.markerSequence = this.resetSequence;
            this.resetSequence = null;
        }
    }

    public void print() {
        for (int i = 0; i < this.markerSequence.size(); ++i) {
            MarkerSegment seg = (MarkerSegment)this.markerSequence.get(i);
            seg.print();
        }
    }
}

