/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_eu extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_gu = "gujaratera";
        final String metaValue_he = "hebreera";
        final String metaValue_la = "latina";
        final String metaValue_ml = "malayalamera";
        final String metaValue_si = "sinhala";
        final Object[][] data = new Object[][] {
            { "sbp", "sanguera" },
            { "nyn", "ankolera" },
            { "luo", "luoera" },
            { "Zsym", "ikurrak" },
            { "fil", "tagaloga" },
            { "luy", "luhyera" },
            { "es_ES", "espainiera (Europa)" },
            { "teo", "tesoera" },
            { "ab", "abkhazera" },
            { "AC", "Ascension uhartea" },
            { "tet", "tetuma" },
            { "AD", "Andorra" },
            { "AE", "Arabiar Emirerri Batuak" },
            { "nl_BE", "flandriera" },
            { "AF", "Afganistan" },
            { "af", "afrikaansa" },
            { "AG", "Antigua eta Barbuda" },
            { "AI", "Angila" },
            { "ak", "akanera" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "am", "amharera" },
            { "Arab", "arabiarra" },
            { "AO", "Angola" },
            { "AQ", "Antartika" },
            { "Jpan", "japoniarra" },
            { "AR", "Argentina" },
            { "ar", "arabiera" },
            { "AS", "Amerikar Samoa" },
            { "as", "assamera" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "en_US", "ingelesa (AEB)" },
            { "AX", "Aland uharteak" },
            { "ay", "aimara" },
            { "AZ", "Azerbaijan" },
            { "az", "azerbaijanera" },
            { "BA", "Bosnia-Herzegovina" },
            { "ba", "bashkirrera" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgika" },
            { "be", "bielorrusiera" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "bg", "bulgariera" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "bm", "bambarera" },
            { "BN", "Brunei" },
            { "bn", "bengalera" },
            { "BO", "Bolivia" },
            { "bo", "tibetera" },
            { "BQ", "Karibeko Herbehereak" },
            { "BR", "Brasil" },
            { "br", "bretoiera" },
            { "BS", "Bahamak" },
            { "bs", "bosniera" },
            { "xog", "sogera" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet uhartea" },
            { "BW", "Botswana" },
            { "Mymr", "birmaniarra" },
            { "BY", "Bielorrusia" },
            { "seh", "senera" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "ca", "katalana" },
            { "CC", "Cocos uharteak" },
            { "ses", "koyraboro sennia" },
            { "CD", "Kongoko Errepublika Demokratikoa" },
            { "CF", "Afrika Erdiko Errepublika" },
            { "CG", "Kongo (Brazzaville)" },
            { "CH", "Suitza" },
            { "CI", "Boli Kosta" },
            { "%%REVISED", "BERRIKUSIA" },
            { "CK", "Cook uharteak" },
            { "CL", "Txile" },
            { "CM", "Kamerun" },
            { "CN", "Txina" },
            { "CO", "Kolonbia" },
            { "co", "korsikera" },
            { "CP", "Clipperton uhartea" },
            { "Orya", "oriyarra" },
            { "CR", "Costa Rica" },
            { "cs", "txekiera" },
            { "CU", "Kuba" },
            { "CV", "Cabo Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Christmas uhartea" },
            { "CY", "Zipre" },
            { "cy", "galesera" },
            { "CZ", "Txekiar Errepublika" },
            { "da", "daniera" },
            { "pt_PT", "portugesa (Europa)" },
            { "DE", "Alemania" },
            { "de", "alemana" },
            { "cgg", "chigera" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibuti" },
            { "DK", "Danimarka" },
            { "ach", "Acholiera" },
            { "Brai", "braillea" },
            { "DM", "Dominika" },
            { "DO", "Dominikar Errepublika" },
            { "bem", "bembera" },
            { "dv", "divehiera" },
            { "DZ", "Aljeria" },
            { "dz", "dzongkha" },
            { "bez", "benera" },
            { "EA", "Ceuta eta Melilla" },
            { "EC", "Ekuador" },
            { "dje", "zarmera" },
            { "EE", "Estonia" },
            { "ee", "eweera" },
            { "EG", "Egipto" },
            { "EH", "Mendebaldeko Sahara" },
            { "el", "greziera" },
            { "en", "ingelesa" },
            { "eo", "esperantoa" },
            { "chr", "txerokiera" },
            { "ER", "Eritrea" },
            { "ES", "Espainia" },
            { "es", "espainiera" },
            { "ET", "Etiopia" },
            { "et", "estoniera" },
            { "EU", "Europar Batasuna" },
            { "eu", "euskara" },
            { "Hang", "hangula" },
            { "shi", "tachelhita" },
            { "hsb", "goi-sorabiera" },
            { "Hani", "idazkera txinatarra" },
            { "fa", "persiera" },
            { "Hans", "sinplifikatua" },
            { "Hant", "tradizionala" },
            { "FI", "Finlandia" },
            { "fi", "finlandiera" },
            { "FJ", "Fiji" },
            { "fj", "fijiera" },
            { "FK", "Malvinak" },
            { "FM", "Mikronesia" },
            { "FO", "Faroe uharteak" },
            { "fo", "faroera" },
            { "Taml", "tamilarra" },
            { "FR", "Frantzia" },
            { "fr", "frantsesa" },
            { "fy", "frisiera" },
            { "GA", "Gabon" },
            { "ga", "gaelikoa" },
            { "GB", "Erresuma Batua" },
            { "GD", "Grenada" },
            { "gd", "eskoziako gaelikoa" },
            { "GE", "Georgia" },
            { "GF", "Guyana Frantsesa" },
            { "GG", "Guernesey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Groenlandia" },
            { "gl", "galiziera" },
            { "GM", "Gambia" },
            { "GN", "Ginea" },
            { "gn", "guaraniera" },
            { "GP", "Guadalupe" },
            { "GQ", "Ekuatore Ginea" },
            { "und", "hizkuntza ezezaguna" },
            { "GR", "Grezia" },
            { "GS", "Hegoaldeko Georgia eta Hegoaldeko Sandwich uharteak" },
            { "GT", "Guatemala" },
            { "gu", metaValue_gu },
            { "GU", "Guam" },
            { "gv", "manxera" },
            { "GW", "Ginea-Bissau" },
            { "tlh", "Klingonera" },
            { "GY", "Guyana" },
            { "ha", "hausa" },
            { "ckb", "soraniera" },
            { "zxx", "ez dago eduki linguistikorik" },
            { "he", metaValue_he },
            { "hi", "hindia" },
            { "HK", "Hong Kong AEB Txina" },
            { "HM", "Heard eta McDonald uharteak" },
            { "HN", "Honduras" },
            { "HR", "Kroazia" },
            { "hr", "kroaziera" },
            { "agq", "aghemera" },
            { "gsw", "alemana (Suitza)" },
            { "HT", "Haiti" },
            { "ht", "haitiera" },
            { "HU", "Hungaria" },
            { "hu", "hungariera" },
            { "hy", "armeniera" },
            { "ia", "Interlingua" },
            { "IC", "Kanariak" },
            { "ID", "Indonesia" },
            { "id", "indonesiera" },
            { "IE", "Irlanda" },
            { "ie", "interlingue" },
            { "ig", "igboera" },
            { "naq", "namera" },
            { "ii", "sichuan yia" },
            { "IL", "Israel" },
            { "IM", "Man uhartea" },
            { "IN", "India" },
            { "IO", "Indiako Ozeanoko lurralde britainiarra" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islandia" },
            { "is", "islandiera" },
            { "IT", "Italia" },
            { "it", "italiera" },
            { "iu", "inuitera" },
            { "Mlym", metaValue_ml },
            { "ja", "japoniera" },
            { "JE", "Jersey" },
            { "JM", "Jamaika" },
            { "Beng", "bengaliarra" },
            { "JO", "Jordania" },
            { "JP", "Japonia" },
            { "sma", "hegoaldeko samiera" },
            { "jv", "javera" },
            { "guz", "gusiiera" },
            { "smj", "Lule samiera" },
            { "de_CH", "aleman garaia (Suitza)" },
            { "smn", "Inari samiera" },
            { "ka", "georgiera" },
            { "sms", "Skolt samiera" },
            { "KE", "Kenya" },
            { "419", "Latinoamerika" },
            { "KG", "Kirgizistan" },
            { "kg", "Kikongoa" },
            { "KH", "Kanbodia" },
            { "KI", "Kiribati" },
            { "ki", "kikuyuera" },
            { "mas", "masaiera" },
            { "kk", "kazakhera" },
            { "kl", "kalaallisutera" },
            { "KM", "Komoreak" },
            { "km", "khemerera" },
            { "KN", "Saint Kitts eta Nevis" },
            { "kn", "kannadera" },
            { "Knda", "kanadarra" },
            { "ko", "koreera" },
            { "KP", "Ipar Korea" },
            { "KR", "Hego Korea" },
            { "ks", "kashmirera" },
            { "ku", "kurduera" },
            { "KW", "Kuwait" },
            { "kw", "kornubiera" },
            { "tpi", "tok pisina" },
            { "KY", "Kaiman uharteak" },
            { "ky", "kirgizera" },
            { "KZ", "Kazakhstan" },
            { "Cyrl", "zirilikoa" },
            { "la", metaValue_la },
            { "LA", "Laos" },
            { "LB", "Libano" },
            { "lb", "luxenburgera" },
            { "LC", "Santa Luzia" },
            { "lg", "gandera" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "Tibt", "tibetarra" },
            { "ln", "lingala" },
            { "lo", "laosera" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lituania" },
            { "lt", "lituaniera" },
            { "LU", "Luxenburgo" },
            { "lu", "luba-katangera" },
            { "LV", "Letonia" },
            { "lv", "letoniera" },
            { "Kana", "katakana" },
            { "LY", "Libia" },
            { "vun", "vunjoa" },
            { "lag", "langiera" },
            { "Thaa", "thaana" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Moldavia" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagaskar" },
            { "mg", "malagasyera" },
            { "MH", "Marshall uharteak" },
            { "Thai", "thailandiarra" },
            { "mi", "maoriera" },
            { "MK", "Mazedonia" },
            { "mk", "mazedoniera" },
            { "ml", metaValue_ml },
            { "ML", "Mali" },
            { "MM", "Myanmar" },
            { "MN", "Mongolia" },
            { "mn", "mongoliera" },
            { "MO", "Macau AEB Txina" },
            { "MP", "Iparraldeko Mariana uharteak" },
            { "MQ", "Martinika" },
            { "MR", "Mauritania" },
            { "mr", "marathera" },
            { "MS", "Montserrat" },
            { "ms", "malaysiera" },
            { "MT", "Malta" },
            { "mt", "maltera" },
            { "MU", "Maurizio" },
            { "MV", "Maldivak" },
            { "MW", "Malawi" },
            { "MX", "Mexiko" },
            { "MY", "Malaysia" },
            { "my", "burmatarra" },
            { "MZ", "Mozambike" },
            { "Armn", "armeniarra" },
            { "dsb", "behe-sorabiera" },
            { "NA", "Namibia" },
            { "nb", "bokmala (Norvegia)" },
            { "NC", "Kaledonia Berria" },
            { "nd", "iparraldeko ndebeleera" },
            { "NE", "Niger" },
            { "ne", "nepalera" },
            { "NF", "Norfolk uhartea" },
            { "NG", "Nigeria" },
            { "NI", "Nikaragua" },
            { "NL", "Herbehereak" },
            { "nl", "nederlandera" },
            { "nn", "nynorsk norvegiera" },
            { "NO", "Norvegia" },
            { "no", "norvegiera" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "rof", "romboera" },
            { "ny", "nyanja" },
            { "NZ", "Zeelanda Berria" },
            { "kab", "kabilera" },
            { "%%POLYTON", "POLITON" },
            { "oc", "Okzitaniera" },
            { "kam", "kambera" },
            { "mer", "meruera" },
            { "OM", "Oman" },
            { "om", "oromoera" },
            { "or", "oriyera" },
            { "os", "osetiera" },
            { "mfe", "Mauritaniako kreolera" },
            { "PA", "Panama" },
            { "pa", "punjabera" },
            { "dua", "dualera" },
            { "PE", "Peru" },
            { "PF", "Polinesia Frantsesa" },
            { "PG", "Papua Ginea Berria" },
            { "PH", "Filipinak" },
            { "PK", "Pakistan" },
            { "PL", "Polonia" },
            { "pl", "poloniera" },
            { "PM", "Saint-Pierre eta Mikelune" },
            { "PN", "Pitcairn uharteak" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestinako Lurraldeak" },
            { "ps", "paxtuera" },
            { "PT", "Portugal" },
            { "pt", "portugesa" },
            { "PW", "Palau" },
            { "PY", "Paraguai" },
            { "tum", "Tumbukera" },
            { "Hebr", metaValue_he },
            { "mgh", "makhuwa-meettoera" },
            { "QA", "Qatar" },
            { "Laoo", "laosarra" },
            { "mgo", "metera" },
            { "%%SCOTLAND", "ESKOZIAR INGELESA" },
            { "QO", "Mugaz kanpoko Ozeania" },
            { "qu", "quechuera" },
            { "brx", "bodoera" },
            { "kde", "makondera" },
            { "001", "Mundua" },
            { "Ethi", "etiopiarra" },
            { "002", "Afrika" },
            { "003", "Ipar Amerika" },
            { "RE", "Reunion" },
            { "005", "Hego Amerika" },
            { "009", "Ozeania" },
            { "rm", "erromantxera" },
            { "rn", "rundiera" },
            { "RO", "Errumania" },
            { "ro", "errumaniera" },
            { "%%SAAHO", "SAHO" },
            { "RS", "Serbia" },
            { "RU", "Errusia" },
            { "ru", "errusiera" },
            { "RW", "Ruanda" },
            { "rw", "kinyaruanda" },
            { "kea", "Cabo Verdeko kreola" },
            { "SA", "Saudi Arabia" },
            { "sa", "sanskritoa" },
            { "SB", "Salomon uharteak" },
            { "twq", "tasawaqa" },
            { "011", "Afrika mendebaldea" },
            { "SC", "Seychelleak" },
            { "SD", "Sudan" },
            { "sd", "sindhia" },
            { "013", "Erdialdeko Amerika" },
            { "SE", "Suedia" },
            { "se", "iparraldeko samiera" },
            { "014", "Afrika ekialdea" },
            { "015", "Afrika iparraldea" },
            { "SG", "Singapur" },
            { "sg", "sangoera" },
            { "SH", "Saint Helena" },
            { "sh", "serbokroaziera" },
            { "si", metaValue_si },
            { "017", "Erdialdeko Afrika" },
            { "SI", "Eslovenia" },
            { "018", "Afrika hegoaldea" },
            { "SJ", "Svalbard eta Jan Mayen uharteak" },
            { "019", "Amerika" },
            { "SK", "Eslovakia" },
            { "sk", "eslovakiera" },
            { "SL", "Sierra Leona" },
            { "sl", "esloveniera" },
            { "SM", "San Marino" },
            { "sm", "samoera" },
            { "SN", "Senegal" },
            { "sn", "shonera" },
            { "SO", "Somalia" },
            { "so", "somaliera" },
            { "arn", "maputxea" },
            { "sq", "albaniera" },
            { "SR", "Surinam" },
            { "sr", "serbiera" },
            { "SS", "Hego Sudan" },
            { "ss", "swatiera" },
            { "ST", "Sao Tome eta Principe" },
            { "st", "hegoaldeko sothoera" },
            { "su", "sundanera" },
            { "SV", "El Salvador" },
            { "sv", "suediera" },
            { "sw", "swahili" },
            { "SX", "Sint Maarten" },
            { "SY", "Siria" },
            { "SZ", "Swazilandia" },
            { "TA", "Tristan da Cunha" },
            { "ta", "tamilera" },
            { "asa", "asua" },
            { "021", "Amerika iparraldea" },
            { "142", "Asia" },
            { "TC", "Turk eta Caicos uharteak" },
            { "143", "Asia erdialdea" },
            { "TD", "Txad" },
            { "te", "teluguera" },
            { "145", "Asia mendebaldea" },
            { "TF", "Hegoaldeko lurralde frantsesak" },
            { "TG", "Togo" },
            { "tg", "tajikistanera" },
            { "TH", "Thailandia" },
            { "th", "thailandiera" },
            { "ti", "tigri\u00f1era" },
            { "TJ", "Tajikistan" },
            { "029", "Karibea" },
            { "TK", "Tokelau" },
            { "tk", "turkmeniera" },
            { "TL", "Ekialdeko Timor" },
            { "tl", "tagalog" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "tn", "tswanera" },
            { "TO", "Tonga" },
            { "to", "tongera" },
            { "dyo", "fonyi jolera" },
            { "TR", "Turkia" },
            { "tr", "turkiera" },
            { "ts", "tsongera" },
            { "TT", "Trinidad eta Tobago" },
            { "tt", "tatarera" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "tw", "twia" },
            { "ty", "tahitiera" },
            { "TZ", "Tanzania" },
            { "nmg", "kwasiera" },
            { "Zzzz", "idazkera ezezaguna" },
            { "150", "Europa" },
            { "UA", "Ukraina" },
            { "030", "Asia ekialdea" },
            { "151", "Europa ekialdea" },
            { "154", "Europa iparraldea" },
            { "sw_CD", "Kongoko swahilia" },
            { "034", "Asia hegoaldea" },
            { "155", "Europa mendebaldea" },
            { "035", "Asia hego-ekialdea" },
            { "UG", "Uganda" },
            { "ug", "uigurrera" },
            { "Kore", "korearra" },
            { "Zyyy", "ohikoa" },
            { "039", "Europa hegoaldea" },
            { "uk", "ukrainera" },
            { "Sinh", metaValue_si },
            { "UM", "Ameriketako Estatu Batuetako Kanpoaldeko Uharte Txikiak" },
            { "ur", "urdua" },
            { "US", "Ameriketako Estatu Batuak" },
            { "haw", "hawaiiera" },
            { "UY", "Uruguai" },
            { "UZ", "Uzbekistan" },
            { "uz", "uzbekera" },
            { "tzm", "Maroko erdialdeko tamazighta" },
            { "VA", "Vatikano Hiria" },
            { "VC", "Saint Vincent eta Grenadinak" },
            { "VE", "Venezuela" },
            { "ve", "vendera" },
            { "VG", "Birjina uharte britainiarrak" },
            { "VI", "Birjina uharte amerikarrak" },
            { "vi", "vietnamera" },
            { "khq", "koyra chiiniera" },
            { "VN", "Vietnam" },
            { "quc", "k\u2019iche\u2019ra" },
            { "VU", "Vanuatu" },
            { "gaa", "Ga" },
            { "rwk", "rwaera" },
            { "gag", "gagauzera" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "WF", "Wallis eta Futuna" },
            { "Grek", "greziarra" },
            { "057", "Mikronesia eskualdea" },
            { "jgo", "ngomba" },
            { "lkt", "lakotera" },
            { "wo", "wolofera" },
            { "zgh", "tamazight estandarra" },
            { "ar_001", "arabiera moderno estandarra" },
            { "WS", "Samoa" },
            { "Mong", "mongoliarra" },
            { "Latn", metaValue_la },
            { "061", "Polinesia" },
            { "xh", "xhosera" },
            { "XK", "Kosovo" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "idatzi gabea" },
            { "moh", "mohawkera" },
            { "YE", "Yemen" },
            { "nqo", "n\u2019koera" },
            { "yi", "Jiddisha" },
            { "yo", "yorubera" },
            { "YT", "Mayotte" },
            { "vai", "vaiera" },
            { "ZA", "Hegoafrika" },
            { "kln", "kalenjinera" },
            { "Deva", "devanagaria" },
            { "zh", "txinera" },
            { "Hira", "hiragana" },
            { "ZM", "Zambia" },
            { "Bopo", "bopomofoa" },
            { "zu", "zuluera" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Eskualde ezezaguna" },
            { "Geor", "georgiarra" },
            { "nso", "pediera" },
            { "loz", "Loziera" },
            { "ebu", "embua" },
            { "jmc", "machamera" },
            { "zh_Hans", "txinera soildua" },
            { "koi", "komi-permyakera" },
            { "kok", "konkaniera" },
            { "nus", "nuerera" },
            { "dav", "taitera" },
            { "zh_Hant", "txinera tradizionala" },
            { "%%VALENCIA", "VALENTZIERA" },
            { "mua", "mudangera" },
            { "Khmr", "khemerarra" },
            { "mul", "hizkuntza anitzak" },
            { "saq", "samburuera" },
            { "efi", "efikera" },
            { "Guru", "gurmukhia" },
            { "lua", "Luba-lulua" },
            { "ksb", "shambalera" },
            { "Telu", "teluguarra" },
            { "ksf", "bafiera" },
        };
        return data;
    }
}
