/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_zu extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Isikhathi sase-Central Africa",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "esase-Moscow Standard Time",
               "MSK",
               "esase-Moscow Summer Time",
               "MSD",
               "esase-Moscow Time",
               "MT",
            };
        final String[] Japan = new String[] {
               "Isikhathi esivamile sase-Japan",
               "JST",
               "Isikhathi semini sase-Japan",
               "JDT",
               "Isikhathi sase-Japan",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "esase-Pakistan Standard Time",
               "PKT",
               "esase-Pakistan Summer Time",
               "PKST",
               "esase-Pakistan Time",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Isikhathi esivamile sase-Taipei",
               "CST",
               "Isikhathi semini sase-Taipei",
               "CDT",
               "Isikhathi sase-Taipei",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Isikhathi Esimisiwe sase-Hovd",
               "HOVT",
               "esase-Hovd Summer Time",
               "HOVST",
               "Isikhathi sase-Hovd",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Isikhathi Esimisiwe sase-Magadan",
               "MAGT",
               "esase-Magadan Summer Time",
               "MAGST",
               "Isikhathi sase-Magadan",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Isikhathi sase-Australian Central West esivamile",
               "ACWST",
               "Isikhathi sasemini sase-Australian Central West",
               "ACWDT",
               "Isikhathi sase-Australian Central West",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Isikhathi esijwayelekile sase-Central Europe",
               "CET",
               "Isikhathi sasehlobo sase-Central Europe",
               "CEST",
               "Isikhathi sase-Central Europe",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Isikhathi Esimisiwe sase-Sakhalin",
               "SAKT",
               "esase-Sakhalin Summer Time",
               "SAKST",
               "Isikhathi sase-Sakhalin",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Isikhathi sase-Paraguay esijwayelekile",
               "PYT",
               "Isikhathi sase-Paraguay sasehlobo",
               "PYST",
               "Isikhathi sase-Paraguay",
               "PYT",
            };
        final String[] Malaysia = new String[] {
               "Isikhathi sase-Malaysia",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "isikhathi sase-North American East esijwayelekile",
               "EST",
               "isikhathi sase-North American East sasemini",
               "EDT",
               "isikhathi sase-North American East",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Isikhathi sase-Lord Howe esivamile",
               "LHST",
               "Isikhathi sase-Lord Howe sasemini",
               "LHDT",
               "Isikhathi sase-Lord Howe",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Isikhathi esivamile sase-New Zealand",
               "NZST",
               "Isikhathi sasemini sase-New Zealand",
               "NZDT",
               "Isikhathi sase-New Zealand",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Isikhathi sase-Indian Ocean",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Isikhathi Esimisiwe sase-Yakutsk",
               "YAKT",
               "esase-Yakutsk Summer Time",
               "YAKST",
               "Isikhathi sase-Yakutsk",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Isikhathi esivamile sase-Mauritius",
               "MUT",
               "Isikhathi sehlobo sase-Mauritius",
               "MUST",
               "Isikhathi sase-Mauritius",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Isikhathi saseMpumalanga Afrika",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Isikhathi sase-East Timor",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Isikhathi sase-Solomon Islands",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Isikhathi sase-Kosrae",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "Isikhathi sase-Marshall Islands",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Isikhathi esijwayelekile sase-Eastern Europe",
               "EET",
               "Isikhathi sasehlobo sase-Eastern Europe",
               "EEST",
               "Isikhathi sase-Eastern Europe",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "isikhathi sase-Newfoundland esijwayelekile",
               "NST",
               "isikhathi sase-Newfoundland sasemini",
               "NDT",
               "isikhathi sase-Newfoundland",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "esase-Afghanistan Time",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Isikhathi esivamile sase-Hong Kong",
               "HKT",
               "Isikhathi sehlobo sase-Hong Kong",
               "HKST",
               "Isikhathi sase-Hong Kong",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Isikhathi saseNyakatho ne-Argentina esijwayelekile",
               "ART",
               "Isikhathi saseNyakatho ne-Argentina sasehlobo",
               "ARST",
               "Isikhathi saseNyakatho ne-Argentina",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "isikhathi sase-Atlantic esijwayelekile",
               "AST",
               "isikhathi sase-Atlantic sasemini",
               "ADT",
               "isikhathi sase-Atlantic",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Isikhathi sase-Ponape",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Isikhathi sase-Bolivia",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "isikhathi sase-Saint Pierre nase-Miquelon esijwayelekile",
               "PMST",
               "isikhathi sase-Saint Pierre nase-Miquelon sasemini",
               "PMDT",
               "isikhathi sase-Saint Pierre nase-Miquelon",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Isikhathi sase-Indochina",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Isikhathi Esimisiwe sase-Yekaterinburg",
               "YEKT",
               "esase-Yekaterinburg Summer Time",
               "YEKST",
               "Isikhathi sase-Yekaterinburg",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "esase-Maldives Time",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Isikhathi sase-Tahiti",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Isikhathi esivamile sase-Israel",
               "IST",
               "Isikhathi sasemini sase-Israel",
               "IDT",
               "Isikhathi sase-Israel",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Isikhathi sase-Central Indonesia",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Isikhathi sase-Wallis and Futuna",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Isikhathi esijwayelekile saseNingizimu Afrika",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Isikhathi sase-Syowa",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Isikhathi sase-Line Islands",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Isikhathi esivamile sase-Uzbekistan",
               "UZT",
               "Isikhathi sehlobo sase-Uzbekistan",
               "UZST",
               "Isikhathi sase-Uzbekistan",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Isikhathi Esimisiwe sase-Omsk",
               "OMST",
               "esase-Omsk Summer Time",
               "OMSST",
               "Isikhathi sase-Omsk",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Isikhathi sase-Seychelles",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Isikhathi sase-Uruguay esijwayelekile",
               "UYT",
               "Isikhathi sase-Uruguay sasehlobo",
               "UYST",
               "Isikhathi sase-Uruguay",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "esase-Nepal Time",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Isikhathi Esimisiwe sase-Ulan Bator",
               "ULAT",
               "esase-Ulan Bator Summer Time",
               "ULAST",
               "Isikhathi sase-Ulan Bator",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "isikhathi sase-North American Central esijwayelekile",
               "CST",
               "isikhathi sase-North American Central sasemini",
               "CDT",
               "isikhathi sase-North American Central",
               "CT",
            };
        final String[] Truk = new String[] {
               "Isikhathi sase-Chuuk",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Isikhathi sase-Niue",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Isikhathi sase-Wake Island",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Isikhathi sase-Falkland Islands esijwayelekile",
               "FKT",
               "Isikhathi sase-Falkland Islands sasehlobo",
               "FKST",
               "Isikhathi sase-Falkland Islands",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Isikhathi sase-Vanuatu esijwayelekile",
               "VUT",
               "Isikhathi sase-Vanuatu sasehlobo",
               "VUST",
               "Isikhathi sase-Vanuatu",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Isikhathi Esimisiwe sase-Novosibirsk",
               "NOVT",
               "esase-Novosibirsk Summer Time",
               "NOVST",
               "Isikhathi sase-Novosibirsk",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Isikhathi esivamile sase-Singapore",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Isikhathi esijwayelekile sase-Azores",
               "AZOT",
               "Isikhathi sasehlobo sase-Azores",
               "AZOST",
               "Isikhathi sase-Azores",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "esase-Apia Standard Time",
               "WSST",
               "esase-Apia Daylight Time",
               "WSDT",
               "esase-Apia Time",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "esase-Bhutan Time",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Isikhathi sase-Suriname",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Isikhathi sase-Nauru",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Isikhathi Esimisiwe sase-Krasnoyarsk",
               "KRAT",
               "Isikhathi sase-Krasnoyarsk sasehlobo",
               "KRAST",
               "Isikhathi sase-Krasnoyarsk",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Isikhathi saseNtshonalanga ne-Kazakhstan",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Isikhathi sase-Myanmar",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "Isikhathi sase-Christmas Island",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Isikhathi sase-Amazon esijwayelekile",
               "AMT",
               "Isikhathi sase-Amazon sasehlobo",
               "AMST",
               "Isikhathi sase-Amazon",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Isikhathi sase-Mpumalanga ne-Kazakhstan",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Isikhathi esivamile sase-Fiji",
               "FJT",
               "Isikhathi sehlobo sase-Fiji",
               "FJST",
               "Isikhathi sase-Fiji",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "Isikhathi sase-Reunion",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Isikhathi sase-Cocos Islands",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Isikhathi esivamile sase-Chatham",
               "CHAST",
               "Isikhathi semini sase-Chatham",
               "CHADT",
               "Isikhathi sase-Chatham",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Isikhathi sase-Vostok",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Isikhathi sase-Argentina esijwayelekile",
               "ART",
               "Isikhathi sase-Argentina sasehlobo",
               "ARST",
               "Isikhathi sase-Argentina",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Isikhathi sase-Gambier",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "esase-Petropavlovsk-Kamchatski Standard Time",
               "PETT",
               "esase-Petropavlovsk-Kamchatski Summer Time",
               "PETST",
               "esase-Petropavlovsk-Kamchatski Time",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "Isikhathi sase-Tuvalu",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Isikhathi sase-Galapagos",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Isikhathi sase-Macquarie Island",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Isikhathi sase-Venezuela",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "isikhathi sase-Hawaii-Aleutia esijwayelekile",
               "HAST",
               "isikhathi sase-Hawaii-Aleutia sasemini",
               "HADT",
               "isikhathi sase-Hawaii-Aleutia",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "esase-Austrilian Central Standard Time",
               "ACST",
               "esase-Austrilian Central Daylight Time",
               "ACDT",
               "esase-Central Australia Time",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "isikhathi sase-North American Pacific esijwayelekile",
               "PST",
               "isikhathi sase-North American Pacific sasemini",
               "PDT",
               "isikhathi sase-North American Pacific",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Isikhathi sase-Phoenix Islands",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Isikhathi esivamile sase-Turkmenistan",
               "TMT",
               "Isikhathi sehlobo sase-Turkmenistan",
               "TMST",
               "Isikhathi sase-Turkmenistan",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Isikhathi esijwayelekile sase-Western Europe",
               "WET",
               "Isikhathi sasehlobo sase-Western Europe",
               "WEST",
               "Isikhathi sase-Western Europe",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Isikhathi esezingeni sase-Cape Verde",
               "CVT",
               "Isikhathi sehlobo sase-Cape Verde",
               "CVST",
               "Isikhathi sase-Cape Verde",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Isikhathi sase-Norfolk Islands",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Isikhathi sase-Guyana",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Isikhathi sase-Pitcairn",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Isikhathi sase-Rothera",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Isikhathi sase-Samoa esijwayelekile",
               "SST",
               "Isikhathi sase-Samoa sasemini",
               "SDT",
               "Isikhathi sase-Samoa",
               "ST",
            };
        final String[] Palau = new String[] {
               "Isikhathi sase-Palau",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "Isikhathi sase-Further-eastern Europe",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Isikhathi esivamile sase-Azerbaijan",
               "AZT",
               "Isikhathi sehlobo sase-Azerbaijan",
               "AZST",
               "Isikhathi sase-Azerbaijan",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Isikhathi sase-Mawson",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "isikhathi sase-Mexican Pacific esijwayelekile",
               "MST",
               "isikhathi sase-Mexican Pacific sasemini",
               "MDT",
               "isikhathi sase-Mexican Pacific",
               "MT",
            };
        final String[] Davis = new String[] {
               "Isikhathi sase-Davis",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "isikhathi sase-Cuba esijwayelekile",
               "CST",
               "isikhathi sase-Cuba sasemini",
               "CDT",
               "isikhathi sase-Cuba",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Isikhathi esijwayelekile saseNtshonalanga Afrika",
               "WAT",
               "Isikhathi sasehlobo saseNtshonalanga Afrika",
               "WAST",
               "Isikhathi saseNtshonalanga Afrika",
               "WAT",
            };
        final String[] GMT = new String[] {
               "Isikhathi sase-Greenwich Mean",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Isikhathi esivamile sase-Philippine",
               "PHT",
               "Isikhathi sehlobo sase-Philippine",
               "PHST",
               "Isikhathi sase-Philippine",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "Isikhathi sase-French Southern and Antarctic",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "Isikhathi sase-South Georgia",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Isikhathi sase-New Caledonia esijwayelekile",
               "NCT",
               "Isikhathi sase-New Caledonia sasehlobo",
               "NCST",
               "Isikhathi sase-New Caledonia",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Isikhathi sase-Brunei Darussalam",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "esase-Iran Standard Time",
               "IRST",
               "esase-Iran Daylight Time",
               "IRDT",
               "esase-Iran Time",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Isikhathi sase-Easter Island esijwayelekile",
               "EAST",
               "Isikhathi sase-Easter Island sasehlobo",
               "EASST",
               "Isikhathi sase-Easter Island",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "isikhathi sase-Northwest Mexico esijwayelekile",
               "PST",
               "isikhathi sase-Northwest Mexico sasemini",
               "PDT",
               "isikhathi sase-Northwest Mexico",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "Isikhathi sase-Dumont-d\u2019Urville",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Isikhathi sase-Tajikistan",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Isikhathi sase-Tonga esijwayelekile",
               "TOT",
               "Isikhathi sase-Tonga sasehlobo",
               "TOST",
               "Isikhathi sase-Tonga",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "esase-Bangladesh Standard Time",
               "BDT",
               "esase-Bangladesh Summer Time",
               "BDST",
               "esase-Bangladesh Time",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Isikhathi sase-Peru esijwayelekile",
               "PET",
               "Isikhathi sase-Peru sasehlobo",
               "PEST",
               "Isikhathi sase-Peru",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "isikhathi sase-West Greenland esijwayelekile",
               "WGT",
               "isikhathi sase-West Greenland sasemini",
               "WGST",
               "isikhathi sase-West Greenland",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Isikhathi sase-Ecuador",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "isikhathi sase-East Greenland esijwayelekile",
               "EGT",
               "isikhathi sase-East Greenland sasemini",
               "EGST",
               "isikhathi sase-East Greenland",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Isikhathi esivamile sase-Gulf",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Isikhathi sase-Eastern Indonesia",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Isikhathi esisezengeni sase-Korea",
               "KST",
               "Isikhathi semini sase-Korea",
               "KDT",
               "Isikhathi sase-Korea",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "I-Australian Western Standard Time",
               "AWST",
               "I-Australian Western Daylight Time",
               "AWDT",
               "Isikhathi sase-Western Australia",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Isikhathi sase-Kyrgystan",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "Isikhathi sase-Western Indonesia",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "Isikhathi esivamile sase-Australian East",
               "AEST",
               "Isikhathi sasemini sase-Australian East",
               "AEDT",
               "Isikhathi sase-Eastern Australia",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Isikhathi sase-French Guiana",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Isikhathi sase-Colombia esijwayelekile",
               "COT",
               "Isikhathi sase-Colombia sasehlobo",
               "COST",
               "Isikhathi sase-Colombia",
               "COT",
            };
        final String[] Chile = new String[] {
               "Isikhathi sase-Chile esijwayelekile",
               "CLT",
               "Isikhathi sase-Chile sasehlobo",
               "CLST",
               "Isikhathi sase-Chile",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Isikhathi sase-Gilbert Islands",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "isikhathi sase-North American Mountain esijwayelekile",
               "MST",
               "isikhathi sase-North American Mountain sasemini",
               "MDT",
               "isikhathi sase-North American Mountain",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Isikhathi sase-Marquesas",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Isikhathi esivamile sase-Arabian",
               "AST",
               "Isikhathi semini sase-Arabian",
               "ADT",
               "Isikhathi sase-Arabian",
               "AT",
            };
        final String[] Alaska = new String[] {
               "isikhathi sase-Alaska esijwayelekile",
               "AKST",
               "Isikhathi sase-Alaska sasemini",
               "AKDT",
               "isikhathi sase-Alaska",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Isikhathi Esimisiwe sase-Vladivostok",
               "VLAT",
               "esase-Vladivostok Summer Time",
               "VLAST",
               "Isikhathi sase-Vladivostok",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "Isikhathi esijwayelekile sase-Chamorro",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Isikhathi Esimisiwe sase-Irkutsk",
               "IRKT",
               "esase-Irkutsk Summer Time",
               "IRKST",
               "Isikhathi sase-Irkutsk",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Isikhathi esivamile sase-Georgia",
               "GET",
               "Isikhathi sehlobo sase-Georgia",
               "GEST",
               "Isikhathi sase-Georgia",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Isikhathi sase-Tokelau",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Isikhathi sase-Papua New Guinea",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Isikhathi sase-Fernando de Noronha esijwayelekile",
               "FNT",
               "Isikhathi sase-Fernando de Noronha sasehlobo",
               "FNST",
               "Isikhathi sase-Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Isikhathi Esimisiwe sase-Choibalsan",
               "CHOT",
               "esase-Choibalsan Summer Time",
               "CHOST",
               "Isikhathi sase-Choibalsan",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Isikhathi sase-Brasilia esijwayelekile",
               "BRT",
               "Isikhathi sase-Brasilia sasehlobo",
               "BRST",
               "Isikhathi sase-Brasilia",
               "BRT",
            };
        final String[] China = new String[] {
               "Isikhathi esivamile sase-China",
               "CST",
               "Isikhathi semini sase-China",
               "CDT",
               "Isikhathi sase-China",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Isikhathi esezingeni sase-Armenia",
               "AMT",
               "Isikhathi sehlobo sase-Armenia",
               "AMST",
               "Isikhathi saseArmenia",
               "AMT",
            };
        final String[] Samara = new String[] {
               "esase-Samara Standard Time",
               "SAMT",
               "esase-Samara Summer Time",
               "SAMST",
               "esase-Samara Time",
               "SAMT",
            };
        final String[] India = new String[] {
               "esase-India Standard Time",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Isikhathi esivamile sase-Cook Islands",
               "CKT",
               "Isikhathi esiyingxenye yasehlobo sase-Cook Islands",
               "CKHST",
               "Isikhathi sase-Cook Islands",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Isikhathi sase-Greenwich Mean",
                    "GMT",
                    "isikhathi sase-British sasehlobo",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Isikhathi sase-Greenwich Mean",
                    "GMT",
                    "isikhathi sase-Irish esivamile",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
