/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.ArrayList;
import java.util.IllformedLocaleException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.util.LocaleUtils;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.common.DateFormat;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.ISODateTimeFormat;

public final class DateProcessor
extends AbstractProcessor {
    public static final String TYPE = "date";
    static final String DEFAULT_TARGET_FIELD = "@timestamp";
    private final DateTimeZone timezone;
    private final Locale locale;
    private final String field;
    private final String targetField;
    private final List<String> formats;
    private final List<Function<String, DateTime>> dateParsers;

    DateProcessor(String tag, DateTimeZone timezone, Locale locale, String field, List<String> formats, String targetField) {
        super(tag);
        this.timezone = timezone;
        this.locale = locale;
        this.field = field;
        this.targetField = targetField;
        this.formats = formats;
        this.dateParsers = new ArrayList<Function<String, DateTime>>(this.formats.size());
        for (String format : formats) {
            DateFormat dateFormat = DateFormat.fromString(format);
            this.dateParsers.add(dateFormat.getFunction(format, timezone, locale));
        }
    }

    public void execute(IngestDocument ingestDocument) {
        Object obj = ingestDocument.getFieldValue(this.field, Object.class);
        String value = null;
        if (obj != null) {
            value = obj.toString();
        }
        DateTime dateTime = null;
        Exception lastException = null;
        for (Function<String, DateTime> dateParser : this.dateParsers) {
            try {
                dateTime = dateParser.apply(value);
            }
            catch (Exception e) {
                lastException = (Exception)ExceptionsHelper.useOrSuppress(lastException, (Throwable)e);
            }
        }
        if (dateTime == null) {
            throw new IllegalArgumentException("unable to parse date [" + value + "]", lastException);
        }
        ingestDocument.setFieldValue(this.targetField, (Object)ISODateTimeFormat.dateTime().print(dateTime));
    }

    public String getType() {
        return TYPE;
    }

    DateTimeZone getTimezone() {
        return this.timezone;
    }

    Locale getLocale() {
        return this.locale;
    }

    String getField() {
        return this.field;
    }

    String getTargetField() {
        return this.targetField;
    }

    List<String> getFormats() {
        return this.formats;
    }

    public static final class Factory
    implements Processor.Factory {
        public DateProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)DateProcessor.TYPE, (String)processorTag, config, (String)"field");
            String targetField = ConfigurationUtils.readStringProperty((String)DateProcessor.TYPE, (String)processorTag, config, (String)"target_field", (String)DateProcessor.DEFAULT_TARGET_FIELD);
            String timezoneString = ConfigurationUtils.readOptionalStringProperty((String)DateProcessor.TYPE, (String)processorTag, config, (String)"timezone");
            DateTimeZone timezone = timezoneString == null ? DateTimeZone.UTC : DateTimeZone.forID((String)timezoneString);
            String localeString = ConfigurationUtils.readOptionalStringProperty((String)DateProcessor.TYPE, (String)processorTag, config, (String)"locale");
            Locale locale = Locale.ENGLISH;
            if (localeString != null) {
                try {
                    locale = new Locale.Builder().setLanguageTag(localeString).build();
                }
                catch (IllformedLocaleException e) {
                    throw new IllegalArgumentException("Invalid language tag specified: " + localeString);
                }
                if (!LocaleUtils.isValid((Locale)locale)) {
                    throw new IllegalArgumentException("Invalid language tag specified: " + localeString);
                }
            }
            List formats = ConfigurationUtils.readList((String)DateProcessor.TYPE, (String)processorTag, config, (String)"formats");
            return new DateProcessor(processorTag, timezone, locale, field, formats, targetField);
        }
    }
}

