/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.CustomAnalyzer;
import org.elasticsearch.index.analysis.MultiTermAwareComponent;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;

public final class CustomNormalizerProvider
extends AbstractIndexAnalyzerProvider<CustomAnalyzer> {
    private final Settings analyzerSettings;
    private CustomAnalyzer customAnalyzer;

    public CustomNormalizerProvider(IndexSettings indexSettings, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.analyzerSettings = settings;
    }

    public void build(TokenizerFactory keywordTokenizerFactory, Map<String, CharFilterFactory> charFilters, Map<String, TokenFilterFactory> tokenFilters) {
        String tokenizerName = this.analyzerSettings.get("tokenizer");
        if (tokenizerName != null) {
            throw new IllegalArgumentException("Custom normalizer [" + this.name() + "] cannot configure a tokenizer");
        }
        String[] charFilterNames = this.analyzerSettings.getAsArray("char_filter");
        ArrayList<CharFilterFactory> charFiltersList = new ArrayList<CharFilterFactory>(charFilterNames.length);
        for (String charFilterName : charFilterNames) {
            CharFilterFactory charFilter = charFilters.get(charFilterName);
            if (charFilter == null) {
                throw new IllegalArgumentException("Custom normalizer [" + this.name() + "] failed to find char_filter under name [" + charFilterName + "]");
            }
            if (!(charFilter instanceof MultiTermAwareComponent)) {
                throw new IllegalArgumentException("Custom normalizer [" + this.name() + "] may not use char filter [" + charFilterName + "]");
            }
            charFilter = (CharFilterFactory)((MultiTermAwareComponent)((Object)charFilter)).getMultiTermComponent();
            charFiltersList.add(charFilter);
        }
        String[] tokenFilterNames = this.analyzerSettings.getAsArray("filter");
        ArrayList<TokenFilterFactory> tokenFilterList = new ArrayList<TokenFilterFactory>(tokenFilterNames.length);
        for (String tokenFilterName : tokenFilterNames) {
            TokenFilterFactory tokenFilter = tokenFilters.get(tokenFilterName);
            if (tokenFilter == null) {
                throw new IllegalArgumentException("Custom Analyzer [" + this.name() + "] failed to find filter under name [" + tokenFilterName + "]");
            }
            if (!(tokenFilter instanceof MultiTermAwareComponent)) {
                throw new IllegalArgumentException("Custom normalizer [" + this.name() + "] may not use filter [" + tokenFilterName + "]");
            }
            tokenFilter = (TokenFilterFactory)((MultiTermAwareComponent)((Object)tokenFilter)).getMultiTermComponent();
            tokenFilterList.add(tokenFilter);
        }
        this.customAnalyzer = new CustomAnalyzer("keyword", keywordTokenizerFactory, charFiltersList.toArray(new CharFilterFactory[charFiltersList.size()]), tokenFilterList.toArray(new TokenFilterFactory[tokenFilterList.size()]));
    }

    @Override
    public CustomAnalyzer get() {
        return this.customAnalyzer;
    }
}

