/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.analysis;

import java.util.Locale;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.elasticsearch.Version;
import org.elasticsearch.index.analysis.MultiTermAwareComponent;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.indices.analysis.PreBuiltCacheFactory;

public enum PreBuiltTokenFilters {
    LOWERCASE(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new LowerCaseFilter(tokenStream);
        }

        @Override
        protected boolean isMultiTermAware() {
            return true;
        }
    };

    protected final PreBuiltCacheFactory.PreBuiltCache<TokenFilterFactory> cache;
    private final PreBuiltCacheFactory.CachingStrategy cachingStrategy;

    protected boolean isMultiTermAware() {
        return false;
    }

    public abstract TokenStream create(TokenStream var1, Version var2);

    private PreBuiltTokenFilters(PreBuiltCacheFactory.CachingStrategy cachingStrategy) {
        this.cachingStrategy = cachingStrategy;
        this.cache = PreBuiltCacheFactory.getCache(cachingStrategy);
    }

    public PreBuiltCacheFactory.CachingStrategy getCachingStrategy() {
        return this.cachingStrategy;
    }

    public synchronized TokenFilterFactory getTokenFilterFactory(final Version version) {
        TokenFilterFactory factory = this.cache.get(version);
        if (factory == null) {
            final String finalName = this.name().toLowerCase(Locale.ROOT);
            factory = this.isMultiTermAware() ? new MultiTermAwareTokenFilterFactory(){

                @Override
                public String name() {
                    return finalName;
                }

                @Override
                public TokenStream create(TokenStream tokenStream) {
                    return PreBuiltTokenFilters.this.create(tokenStream, version);
                }

                @Override
                public Object getMultiTermComponent() {
                    return this;
                }
            } : new TokenFilterFactory(){

                @Override
                public String name() {
                    return finalName;
                }

                @Override
                public TokenStream create(TokenStream tokenStream) {
                    return PreBuiltTokenFilters.this.create(tokenStream, version);
                }
            };
            this.cache.put(version, factory);
        }
        return factory;
    }

    private static interface MultiTermAwareTokenFilterFactory
    extends TokenFilterFactory,
    MultiTermAwareComponent {
    }
}

