/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rescore;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.support.ToXContentToBytes;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.search.rescore.QueryRescorer;
import org.elasticsearch.search.rescore.QueryRescorerBuilder;

public abstract class RescoreBuilder<RB extends RescoreBuilder<RB>>
extends ToXContentToBytes
implements NamedWriteable,
Rewriteable<RescoreBuilder<RB>> {
    protected Integer windowSize;
    private static ParseField WINDOW_SIZE_FIELD = new ParseField("window_size", new String[0]);

    public RescoreBuilder() {
    }

    protected RescoreBuilder(StreamInput in) throws IOException {
        this.windowSize = in.readOptionalVInt();
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalVInt(this.windowSize);
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    public RB windowSize(int windowSize) {
        this.windowSize = windowSize;
        return (RB)this;
    }

    public Integer windowSize() {
        return this.windowSize;
    }

    public static RescoreBuilder<?> parseFromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        RescoreBuilder rescorer = null;
        Integer windowSize = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (WINDOW_SIZE_FIELD.match(fieldName)) {
                    windowSize = parser.intValue();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "rescore doesn't support [" + fieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("query".equals(fieldName)) {
                    rescorer = QueryRescorerBuilder.fromXContent(parser);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "rescore doesn't support rescorer with name [" + fieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + (Object)((Object)token) + "] after [" + fieldName + "]", new Object[0]);
        }
        if (rescorer == null) {
            throw new ParsingException(parser.getTokenLocation(), "missing rescore type", new Object[0]);
        }
        if (windowSize != null) {
            rescorer.windowSize(windowSize);
        }
        return rescorer;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.windowSize != null) {
            builder.field("window_size", this.windowSize);
        }
        this.doXContent(builder, params);
        builder.endObject();
        return builder;
    }

    protected abstract void doXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public abstract QueryRescorer.QueryRescoreContext build(QueryShardContext var1) throws IOException;

    public static QueryRescorerBuilder queryRescorer(QueryBuilder queryBuilder) {
        return new QueryRescorerBuilder(queryBuilder);
    }

    public int hashCode() {
        return Objects.hash(this.windowSize);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RescoreBuilder other = (RescoreBuilder)obj;
        return Objects.equals(this.windowSize, other.windowSize);
    }
}

