/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.zaproxy.zap.extension.alert.ExtensionAlert;

public abstract class PopupMenuItemAlert
extends ExtensionPopupMenuItem {
    private static final long serialVersionUID = 1L;
    private final boolean multiSelect;
    private final ExtensionAlert extAlert;
    private static final Logger log = Logger.getLogger(PopupMenuItemAlert.class);

    public PopupMenuItemAlert(String string) {
        this(string, false);
    }

    public PopupMenuItemAlert(String string, boolean bl) {
        super(string);
        this.multiSelect = bl;
        this.addActionListener(new PerformActionsActionListener());
        this.extAlert = Control.getSingleton().getExtensionLoader().getExtension(ExtensionAlert.class);
    }

    public final boolean isMultiSelect() {
        return this.multiSelect;
    }

    private Set<Alert> getAlertNodes() {
        TreePath[] treePathArray = this.extAlert.getAlertPanel().getTreeAlert().getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return Collections.emptySet();
        }
        HashSet<Alert> hashSet = new HashSet<Alert>();
        if (!this.isMultiSelect()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent();
            hashSet.add((Alert)defaultMutableTreeNode.getUserObject());
            return hashSet;
        }
        for (int i = 0; i < treePathArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            if (defaultMutableTreeNode.getChildCount() == 0) {
                hashSet.add((Alert)defaultMutableTreeNode.getUserObject());
                continue;
            }
            for (int j = 0; j < defaultMutableTreeNode.getChildCount(); ++j) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(j);
                hashSet.add((Alert)defaultMutableTreeNode2.getUserObject());
            }
        }
        return hashSet;
    }

    protected abstract void performAction(Alert var1);

    protected void performActions(Set<Alert> set) {
        for (Alert alert : set) {
            this.performAction(alert);
        }
    }

    protected boolean isButtonEnabledForNumberOfSelectedAlerts(int n) {
        if (n == 0) {
            return false;
        }
        return this.isMultiSelect() || n <= 1;
    }

    @Override
    public boolean isEnableForComponent(Component component) {
        if (this.extAlert == null) {
            return false;
        }
        if ("treeAlert".equals(component.getName())) {
            this.setEnabled(!this.extAlert.getAlertPanel().getTreeAlert().isRowSelected(0) && this.isButtonEnabledForNumberOfSelectedAlerts(this.getNumberOfSelectedAlerts()));
            return true;
        }
        return false;
    }

    private int getNumberOfSelectedAlerts() {
        JTree jTree = this.extAlert.getAlertPanel().getTreeAlert();
        int n = jTree.getSelectionCount();
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getSelectionPath().getLastPathComponent();
            if (defaultMutableTreeNode.getChildCount() == 0 || !this.isMultiSelect()) {
                return 1;
            }
            return defaultMutableTreeNode.getChildCount();
        }
        n = 0;
        TreePath[] treePathArray = jTree.getSelectionPaths();
        for (int i = 0; i < treePathArray.length; ++i) {
            TreePath treePath = treePathArray[i];
            int n2 = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getChildCount();
            n += n2 != 0 ? n2 : (jTree.isPathSelected(treePath.getParentPath()) ? 0 : 1);
        }
        return n;
    }

    protected ExtensionAlert getExtensionAlert() {
        return this.extAlert;
    }

    private class PerformActionsActionListener
    implements ActionListener {
        private PerformActionsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Set set = PopupMenuItemAlert.this.getAlertNodes();
                PopupMenuItemAlert.this.performActions(set);
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }
}

