/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.script;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import net.sf.json.JSONObject;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.ScriptEngineWrapper;
import org.zaproxy.zap.extension.script.ScriptType;
import org.zaproxy.zap.extension.script.ScriptWrapper;

public class ScriptAPI
extends ApiImplementor {
    private static final String PREFIX = "script";
    private static final String VIEW_ENGINES = "listEngines";
    private static final String VIEW_SCRIPTS = "listScripts";
    private static final String ACTION_ENABLE = "enable";
    private static final String ACTION_DISABLE = "disable";
    private static final String ACTION_RUN_STANDALONE = "runStandAloneScript";
    private static final String ACTION_LOAD = "load";
    private static final String ACTION_REMOVE = "remove";
    private static final String ACTION_PARAM_SCRIPT_NAME = "scriptName";
    private static final String ACTION_PARAM_SCRIPT_DESC = "scriptDescription";
    private static final String ACTION_PARAM_SCRIPT_TYPE = "scriptType";
    private static final String ACTION_PARAM_SCRIPT_ENGINE = "scriptEngine";
    private static final String ACTION_PARAM_FILE_NAME = "fileName";
    private ExtensionScript extension;

    public ScriptAPI(ExtensionScript extensionScript) {
        this.extension = extensionScript;
        this.addApiView(new ApiView(VIEW_ENGINES, new String[0], new String[0]));
        this.addApiView(new ApiView(VIEW_SCRIPTS, new String[0], new String[0]));
        this.addApiAction(new ApiAction(ACTION_ENABLE, new String[]{ACTION_PARAM_SCRIPT_NAME}, new String[0]));
        this.addApiAction(new ApiAction(ACTION_DISABLE, new String[]{ACTION_PARAM_SCRIPT_NAME}, new String[0]));
        this.addApiAction(new ApiAction(ACTION_LOAD, new String[]{ACTION_PARAM_SCRIPT_NAME, ACTION_PARAM_SCRIPT_TYPE, ACTION_PARAM_SCRIPT_ENGINE, ACTION_PARAM_FILE_NAME}, new String[]{ACTION_PARAM_SCRIPT_DESC}));
        this.addApiAction(new ApiAction(ACTION_REMOVE, new String[]{ACTION_PARAM_SCRIPT_NAME}, new String[0]));
        this.addApiAction(new ApiAction(ACTION_RUN_STANDALONE, new String[]{ACTION_PARAM_SCRIPT_NAME}, new String[0]));
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiView(String string, JSONObject jSONObject) throws ApiException {
        if (VIEW_SCRIPTS.equals(string)) {
            ApiResponseList apiResponseList = new ApiResponseList(string);
            for (ScriptType scriptType : this.extension.getScriptTypes()) {
                for (ScriptWrapper scriptWrapper : this.extension.getScripts(scriptType)) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("name", scriptWrapper.getName());
                    hashMap.put("type", scriptWrapper.getTypeName());
                    hashMap.put("engine", scriptWrapper.getEngineName());
                    hashMap.put("description", scriptWrapper.getDescription());
                    hashMap.put("error", Boolean.toString(scriptWrapper.isError()));
                    if (scriptWrapper.isError()) {
                        hashMap.put("lastError", scriptWrapper.getLastErrorDetails());
                    }
                    if (scriptType.isEnableable()) {
                        hashMap.put("enabled", Boolean.toString(scriptWrapper.isEnabled()));
                    }
                    apiResponseList.addItem(new ApiResponseSet("Script", hashMap));
                }
            }
            return apiResponseList;
        }
        if (VIEW_ENGINES.equals(string)) {
            ApiResponseList apiResponseList = new ApiResponseList(string);
            for (String string2 : this.extension.getScriptingEngines()) {
                apiResponseList.addItem(new ApiResponseElement("engine", string2));
            }
            return apiResponseList;
        }
        throw new ApiException(ApiException.Type.BAD_VIEW);
    }

    @Override
    public ApiResponse handleApiAction(String string, JSONObject jSONObject) throws ApiException {
        if (ACTION_ENABLE.equals(string)) {
            ScriptWrapper scriptWrapper = this.extension.getScript(jSONObject.getString(ACTION_PARAM_SCRIPT_NAME));
            if (scriptWrapper == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, ACTION_PARAM_SCRIPT_NAME);
            }
            if (!scriptWrapper.getType().isEnableable()) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, ACTION_PARAM_SCRIPT_NAME);
            }
            this.extension.setEnabled(scriptWrapper, true);
            return ApiResponseElement.OK;
        }
        if (ACTION_DISABLE.equals(string)) {
            ScriptWrapper scriptWrapper = this.extension.getScript(jSONObject.getString(ACTION_PARAM_SCRIPT_NAME));
            if (scriptWrapper == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, ACTION_PARAM_SCRIPT_NAME);
            }
            if (!scriptWrapper.getType().isEnableable()) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, ACTION_PARAM_SCRIPT_NAME);
            }
            this.extension.setEnabled(scriptWrapper, false);
            return ApiResponseElement.OK;
        }
        if (ACTION_LOAD.equals(string)) {
            ScriptType scriptType = this.extension.getScriptType(jSONObject.getString(ACTION_PARAM_SCRIPT_TYPE));
            if (scriptType == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, ACTION_PARAM_SCRIPT_TYPE);
            }
            ScriptEngineWrapper scriptEngineWrapper = this.extension.getEngineWrapper(jSONObject.getString(ACTION_PARAM_SCRIPT_ENGINE));
            if (scriptEngineWrapper == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, ACTION_PARAM_SCRIPT_ENGINE);
            }
            File file = new File(jSONObject.getString(ACTION_PARAM_FILE_NAME));
            if (!file.exists()) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, file.getAbsolutePath());
            }
            ScriptWrapper scriptWrapper = new ScriptWrapper(jSONObject.getString(ACTION_PARAM_SCRIPT_NAME), this.getParam(jSONObject, ACTION_PARAM_SCRIPT_DESC, ""), scriptEngineWrapper, scriptType, true, file);
            try {
                this.extension.loadScript(scriptWrapper);
            }
            catch (IOException iOException) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)iOException);
            }
            this.extension.addScript(scriptWrapper, false);
            return ApiResponseElement.OK;
        }
        if (ACTION_REMOVE.equals(string)) {
            ScriptWrapper scriptWrapper = this.extension.getScript(jSONObject.getString(ACTION_PARAM_SCRIPT_NAME));
            if (scriptWrapper == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, ACTION_PARAM_SCRIPT_NAME);
            }
            this.extension.removeScript(scriptWrapper);
            return ApiResponseElement.OK;
        }
        if (ACTION_RUN_STANDALONE.equals(string)) {
            ScriptWrapper scriptWrapper = this.extension.getScript(jSONObject.getString(ACTION_PARAM_SCRIPT_NAME));
            if (scriptWrapper == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, ACTION_PARAM_SCRIPT_NAME);
            }
            if (!scriptWrapper.getType().getName().equals("standalone")) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, ACTION_PARAM_SCRIPT_NAME);
            }
            try {
                this.extension.invokeScript(scriptWrapper);
            }
            catch (Exception exception) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)exception);
            }
            return ApiResponseElement.OK;
        }
        throw new ApiException(ApiException.Type.BAD_VIEW);
    }
}

