/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tribe;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterApplier;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.discovery.DiscoverySettings;
import org.elasticsearch.discovery.zen.UnicastHostsProvider;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.node.Node;
import org.elasticsearch.plugins.ClusterPlugin;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.tribe.TribeDiscovery;
import org.elasticsearch.tribe.TribeService;
import org.elasticsearch.watcher.ResourceWatcherService;

public class TribePlugin
extends Plugin
implements DiscoveryPlugin,
ClusterPlugin {
    private final Settings settings;
    private TribeService tribeService;

    public TribePlugin(Settings settings) {
        this.settings = settings;
    }

    public Map<String, Supplier<Discovery>> getDiscoveryTypes(ThreadPool threadPool, TransportService transportService, NamedWriteableRegistry namedWriteableRegistry, MasterService masterService, ClusterApplier clusterApplier, ClusterSettings clusterSettings, UnicastHostsProvider hostsProvider, AllocationService allocationService) {
        return Collections.singletonMap("tribe", () -> new TribeDiscovery(this.settings, transportService, masterService, clusterApplier));
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry) {
        this.tribeService = new TribeService(this.settings, nodeEnvironment, clusterService, namedWriteableRegistry, this.nodeBuilder(environment.configFile()));
        return Collections.singleton(this.tribeService);
    }

    protected Function<Settings, Node> nodeBuilder(Path configPath) {
        return settings -> new Node(new Environment(settings, configPath));
    }

    public void onNodeStarted() {
        this.tribeService.startNodes();
    }

    public Settings additionalSettings() {
        if (!TribeService.TRIBE_NAME_SETTING.exists(this.settings)) {
            Map nodesSettings = this.settings.getGroups("tribe", true);
            if (nodesSettings.isEmpty()) {
                return Settings.EMPTY;
            }
            Settings.Builder sb = Settings.builder();
            if (Node.NODE_MASTER_SETTING.exists(this.settings)) {
                if (((Boolean)Node.NODE_MASTER_SETTING.get(this.settings)).booleanValue()) {
                    throw new IllegalArgumentException("node cannot be tribe as well as master node");
                }
            } else {
                sb.put(Node.NODE_MASTER_SETTING.getKey(), false);
            }
            if (Node.NODE_DATA_SETTING.exists(this.settings)) {
                if (((Boolean)Node.NODE_DATA_SETTING.get(this.settings)).booleanValue()) {
                    throw new IllegalArgumentException("node cannot be tribe as well as data node");
                }
            } else {
                sb.put(Node.NODE_DATA_SETTING.getKey(), false);
            }
            if (Node.NODE_INGEST_SETTING.exists(this.settings)) {
                if (((Boolean)Node.NODE_INGEST_SETTING.get(this.settings)).booleanValue()) {
                    throw new IllegalArgumentException("node cannot be tribe as well as ingest node");
                }
            } else {
                sb.put(Node.NODE_INGEST_SETTING.getKey(), false);
            }
            if (!NodeEnvironment.MAX_LOCAL_STORAGE_NODES_SETTING.exists(this.settings)) {
                sb.put(NodeEnvironment.MAX_LOCAL_STORAGE_NODES_SETTING.getKey(), nodesSettings.size());
            }
            sb.put(DiscoveryModule.DISCOVERY_TYPE_SETTING.getKey(), "tribe");
            sb.put(DiscoverySettings.INITIAL_STATE_TIMEOUT_SETTING.getKey(), 0);
            if (sb.get("cluster.name") == null) {
                sb.put("cluster.name", "tribe_" + UUIDs.randomBase64UUID());
            }
            sb.put(TransportMasterNodeReadAction.FORCE_LOCAL_SETTING.getKey(), true);
            return sb.build();
        }
        for (String s : this.settings.getAsMap().keySet()) {
            if (!s.startsWith("tribe.") || s.equals(TribeService.TRIBE_NAME_SETTING.getKey())) continue;
            throw new IllegalArgumentException("tribe cannot contain inner tribes: " + s);
        }
        return Settings.EMPTY;
    }

    public List<Setting<?>> getSettings() {
        List<Setting<?>> defaults = Arrays.asList(TribeService.BLOCKS_METADATA_SETTING, TribeService.BLOCKS_WRITE_SETTING, TribeService.BLOCKS_WRITE_INDICES_SETTING, TribeService.BLOCKS_READ_INDICES_SETTING, TribeService.BLOCKS_METADATA_INDICES_SETTING, TribeService.ON_CONFLICT_SETTING, TribeService.TRIBE_NAME_SETTING);
        Map nodesSettings = this.settings.getGroups("tribe", true);
        if (nodesSettings.isEmpty()) {
            return defaults;
        }
        ArrayList allSettings = new ArrayList(defaults);
        for (Map.Entry entry : nodesSettings.entrySet()) {
            String prefix = "tribe." + (String)entry.getKey() + ".";
            if (TribeService.TRIBE_SETTING_KEYS.stream().anyMatch(s -> s.startsWith(prefix))) continue;
            Setting.AffixSetting setting = Setting.prefixKeySetting((String)prefix, key -> new Setting(key, "", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope}));
            allSettings.add((Setting<?>)setting);
        }
        return allSettings;
    }
}

