/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.AbortingException;
import org.apache.lucene.index.BinaryDocValuesFieldUpdates;
import org.apache.lucene.index.BufferedUpdatesStream;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.DocValuesUpdate;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FrozenBufferedUpdates;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileDeleter;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.NumericDocValuesFieldUpdates;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.ReadersAndUpdates;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentMerger;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.StandardDirectoryReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TwoPhaseCommit;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockValidatingDirectoryWrapper;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.MergeInfo;
import org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.ThreadInterruptedException;
import org.apache.lucene.util.Version;

public class IndexWriter
implements Closeable,
TwoPhaseCommit,
Accountable {
    public static final int MAX_DOCS = 0x7FFFFF7F;
    public static final int MAX_POSITION = 0x7FFFFF7F;
    private static int actualMaxDocs = 0x7FFFFF7F;
    boolean enableTestPoints;
    static final int UNBOUNDED_MAX_MERGE_SEGMENTS = -1;
    public static final String WRITE_LOCK_NAME = "write.lock";
    public static final String SOURCE = "source";
    public static final String SOURCE_MERGE = "merge";
    public static final String SOURCE_FLUSH = "flush";
    public static final String SOURCE_ADDINDEXES_READERS = "addIndexes(CodecReader...)";
    public static final int MAX_TERM_LENGTH = 32766;
    public static final int MAX_STORED_STRING_LENGTH = ArrayUtil.MAX_ARRAY_LENGTH / 3;
    volatile Throwable tragedy;
    private final Directory directoryOrig;
    final Directory directory;
    private final Analyzer analyzer;
    private final AtomicLong changeCount;
    private volatile long lastCommitChangeCount;
    private List<SegmentCommitInfo> rollbackSegments;
    volatile SegmentInfos pendingCommit;
    volatile long pendingSeqNo;
    volatile long pendingCommitChangeCount;
    private Collection<String> filesToCommit;
    final SegmentInfos segmentInfos;
    final FieldInfos.FieldNumbers globalFieldNumberMap;
    final DocumentsWriter docWriter;
    private final Queue<Event> eventQueue;
    final IndexFileDeleter deleter;
    private Map<SegmentCommitInfo, Boolean> segmentsToMerge;
    private int mergeMaxNumSegments;
    private Lock writeLock;
    private volatile boolean closed;
    private volatile boolean closing;
    final AtomicBoolean maybeMerge;
    private Iterable<Map.Entry<String, String>> commitUserData;
    HashSet<SegmentCommitInfo> mergingSegments;
    private final MergeScheduler mergeScheduler;
    private LinkedList<MergePolicy.OneMerge> pendingMerges;
    private Set<MergePolicy.OneMerge> runningMerges;
    private List<MergePolicy.OneMerge> mergeExceptions;
    private long mergeGen;
    private boolean stopMerges;
    private boolean didMessageState;
    final AtomicInteger flushCount;
    final AtomicInteger flushDeletesCount;
    final ReaderPool readerPool;
    final BufferedUpdatesStream bufferedUpdatesStream;
    final AtomicLong mergeFinishedGen;
    private volatile boolean poolReaders;
    private final LiveIndexWriterConfig config;
    private long startCommitTime;
    final AtomicLong pendingNumDocs;
    final Codec codec;
    final InfoStream infoStream;
    private final Object commitLock;
    private final Object fullFlushLock;
    boolean keepFullyDeletedSegments;

    static void setMaxDocs(int maxDocs) {
        if (maxDocs > 0x7FFFFF7F) {
            throw new IllegalArgumentException("maxDocs must be <= IndexWriter.MAX_DOCS=2147483519; got: " + maxDocs);
        }
        actualMaxDocs = maxDocs;
    }

    static int getActualMaxDocs() {
        return actualMaxDocs;
    }

    DirectoryReader getReader() throws IOException {
        return this.getReader(true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DirectoryReader getReader(boolean applyAllDeletes, boolean writeAllDeletes) throws IOException {
        this.ensureOpen();
        if (writeAllDeletes && !applyAllDeletes) {
            throw new IllegalArgumentException("applyAllDeletes must be true when writeAllDeletes=true");
        }
        long tStart = System.currentTimeMillis();
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "flush at getReader");
        }
        this.poolReaders = true;
        DirectoryReader r = null;
        this.doBeforeFlush();
        boolean anyChanges = false;
        boolean success2 = false;
        try {
            boolean success = false;
            Object object = this.fullFlushLock;
            synchronized (object) {
                try {
                    long seqNo = this.docWriter.flushAllThreads();
                    if (seqNo < 0L) {
                        anyChanges = true;
                        seqNo = -seqNo;
                    } else {
                        anyChanges = false;
                    }
                    if (!anyChanges) {
                        this.flushCount.incrementAndGet();
                    }
                    this.processEvents(false, true);
                    if (applyAllDeletes) {
                        this.applyAllDeletesAndUpdates();
                    }
                    IndexWriter indexWriter = this;
                    synchronized (indexWriter) {
                        this.readerPool.writeAllDocValuesUpdates();
                        if (writeAllDeletes) {
                            this.readerPool.commit(this.segmentInfos);
                        }
                        r = StandardDirectoryReader.open(this, this.segmentInfos, applyAllDeletes, writeAllDeletes);
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "return reader version=" + r.getVersion() + " reader=" + r);
                        }
                    }
                    success = true;
                }
                finally {
                    this.docWriter.finishFullFlush(this, success);
                    if (success) {
                        this.processEvents(false, true);
                        this.doAfterFlush();
                    } else if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "hit exception during NRT reader");
                    }
                }
            }
            if (anyChanges |= this.maybeMerge.getAndSet(false)) {
                this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.FULL_FLUSH, -1);
            }
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "getReader took " + (System.currentTimeMillis() - tStart) + " msec");
            }
            if (success2 = true) return r;
        }
        catch (VirtualMachineError | AbortingException tragedy) {
            DirectoryReader directoryReader;
            try {
                this.tragicEvent(tragedy, "getReader");
                directoryReader = null;
                if (success2) return directoryReader;
            }
            catch (Throwable throwable) {
                if (success2) throw throwable;
                IOUtils.closeWhileHandlingException(r);
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(r);
            return directoryReader;
        }
        IOUtils.closeWhileHandlingException(r);
        return r;
    }

    @Override
    public final long ramBytesUsed() {
        this.ensureOpen();
        return this.docWriter.ramBytesUsed();
    }

    public int numDeletedDocs(SegmentCommitInfo info) {
        this.ensureOpen(false);
        int delCount = info.getDelCount();
        ReadersAndUpdates rld = this.readerPool.get(info, false);
        if (rld != null) {
            delCount += rld.getPendingDeleteCount();
        }
        return delCount;
    }

    protected final void ensureOpen(boolean failIfClosing) throws AlreadyClosedException {
        if (this.closed || failIfClosing && this.closing) {
            throw new AlreadyClosedException("this IndexWriter is closed", this.tragedy);
        }
    }

    protected final void ensureOpen() throws AlreadyClosedException {
        this.ensureOpen(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexWriter(Directory d, IndexWriterConfig conf) throws IOException {
        block34: {
            block35: {
                this.enableTestPoints = false;
                this.changeCount = new AtomicLong();
                this.segmentsToMerge = new HashMap<SegmentCommitInfo, Boolean>();
                this.maybeMerge = new AtomicBoolean();
                this.mergingSegments = new HashSet();
                this.pendingMerges = new LinkedList();
                this.runningMerges = new HashSet<MergePolicy.OneMerge>();
                this.mergeExceptions = new ArrayList<MergePolicy.OneMerge>();
                this.flushCount = new AtomicInteger();
                this.flushDeletesCount = new AtomicInteger();
                this.readerPool = new ReaderPool();
                this.mergeFinishedGen = new AtomicLong();
                this.pendingNumDocs = new AtomicLong();
                this.commitLock = new Object();
                this.fullFlushLock = new Object();
                if (d instanceof FSDirectory && ((FSDirectory)d).checkPendingDeletions()) {
                    throw new IllegalArgumentException("Directory " + d + " still has pending deleted files; cannot initialize IndexWriter");
                }
                conf.setIndexWriter(this);
                this.config = conf;
                this.infoStream = this.config.getInfoStream();
                this.writeLock = d.obtainLock(WRITE_LOCK_NAME);
                boolean success = false;
                try {
                    Object lastSegmentsFile;
                    this.directoryOrig = d;
                    this.directory = new LockValidatingDirectoryWrapper(d, this.writeLock);
                    this.analyzer = this.config.getAnalyzer();
                    this.mergeScheduler = this.config.getMergeScheduler();
                    this.mergeScheduler.setInfoStream(this.infoStream);
                    this.codec = this.config.getCodec();
                    this.bufferedUpdatesStream = new BufferedUpdatesStream(this);
                    this.poolReaders = this.config.getReaderPooling();
                    IndexWriterConfig.OpenMode mode = this.config.getOpenMode();
                    boolean create = mode == IndexWriterConfig.OpenMode.CREATE ? true : (mode == IndexWriterConfig.OpenMode.APPEND ? false : !DirectoryReader.indexExists(this.directory));
                    boolean initialIndexExists = true;
                    Object[] files = this.directory.listAll();
                    IndexCommit commit = this.config.getIndexCommit();
                    StandardDirectoryReader reader = commit == null ? null : commit.getReader();
                    if (create) {
                        if (this.config.getIndexCommit() != null) {
                            if (mode == IndexWriterConfig.OpenMode.CREATE) {
                                throw new IllegalArgumentException("cannot use IndexWriterConfig.setIndexCommit() with OpenMode.CREATE");
                            }
                            throw new IllegalArgumentException("cannot use IndexWriterConfig.setIndexCommit() when index has no commit");
                        }
                        SegmentInfos sis = new SegmentInfos(Version.LATEST.major);
                        try {
                            SegmentInfos previous = SegmentInfos.readLatestCommit(this.directory);
                            sis.updateGenerationVersionAndCounter(previous);
                        }
                        catch (IOException e) {
                            initialIndexExists = false;
                        }
                        this.segmentInfos = sis;
                        this.rollbackSegments = this.segmentInfos.createBackupSegmentInfos();
                        this.changed();
                    } else if (reader != null) {
                        SegmentInfos lastCommit;
                        if (reader.directory() != commit.getDirectory()) {
                            throw new IllegalArgumentException("IndexCommit's reader must have the same directory as the IndexCommit");
                        }
                        if (reader.directory() != this.directoryOrig) {
                            throw new IllegalArgumentException("IndexCommit's reader must have the same directory passed to IndexWriter");
                        }
                        if (reader.segmentInfos.getLastGeneration() == 0L) {
                            throw new IllegalArgumentException("index must already have an initial commit to open from reader");
                        }
                        this.segmentInfos = reader.segmentInfos.clone();
                        try {
                            lastCommit = SegmentInfos.readCommit(this.directoryOrig, this.segmentInfos.getSegmentsFileName());
                        }
                        catch (IOException ioe) {
                            throw new IllegalArgumentException("the provided reader is stale: its prior commit file \"" + this.segmentInfos.getSegmentsFileName() + "\" is missing from index");
                        }
                        if (reader.writer != null) {
                            assert (reader.writer.closed);
                            this.segmentInfos.updateGenerationVersionAndCounter(reader.writer.segmentInfos);
                            lastCommit.updateGenerationVersionAndCounter(reader.writer.segmentInfos);
                        }
                        this.rollbackSegments = lastCommit.createBackupSegmentInfos();
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "init from reader " + reader);
                            this.messageState();
                        }
                    } else {
                        lastSegmentsFile = SegmentInfos.getLastCommitSegmentsFileName((String[])files);
                        if (lastSegmentsFile == null) {
                            throw new IndexNotFoundException("no segments* file found in " + this.directory + ": files: " + Arrays.toString(files));
                        }
                        this.segmentInfos = SegmentInfos.readCommit(this.directoryOrig, (String)lastSegmentsFile);
                        if (commit != null) {
                            if (commit.getDirectory() != this.directoryOrig) {
                                throw new IllegalArgumentException("IndexCommit's directory doesn't match my directory, expected=" + this.directoryOrig + ", got=" + commit.getDirectory());
                            }
                            SegmentInfos oldInfos = SegmentInfos.readCommit(this.directoryOrig, commit.getSegmentsFileName());
                            this.segmentInfos.replace(oldInfos);
                            this.changed();
                            if (this.infoStream.isEnabled("IW")) {
                                this.infoStream.message("IW", "init: loaded commit \"" + commit.getSegmentsFileName() + "\"");
                            }
                        }
                        this.rollbackSegments = this.segmentInfos.createBackupSegmentInfos();
                    }
                    this.commitUserData = new HashMap<String, String>(this.segmentInfos.getUserData()).entrySet();
                    this.pendingNumDocs.set(this.segmentInfos.totalMaxDoc());
                    this.globalFieldNumberMap = this.getFieldNumberMap();
                    this.validateIndexSort();
                    this.config.getFlushPolicy().init(this.config);
                    this.docWriter = new DocumentsWriter(this, this.config, this.directoryOrig, this.directory);
                    this.eventQueue = this.docWriter.eventQueue();
                    lastSegmentsFile = this;
                    synchronized (lastSegmentsFile) {
                        this.deleter = new IndexFileDeleter((String[])files, this.directoryOrig, this.directory, this.config.getIndexDeletionPolicy(), this.segmentInfos, this.infoStream, this, initialIndexExists, reader != null);
                        assert (create || this.filesExist(this.segmentInfos));
                    }
                    if (this.deleter.startingCommitDeleted) {
                        this.changed();
                    }
                    if (reader != null) {
                        List<LeafReaderContext> leaves = reader.leaves();
                        assert (this.segmentInfos.size() == leaves.size());
                        for (int i = 0; i < leaves.size(); ++i) {
                            LeafReaderContext leaf = leaves.get(i);
                            SegmentReader segReader = (SegmentReader)leaf.reader();
                            SegmentReader newReader = new SegmentReader(this.segmentInfos.info(i), segReader, segReader.getLiveDocs(), segReader.numDocs());
                            this.readerPool.readerMap.put(newReader.getSegmentInfo(), new ReadersAndUpdates(this, newReader));
                        }
                        this.segmentInfos.changed();
                        this.changed();
                    }
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "init: create=" + create);
                        this.messageState();
                    }
                    if (success = true) break block34;
                    if (!this.infoStream.isEnabled("IW")) break block35;
                    this.infoStream.message("IW", "init: hit exception on init; releasing write lock");
                }
                catch (Throwable throwable) {
                    if (!success) {
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "init: hit exception on init; releasing write lock");
                        }
                        IOUtils.closeWhileHandlingException(this.writeLock);
                        this.writeLock = null;
                    }
                    throw throwable;
                }
            }
            IOUtils.closeWhileHandlingException(this.writeLock);
            this.writeLock = null;
        }
    }

    private void validateIndexSort() throws CorruptIndexException {
        Sort indexSort = this.config.getIndexSort();
        if (indexSort != null) {
            for (SegmentCommitInfo info : this.segmentInfos) {
                Sort segmentIndexSort = info.info.getIndexSort();
                if (segmentIndexSort != null && !indexSort.equals(segmentIndexSort)) {
                    throw new IllegalArgumentException("cannot change previous indexSort=" + segmentIndexSort + " (from segment=" + info + ") to new indexSort=" + indexSort);
                }
                if (segmentIndexSort != null || !info.info.getVersion().onOrAfter(Version.LUCENE_6_5_0)) continue;
                throw new CorruptIndexException("segment not sorted with indexSort=" + segmentIndexSort, info.info.toString());
            }
        }
    }

    static FieldInfos readFieldInfos(SegmentCommitInfo si) throws IOException {
        Codec codec = si.info.getCodec();
        FieldInfosFormat reader = codec.fieldInfosFormat();
        if (si.hasFieldUpdates()) {
            String segmentSuffix = Long.toString(si.getFieldInfosGen(), 36);
            return reader.read(si.info.dir, si.info, segmentSuffix, IOContext.READONCE);
        }
        if (si.info.getUseCompoundFile()) {
            try (Directory cfs = codec.compoundFormat().getCompoundReader(si.info.dir, si.info, IOContext.DEFAULT);){
                FieldInfos fieldInfos = reader.read(cfs, si.info, "", IOContext.READONCE);
                return fieldInfos;
            }
        }
        return reader.read(si.info.dir, si.info, "", IOContext.READONCE);
    }

    private FieldInfos.FieldNumbers getFieldNumberMap() throws IOException {
        FieldInfos.FieldNumbers map = new FieldInfos.FieldNumbers();
        for (SegmentCommitInfo info : this.segmentInfos) {
            FieldInfos fis = IndexWriter.readFieldInfos(info);
            for (FieldInfo fi : fis) {
                map.addOrGet(fi.name, fi.number, fi.getDocValuesType(), fi.getPointDimensionCount(), fi.getPointNumBytes());
            }
        }
        return map;
    }

    public LiveIndexWriterConfig getConfig() {
        this.ensureOpen(false);
        return this.config;
    }

    private void messageState() {
        if (this.infoStream.isEnabled("IW") && !this.didMessageState) {
            this.didMessageState = true;
            this.infoStream.message("IW", "\ndir=" + this.directoryOrig + "\n" + "index=" + this.segString() + "\n" + "version=" + Version.LATEST.toString() + "\n" + this.config.toString());
            StringBuilder unmapInfo = new StringBuilder(Boolean.toString(MMapDirectory.UNMAP_SUPPORTED));
            if (!MMapDirectory.UNMAP_SUPPORTED) {
                unmapInfo.append(" (").append(MMapDirectory.UNMAP_NOT_SUPPORTED_REASON).append(")");
            }
            this.infoStream.message("IW", "MMapDirectory.UNMAP_SUPPORTED=" + unmapInfo);
        }
    }

    private void shutdown() throws IOException {
        if (this.pendingCommit != null) {
            throw new IllegalStateException("cannot close: prepareCommit was already called with no corresponding call to commit");
        }
        if (this.shouldClose(true)) {
            boolean success = false;
            try {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "now flush at close");
                }
                this.flush(true, true);
                this.waitForMerges();
                this.commitInternal(this.config.getMergePolicy());
                this.rollbackInternal();
                success = true;
            }
            finally {
                if (!success) {
                    try {
                        this.rollbackInternal();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.config.getCommitOnClose()) {
            this.shutdown();
        } else {
            this.rollback();
        }
    }

    private synchronized boolean shouldClose(boolean waitForClose) {
        while (!this.closed) {
            if (!this.closing) {
                this.closing = true;
                return true;
            }
            if (!waitForClose) {
                return false;
            }
            this.doWait();
        }
        return false;
    }

    public Directory getDirectory() {
        return this.directoryOrig;
    }

    public Analyzer getAnalyzer() {
        this.ensureOpen();
        return this.analyzer;
    }

    public synchronized int maxDoc() {
        this.ensureOpen();
        return this.docWriter.getNumDocs() + this.segmentInfos.totalMaxDoc();
    }

    public synchronized void advanceSegmentInfosVersion(long newVersion) {
        this.ensureOpen();
        if (this.segmentInfos.getVersion() < newVersion) {
            this.segmentInfos.setVersion(newVersion);
        }
        this.changed();
    }

    public synchronized int numDocs() {
        this.ensureOpen();
        int count = this.docWriter.getNumDocs();
        for (SegmentCommitInfo info : this.segmentInfos) {
            count += info.info.maxDoc() - this.numDeletedDocs(info);
        }
        return count;
    }

    public synchronized boolean hasDeletions() {
        this.ensureOpen();
        if (this.bufferedUpdatesStream.any()) {
            return true;
        }
        if (this.docWriter.anyDeletions()) {
            return true;
        }
        if (this.readerPool.anyPendingDeletes()) {
            return true;
        }
        for (SegmentCommitInfo info : this.segmentInfos) {
            if (!info.hasDeletions()) continue;
            return true;
        }
        return false;
    }

    public long addDocument(Iterable<? extends IndexableField> doc) throws IOException {
        return this.updateDocument(null, doc);
    }

    public long addDocuments(Iterable<? extends Iterable<? extends IndexableField>> docs) throws IOException {
        return this.updateDocuments(null, docs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long updateDocuments(Term delTerm, Iterable<? extends Iterable<? extends IndexableField>> docs) throws IOException {
        this.ensureOpen();
        boolean success = false;
        try {
            long seqNo = this.docWriter.updateDocuments(docs, this.analyzer, delTerm);
            if (seqNo < 0L) {
                seqNo = -seqNo;
                this.processEvents(true, false);
            }
            success = true;
            long l = seqNo;
            if (!success && this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "hit exception updating document");
            }
            return l;
        }
        catch (Throwable throwable) {
            try {
                if (!success && this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "hit exception updating document");
                }
                throw throwable;
            }
            catch (VirtualMachineError | AbortingException tragedy) {
                this.tragicEvent(tragedy, "updateDocuments");
                return -1L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long tryDeleteDocument(IndexReader readerIn, int docID) throws IOException {
        ReadersAndUpdates rld;
        LeafReader reader;
        if (readerIn instanceof LeafReader) {
            reader = (LeafReader)readerIn;
        } else {
            List<LeafReaderContext> leaves = readerIn.leaves();
            int subIndex = ReaderUtil.subIndex(docID, leaves);
            reader = leaves.get(subIndex).reader();
            assert ((docID -= leaves.get((int)subIndex).docBase) >= 0);
            assert (docID < reader.maxDoc());
        }
        if (!(reader instanceof SegmentReader)) {
            throw new IllegalArgumentException("the reader must be a SegmentReader or composite reader containing only SegmentReaders");
        }
        SegmentCommitInfo info = ((SegmentReader)reader).getSegmentInfo();
        if (this.segmentInfos.indexOf(info) != -1 && (rld = this.readerPool.get(info, false)) != null) {
            BufferedUpdatesStream bufferedUpdatesStream = this.bufferedUpdatesStream;
            synchronized (bufferedUpdatesStream) {
                if (rld.delete(docID)) {
                    int fullDelCount = rld.info.getDelCount() + rld.getPendingDeleteCount();
                    if (fullDelCount == rld.info.info.maxDoc()) {
                        this.dropDeletedSegment(rld.info);
                        this.checkpoint();
                    }
                    this.changed();
                }
                return this.docWriter.deleteQueue.getNextSequenceNumber();
            }
        }
        return -1L;
    }

    synchronized void dropDeletedSegment(SegmentCommitInfo info) throws IOException {
        if (!this.mergingSegments.contains(info)) {
            this.segmentInfos.remove(info);
            this.pendingNumDocs.addAndGet(-info.info.maxDoc());
            this.readerPool.drop(info);
        }
    }

    public long deleteDocuments(Term ... terms) throws IOException {
        this.ensureOpen();
        try {
            long seqNo = this.docWriter.deleteTerms(terms);
            if (seqNo < 0L) {
                seqNo = -seqNo;
                this.processEvents(true, false);
            }
            return seqNo;
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, "deleteDocuments(Term..)");
            return -1L;
        }
    }

    public long deleteDocuments(Query ... queries) throws IOException {
        this.ensureOpen();
        for (Query query : queries) {
            if (query.getClass() != MatchAllDocsQuery.class) continue;
            return this.deleteAll();
        }
        try {
            long seqNo = this.docWriter.deleteQueries(queries);
            if (seqNo < 0L) {
                seqNo = -seqNo;
                this.processEvents(true, false);
            }
            return seqNo;
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, "deleteDocuments(Query..)");
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long updateDocument(Term term, Iterable<? extends IndexableField> doc) throws IOException {
        this.ensureOpen();
        boolean success = false;
        try {
            long seqNo = this.docWriter.updateDocument(doc, this.analyzer, term);
            if (seqNo < 0L) {
                seqNo = -seqNo;
                this.processEvents(true, false);
            }
            success = true;
            long l = seqNo;
            if (!success && this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "hit exception updating document");
            }
            return l;
        }
        catch (Throwable throwable) {
            try {
                if (!success && this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "hit exception updating document");
                }
                throw throwable;
            }
            catch (VirtualMachineError | AbortingException tragedy) {
                this.tragicEvent(tragedy, "updateDocument");
                return -1L;
            }
        }
    }

    public long updateNumericDocValue(Term term, String field, long value) throws IOException {
        this.ensureOpen();
        if (!this.globalFieldNumberMap.contains(field, DocValuesType.NUMERIC)) {
            throw new IllegalArgumentException("can only update existing numeric-docvalues fields!");
        }
        if (this.config.getIndexSortFields().contains(field)) {
            throw new IllegalArgumentException("cannot update docvalues field involved in the index sort, field=" + field + ", sort=" + this.config.getIndexSort());
        }
        try {
            long seqNo = this.docWriter.updateDocValues(new DocValuesUpdate.NumericDocValuesUpdate(term, field, value));
            if (seqNo < 0L) {
                seqNo = -seqNo;
                this.processEvents(true, false);
            }
            return seqNo;
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, "updateNumericDocValue");
            return -1L;
        }
    }

    public long updateBinaryDocValue(Term term, String field, BytesRef value) throws IOException {
        this.ensureOpen();
        if (value == null) {
            throw new IllegalArgumentException("cannot update a field to a null value: " + field);
        }
        if (!this.globalFieldNumberMap.contains(field, DocValuesType.BINARY)) {
            throw new IllegalArgumentException("can only update existing binary-docvalues fields!");
        }
        try {
            long seqNo = this.docWriter.updateDocValues(new DocValuesUpdate.BinaryDocValuesUpdate(term, field, value));
            if (seqNo < 0L) {
                seqNo = -seqNo;
                this.processEvents(true, false);
            }
            return seqNo;
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, "updateBinaryDocValue");
            return -1L;
        }
    }

    public long updateDocValues(Term term, Field ... updates) throws IOException {
        this.ensureOpen();
        DocValuesUpdate[] dvUpdates = new DocValuesUpdate[updates.length];
        block6: for (int i = 0; i < updates.length; ++i) {
            Field f = updates[i];
            DocValuesType dvType = f.fieldType().docValuesType();
            if (dvType == null) {
                throw new NullPointerException("DocValuesType must not be null (field: \"" + f.name() + "\")");
            }
            if (dvType == DocValuesType.NONE) {
                throw new IllegalArgumentException("can only update NUMERIC or BINARY fields! field=" + f.name());
            }
            if (!this.globalFieldNumberMap.contains(f.name(), dvType)) {
                throw new IllegalArgumentException("can only update existing docvalues fields! field=" + f.name() + ", type=" + (Object)((Object)dvType));
            }
            if (this.config.getIndexSortFields().contains(f.name())) {
                throw new IllegalArgumentException("cannot update docvalues field involved in the index sort, field=" + f.name() + ", sort=" + this.config.getIndexSort());
            }
            switch (dvType) {
                case NUMERIC: {
                    dvUpdates[i] = new DocValuesUpdate.NumericDocValuesUpdate(term, f.name(), (Long)f.numericValue());
                    continue block6;
                }
                case BINARY: {
                    dvUpdates[i] = new DocValuesUpdate.BinaryDocValuesUpdate(term, f.name(), f.binaryValue());
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("can only update NUMERIC or BINARY fields: field=" + f.name() + ", type=" + (Object)((Object)dvType));
                }
            }
        }
        try {
            long seqNo = this.docWriter.updateDocValues(dvUpdates);
            if (seqNo < 0L) {
                seqNo = -seqNo;
                this.processEvents(true, false);
            }
            return seqNo;
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, "updateDocValues");
            return -1L;
        }
    }

    final synchronized int getSegmentCount() {
        return this.segmentInfos.size();
    }

    final synchronized int getNumBufferedDocuments() {
        return this.docWriter.getNumDocs();
    }

    final synchronized Collection<String> getIndexFileNames() throws IOException {
        return this.segmentInfos.files(true);
    }

    final synchronized int maxDoc(int i) {
        if (i >= 0 && i < this.segmentInfos.size()) {
            return this.segmentInfos.info((int)i).info.maxDoc();
        }
        return -1;
    }

    final int getFlushCount() {
        return this.flushCount.get();
    }

    final int getFlushDeletesCount() {
        return this.flushDeletesCount.get();
    }

    public Set<String> getFieldNames() {
        return this.globalFieldNumberMap.getFieldNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String newSegmentName() {
        SegmentInfos segmentInfos = this.segmentInfos;
        synchronized (segmentInfos) {
            this.changeCount.incrementAndGet();
            this.segmentInfos.changed();
            return "_" + Integer.toString(this.segmentInfos.counter++, 36);
        }
    }

    public void forceMerge(int maxNumSegments) throws IOException {
        this.forceMerge(maxNumSegments, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceMerge(int maxNumSegments, boolean doWait) throws IOException {
        this.ensureOpen();
        if (maxNumSegments < 1) {
            throw new IllegalArgumentException("maxNumSegments must be >= 1; got " + maxNumSegments);
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "forceMerge: index now " + this.segString());
            this.infoStream.message("IW", "now flush at forceMerge");
        }
        this.flush(true, true);
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            this.resetMergeExceptions();
            this.segmentsToMerge.clear();
            for (SegmentCommitInfo info : this.segmentInfos) {
                assert (info != null);
                this.segmentsToMerge.put(info, Boolean.TRUE);
            }
            this.mergeMaxNumSegments = maxNumSegments;
            for (MergePolicy.OneMerge merge : this.pendingMerges) {
                merge.maxNumSegments = maxNumSegments;
                if (merge.info == null) continue;
                this.segmentsToMerge.put(merge.info, Boolean.TRUE);
            }
            for (MergePolicy.OneMerge merge : this.runningMerges) {
                merge.maxNumSegments = maxNumSegments;
                if (merge.info == null) continue;
                this.segmentsToMerge.put(merge.info, Boolean.TRUE);
            }
        }
        this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.EXPLICIT, maxNumSegments);
        if (doWait) {
            indexWriter = this;
            synchronized (indexWriter) {
                while (true) {
                    if (this.tragedy != null) {
                        throw new IllegalStateException("this writer hit an unrecoverable error; cannot complete forceMerge", this.tragedy);
                    }
                    if (this.mergeExceptions.size() > 0) {
                        int size = this.mergeExceptions.size();
                        for (int i = 0; i < size; ++i) {
                            MergePolicy.OneMerge merge = this.mergeExceptions.get(i);
                            if (merge.maxNumSegments == -1) continue;
                            throw new IOException("background merge hit exception: " + merge.segString(), merge.getException());
                        }
                    }
                    if (!this.maxNumSegmentsMergesPending()) break;
                    this.doWait();
                }
            }
            this.ensureOpen();
        }
    }

    private synchronized boolean maxNumSegmentsMergesPending() {
        for (MergePolicy.OneMerge merge : this.pendingMerges) {
            if (merge.maxNumSegments == -1) continue;
            return true;
        }
        for (MergePolicy.OneMerge merge : this.runningMerges) {
            if (merge.maxNumSegments == -1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceMergeDeletes(boolean doWait) throws IOException {
        MergePolicy.MergeSpecification spec;
        this.ensureOpen();
        this.flush(true, true);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "forceMergeDeletes: index now " + this.segString());
        }
        MergePolicy mergePolicy = this.config.getMergePolicy();
        boolean newMergesFound = false;
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            spec = mergePolicy.findForcedDeletesMerges(this.segmentInfos, this);
            boolean bl = newMergesFound = spec != null;
            if (newMergesFound) {
                int numMerges = spec.merges.size();
                for (int i = 0; i < numMerges; ++i) {
                    this.registerMerge(spec.merges.get(i));
                }
            }
        }
        this.mergeScheduler.merge(this, MergeTrigger.EXPLICIT, newMergesFound);
        if (spec != null && doWait) {
            int numMerges = spec.merges.size();
            IndexWriter indexWriter2 = this;
            synchronized (indexWriter2) {
                boolean running = true;
                while (running) {
                    if (this.tragedy != null) {
                        throw new IllegalStateException("this writer hit an unrecoverable error; cannot complete forceMergeDeletes", this.tragedy);
                    }
                    running = false;
                    for (int i = 0; i < numMerges; ++i) {
                        Throwable t;
                        MergePolicy.OneMerge merge = spec.merges.get(i);
                        if (this.pendingMerges.contains(merge) || this.runningMerges.contains(merge)) {
                            running = true;
                        }
                        if ((t = merge.getException()) == null) continue;
                        throw new IOException("background merge hit exception: " + merge.segString(), t);
                    }
                    if (!running) continue;
                    this.doWait();
                }
            }
        }
    }

    public void forceMergeDeletes() throws IOException {
        this.forceMergeDeletes(true);
    }

    public final void maybeMerge() throws IOException {
        this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.EXPLICIT, -1);
    }

    final void maybeMerge(MergePolicy mergePolicy, MergeTrigger trigger, int maxNumSegments) throws IOException {
        this.ensureOpen(false);
        boolean newMergesFound = this.updatePendingMerges(mergePolicy, trigger, maxNumSegments);
        this.mergeScheduler.merge(this, trigger, newMergesFound);
    }

    private synchronized boolean updatePendingMerges(MergePolicy mergePolicy, MergeTrigger trigger, int maxNumSegments) throws IOException {
        int i;
        int numMerges;
        MergePolicy.MergeSpecification spec;
        this.messageState();
        assert (maxNumSegments == -1 || maxNumSegments > 0);
        assert (trigger != null);
        if (this.stopMerges) {
            return false;
        }
        if (this.tragedy != null) {
            return false;
        }
        boolean newMergesFound = false;
        if (maxNumSegments != -1) {
            assert (trigger == MergeTrigger.EXPLICIT || trigger == MergeTrigger.MERGE_FINISHED) : "Expected EXPLICT or MERGE_FINISHED as trigger even with maxNumSegments set but was: " + trigger.name();
            spec = mergePolicy.findForcedMerges(this.segmentInfos, maxNumSegments, Collections.unmodifiableMap(this.segmentsToMerge), this);
            boolean bl = newMergesFound = spec != null;
            if (newMergesFound) {
                numMerges = spec.merges.size();
                for (i = 0; i < numMerges; ++i) {
                    MergePolicy.OneMerge merge = spec.merges.get(i);
                    merge.maxNumSegments = maxNumSegments;
                }
            }
        } else {
            spec = mergePolicy.findMerges(trigger, this.segmentInfos, this);
        }
        boolean bl = newMergesFound = spec != null;
        if (newMergesFound) {
            numMerges = spec.merges.size();
            for (i = 0; i < numMerges; ++i) {
                this.registerMerge(spec.merges.get(i));
            }
        }
        return newMergesFound;
    }

    public synchronized Collection<SegmentCommitInfo> getMergingSegments() {
        return this.mergingSegments;
    }

    public synchronized MergePolicy.OneMerge getNextMerge() {
        if (this.pendingMerges.size() == 0) {
            return null;
        }
        MergePolicy.OneMerge merge = this.pendingMerges.removeFirst();
        this.runningMerges.add(merge);
        return merge;
    }

    public synchronized boolean hasPendingMerges() {
        return this.pendingMerges.size() != 0;
    }

    @Override
    public void rollback() throws IOException {
        if (this.shouldClose(true)) {
            this.rollbackInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackInternal() throws IOException {
        Object object = this.commitLock;
        synchronized (object) {
            this.rollbackInternalNoCommit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackInternalNoCommit() throws IOException {
        IndexWriter indexWriter;
        boolean success;
        block38: {
            success = false;
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "rollback");
            }
            try {
                this.abortMerges();
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "rollback: done finish merges");
                }
                this.mergeScheduler.close();
                this.docWriter.close();
                this.docWriter.abort(this);
                indexWriter = this;
                synchronized (indexWriter) {
                    if (this.pendingCommit != null) {
                        this.pendingCommit.rollbackCommit(this.directory);
                        try {
                            this.deleter.decRef(this.pendingCommit);
                        }
                        finally {
                            this.pendingCommit = null;
                            this.notifyAll();
                        }
                    }
                    this.readerPool.dropAll(false);
                    this.segmentInfos.rollbackSegmentInfos(this.rollbackSegments);
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "rollback: infos=" + this.segString(this.segmentInfos));
                    }
                    this.testPoint("rollback before checkpoint");
                    if (this.tragedy == null) {
                        this.deleter.checkpoint(this.segmentInfos, false);
                        this.deleter.refresh();
                        this.deleter.close();
                    }
                    this.lastCommitChangeCount = this.changeCount.get();
                    this.closed = true;
                    IOUtils.close(this.writeLock);
                    this.writeLock = null;
                }
                success = true;
                if (success) break block38;
            }
            catch (VirtualMachineError tragedy) {
                block39: {
                    try {
                        this.tragicEvent(tragedy, "rollbackInternal");
                        if (success) break block39;
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            IOUtils.closeWhileHandlingException(this.mergeScheduler);
                        }
                        IndexWriter indexWriter2 = this;
                        synchronized (indexWriter2) {
                            if (!success) {
                                if (this.pendingCommit != null) {
                                    try {
                                        this.pendingCommit.rollbackCommit(this.directory);
                                        this.deleter.decRef(this.pendingCommit);
                                    }
                                    catch (Throwable throwable2) {
                                        // empty catch block
                                    }
                                    this.pendingCommit = null;
                                }
                                IOUtils.closeWhileHandlingException(this.readerPool, this.deleter, this.writeLock);
                                this.writeLock = null;
                            }
                            this.closed = true;
                            this.closing = false;
                            this.notifyAll();
                        }
                        throw throwable;
                    }
                    IOUtils.closeWhileHandlingException(this.mergeScheduler);
                }
                IndexWriter indexWriter3 = this;
                synchronized (indexWriter3) {
                    if (!success) {
                        if (this.pendingCommit != null) {
                            try {
                                this.pendingCommit.rollbackCommit(this.directory);
                                this.deleter.decRef(this.pendingCommit);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            this.pendingCommit = null;
                        }
                        IOUtils.closeWhileHandlingException(this.readerPool, this.deleter, this.writeLock);
                        this.writeLock = null;
                    }
                    this.closed = true;
                    this.closing = false;
                    this.notifyAll();
                }
            }
            IOUtils.closeWhileHandlingException(this.mergeScheduler);
        }
        indexWriter = this;
        synchronized (indexWriter) {
            if (!success) {
                if (this.pendingCommit != null) {
                    try {
                        this.pendingCommit.rollbackCommit(this.directory);
                        this.deleter.decRef(this.pendingCommit);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.pendingCommit = null;
                }
                IOUtils.closeWhileHandlingException(this.readerPool, this.deleter, this.writeLock);
                this.writeLock = null;
            }
            this.closed = true;
            this.closing = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long deleteAll() throws IOException {
        this.ensureOpen();
        boolean success = false;
        Object object = this.fullFlushLock;
        synchronized (object) {
            long abortedDocCount = this.docWriter.lockAndAbortAll(this);
            this.pendingNumDocs.addAndGet(-abortedDocCount);
            this.processEvents(false, true);
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                long l;
                block14: {
                    try {
                        this.abortMerges();
                        this.stopMerges = false;
                        this.pendingNumDocs.addAndGet(-this.segmentInfos.totalMaxDoc());
                        this.segmentInfos.clear();
                        this.deleter.checkpoint(this.segmentInfos, false);
                        this.readerPool.dropAll(false);
                        this.changeCount.incrementAndGet();
                        this.segmentInfos.changed();
                        this.globalFieldNumberMap.clear();
                        success = true;
                        long seqNo = this.docWriter.deleteQueue.getNextSequenceNumber();
                        this.docWriter.setLastSeqNo(seqNo);
                        l = seqNo;
                        this.docWriter.unlockAllAfterAbortAll(this);
                        if (success || !this.infoStream.isEnabled("IW")) break block14;
                        this.infoStream.message("IW", "hit exception during deleteAll");
                    }
                    catch (Throwable throwable) {
                        try {
                            this.docWriter.unlockAllAfterAbortAll(this);
                            if (!success && this.infoStream.isEnabled("IW")) {
                                this.infoStream.message("IW", "hit exception during deleteAll");
                            }
                            throw throwable;
                        }
                        catch (VirtualMachineError tragedy) {
                            this.tragicEvent(tragedy, "deleteAll");
                            return -1L;
                        }
                    }
                }
                return l;
            }
        }
    }

    private synchronized void abortMerges() {
        this.stopMerges = true;
        for (MergePolicy.OneMerge merge : this.pendingMerges) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "now abort pending merge " + this.segString(merge.segments));
            }
            merge.setAborted();
            this.mergeFinish(merge);
        }
        this.pendingMerges.clear();
        for (MergePolicy.OneMerge merge : this.runningMerges) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "now abort running merge " + this.segString(merge.segments));
            }
            merge.setAborted();
        }
        while (this.runningMerges.size() != 0) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "now wait for " + this.runningMerges.size() + " running merge/s to abort");
            }
            this.doWait();
        }
        this.notifyAll();
        assert (0 == this.mergingSegments.size());
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "all running merges have aborted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForMerges() throws IOException {
        this.mergeScheduler.merge(this, MergeTrigger.CLOSING, false);
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            this.ensureOpen(false);
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "waitForMerges");
            }
            while (this.pendingMerges.size() > 0 || this.runningMerges.size() > 0) {
                this.doWait();
            }
            assert (0 == this.mergingSegments.size());
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "waitForMerges done");
            }
        }
    }

    synchronized void checkpoint() throws IOException {
        this.changed();
        this.deleter.checkpoint(this.segmentInfos, false);
    }

    synchronized void checkpointNoSIS() throws IOException {
        this.changeCount.incrementAndGet();
        this.deleter.checkpoint(this.segmentInfos, false);
    }

    synchronized void changed() {
        this.changeCount.incrementAndGet();
        this.segmentInfos.changed();
    }

    synchronized void publishFrozenUpdates(FrozenBufferedUpdates packet) throws IOException {
        assert (packet != null && packet.any());
        this.bufferedUpdatesStream.push(packet);
        this.docWriter.putEvent(new DocumentsWriter.ResolveUpdatesEvent(packet));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void publishFlushedSegment(SegmentCommitInfo newSegment, FrozenBufferedUpdates packet, FrozenBufferedUpdates globalPacket, Sorter.DocMap sortMap) throws IOException {
        try {
            long nextGen;
            this.ensureOpen(false);
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "publishFlushedSegment " + newSegment);
            }
            if (globalPacket != null && globalPacket.any()) {
                this.bufferedUpdatesStream.push(globalPacket);
                this.docWriter.putEvent(new DocumentsWriter.ResolveUpdatesEvent(globalPacket));
            }
            if (packet != null && packet.any()) {
                nextGen = this.bufferedUpdatesStream.push(packet);
                this.docWriter.putEvent(new DocumentsWriter.ResolveUpdatesEvent(packet));
            } else {
                nextGen = this.bufferedUpdatesStream.getNextGen();
                this.bufferedUpdatesStream.finishedSegment(nextGen);
            }
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "publish sets newSegment delGen=" + nextGen + " seg=" + this.segString(newSegment));
            }
            newSegment.setBufferedDeletesGen(nextGen);
            this.segmentInfos.add(newSegment);
            this.checkpoint();
            if (packet != null && packet.any() && sortMap != null) {
                ReadersAndUpdates rld = this.readerPool.get(newSegment, true);
                rld.sortMap = sortMap;
            }
        }
        finally {
            this.flushCount.incrementAndGet();
            this.doAfterFlush();
        }
    }

    private synchronized void resetMergeExceptions() {
        this.mergeExceptions = new ArrayList<MergePolicy.OneMerge>();
        ++this.mergeGen;
    }

    private void noDupDirs(Directory ... dirs) {
        HashSet<Directory> dups = new HashSet<Directory>();
        for (int i = 0; i < dirs.length; ++i) {
            if (dups.contains(dirs[i])) {
                throw new IllegalArgumentException("Directory " + dirs[i] + " appears more than once");
            }
            if (dirs[i] == this.directoryOrig) {
                throw new IllegalArgumentException("Cannot add directory to itself");
            }
            dups.add(dirs[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Lock> acquireWriteLocks(Directory ... dirs) throws IOException {
        ArrayList<Lock> locks = new ArrayList<Lock>(dirs.length);
        for (int i = 0; i < dirs.length; ++i) {
            boolean success = false;
            try {
                Lock lock = dirs[i].obtainLock(WRITE_LOCK_NAME);
                locks.add(lock);
                success = true;
                continue;
            }
            finally {
                if (!success) {
                    IOUtils.closeWhileHandlingException(locks);
                }
            }
        }
        return locks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addIndexes(Directory ... dirs) throws IOException {
        long seqNo;
        this.ensureOpen();
        this.noDupDirs(dirs);
        List<Lock> locks = this.acquireWriteLocks(dirs);
        Sort indexSort = this.config.getIndexSort();
        boolean successTop = false;
        try {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "flush at addIndexes(Directory...)");
            }
            this.flush(false, true);
            ArrayList<SegmentCommitInfo> infos = new ArrayList<SegmentCommitInfo>();
            long totalMaxDoc = 0L;
            ArrayList<SegmentInfos> commits = new ArrayList<SegmentInfos>(dirs.length);
            for (Directory dir : dirs) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "addIndexes: process directory " + dir);
                }
                SegmentInfos sis = SegmentInfos.readLatestCommit(dir);
                if (this.segmentInfos.getIndexCreatedVersionMajor() != sis.getIndexCreatedVersionMajor()) {
                    throw new IllegalArgumentException("Cannot use addIndexes(Directory) with indexes that have been created by a different Lucene version. The current index was generated by Lucene " + this.segmentInfos.getIndexCreatedVersionMajor() + " while one of the directories contains an index that was generated with Lucene " + sis.getIndexCreatedVersionMajor());
                }
                totalMaxDoc += (long)sis.totalMaxDoc();
                commits.add(sis);
            }
            this.testReserveDocs(totalMaxDoc);
            boolean success = false;
            try {
                for (SegmentInfos sis : commits) {
                    for (SegmentCommitInfo info : sis) {
                        assert (!infos.contains(info)) : "dup info dir=" + info.info.dir + " name=" + info.info.name;
                        Sort segmentIndexSort = info.info.getIndexSort();
                        if (indexSort != null && segmentIndexSort != null && !indexSort.equals(segmentIndexSort)) {
                            throw new IllegalArgumentException("cannot change index sort from " + segmentIndexSort + " to " + indexSort);
                        }
                        String newSegName = this.newSegmentName();
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "addIndexes: process segment origName=" + info.info.name + " newName=" + newSegName + " info=" + info);
                        }
                        IOContext context = new IOContext(new FlushInfo(info.info.maxDoc(), info.sizeInBytes()));
                        FieldInfos fis = IndexWriter.readFieldInfos(info);
                        for (FieldInfo fi : fis) {
                            this.globalFieldNumberMap.addOrGet(fi.name, fi.number, fi.getDocValuesType(), fi.getPointDimensionCount(), fi.getPointNumBytes());
                        }
                        infos.add(this.copySegmentAsIs(info, newSegName, context));
                    }
                }
                success = true;
            }
            finally {
                if (!success) {
                    for (SegmentCommitInfo sipc : infos) {
                        this.deleteNewFiles(sipc.files());
                    }
                }
            }
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                success = false;
                try {
                    this.ensureOpen();
                    this.reserveDocs(totalMaxDoc);
                    seqNo = this.docWriter.deleteQueue.getNextSequenceNumber();
                    success = true;
                }
                finally {
                    if (!success) {
                        for (SegmentCommitInfo sipc : infos) {
                            this.deleteNewFiles(sipc.files());
                        }
                    }
                }
                this.segmentInfos.addAll(infos);
                this.checkpoint();
            }
            successTop = true;
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, "addIndexes(Directory...)");
            seqNo = -1L;
        }
        finally {
            if (successTop) {
                IOUtils.close(locks);
            } else {
                IOUtils.closeWhileHandlingException(locks);
            }
        }
        this.maybeMerge();
        return seqNo;
    }

    private void validateMergeReader(CodecReader leaf) {
        LeafMetaData segmentMeta = leaf.getMetaData();
        if (this.segmentInfos.getIndexCreatedVersionMajor() != segmentMeta.getCreatedVersionMajor()) {
            throw new IllegalArgumentException("Cannot merge a segment that has been created with major version " + segmentMeta.getCreatedVersionMajor() + " into this index which has been created by major version " + this.segmentInfos.getIndexCreatedVersionMajor());
        }
        if (this.segmentInfos.getIndexCreatedVersionMajor() >= 7 && segmentMeta.getMinVersion() == null) {
            throw new IllegalStateException("Indexes created on or after Lucene 7 must record the created version major, but " + leaf + " hides it");
        }
        Sort leafIndexSort = segmentMeta.getSort();
        if (this.config.getIndexSort() != null && leafIndexSort != null && !this.config.getIndexSort().equals(leafIndexSort)) {
            throw new IllegalArgumentException("cannot change index sort from " + leafIndexSort + " to " + this.config.getIndexSort());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addIndexes(CodecReader ... readers) throws IOException {
        long seqNo;
        this.ensureOpen();
        long numDocs = 0L;
        Sort indexSort = this.config.getIndexSort();
        try {
            boolean useCompoundFile;
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "flush at addIndexes(CodecReader...)");
            }
            this.flush(false, true);
            String mergedName = this.newSegmentName();
            for (CodecReader leaf : readers) {
                numDocs += (long)leaf.numDocs();
                this.validateMergeReader(leaf);
            }
            this.testReserveDocs(numDocs);
            IOContext context = new IOContext(new MergeInfo(Math.toIntExact(numDocs), -1L, false, -1));
            TrackingDirectoryWrapper trackingDir = new TrackingDirectoryWrapper(this.directory);
            SegmentInfo info = new SegmentInfo(this.directoryOrig, Version.LATEST, null, mergedName, -1, false, this.codec, Collections.emptyMap(), StringHelper.randomId(), new HashMap<String, String>(), this.config.getIndexSort());
            SegmentMerger merger = new SegmentMerger(Arrays.asList(readers), info, this.infoStream, trackingDir, this.globalFieldNumberMap, context);
            if (!merger.shouldMerge()) {
                return this.docWriter.deleteQueue.getNextSequenceNumber();
            }
            merger.merge();
            SegmentCommitInfo infoPerCommit = new SegmentCommitInfo(info, 0, -1L, -1L, -1L);
            info.setFiles(new HashSet<String>(trackingDir.getCreatedFiles()));
            trackingDir.clearCreatedFiles();
            IndexWriter.setDiagnostics(info, SOURCE_ADDINDEXES_READERS);
            MergePolicy mergePolicy = this.config.getMergePolicy();
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                if (this.stopMerges) {
                    this.deleteNewFiles(infoPerCommit.files());
                    return this.docWriter.deleteQueue.getNextSequenceNumber();
                }
                this.ensureOpen();
                useCompoundFile = mergePolicy.useCompoundFile(this.segmentInfos, infoPerCommit, this);
            }
            if (useCompoundFile) {
                Collection<String> filesToDelete = infoPerCommit.files();
                TrackingDirectoryWrapper trackingCFSDir = new TrackingDirectoryWrapper(this.directory);
                try {
                    this.createCompoundFile(this.infoStream, trackingCFSDir, info, context);
                }
                finally {
                    this.deleteNewFiles(filesToDelete);
                }
                info.setUseCompoundFile(true);
            }
            this.codec.segmentInfoFormat().write(trackingDir, info, context);
            info.addFiles(trackingDir.getCreatedFiles());
            indexWriter = this;
            synchronized (indexWriter) {
                if (this.stopMerges) {
                    this.deleteNewFiles(infoPerCommit.files());
                    return this.docWriter.deleteQueue.getNextSequenceNumber();
                }
                this.ensureOpen();
                this.reserveDocs(numDocs);
                this.segmentInfos.add(infoPerCommit);
                seqNo = this.docWriter.deleteQueue.getNextSequenceNumber();
                this.checkpoint();
            }
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, SOURCE_ADDINDEXES_READERS);
            seqNo = -1L;
        }
        this.maybeMerge();
        return seqNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentCommitInfo copySegmentAsIs(SegmentCommitInfo info, String segName, IOContext context) throws IOException {
        SegmentInfo newInfo = new SegmentInfo(this.directoryOrig, info.info.getVersion(), info.info.getMinVersion(), segName, info.info.maxDoc(), info.info.getUseCompoundFile(), info.info.getCodec(), info.info.getDiagnostics(), info.info.getId(), info.info.getAttributes(), info.info.getIndexSort());
        SegmentCommitInfo newInfoPerCommit = new SegmentCommitInfo(newInfo, info.getDelCount(), info.getDelGen(), info.getFieldInfosGen(), info.getDocValuesGen());
        newInfo.setFiles(info.files());
        boolean success = false;
        HashSet<String> copiedFiles = new HashSet<String>();
        try {
            for (String file : info.files()) {
                String newFileName = newInfo.namedForThisSegment(file);
                this.directory.copyFrom(info.info.dir, file, newFileName, context);
                copiedFiles.add(newFileName);
            }
            success = true;
        }
        finally {
            if (!success) {
                this.deleteNewFiles(copiedFiles);
            }
        }
        assert (copiedFiles.equals(newInfoPerCommit.files()));
        return newInfoPerCommit;
    }

    protected void doAfterFlush() throws IOException {
    }

    protected void doBeforeFlush() throws IOException {
    }

    @Override
    public final long prepareCommit() throws IOException {
        this.ensureOpen();
        this.pendingSeqNo = this.prepareCommitInternal();
        if (this.maybeMerge.getAndSet(false)) {
            this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.FULL_FLUSH, -1);
        }
        return this.pendingSeqNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long prepareCommitInternal() throws IOException {
        this.startCommitTime = System.nanoTime();
        Object object = this.commitLock;
        synchronized (object) {
            boolean success;
            IndexWriter indexWriter;
            long seqNo;
            block31: {
                long l2;
                this.ensureOpen(false);
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "prepareCommit: flush");
                    this.infoStream.message("IW", "  index before flush " + this.segString());
                }
                if (this.tragedy != null) {
                    throw new IllegalStateException("this writer hit an unrecoverable error; cannot commit", this.tragedy);
                }
                if (this.pendingCommit != null) {
                    throw new IllegalStateException("prepareCommit was already called with no corresponding call to commit");
                }
                this.doBeforeFlush();
                this.testPoint("startDoFlush");
                SegmentInfos toCommit = null;
                boolean anyChanges = false;
                try {
                    Object object2 = this.fullFlushLock;
                    synchronized (object2) {
                        boolean flushSuccess = false;
                        boolean success2 = false;
                        try {
                            seqNo = this.docWriter.flushAllThreads();
                            if (seqNo < 0L) {
                                anyChanges = true;
                                seqNo = -seqNo;
                            }
                            if (!anyChanges) {
                                this.flushCount.incrementAndGet();
                            }
                            this.processEvents(false, false);
                            flushSuccess = true;
                            this.applyAllDeletesAndUpdates();
                            indexWriter = this;
                            synchronized (indexWriter) {
                                this.readerPool.commit(this.segmentInfos);
                                if (this.changeCount.get() != this.lastCommitChangeCount) {
                                    this.changeCount.incrementAndGet();
                                    this.segmentInfos.changed();
                                }
                                if (this.commitUserData != null) {
                                    HashMap<String, String> userData = new HashMap<String, String>();
                                    for (Map.Entry<String, String> ent : this.commitUserData) {
                                        userData.put(ent.getKey(), ent.getValue());
                                    }
                                    this.segmentInfos.setUserData(userData, false);
                                }
                                toCommit = this.segmentInfos.clone();
                                this.pendingCommitChangeCount = this.changeCount.get();
                                this.filesToCommit = toCommit.files(false);
                                this.deleter.incRef(this.filesToCommit);
                            }
                            success2 = true;
                        }
                        finally {
                            if (!success2 && this.infoStream.isEnabled("IW")) {
                                this.infoStream.message("IW", "hit exception during prepareCommit");
                            }
                            this.docWriter.finishFullFlush(this, flushSuccess);
                            this.doAfterFlush();
                        }
                    }
                }
                catch (VirtualMachineError | AbortingException tragedy) {
                    this.tragicEvent(tragedy, "prepareCommit");
                    seqNo = -1L;
                }
                success = false;
                try {
                    if (anyChanges) {
                        this.maybeMerge.set(true);
                    }
                    this.startCommit(toCommit);
                    success = true;
                    if (this.pendingCommit != null) break block31;
                    l2 = -1L;
                    if (success) return l2;
                    indexWriter = this;
                }
                catch (Throwable throwable) {
                    if (success) throw throwable;
                    IndexWriter indexWriter2 = this;
                    synchronized (indexWriter2) {
                        if (this.filesToCommit == null) throw throwable;
                        this.deleter.decRefWhileHandlingException(this.filesToCommit);
                        this.filesToCommit = null;
                        throw throwable;
                    }
                }
                synchronized (indexWriter) {
                    if (this.filesToCommit == null) return l2;
                    this.deleter.decRefWhileHandlingException(this.filesToCommit);
                    this.filesToCommit = null;
                    return l2;
                }
            }
            long l = seqNo;
            if (success) return l;
            indexWriter = this;
            synchronized (indexWriter) {
                if (this.filesToCommit == null) return l;
                this.deleter.decRefWhileHandlingException(this.filesToCommit);
                this.filesToCommit = null;
                return l;
            }
        }
    }

    public final synchronized void setLiveCommitData(Iterable<Map.Entry<String, String>> commitUserData) {
        this.setLiveCommitData(commitUserData, true);
    }

    public final synchronized void setLiveCommitData(Iterable<Map.Entry<String, String>> commitUserData, boolean doIncrementVersion) {
        this.commitUserData = commitUserData;
        if (doIncrementVersion) {
            this.segmentInfos.changed();
        }
        this.changeCount.incrementAndGet();
    }

    public final synchronized Iterable<Map.Entry<String, String>> getLiveCommitData() {
        return this.commitUserData;
    }

    @Override
    public final long commit() throws IOException {
        this.ensureOpen();
        return this.commitInternal(this.config.getMergePolicy());
    }

    public final boolean hasUncommittedChanges() {
        return this.changeCount.get() != this.lastCommitChangeCount || this.docWriter.anyChanges() || this.bufferedUpdatesStream.any();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long commitInternal(MergePolicy mergePolicy) throws IOException {
        long seqNo;
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "commit: start");
        }
        Object object = this.commitLock;
        synchronized (object) {
            this.ensureOpen(false);
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "commit: enter lock");
            }
            if (this.pendingCommit == null) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "commit: now prepare");
                }
                seqNo = this.prepareCommitInternal();
            } else {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "commit: already prepared");
                }
                seqNo = this.pendingSeqNo;
            }
            this.finishCommit();
        }
        if (this.maybeMerge.getAndSet(false)) {
            this.maybeMerge(mergePolicy, MergeTrigger.FULL_FLUSH, -1);
        }
        return seqNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void finishCommit() throws IOException {
        boolean commitCompleted = false;
        boolean finished = false;
        String committedSegmentsFileName = null;
        try {
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                this.ensureOpen(false);
                if (this.tragedy != null) {
                    throw new IllegalStateException("this writer hit an unrecoverable error; cannot complete commit", this.tragedy);
                }
                if (this.pendingCommit != null) {
                    try {
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "commit: pendingCommit != null");
                        }
                        committedSegmentsFileName = this.pendingCommit.finishCommit(this.directory);
                        commitCompleted = true;
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "commit: done writing segments file \"" + committedSegmentsFileName + "\"");
                        }
                        this.deleter.checkpoint(this.pendingCommit, true);
                        this.segmentInfos.updateGeneration(this.pendingCommit);
                        this.lastCommitChangeCount = this.pendingCommitChangeCount;
                        this.rollbackSegments = this.pendingCommit.createBackupSegmentInfos();
                        finished = true;
                    }
                    finally {
                        this.notifyAll();
                        try {
                            if (finished) {
                                this.deleter.decRef(this.filesToCommit);
                            } else if (!commitCompleted) {
                                this.deleter.decRefWhileHandlingException(this.filesToCommit);
                            }
                        }
                        finally {
                            this.pendingCommit = null;
                            this.filesToCommit = null;
                        }
                    }
                }
                assert (this.filesToCommit == null);
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "commit: pendingCommit == null; skip");
                }
            }
        }
        catch (Throwable t) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "hit exception during finishCommit: " + t.getMessage());
            }
            if (commitCompleted) {
                this.tragicEvent(t, "finishCommit");
            }
            throw IOUtils.rethrowAlways(t);
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", String.format(Locale.ROOT, "commit: took %.1f msec", (double)(System.nanoTime() - this.startCommitTime) / 1000000.0));
            this.infoStream.message("IW", "commit: done");
        }
    }

    boolean holdsFullFlushLock() {
        return Thread.holdsLock(this.fullFlushLock);
    }

    public final void flush() throws IOException {
        this.flush(true, true);
    }

    final void flush(boolean triggerMerge, boolean applyAllDeletes) throws IOException {
        this.ensureOpen(false);
        if (this.doFlush(applyAllDeletes) && triggerMerge) {
            this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.FULL_FLUSH, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFlush(boolean applyAllDeletes) throws IOException {
        if (this.tragedy != null) {
            throw new IllegalStateException("this writer hit an unrecoverable error; cannot flush", this.tragedy);
        }
        this.doBeforeFlush();
        this.testPoint("startDoFlush");
        boolean success = false;
        try {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "  start flush: applyAllDeletes=" + applyAllDeletes);
                this.infoStream.message("IW", "  index before flush " + this.segString());
            }
            boolean anyChanges = false;
            Object object = this.fullFlushLock;
            synchronized (object) {
                boolean flushSuccess = false;
                try {
                    long seqNo = this.docWriter.flushAllThreads();
                    if (seqNo < 0L) {
                        seqNo = -seqNo;
                        anyChanges = true;
                    } else {
                        anyChanges = false;
                    }
                    if (!anyChanges) {
                        this.flushCount.incrementAndGet();
                    }
                    flushSuccess = true;
                }
                finally {
                    this.docWriter.finishFullFlush(this, flushSuccess);
                    this.processEvents(false, true);
                }
            }
            if (applyAllDeletes) {
                this.applyAllDeletesAndUpdates();
            }
            anyChanges |= this.maybeMerge.getAndSet(false);
            object = this;
            synchronized (object) {
                try {
                    this.doAfterFlush();
                    success = true;
                    boolean bl = anyChanges;
                    return bl;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (VirtualMachineError | AbortingException tragedy) {
                        this.tragicEvent(tragedy, "doFlush");
                        boolean bl = false;
                        return bl;
                    }
                }
            }
        }
        finally {
            if (!success && this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "hit exception during flush");
            }
        }
    }

    final void applyAllDeletesAndUpdates() throws IOException {
        assert (!Thread.holdsLock(this));
        this.flushDeletesCount.incrementAndGet();
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "now apply all deletes for all segments buffered updates bytesUsed=" + this.bufferedUpdatesStream.ramBytesUsed() + " reader pool bytesUsed=" + this.readerPool.ramBytesUsed());
        }
        this.bufferedUpdatesStream.waitApplyAll();
    }

    DocumentsWriter getDocsWriter() {
        return this.docWriter;
    }

    public final synchronized int numRamDocs() {
        this.ensureOpen();
        return this.docWriter.getNumDocs();
    }

    private synchronized void ensureValidMerge(MergePolicy.OneMerge merge) {
        for (SegmentCommitInfo info : merge.segments) {
            if (this.segmentInfos.contains(info)) continue;
            throw new MergePolicy.MergeException("MergePolicy selected a segment (" + info.info.name + ") that is not in the current index " + this.segString(), this.directoryOrig);
        }
    }

    private void skipDeletedDoc(DocValuesFieldUpdates.Iterator[] updatesIters, int deletedDoc) {
        for (DocValuesFieldUpdates.Iterator iter : updatesIters) {
            if (iter.doc() == deletedDoc) {
                iter.nextDoc();
            }
            assert (iter.doc() > deletedDoc) : "updateDoc=" + iter.doc() + " deletedDoc=" + deletedDoc;
        }
    }

    private synchronized ReadersAndUpdates commitMergedDeletesAndUpdates(MergePolicy.OneMerge merge, MergeState mergeState) throws IOException {
        this.mergeFinishedGen.incrementAndGet();
        this.testPoint("startCommitMergeDeletes");
        List<SegmentCommitInfo> sourceSegments = merge.segments;
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "commitMergeDeletes " + this.segString(merge.segments));
        }
        long minGen = Long.MAX_VALUE;
        ReadersAndUpdates mergedDeletesAndUpdates = this.readerPool.get(merge.info, true);
        HashMap mappedDVUpdates = new HashMap();
        boolean anyDVUpdates = false;
        assert (sourceSegments.size() == mergeState.docMaps.length);
        for (int i = 0; i < sourceSegments.size(); ++i) {
            SegmentCommitInfo info = sourceSegments.get(i);
            minGen = Math.min(info.getBufferedDeletesGen(), minGen);
            int maxDoc = info.info.maxDoc();
            Bits prevLiveDocs = merge.readers.get(i).getLiveDocs();
            ReadersAndUpdates rld = this.readerPool.get(info, false);
            assert (rld != null) : "seg=" + info.info.name;
            Bits currentLiveDocs = rld.getLiveDocs();
            MergeState.DocMap segDocMap = mergeState.docMaps[i];
            MergeState.DocMap segLeafDocMap = mergeState.leafDocMaps[i];
            if (prevLiveDocs != null) {
                assert (currentLiveDocs != null);
                assert (prevLiveDocs.length() == maxDoc);
                assert (currentLiveDocs.length() == maxDoc);
                if (currentLiveDocs != prevLiveDocs) {
                    for (int j = 0; j < maxDoc; ++j) {
                        if (!prevLiveDocs.get(j)) {
                            assert (!currentLiveDocs.get(j));
                            continue;
                        }
                        if (currentLiveDocs.get(j)) continue;
                        mergedDeletesAndUpdates.delete(segDocMap.get(segLeafDocMap.get(j)));
                    }
                }
            } else if (currentLiveDocs != null) {
                assert (currentLiveDocs.length() == maxDoc);
                for (int j = 0; j < maxDoc; ++j) {
                    if (currentLiveDocs.get(j)) continue;
                    mergedDeletesAndUpdates.delete(segDocMap.get(segLeafDocMap.get(j)));
                }
            }
            Map<String, List<DocValuesFieldUpdates>> mergingDVUpdates = rld.getMergingDVUpdates();
            for (Map.Entry<String, List<DocValuesFieldUpdates>> ent : mergingDVUpdates.entrySet()) {
                String field = ent.getKey();
                HashMap<Long, DocValuesFieldUpdates> mappedField = (HashMap<Long, DocValuesFieldUpdates>)mappedDVUpdates.get(field);
                if (mappedField == null) {
                    mappedField = new HashMap<Long, DocValuesFieldUpdates>();
                    mappedDVUpdates.put(field, mappedField);
                }
                for (DocValuesFieldUpdates updates : ent.getValue()) {
                    int doc;
                    if (this.bufferedUpdatesStream.stillRunning(updates.delGen)) continue;
                    assert (field.equals(updates.field));
                    DocValuesFieldUpdates mappedUpdates = (DocValuesFieldUpdates)mappedField.get(updates.delGen);
                    if (mappedUpdates == null) {
                        switch (updates.type) {
                            case NUMERIC: {
                                mappedUpdates = new NumericDocValuesFieldUpdates(updates.delGen, updates.field, merge.info.info.maxDoc());
                                break;
                            }
                            case BINARY: {
                                mappedUpdates = new BinaryDocValuesFieldUpdates(updates.delGen, updates.field, merge.info.info.maxDoc());
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        mappedField.put(updates.delGen, mappedUpdates);
                    }
                    DocValuesFieldUpdates.Iterator it = updates.iterator();
                    while ((doc = it.nextDoc()) != Integer.MAX_VALUE) {
                        int mappedDoc = segDocMap.get(segLeafDocMap.get(doc));
                        if (mappedDoc == -1) continue;
                        mappedUpdates.add(mappedDoc, it.value());
                        anyDVUpdates = true;
                    }
                }
            }
        }
        if (anyDVUpdates) {
            for (Map d : mappedDVUpdates.values()) {
                for (DocValuesFieldUpdates updates : d.values()) {
                    updates.finish();
                    mergedDeletesAndUpdates.addDVUpdate(updates);
                }
            }
        }
        if (this.infoStream.isEnabled("IW")) {
            if (mergedDeletesAndUpdates == null) {
                this.infoStream.message("IW", "no new deletes or field updates since merge started");
            } else {
                String msg = mergedDeletesAndUpdates.getPendingDeleteCount() + " new deletes";
                if (anyDVUpdates) {
                    msg = msg + " and " + mergedDeletesAndUpdates.getNumDVUpdates() + " new field updates";
                    msg = msg + " (" + mergedDeletesAndUpdates.ramBytesUsed.get() + ") bytes";
                }
                msg = msg + " since merge started";
                this.infoStream.message("IW", msg);
            }
        }
        merge.info.setBufferedDeletesGen(minGen);
        return mergedDeletesAndUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean commitMerge(MergePolicy.OneMerge merge, MergeState mergeState) throws IOException {
        boolean dropSegment;
        boolean allDeleted;
        ReadersAndUpdates mergedUpdates;
        this.testPoint("startCommitMerge");
        if (this.tragedy != null) {
            throw new IllegalStateException("this writer hit an unrecoverable error; cannot complete merge", this.tragedy);
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "commitMerge: " + this.segString(merge.segments) + " index=" + this.segString());
        }
        assert (merge.registerDone);
        if (merge.isAborted()) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "commitMerge: skip: it was aborted");
            }
            this.readerPool.drop(merge.info);
            this.deleteNewFiles(merge.info.files());
            return false;
        }
        ReadersAndUpdates readersAndUpdates = mergedUpdates = merge.info.info.maxDoc() == 0 ? null : this.commitMergedDeletesAndUpdates(merge, mergeState);
        assert (!this.segmentInfos.contains(merge.info));
        boolean bl = allDeleted = merge.segments.size() == 0 || merge.info.info.maxDoc() == 0 || mergedUpdates != null && mergedUpdates.getPendingDeleteCount() == merge.info.info.maxDoc();
        if (this.infoStream.isEnabled("IW") && allDeleted) {
            this.infoStream.message("IW", "merged segment " + merge.info + " is 100% deleted" + (this.keepFullyDeletedSegments ? "" : "; skipping insert"));
        }
        boolean bl2 = dropSegment = allDeleted && !this.keepFullyDeletedSegments;
        assert (merge.segments.size() > 0 || dropSegment);
        assert (merge.info.info.maxDoc() != 0 || this.keepFullyDeletedSegments || dropSegment);
        if (mergedUpdates != null) {
            boolean success = false;
            try {
                if (dropSegment) {
                    mergedUpdates.dropChanges();
                }
                this.readerPool.release(mergedUpdates, false);
                success = true;
            }
            finally {
                if (!success) {
                    mergedUpdates.dropChanges();
                    this.readerPool.drop(merge.info);
                }
            }
        }
        this.segmentInfos.applyMergeChanges(merge, dropSegment);
        int delDocCount = merge.totalMaxDoc - merge.info.info.maxDoc();
        assert (delDocCount >= 0);
        this.pendingNumDocs.addAndGet(-delDocCount);
        if (dropSegment) {
            assert (!this.segmentInfos.contains(merge.info));
            this.readerPool.drop(merge.info);
            this.deleteNewFiles(merge.info.files());
        }
        boolean success = false;
        try {
            this.closeMergeReaders(merge, false);
            success = true;
        }
        finally {
            if (success) {
                this.checkpoint();
            } else {
                try {
                    this.checkpoint();
                }
                catch (Throwable throwable) {}
            }
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "after commitMerge: " + this.segString());
        }
        if (merge.maxNumSegments != -1 && !dropSegment && !this.segmentsToMerge.containsKey(merge.info)) {
            this.segmentsToMerge.put(merge.info, Boolean.FALSE);
        }
        return true;
    }

    private final void handleMergeException(Throwable t, MergePolicy.OneMerge merge) throws IOException {
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "handleMergeException: merge=" + this.segString(merge.segments) + " exc=" + t);
        }
        merge.setException(t);
        this.addMergeException(merge);
        if (t instanceof MergePolicy.MergeAbortedException) {
            if (merge.isExternal) {
                throw (MergePolicy.MergeAbortedException)t;
            }
        } else {
            assert (t != null);
            throw IOUtils.rethrowAlways(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(MergePolicy.OneMerge merge) throws IOException {
        boolean success = false;
        long t0 = System.currentTimeMillis();
        MergePolicy mergePolicy = this.config.getMergePolicy();
        try {
            try {
                try {
                    this.mergeInit(merge);
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "now merge\n  merge=" + this.segString(merge.segments) + "\n  index=" + this.segString());
                    }
                    this.mergeMiddle(merge, mergePolicy);
                    this.mergeSuccess(merge);
                    success = true;
                }
                catch (Throwable t) {
                    this.handleMergeException(t, merge);
                }
            }
            finally {
                IndexWriter t = this;
                synchronized (t) {
                    this.mergeFinish(merge);
                    if (!success) {
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "hit exception during merge");
                        }
                    } else if (!(merge.isAborted() || merge.maxNumSegments == -1 && (this.closed || this.closing))) {
                        this.updatePendingMerges(mergePolicy, MergeTrigger.MERGE_FINISHED, merge.maxNumSegments);
                    }
                }
            }
        }
        catch (Throwable t) {
            this.tragicEvent(t, SOURCE_MERGE);
        }
        if (merge.info != null && !merge.isAborted() && this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "merge time " + (System.currentTimeMillis() - t0) + " msec for " + merge.info.info.maxDoc() + " docs");
        }
    }

    void mergeSuccess(MergePolicy.OneMerge merge) {
    }

    final synchronized boolean registerMerge(MergePolicy.OneMerge merge) throws IOException {
        if (merge.registerDone) {
            return true;
        }
        assert (merge.segments.size() > 0);
        if (this.stopMerges) {
            merge.setAborted();
            throw new MergePolicy.MergeAbortedException("merge is aborted: " + this.segString(merge.segments));
        }
        boolean isExternal = false;
        for (SegmentCommitInfo segmentCommitInfo : merge.segments) {
            if (this.mergingSegments.contains(segmentCommitInfo)) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "reject merge " + this.segString(merge.segments) + ": segment " + this.segString(segmentCommitInfo) + " is already marked for merge");
                }
                return false;
            }
            if (!this.segmentInfos.contains(segmentCommitInfo)) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "reject merge " + this.segString(merge.segments) + ": segment " + this.segString(segmentCommitInfo) + " does not exist in live infos");
                }
                return false;
            }
            if (segmentCommitInfo.info.dir != this.directoryOrig) {
                isExternal = true;
            }
            if (!this.segmentsToMerge.containsKey(segmentCommitInfo)) continue;
            merge.maxNumSegments = this.mergeMaxNumSegments;
        }
        this.ensureValidMerge(merge);
        this.pendingMerges.add(merge);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "add merge to pendingMerges: " + this.segString(merge.segments) + " [total " + this.pendingMerges.size() + " pending]");
        }
        merge.mergeGen = this.mergeGen;
        merge.isExternal = isExternal;
        if (this.infoStream.isEnabled("IW")) {
            StringBuilder builder = new StringBuilder("registerMerge merging= [");
            for (SegmentCommitInfo info : this.mergingSegments) {
                builder.append(info.info.name).append(", ");
            }
            builder.append("]");
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", builder.toString());
            }
        }
        for (SegmentCommitInfo segmentCommitInfo : merge.segments) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "registerMerge info=" + this.segString(segmentCommitInfo));
            }
            this.mergingSegments.add(segmentCommitInfo);
        }
        assert (merge.estimatedMergeBytes == 0L);
        assert (merge.totalMergeBytes == 0L);
        for (SegmentCommitInfo segmentCommitInfo : merge.segments) {
            if (segmentCommitInfo.info.maxDoc() <= 0) continue;
            int delCount = this.numDeletedDocs(segmentCommitInfo);
            assert (delCount <= segmentCommitInfo.info.maxDoc());
            double delRatio = (double)delCount / (double)segmentCommitInfo.info.maxDoc();
            merge.estimatedMergeBytes = (long)((double)merge.estimatedMergeBytes + (double)segmentCommitInfo.sizeInBytes() * (1.0 - delRatio));
            merge.totalMergeBytes += segmentCommitInfo.sizeInBytes();
        }
        merge.registerDone = true;
        return true;
    }

    final void mergeInit(MergePolicy.OneMerge merge) throws IOException {
        this.bufferedUpdatesStream.waitApplyForMerge(merge.segments);
        boolean success = false;
        try {
            this._mergeInit(merge);
            success = true;
        }
        finally {
            if (!success) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "hit exception in mergeInit");
                }
                this.mergeFinish(merge);
            }
        }
    }

    private synchronized void _mergeInit(MergePolicy.OneMerge merge) throws IOException {
        this.testPoint("startMergeInit");
        assert (merge.registerDone);
        assert (merge.maxNumSegments == -1 || merge.maxNumSegments > 0);
        if (this.tragedy != null) {
            throw new IllegalStateException("this writer hit an unrecoverable error; cannot merge", this.tragedy);
        }
        if (merge.info != null) {
            return;
        }
        merge.mergeInit();
        if (merge.isAborted()) {
            return;
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "now apply deletes for " + merge.segments.size() + " merging segments");
        }
        this.readerPool.writeDocValuesUpdatesForMerge(merge.segments);
        String mergeSegmentName = this.newSegmentName();
        SegmentInfo si = new SegmentInfo(this.directoryOrig, Version.LATEST, null, mergeSegmentName, -1, false, this.codec, Collections.emptyMap(), StringHelper.randomId(), new HashMap<String, String>(), this.config.getIndexSort());
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("mergeMaxNumSegments", "" + merge.maxNumSegments);
        details.put("mergeFactor", Integer.toString(merge.segments.size()));
        IndexWriter.setDiagnostics(si, SOURCE_MERGE, details);
        merge.setMergeInfo(new SegmentCommitInfo(si, 0, -1L, -1L, -1L));
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "merge seg=" + merge.info.info.name + " " + this.segString(merge.segments));
        }
    }

    static void setDiagnostics(SegmentInfo info, String source) {
        IndexWriter.setDiagnostics(info, source, null);
    }

    private static void setDiagnostics(SegmentInfo info, String source, Map<String, String> details) {
        HashMap<String, String> diagnostics = new HashMap<String, String>();
        diagnostics.put(SOURCE, source);
        diagnostics.put("lucene.version", Version.LATEST.toString());
        diagnostics.put("os", Constants.OS_NAME);
        diagnostics.put("os.arch", Constants.OS_ARCH);
        diagnostics.put("os.version", Constants.OS_VERSION);
        diagnostics.put("java.version", Constants.JAVA_VERSION);
        diagnostics.put("java.vendor", Constants.JAVA_VENDOR);
        diagnostics.put("java.runtime.version", System.getProperty("java.runtime.version", "undefined"));
        diagnostics.put("java.vm.version", System.getProperty("java.vm.version", "undefined"));
        diagnostics.put("timestamp", Long.toString(new Date().getTime()));
        if (details != null) {
            diagnostics.putAll(details);
        }
        info.setDiagnostics(diagnostics);
    }

    final synchronized void mergeFinish(MergePolicy.OneMerge merge) {
        this.notifyAll();
        if (merge.registerDone) {
            List<SegmentCommitInfo> sourceSegments = merge.segments;
            for (SegmentCommitInfo info : sourceSegments) {
                this.mergingSegments.remove(info);
            }
            merge.registerDone = false;
        }
        this.runningMerges.remove(merge);
    }

    private final synchronized void closeMergeReaders(MergePolicy.OneMerge merge, boolean suppressExceptions) throws IOException {
        Throwable th;
        block11: {
            int numSegments = merge.readers.size();
            th = null;
            boolean drop = !suppressExceptions;
            for (int i = 0; i < numSegments; ++i) {
                block10: {
                    SegmentReader sr = merge.readers.get(i);
                    if (sr == null) continue;
                    try {
                        ReadersAndUpdates rld = this.readerPool.get(sr.getSegmentInfo(), false);
                        assert (rld != null);
                        if (drop) {
                            rld.dropChanges();
                        } else {
                            rld.dropMergingUpdates();
                        }
                        rld.release(sr);
                        this.readerPool.release(rld);
                        if (drop) {
                            this.readerPool.drop(rld.info);
                        }
                    }
                    catch (Throwable t) {
                        if (th != null) break block10;
                        th = t;
                    }
                }
                merge.readers.set(i, null);
            }
            try {
                merge.mergeFinished();
            }
            catch (Throwable t) {
                if (th != null) break block11;
                th = t;
            }
        }
        if (!suppressExceptions && th != null) {
            throw IOUtils.rethrowAlways(th);
        }
    }

    /*
     * Exception decompiling
     */
    private int mergeMiddle(MergePolicy.OneMerge merge, MergePolicy mergePolicy) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[MONITOR]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    synchronized void addMergeException(MergePolicy.OneMerge merge) {
        assert (merge.getException() != null);
        if (!this.mergeExceptions.contains(merge) && this.mergeGen == merge.mergeGen) {
            this.mergeExceptions.add(merge);
        }
    }

    final int getBufferedDeleteTermsSize() {
        return this.docWriter.getBufferedDeleteTermsSize();
    }

    final int getNumBufferedDeleteTerms() {
        return this.docWriter.getNumBufferedDeleteTerms();
    }

    synchronized SegmentCommitInfo newestSegment() {
        return this.segmentInfos.size() > 0 ? this.segmentInfos.info(this.segmentInfos.size() - 1) : null;
    }

    synchronized String segString() {
        return this.segString(this.segmentInfos);
    }

    synchronized String segString(Iterable<SegmentCommitInfo> infos) {
        StringBuilder buffer = new StringBuilder();
        for (SegmentCommitInfo info : infos) {
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append(this.segString(info));
        }
        return buffer.toString();
    }

    synchronized String segString(SegmentCommitInfo info) {
        return info.toString(this.numDeletedDocs(info) - info.getDelCount());
    }

    private synchronized void doWait() {
        try {
            this.wait(1000L);
        }
        catch (InterruptedException ie) {
            throw new ThreadInterruptedException(ie);
        }
    }

    void setKeepFullyDeletedSegments(boolean v) {
        this.keepFullyDeletedSegments = v;
    }

    boolean getKeepFullyDeletedSegments() {
        return this.keepFullyDeletedSegments;
    }

    private boolean filesExist(SegmentInfos toSync) throws IOException {
        Collection<String> files = toSync.files(false);
        for (String fileName : files) {
            assert (this.deleter.exists(fileName)) : "IndexFileDeleter doesn't know about file " + fileName;
        }
        return true;
    }

    synchronized SegmentInfos toLiveInfos(SegmentInfos sis) {
        SegmentInfos newSIS = new SegmentInfos(sis.getIndexCreatedVersionMajor());
        HashMap<SegmentCommitInfo, SegmentCommitInfo> liveSIS = new HashMap<SegmentCommitInfo, SegmentCommitInfo>();
        for (SegmentCommitInfo info : this.segmentInfos) {
            liveSIS.put(info, info);
        }
        for (SegmentCommitInfo info : sis) {
            SegmentCommitInfo liveInfo = (SegmentCommitInfo)liveSIS.get(info);
            if (liveInfo != null) {
                info = liveInfo;
            }
            newSIS.add(info);
        }
        return newSIS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCommit(SegmentInfos toSync) throws IOException {
        this.testPoint("startStartCommit");
        assert (this.pendingCommit == null);
        if (this.tragedy != null) {
            throw new IllegalStateException("this writer hit an unrecoverable error; cannot commit", this.tragedy);
        }
        try {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "startCommit(): start");
            }
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                if (this.lastCommitChangeCount > this.changeCount.get()) {
                    throw new IllegalStateException("lastCommitChangeCount=" + this.lastCommitChangeCount + ",changeCount=" + this.changeCount);
                }
                if (this.pendingCommitChangeCount == this.lastCommitChangeCount) {
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "  skip startCommit(): no changes pending");
                    }
                    try {
                        this.deleter.decRef(this.filesToCommit);
                    }
                    finally {
                        this.filesToCommit = null;
                    }
                    return;
                }
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "startCommit index=" + this.segString(this.toLiveInfos(toSync)) + " changeCount=" + this.changeCount);
                }
                assert (this.filesExist(toSync));
            }
            this.testPoint("midStartCommit");
            boolean pendingCommitSet = false;
            try {
                Collection<String> filesToSync;
                this.testPoint("midStartCommit2");
                IndexWriter indexWriter2 = this;
                synchronized (indexWriter2) {
                    assert (this.pendingCommit == null);
                    assert (this.segmentInfos.getGeneration() == toSync.getGeneration());
                    toSync.prepareCommit(this.directory);
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "startCommit: wrote pending segments file \"" + IndexFileNames.fileNameFromGeneration("pending_segments", "", toSync.getGeneration()) + "\"");
                    }
                    pendingCommitSet = true;
                    this.pendingCommit = toSync;
                }
                boolean success = false;
                try {
                    filesToSync = toSync.files(false);
                    this.directory.sync(filesToSync);
                    success = true;
                }
                finally {
                    if (!success) {
                        pendingCommitSet = false;
                        this.pendingCommit = null;
                        toSync.rollbackCommit(this.directory);
                    }
                }
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "done all syncs: " + filesToSync);
                }
                this.testPoint("midStartCommitSuccess");
            }
            finally {
                IndexWriter indexWriter3 = this;
                synchronized (indexWriter3) {
                    this.segmentInfos.updateGeneration(toSync);
                    if (!pendingCommitSet) {
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "hit exception committing segments file");
                        }
                        this.deleter.decRefWhileHandlingException(this.filesToCommit);
                        this.filesToCommit = null;
                    }
                }
            }
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, "startCommit");
        }
        this.testPoint("finishStartCommit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tragicEvent(Throwable tragedy, String location) throws IOException {
        if (tragedy instanceof AbortingException) {
            tragedy = tragedy.getCause();
        }
        assert (!(tragedy instanceof MergePolicy.MergeAbortedException));
        assert (!Thread.holdsLock(this));
        assert (tragedy != null);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "hit tragic " + tragedy.getClass().getSimpleName() + " inside " + location);
        }
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            if (this.tragedy != null) {
                throw IOUtils.rethrowAlways(tragedy);
            }
            this.tragedy = tragedy;
        }
        if (this.shouldClose(false)) {
            this.rollbackInternal();
        }
        throw IOUtils.rethrowAlways(tragedy);
    }

    public Throwable getTragicException() {
        return this.tragedy;
    }

    public boolean isOpen() {
        return !this.closing && !this.closed;
    }

    private final void testPoint(String message) {
        if (this.enableTestPoints) {
            assert (this.infoStream.isEnabled("TP"));
            this.infoStream.message("TP", message);
        }
    }

    synchronized boolean nrtIsCurrent(SegmentInfos infos) {
        boolean isCurrent;
        this.ensureOpen();
        boolean bl = isCurrent = infos.getVersion() == this.segmentInfos.getVersion() && !this.docWriter.anyChanges() && !this.bufferedUpdatesStream.any() && !this.readerPool.anyChanges();
        if (this.infoStream.isEnabled("IW") && !isCurrent) {
            this.infoStream.message("IW", "nrtIsCurrent: infoVersion matches: " + (infos.getVersion() == this.segmentInfos.getVersion()) + "; DW changes: " + this.docWriter.anyChanges() + "; BD changes: " + this.bufferedUpdatesStream.any());
        }
        return isCurrent;
    }

    synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized void deleteUnusedFiles() throws IOException {
        this.ensureOpen(false);
        this.deleter.revisitPolicy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void createCompoundFile(InfoStream infoStream, TrackingDirectoryWrapper directory, SegmentInfo info, IOContext context) throws IOException {
        if (!directory.getCreatedFiles().isEmpty()) {
            throw new IllegalStateException("pass a clean trackingdir for CFS creation");
        }
        if (infoStream.isEnabled("IW")) {
            infoStream.message("IW", "create compound file");
        }
        boolean success = false;
        try {
            info.getCodec().compoundFormat().write(directory, info, context);
            success = true;
        }
        finally {
            if (!success) {
                this.deleteNewFiles(directory.getCreatedFiles());
            }
        }
        info.setFiles(new HashSet<String>(directory.getCreatedFiles()));
    }

    final synchronized void deleteNewFiles(Collection<String> files) throws IOException {
        this.deleter.deleteNewFiles(files);
    }

    final synchronized void flushFailed(SegmentInfo info) throws IOException {
        Set<String> files;
        try {
            files = info.files();
        }
        catch (IllegalStateException ise) {
            files = null;
        }
        if (files != null) {
            this.deleter.deleteNewFiles(files);
        }
    }

    final int purge(boolean forced) throws IOException {
        return this.docWriter.purgeBuffer(this, forced);
    }

    final void applyDeletesAndPurge(boolean forcePurge) throws IOException {
        try {
            this.purge(forcePurge);
        }
        finally {
            this.flushCount.incrementAndGet();
        }
    }

    final void doAfterSegmentFlushed(boolean triggerMerge, boolean forcePurge) throws IOException {
        try {
            this.purge(forcePurge);
        }
        finally {
            if (triggerMerge) {
                this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.SEGMENT_FLUSH, -1);
            }
        }
    }

    public synchronized void incRefDeleter(SegmentInfos segmentInfos) throws IOException {
        this.ensureOpen();
        this.deleter.incRef(segmentInfos, false);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "incRefDeleter for NRT reader version=" + segmentInfos.getVersion() + " segments=" + this.segString(segmentInfos));
        }
    }

    public synchronized void decRefDeleter(SegmentInfos segmentInfos) throws IOException {
        this.ensureOpen();
        this.deleter.decRef(segmentInfos);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "decRefDeleter for NRT reader version=" + segmentInfos.getVersion() + " segments=" + this.segString(segmentInfos));
        }
    }

    private void processEvents(boolean triggerMerge, boolean forcePurge) throws IOException {
        this.processEvents(this.eventQueue, triggerMerge, forcePurge);
        if (triggerMerge) {
            this.maybeMerge(this.getConfig().getMergePolicy(), MergeTrigger.SEGMENT_FLUSH, -1);
        }
    }

    private void processEvents(Queue<Event> queue, boolean triggerMerge, boolean forcePurge) throws IOException {
        boolean processed = false;
        if (this.tragedy == null) {
            Event event;
            while ((event = queue.poll()) != null) {
                processed = true;
                event.process(this, triggerMerge, forcePurge);
            }
        }
    }

    private void reserveDocs(long addedNumDocs) {
        assert (addedNumDocs >= 0L);
        if (this.pendingNumDocs.addAndGet(addedNumDocs) > (long)actualMaxDocs) {
            this.pendingNumDocs.addAndGet(-addedNumDocs);
            this.tooManyDocs(addedNumDocs);
        }
    }

    private void testReserveDocs(long addedNumDocs) {
        assert (addedNumDocs >= 0L);
        if (this.pendingNumDocs.get() + addedNumDocs > (long)actualMaxDocs) {
            this.tooManyDocs(addedNumDocs);
        }
    }

    private void tooManyDocs(long addedNumDocs) {
        assert (addedNumDocs >= 0L);
        throw new IllegalArgumentException("number of documents in the index cannot exceed " + actualMaxDocs + " (current document count is " + this.pendingNumDocs.get() + "; added numDocs is " + addedNumDocs + ")");
    }

    public long getMaxCompletedSequenceNumber() {
        this.ensureOpen();
        return this.docWriter.getMaxCompletedSequenceNumber();
    }

    private static /* synthetic */ String lambda$mergeMiddle$1(Map.Entry e) {
        return String.format(Locale.ROOT, "%.1f sec %s", (double)((Long)e.getValue()).longValue() / 1.0E9, ((MergePolicy.OneMergeProgress.PauseReason)((Object)e.getKey())).name().toLowerCase(Locale.ROOT));
    }

    private static /* synthetic */ boolean lambda$mergeMiddle$0(Map.Entry e) {
        return (Long)e.getValue() > 0L;
    }

    static interface Event {
        public void process(IndexWriter var1, boolean var2, boolean var3) throws IOException;
    }

    public static abstract class IndexReaderWarmer {
        protected IndexReaderWarmer() {
        }

        public abstract void warm(LeafReader var1) throws IOException;
    }

    private static class MergedDeletesAndUpdates {
        ReadersAndUpdates mergedDeletesAndUpdates = null;

        MergedDeletesAndUpdates() {
        }

        final void init(ReaderPool readerPool, MergePolicy.OneMerge merge) throws IOException {
            if (this.mergedDeletesAndUpdates == null) {
                this.mergedDeletesAndUpdates = readerPool.get(merge.info, true);
            }
        }
    }

    class ReaderPool
    implements Closeable {
        private final Map<SegmentCommitInfo, ReadersAndUpdates> readerMap = new HashMap<SegmentCommitInfo, ReadersAndUpdates>();
        private final AtomicBoolean writeDocValuesLock = new AtomicBoolean();

        ReaderPool() {
        }

        public synchronized boolean assertInfoIsLive(SegmentCommitInfo info) {
            int idx = IndexWriter.this.segmentInfos.indexOf(info);
            assert (idx != -1) : "info=" + info + " isn't live";
            assert (IndexWriter.this.segmentInfos.info(idx) == info) : "info=" + info + " doesn't match live info in segmentInfos";
            return true;
        }

        public synchronized void drop(SegmentCommitInfo info) throws IOException {
            ReadersAndUpdates rld = this.readerMap.get(info);
            if (rld != null) {
                assert (info == rld.info);
                this.readerMap.remove(info);
                rld.dropReaders();
            }
        }

        public synchronized long ramBytesUsed() {
            long bytes = 0L;
            for (ReadersAndUpdates rld : this.readerMap.values()) {
                bytes += rld.ramBytesUsed.get();
            }
            return bytes;
        }

        public synchronized boolean anyPendingDeletes() {
            for (ReadersAndUpdates rld : this.readerMap.values()) {
                if (rld.getPendingDeleteCount() == 0) continue;
                return true;
            }
            return false;
        }

        public synchronized void release(ReadersAndUpdates rld) throws IOException {
            this.release(rld, true);
        }

        public synchronized void release(ReadersAndUpdates rld, boolean assertInfoLive) throws IOException {
            rld.decRef();
            if (rld.refCount() == 0) {
                assert (!this.readerMap.containsKey(rld.info)) : "seg=" + rld.info + " has refCount 0 but still unexpectedly exists in the reader pool";
            } else {
                assert (rld.refCount() > 0) : "refCount=" + rld.refCount() + " reader=" + rld.info;
                if (!IndexWriter.this.poolReaders && rld.refCount() == 1 && this.readerMap.containsKey(rld.info)) {
                    if (rld.writeLiveDocs(IndexWriter.this.directory)) {
                        assert (!assertInfoLive || this.assertInfoIsLive(rld.info));
                        IndexWriter.this.checkpointNoSIS();
                    }
                    rld.writeFieldUpdates(IndexWriter.this.directory, IndexWriter.this.bufferedUpdatesStream.getCompletedDelGen(), IndexWriter.this.infoStream);
                    if (rld.getNumDVUpdates() == 0L) {
                        rld.dropReaders();
                        this.readerMap.remove(rld.info);
                    }
                }
            }
        }

        @Override
        public void close() throws IOException {
            this.dropAll(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeAllDocValuesUpdates() throws IOException {
            HashSet<ReadersAndUpdates> copy;
            ReaderPool readerPool = this;
            synchronized (readerPool) {
                copy = new HashSet<ReadersAndUpdates>(this.readerMap.values());
            }
            boolean any = false;
            for (ReadersAndUpdates rld : copy) {
                any |= rld.writeFieldUpdates(IndexWriter.this.directory, IndexWriter.this.bufferedUpdatesStream.getCompletedDelGen(), IndexWriter.this.infoStream);
            }
            if (any) {
                IndexWriter.this.checkpoint();
            }
        }

        void writeDocValuesUpdatesForMerge(List<SegmentCommitInfo> infos) throws IOException {
            boolean any = false;
            for (SegmentCommitInfo info : infos) {
                ReadersAndUpdates rld = this.get(info, false);
                if (rld == null) continue;
                any |= rld.writeFieldUpdates(IndexWriter.this.directory, IndexWriter.this.bufferedUpdatesStream.getCompletedDelGen(), IndexWriter.this.infoStream);
                rld.setIsMerging();
            }
            if (any) {
                IndexWriter.this.checkpoint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeSomeDocValuesUpdates() throws IOException {
            block15: {
                assert (!Thread.holdsLock(IndexWriter.this));
                if (this.writeDocValuesLock.compareAndSet(false, true)) {
                    try {
                        ReadersAndUpdates rld;
                        LiveIndexWriterConfig config = IndexWriter.this.getConfig();
                        double mb = config.getRAMBufferSizeMB();
                        if (mb == -1.0) break block15;
                        long startNS = System.nanoTime();
                        long ramBytesUsed = this.ramBytesUsed();
                        if (!((double)ramBytesUsed > 0.5 * mb * 1024.0 * 1024.0)) break block15;
                        if (IndexWriter.this.infoStream.isEnabled("BD")) {
                            IndexWriter.this.infoStream.message("BD", String.format(Locale.ROOT, "now write some pending DV updates: %.2f MB used vs IWC Buffer %.2f MB", (double)ramBytesUsed / 1024.0 / 1024.0, mb));
                        }
                        PriorityQueue<ReadersAndUpdates> queue = new PriorityQueue<ReadersAndUpdates>(this.readerMap.size(), (a, b) -> Long.compare(b.ramBytesUsed.get(), a.ramBytesUsed.get()));
                        ReaderPool readerPool = this;
                        synchronized (readerPool) {
                            for (ReadersAndUpdates rld2 : this.readerMap.values()) {
                                queue.add(rld2);
                            }
                        }
                        int count = 0;
                        while ((double)ramBytesUsed > 0.5 * mb * 1024.0 * 1024.0 && (rld = (ReadersAndUpdates)queue.poll()) != null) {
                            long bytesUsedBefore = rld.ramBytesUsed.get();
                            IndexWriter indexWriter = IndexWriter.this;
                            synchronized (indexWriter) {
                                rld.writeFieldUpdates(IndexWriter.this.directory, IndexWriter.this.bufferedUpdatesStream.getCompletedDelGen(), IndexWriter.this.infoStream);
                            }
                            long bytesUsedAfter = rld.ramBytesUsed.get();
                            ramBytesUsed -= bytesUsedBefore - bytesUsedAfter;
                            ++count;
                        }
                        if (IndexWriter.this.infoStream.isEnabled("BD")) {
                            IndexWriter.this.infoStream.message("BD", String.format(Locale.ROOT, "done write some DV updates for %d segments: now %.2f MB used vs IWC Buffer %.2f MB; took %.2f sec", count, (double)this.ramBytesUsed() / 1024.0 / 1024.0, mb, (double)(System.nanoTime() - startNS) / 1.0E9));
                        }
                    }
                    finally {
                        this.writeDocValuesLock.set(false);
                    }
                }
            }
        }

        synchronized void dropAll(boolean doSave) throws IOException {
            Throwable priorE = null;
            Iterator<Map.Entry<SegmentCommitInfo, ReadersAndUpdates>> it = this.readerMap.entrySet().iterator();
            while (it.hasNext()) {
                ReadersAndUpdates rld;
                block11: {
                    rld = it.next().getValue();
                    try {
                        if (doSave && rld.writeLiveDocs(IndexWriter.this.directory)) {
                            assert (this.assertInfoIsLive(rld.info));
                            IndexWriter.this.checkpointNoSIS();
                        }
                    }
                    catch (Throwable t) {
                        if (doSave) {
                            throw IOUtils.rethrowAlways(t);
                        }
                        if (priorE != null) break block11;
                        priorE = t;
                    }
                }
                it.remove();
                try {
                    rld.dropReaders();
                }
                catch (Throwable t) {
                    if (doSave) {
                        throw IOUtils.rethrowAlways(t);
                    }
                    if (priorE != null) continue;
                    priorE = t;
                }
            }
            assert (this.readerMap.size() == 0);
            if (priorE != null) {
                throw IOUtils.rethrowAlways(priorE);
            }
        }

        public synchronized void commit(SegmentInfos infos) throws IOException {
            for (SegmentCommitInfo info : infos) {
                ReadersAndUpdates rld = this.readerMap.get(info);
                if (rld == null) continue;
                assert (rld.info == info);
                boolean changed = rld.writeLiveDocs(IndexWriter.this.directory);
                if (!(changed |= rld.writeFieldUpdates(IndexWriter.this.directory, IndexWriter.this.bufferedUpdatesStream.getCompletedDelGen(), IndexWriter.this.infoStream))) continue;
                assert (this.assertInfoIsLive(info));
                IndexWriter.this.checkpointNoSIS();
            }
        }

        public synchronized boolean anyChanges() {
            for (ReadersAndUpdates rld : this.readerMap.values()) {
                if (rld.getNumDVUpdates() == 0L) continue;
                return true;
            }
            return false;
        }

        public synchronized ReadersAndUpdates get(SegmentCommitInfo info, boolean create) {
            IndexWriter.this.ensureOpen(false);
            assert (info.info.dir == IndexWriter.this.directoryOrig) : "info.dir=" + info.info.dir + " vs " + IndexWriter.access$100(IndexWriter.this);
            ReadersAndUpdates rld = this.readerMap.get(info);
            if (rld == null) {
                if (!create) {
                    return null;
                }
                rld = new ReadersAndUpdates(IndexWriter.this, info);
                this.readerMap.put(info, rld);
            } else assert (rld.info == info) : "rld.info=" + rld.info + " info=" + info + " isLive?=" + this.assertInfoIsLive(rld.info) + " vs " + this.assertInfoIsLive(info);
            if (create) {
                rld.incRef();
            }
            assert (this.noDups());
            return rld;
        }

        private boolean noDups() {
            HashSet<String> seen = new HashSet<String>();
            for (SegmentCommitInfo info : this.readerMap.keySet()) {
                assert (!seen.contains(info.info.name));
                seen.add(info.info.name);
            }
            return true;
        }
    }
}

