/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.MultiTermsEnum;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;
import org.apache.lucene.util.packed.PackedLongValues;

public class MultiDocValues {
    private MultiDocValues() {
    }

    public static NumericDocValues getNormValues(IndexReader r, final String field) throws IOException {
        final List<LeafReaderContext> leaves = r.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getNormValues(field);
        }
        FieldInfo fi = MultiFields.getMergedFieldInfos(r).fieldInfo(field);
        if (fi == null || !fi.hasNorms()) {
            return null;
        }
        return new NumericDocValues(){
            private int nextLeaf;
            private NumericDocValues currentValues;
            private LeafReaderContext currentLeaf;
            private int docID = -1;

            @Override
            public int nextDoc() throws IOException {
                int newDocID;
                while (true) {
                    if (this.currentValues == null) {
                        if (this.nextLeaf == leaves.size()) {
                            this.docID = Integer.MAX_VALUE;
                            return this.docID;
                        }
                        this.currentLeaf = (LeafReaderContext)leaves.get(this.nextLeaf);
                        this.currentValues = this.currentLeaf.reader().getNormValues(field);
                        ++this.nextLeaf;
                        continue;
                    }
                    newDocID = this.currentValues.nextDoc();
                    if (newDocID != Integer.MAX_VALUE) break;
                    this.currentValues = null;
                }
                this.docID = this.currentLeaf.docBase + newDocID;
                return this.docID;
            }

            @Override
            public int docID() {
                return this.docID;
            }

            @Override
            public int advance(int targetDocID) throws IOException {
                int newDocID;
                if (targetDocID <= this.docID) {
                    throw new IllegalArgumentException("can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID);
                }
                int readerIndex = ReaderUtil.subIndex(targetDocID, leaves);
                if (readerIndex >= this.nextLeaf) {
                    if (readerIndex == leaves.size()) {
                        this.currentValues = null;
                        this.docID = Integer.MAX_VALUE;
                        return this.docID;
                    }
                    this.currentLeaf = (LeafReaderContext)leaves.get(readerIndex);
                    this.currentValues = this.currentLeaf.reader().getNormValues(field);
                    if (this.currentValues == null) {
                        return this.nextDoc();
                    }
                    this.nextLeaf = readerIndex + 1;
                }
                if ((newDocID = this.currentValues.advance(targetDocID - this.currentLeaf.docBase)) == Integer.MAX_VALUE) {
                    this.currentValues = null;
                    return this.nextDoc();
                }
                this.docID = this.currentLeaf.docBase + newDocID;
                return this.docID;
            }

            @Override
            public boolean advanceExact(int targetDocID) throws IOException {
                if (targetDocID < this.docID) {
                    throw new IllegalArgumentException("can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID);
                }
                int readerIndex = ReaderUtil.subIndex(targetDocID, leaves);
                if (readerIndex >= this.nextLeaf) {
                    if (readerIndex == leaves.size()) {
                        throw new IllegalArgumentException("Out of range: " + targetDocID);
                    }
                    this.currentLeaf = (LeafReaderContext)leaves.get(readerIndex);
                    this.currentValues = this.currentLeaf.reader().getNormValues(field);
                    this.nextLeaf = readerIndex + 1;
                }
                this.docID = targetDocID;
                if (this.currentValues == null) {
                    return false;
                }
                return this.currentValues.advanceExact(targetDocID - this.currentLeaf.docBase);
            }

            @Override
            public long longValue() throws IOException {
                return this.currentValues.longValue();
            }

            @Override
            public long cost() {
                return 0L;
            }
        };
    }

    public static NumericDocValues getNumericValues(IndexReader r, final String field) throws IOException {
        final List<LeafReaderContext> leaves = r.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getNumericDocValues(field);
        }
        boolean anyReal = false;
        for (LeafReaderContext leaf : leaves) {
            DocValuesType dvType;
            FieldInfo fieldInfo = leaf.reader().getFieldInfos().fieldInfo(field);
            if (fieldInfo == null || (dvType = fieldInfo.getDocValuesType()) != DocValuesType.NUMERIC) continue;
            anyReal = true;
            break;
        }
        if (!anyReal) {
            return null;
        }
        return new NumericDocValues(){
            private int nextLeaf;
            private NumericDocValues currentValues;
            private LeafReaderContext currentLeaf;
            private int docID = -1;

            @Override
            public int docID() {
                return this.docID;
            }

            @Override
            public int nextDoc() throws IOException {
                int newDocID;
                while (true) {
                    if (this.currentValues == null) {
                        if (this.nextLeaf == leaves.size()) {
                            this.docID = Integer.MAX_VALUE;
                            return this.docID;
                        }
                        this.currentLeaf = (LeafReaderContext)leaves.get(this.nextLeaf);
                        this.currentValues = this.currentLeaf.reader().getNumericDocValues(field);
                        ++this.nextLeaf;
                        continue;
                    }
                    newDocID = this.currentValues.nextDoc();
                    if (newDocID != Integer.MAX_VALUE) break;
                    this.currentValues = null;
                }
                this.docID = this.currentLeaf.docBase + newDocID;
                return this.docID;
            }

            @Override
            public int advance(int targetDocID) throws IOException {
                int newDocID;
                if (targetDocID <= this.docID) {
                    throw new IllegalArgumentException("can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID);
                }
                int readerIndex = ReaderUtil.subIndex(targetDocID, leaves);
                if (readerIndex >= this.nextLeaf) {
                    if (readerIndex == leaves.size()) {
                        this.currentValues = null;
                        this.docID = Integer.MAX_VALUE;
                        return this.docID;
                    }
                    this.currentLeaf = (LeafReaderContext)leaves.get(readerIndex);
                    this.currentValues = this.currentLeaf.reader().getNumericDocValues(field);
                    this.nextLeaf = readerIndex + 1;
                    if (this.currentValues == null) {
                        return this.nextDoc();
                    }
                }
                if ((newDocID = this.currentValues.advance(targetDocID - this.currentLeaf.docBase)) == Integer.MAX_VALUE) {
                    this.currentValues = null;
                    return this.nextDoc();
                }
                this.docID = this.currentLeaf.docBase + newDocID;
                return this.docID;
            }

            @Override
            public boolean advanceExact(int targetDocID) throws IOException {
                if (targetDocID < this.docID) {
                    throw new IllegalArgumentException("can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID);
                }
                int readerIndex = ReaderUtil.subIndex(targetDocID, leaves);
                if (readerIndex >= this.nextLeaf) {
                    if (readerIndex == leaves.size()) {
                        throw new IllegalArgumentException("Out of range: " + targetDocID);
                    }
                    this.currentLeaf = (LeafReaderContext)leaves.get(readerIndex);
                    this.currentValues = this.currentLeaf.reader().getNumericDocValues(field);
                    this.nextLeaf = readerIndex + 1;
                }
                this.docID = targetDocID;
                if (this.currentValues == null) {
                    return false;
                }
                return this.currentValues.advanceExact(targetDocID - this.currentLeaf.docBase);
            }

            @Override
            public long longValue() throws IOException {
                return this.currentValues.longValue();
            }

            @Override
            public long cost() {
                return 0L;
            }
        };
    }

    public static BinaryDocValues getBinaryValues(IndexReader r, final String field) throws IOException {
        final List<LeafReaderContext> leaves = r.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getBinaryDocValues(field);
        }
        boolean anyReal = false;
        for (LeafReaderContext leaf : leaves) {
            DocValuesType dvType;
            FieldInfo fieldInfo = leaf.reader().getFieldInfos().fieldInfo(field);
            if (fieldInfo == null || (dvType = fieldInfo.getDocValuesType()) != DocValuesType.BINARY) continue;
            anyReal = true;
            break;
        }
        if (!anyReal) {
            return null;
        }
        return new BinaryDocValues(){
            private int nextLeaf;
            private BinaryDocValues currentValues;
            private LeafReaderContext currentLeaf;
            private int docID = -1;

            @Override
            public int nextDoc() throws IOException {
                int newDocID;
                while (true) {
                    if (this.currentValues == null) {
                        if (this.nextLeaf == leaves.size()) {
                            this.docID = Integer.MAX_VALUE;
                            return this.docID;
                        }
                        this.currentLeaf = (LeafReaderContext)leaves.get(this.nextLeaf);
                        this.currentValues = this.currentLeaf.reader().getBinaryDocValues(field);
                        ++this.nextLeaf;
                        continue;
                    }
                    newDocID = this.currentValues.nextDoc();
                    if (newDocID != Integer.MAX_VALUE) break;
                    this.currentValues = null;
                }
                this.docID = this.currentLeaf.docBase + newDocID;
                return this.docID;
            }

            @Override
            public int docID() {
                return this.docID;
            }

            @Override
            public int advance(int targetDocID) throws IOException {
                int newDocID;
                if (targetDocID <= this.docID) {
                    throw new IllegalArgumentException("can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID);
                }
                int readerIndex = ReaderUtil.subIndex(targetDocID, leaves);
                if (readerIndex >= this.nextLeaf) {
                    if (readerIndex == leaves.size()) {
                        this.currentValues = null;
                        this.docID = Integer.MAX_VALUE;
                        return this.docID;
                    }
                    this.currentLeaf = (LeafReaderContext)leaves.get(readerIndex);
                    this.currentValues = this.currentLeaf.reader().getBinaryDocValues(field);
                    this.nextLeaf = readerIndex + 1;
                    if (this.currentValues == null) {
                        return this.nextDoc();
                    }
                }
                if ((newDocID = this.currentValues.advance(targetDocID - this.currentLeaf.docBase)) == Integer.MAX_VALUE) {
                    this.currentValues = null;
                    return this.nextDoc();
                }
                this.docID = this.currentLeaf.docBase + newDocID;
                return this.docID;
            }

            @Override
            public boolean advanceExact(int targetDocID) throws IOException {
                if (targetDocID < this.docID) {
                    throw new IllegalArgumentException("can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID);
                }
                int readerIndex = ReaderUtil.subIndex(targetDocID, leaves);
                if (readerIndex >= this.nextLeaf) {
                    if (readerIndex == leaves.size()) {
                        throw new IllegalArgumentException("Out of range: " + targetDocID);
                    }
                    this.currentLeaf = (LeafReaderContext)leaves.get(readerIndex);
                    this.currentValues = this.currentLeaf.reader().getBinaryDocValues(field);
                    this.nextLeaf = readerIndex + 1;
                }
                this.docID = targetDocID;
                if (this.currentValues == null) {
                    return false;
                }
                return this.currentValues.advanceExact(targetDocID - this.currentLeaf.docBase);
            }

            @Override
            public BytesRef binaryValue() throws IOException {
                return this.currentValues.binaryValue();
            }

            @Override
            public long cost() {
                return 0L;
            }
        };
    }

    public static SortedNumericDocValues getSortedNumericValues(IndexReader r, String field) throws IOException {
        final List<LeafReaderContext> leaves = r.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getSortedNumericDocValues(field);
        }
        boolean anyReal = false;
        final SortedNumericDocValues[] values = new SortedNumericDocValues[size];
        int[] starts = new int[size + 1];
        long totalCost = 0L;
        for (int i = 0; i < size; ++i) {
            LeafReaderContext context = leaves.get(i);
            SortedNumericDocValues v = context.reader().getSortedNumericDocValues(field);
            if (v == null) {
                v = DocValues.emptySortedNumeric(context.reader().maxDoc());
            } else {
                anyReal = true;
            }
            values[i] = v;
            starts[i] = context.docBase;
            totalCost += v.cost();
        }
        starts[size] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        final long finalTotalCost = totalCost;
        return new SortedNumericDocValues(){
            private int nextLeaf;
            private SortedNumericDocValues currentValues;
            private LeafReaderContext currentLeaf;
            private int docID = -1;

            @Override
            public int nextDoc() throws IOException {
                int newDocID;
                while (true) {
                    if (this.currentValues == null) {
                        if (this.nextLeaf == leaves.size()) {
                            this.docID = Integer.MAX_VALUE;
                            return this.docID;
                        }
                        this.currentLeaf = (LeafReaderContext)leaves.get(this.nextLeaf);
                        this.currentValues = values[this.nextLeaf];
                        ++this.nextLeaf;
                    }
                    if ((newDocID = this.currentValues.nextDoc()) != Integer.MAX_VALUE) break;
                    this.currentValues = null;
                }
                this.docID = this.currentLeaf.docBase + newDocID;
                return this.docID;
            }

            @Override
            public int docID() {
                return this.docID;
            }

            @Override
            public int advance(int targetDocID) throws IOException {
                int newDocID;
                if (targetDocID <= this.docID) {
                    throw new IllegalArgumentException("can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID);
                }
                int readerIndex = ReaderUtil.subIndex(targetDocID, leaves);
                if (readerIndex >= this.nextLeaf) {
                    if (readerIndex == leaves.size()) {
                        this.currentValues = null;
                        this.docID = Integer.MAX_VALUE;
                        return this.docID;
                    }
                    this.currentLeaf = (LeafReaderContext)leaves.get(readerIndex);
                    this.currentValues = values[readerIndex];
                    this.nextLeaf = readerIndex + 1;
                }
                if ((newDocID = this.currentValues.advance(targetDocID - this.currentLeaf.docBase)) == Integer.MAX_VALUE) {
                    this.currentValues = null;
                    return this.nextDoc();
                }
                this.docID = this.currentLeaf.docBase + newDocID;
                return this.docID;
            }

            @Override
            public boolean advanceExact(int targetDocID) throws IOException {
                if (targetDocID < this.docID) {
                    throw new IllegalArgumentException("can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID);
                }
                int readerIndex = ReaderUtil.subIndex(targetDocID, leaves);
                if (readerIndex >= this.nextLeaf) {
                    if (readerIndex == leaves.size()) {
                        throw new IllegalArgumentException("Out of range: " + targetDocID);
                    }
                    this.currentLeaf = (LeafReaderContext)leaves.get(readerIndex);
                    this.currentValues = values[readerIndex];
                    this.nextLeaf = readerIndex + 1;
                }
                this.docID = targetDocID;
                if (this.currentValues == null) {
                    return false;
                }
                return this.currentValues.advanceExact(targetDocID - this.currentLeaf.docBase);
            }

            @Override
            public long cost() {
                return finalTotalCost;
            }

            @Override
            public int docValueCount() {
                return this.currentValues.docValueCount();
            }

            @Override
            public long nextValue() throws IOException {
                return this.currentValues.nextValue();
            }
        };
    }

    public static SortedDocValues getSortedValues(IndexReader r, String field) throws IOException {
        List<LeafReaderContext> leaves = r.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getSortedDocValues(field);
        }
        boolean anyReal = false;
        SortedDocValues[] values = new SortedDocValues[size];
        int[] starts = new int[size + 1];
        long totalCost = 0L;
        for (int i = 0; i < size; ++i) {
            LeafReaderContext context = leaves.get(i);
            SortedDocValues v = context.reader().getSortedDocValues(field);
            if (v == null) {
                v = DocValues.emptySorted();
            } else {
                anyReal = true;
                totalCost += v.cost();
            }
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        IndexReader.CacheHelper cacheHelper = r.getReaderCacheHelper();
        IndexReader.CacheKey owner = cacheHelper == null ? null : cacheHelper.getKey();
        OrdinalMap mapping = OrdinalMap.build(owner, values, 0.25f);
        return new MultiSortedDocValues(values, starts, mapping, totalCost);
    }

    public static SortedSetDocValues getSortedSetValues(IndexReader r, String field) throws IOException {
        List<LeafReaderContext> leaves = r.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getSortedSetDocValues(field);
        }
        boolean anyReal = false;
        SortedSetDocValues[] values = new SortedSetDocValues[size];
        int[] starts = new int[size + 1];
        long totalCost = 0L;
        for (int i = 0; i < size; ++i) {
            LeafReaderContext context = leaves.get(i);
            SortedSetDocValues v = context.reader().getSortedSetDocValues(field);
            if (v == null) {
                v = DocValues.emptySortedSet();
            } else {
                anyReal = true;
                totalCost += v.cost();
            }
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        IndexReader.CacheHelper cacheHelper = r.getReaderCacheHelper();
        IndexReader.CacheKey owner = cacheHelper == null ? null : cacheHelper.getKey();
        OrdinalMap mapping = OrdinalMap.build(owner, values, 0.25f);
        return new MultiSortedSetDocValues(values, starts, mapping, totalCost);
    }

    public static class MultiSortedSetDocValues
    extends SortedSetDocValues {
        public final int[] docStarts;
        public final SortedSetDocValues[] values;
        public final OrdinalMap mapping;
        private final long totalCost;
        private int nextLeaf;
        private SortedSetDocValues currentValues;
        private int currentDocStart;
        private int docID = -1;

        public MultiSortedSetDocValues(SortedSetDocValues[] values, int[] docStarts, OrdinalMap mapping, long totalCost) throws IOException {
            assert (docStarts.length == values.length + 1);
            this.values = values;
            this.docStarts = docStarts;
            this.mapping = mapping;
            this.totalCost = totalCost;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int nextDoc() throws IOException {
            int newDocID;
            while (true) {
                if (this.currentValues == null) {
                    if (this.nextLeaf == this.values.length) {
                        this.docID = Integer.MAX_VALUE;
                        return this.docID;
                    }
                    this.currentDocStart = this.docStarts[this.nextLeaf];
                    this.currentValues = this.values[this.nextLeaf];
                    ++this.nextLeaf;
                    continue;
                }
                newDocID = this.currentValues.nextDoc();
                if (newDocID != Integer.MAX_VALUE) break;
                this.currentValues = null;
            }
            this.docID = this.currentDocStart + newDocID;
            return this.docID;
        }

        @Override
        public int advance(int targetDocID) throws IOException {
            int newDocID;
            if (targetDocID <= this.docID) {
                throw new IllegalArgumentException("can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID);
            }
            int readerIndex = ReaderUtil.subIndex(targetDocID, this.docStarts);
            if (readerIndex >= this.nextLeaf) {
                if (readerIndex == this.values.length) {
                    this.currentValues = null;
                    this.docID = Integer.MAX_VALUE;
                    return this.docID;
                }
                this.currentDocStart = this.docStarts[readerIndex];
                this.currentValues = this.values[readerIndex];
                this.nextLeaf = readerIndex + 1;
            }
            if ((newDocID = this.currentValues.advance(targetDocID - this.currentDocStart)) == Integer.MAX_VALUE) {
                this.currentValues = null;
                return this.nextDoc();
            }
            this.docID = this.currentDocStart + newDocID;
            return this.docID;
        }

        @Override
        public boolean advanceExact(int targetDocID) throws IOException {
            if (targetDocID < this.docID) {
                throw new IllegalArgumentException("can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID);
            }
            int readerIndex = ReaderUtil.subIndex(targetDocID, this.docStarts);
            if (readerIndex >= this.nextLeaf) {
                if (readerIndex == this.values.length) {
                    throw new IllegalArgumentException("Out of range: " + targetDocID);
                }
                this.currentDocStart = this.docStarts[readerIndex];
                this.currentValues = this.values[readerIndex];
                this.nextLeaf = readerIndex + 1;
            }
            this.docID = targetDocID;
            if (this.currentValues == null) {
                return false;
            }
            return this.currentValues.advanceExact(targetDocID - this.currentDocStart);
        }

        @Override
        public long nextOrd() throws IOException {
            long segmentOrd = this.currentValues.nextOrd();
            if (segmentOrd == -1L) {
                return segmentOrd;
            }
            return this.mapping.getGlobalOrds(this.nextLeaf - 1).get(segmentOrd);
        }

        @Override
        public BytesRef lookupOrd(long ord) throws IOException {
            int subIndex = this.mapping.getFirstSegmentNumber(ord);
            long segmentOrd = this.mapping.getFirstSegmentOrd(ord);
            return this.values[subIndex].lookupOrd(segmentOrd);
        }

        @Override
        public long getValueCount() {
            return this.mapping.getValueCount();
        }

        @Override
        public long cost() {
            return this.totalCost;
        }
    }

    public static class MultiSortedDocValues
    extends SortedDocValues {
        public final int[] docStarts;
        public final SortedDocValues[] values;
        public final OrdinalMap mapping;
        private final long totalCost;
        private int nextLeaf;
        private SortedDocValues currentValues;
        private int currentDocStart;
        private int docID = -1;

        public MultiSortedDocValues(SortedDocValues[] values, int[] docStarts, OrdinalMap mapping, long totalCost) throws IOException {
            assert (docStarts.length == values.length + 1);
            this.values = values;
            this.docStarts = docStarts;
            this.mapping = mapping;
            this.totalCost = totalCost;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int nextDoc() throws IOException {
            int newDocID;
            while (true) {
                if (this.currentValues == null) {
                    if (this.nextLeaf == this.values.length) {
                        this.docID = Integer.MAX_VALUE;
                        return this.docID;
                    }
                    this.currentDocStart = this.docStarts[this.nextLeaf];
                    this.currentValues = this.values[this.nextLeaf];
                    ++this.nextLeaf;
                    continue;
                }
                newDocID = this.currentValues.nextDoc();
                if (newDocID != Integer.MAX_VALUE) break;
                this.currentValues = null;
            }
            this.docID = this.currentDocStart + newDocID;
            return this.docID;
        }

        @Override
        public int advance(int targetDocID) throws IOException {
            int newDocID;
            if (targetDocID <= this.docID) {
                throw new IllegalArgumentException("can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID);
            }
            int readerIndex = ReaderUtil.subIndex(targetDocID, this.docStarts);
            if (readerIndex >= this.nextLeaf) {
                if (readerIndex == this.values.length) {
                    this.currentValues = null;
                    this.docID = Integer.MAX_VALUE;
                    return this.docID;
                }
                this.currentDocStart = this.docStarts[readerIndex];
                this.currentValues = this.values[readerIndex];
                this.nextLeaf = readerIndex + 1;
            }
            if ((newDocID = this.currentValues.advance(targetDocID - this.currentDocStart)) == Integer.MAX_VALUE) {
                this.currentValues = null;
                return this.nextDoc();
            }
            this.docID = this.currentDocStart + newDocID;
            return this.docID;
        }

        @Override
        public boolean advanceExact(int targetDocID) throws IOException {
            if (targetDocID < this.docID) {
                throw new IllegalArgumentException("can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID);
            }
            int readerIndex = ReaderUtil.subIndex(targetDocID, this.docStarts);
            if (readerIndex >= this.nextLeaf) {
                if (readerIndex == this.values.length) {
                    throw new IllegalArgumentException("Out of range: " + targetDocID);
                }
                this.currentDocStart = this.docStarts[readerIndex];
                this.currentValues = this.values[readerIndex];
                this.nextLeaf = readerIndex + 1;
            }
            this.docID = targetDocID;
            if (this.currentValues == null) {
                return false;
            }
            return this.currentValues.advanceExact(targetDocID - this.currentDocStart);
        }

        @Override
        public int ordValue() throws IOException {
            return (int)this.mapping.getGlobalOrds(this.nextLeaf - 1).get(this.currentValues.ordValue());
        }

        @Override
        public BytesRef lookupOrd(int ord) throws IOException {
            int subIndex = this.mapping.getFirstSegmentNumber(ord);
            int segmentOrd = (int)this.mapping.getFirstSegmentOrd(ord);
            return this.values[subIndex].lookupOrd(segmentOrd);
        }

        @Override
        public int getValueCount() {
            return (int)this.mapping.getValueCount();
        }

        @Override
        public long cost() {
            return this.totalCost;
        }
    }

    public static class OrdinalMap
    implements Accountable {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(OrdinalMap.class);
        public final IndexReader.CacheKey owner;
        final PackedLongValues globalOrdDeltas;
        final PackedLongValues firstSegments;
        final LongValues[] segmentToGlobalOrds;
        final SegmentMap segmentMap;
        final long ramBytesUsed;

        public static OrdinalMap build(IndexReader.CacheKey owner, SortedDocValues[] values, float acceptableOverheadRatio) throws IOException {
            TermsEnum[] subs = new TermsEnum[values.length];
            long[] weights = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                subs[i] = values[i].termsEnum();
                weights[i] = values[i].getValueCount();
            }
            return OrdinalMap.build(owner, subs, weights, acceptableOverheadRatio);
        }

        public static OrdinalMap build(IndexReader.CacheKey owner, SortedSetDocValues[] values, float acceptableOverheadRatio) throws IOException {
            TermsEnum[] subs = new TermsEnum[values.length];
            long[] weights = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                subs[i] = values[i].termsEnum();
                weights[i] = values[i].getValueCount();
            }
            return OrdinalMap.build(owner, subs, weights, acceptableOverheadRatio);
        }

        public static OrdinalMap build(IndexReader.CacheKey owner, TermsEnum[] subs, long[] weights, float acceptableOverheadRatio) throws IOException {
            if (subs.length != weights.length) {
                throw new IllegalArgumentException("subs and weights must have the same length");
            }
            SegmentMap segmentMap = new SegmentMap(weights);
            return new OrdinalMap(owner, subs, segmentMap, acceptableOverheadRatio);
        }

        OrdinalMap(IndexReader.CacheKey owner, TermsEnum[] subs, SegmentMap segmentMap, float acceptableOverheadRatio) throws IOException {
            this.owner = owner;
            this.segmentMap = segmentMap;
            PackedLongValues.Builder globalOrdDeltas = PackedLongValues.monotonicBuilder(0.0f);
            PackedLongValues.Builder firstSegments = PackedLongValues.packedBuilder(0.0f);
            PackedLongValues.Builder[] ordDeltas = new PackedLongValues.Builder[subs.length];
            for (int i = 0; i < ordDeltas.length; ++i) {
                ordDeltas[i] = PackedLongValues.monotonicBuilder(acceptableOverheadRatio);
            }
            long[] ordDeltaBits = new long[subs.length];
            long[] segmentOrds = new long[subs.length];
            ReaderSlice[] slices = new ReaderSlice[subs.length];
            MultiTermsEnum.TermsEnumIndex[] indexes = new MultiTermsEnum.TermsEnumIndex[slices.length];
            for (int i = 0; i < slices.length; ++i) {
                slices[i] = new ReaderSlice(0, 0, i);
                indexes[i] = new MultiTermsEnum.TermsEnumIndex(subs[segmentMap.newToOld(i)], i);
            }
            MultiTermsEnum mte = new MultiTermsEnum(slices);
            mte.reset(indexes);
            long globalOrd = 0L;
            while (mte.next() != null) {
                MultiTermsEnum.TermsEnumWithSlice[] matches = mte.getMatchArray();
                int firstSegmentIndex = Integer.MAX_VALUE;
                long globalOrdDelta = Long.MAX_VALUE;
                for (int i = 0; i < mte.getMatchCount(); ++i) {
                    int segmentIndex = matches[i].index;
                    long segmentOrd = matches[i].terms.ord();
                    long delta = globalOrd - segmentOrd;
                    if (segmentIndex < firstSegmentIndex) {
                        firstSegmentIndex = segmentIndex;
                        globalOrdDelta = delta;
                    }
                    while (segmentOrds[segmentIndex] <= segmentOrd) {
                        int n = segmentIndex;
                        ordDeltaBits[n] = ordDeltaBits[n] | delta;
                        ordDeltas[segmentIndex].add(delta);
                        int n2 = segmentIndex;
                        segmentOrds[n2] = segmentOrds[n2] + 1L;
                    }
                }
                assert (firstSegmentIndex < segmentOrds.length);
                firstSegments.add(firstSegmentIndex);
                globalOrdDeltas.add(globalOrdDelta);
                ++globalOrd;
            }
            this.firstSegments = firstSegments.build();
            this.globalOrdDeltas = globalOrdDeltas.build();
            this.segmentToGlobalOrds = new LongValues[subs.length];
            long ramBytesUsed = BASE_RAM_BYTES_USED + this.globalOrdDeltas.ramBytesUsed() + this.firstSegments.ramBytesUsed() + RamUsageEstimator.shallowSizeOf(this.segmentToGlobalOrds) + segmentMap.ramBytesUsed();
            for (int i = 0; i < ordDeltas.length; ++i) {
                final PackedLongValues deltas = ordDeltas[i].build();
                if (ordDeltaBits[i] == 0L) {
                    this.segmentToGlobalOrds[i] = LongValues.IDENTITY;
                    continue;
                }
                int bitsRequired = ordDeltaBits[i] < 0L ? 64 : PackedInts.bitsRequired(ordDeltaBits[i]);
                long monotonicBits = deltas.ramBytesUsed() * 8L;
                long packedBits = (long)bitsRequired * deltas.size();
                if (deltas.size() <= Integer.MAX_VALUE && (float)packedBits <= (float)monotonicBits * (1.0f + acceptableOverheadRatio)) {
                    int size = (int)deltas.size();
                    final PackedInts.Mutable newDeltas = PackedInts.getMutable(size, bitsRequired, acceptableOverheadRatio);
                    PackedLongValues.Iterator it = deltas.iterator();
                    for (int ord = 0; ord < size; ++ord) {
                        newDeltas.set(ord, it.next());
                    }
                    assert (!it.hasNext());
                    this.segmentToGlobalOrds[i] = new LongValues(){

                        @Override
                        public long get(long ord) {
                            return ord + newDeltas.get((int)ord);
                        }
                    };
                    ramBytesUsed += newDeltas.ramBytesUsed();
                } else {
                    this.segmentToGlobalOrds[i] = new LongValues(){

                        @Override
                        public long get(long ord) {
                            return ord + deltas.get(ord);
                        }
                    };
                    ramBytesUsed += deltas.ramBytesUsed();
                }
                ramBytesUsed += RamUsageEstimator.shallowSizeOf(this.segmentToGlobalOrds[i]);
            }
            this.ramBytesUsed = ramBytesUsed;
        }

        public LongValues getGlobalOrds(int segmentIndex) {
            return this.segmentToGlobalOrds[this.segmentMap.oldToNew(segmentIndex)];
        }

        public long getFirstSegmentOrd(long globalOrd) {
            return globalOrd - this.globalOrdDeltas.get(globalOrd);
        }

        public int getFirstSegmentNumber(long globalOrd) {
            return this.segmentMap.newToOld((int)this.firstSegments.get(globalOrd));
        }

        public long getValueCount() {
            return this.globalOrdDeltas.size();
        }

        @Override
        public long ramBytesUsed() {
            return this.ramBytesUsed;
        }

        @Override
        public Collection<Accountable> getChildResources() {
            ArrayList<Accountable> resources = new ArrayList<Accountable>();
            resources.add(Accountables.namedAccountable("global ord deltas", this.globalOrdDeltas));
            resources.add(Accountables.namedAccountable("first segments", this.firstSegments));
            resources.add(Accountables.namedAccountable("segment map", this.segmentMap));
            return resources;
        }

        private static class SegmentMap
        implements Accountable {
            private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SegmentMap.class);
            private final int[] newToOld;
            private final int[] oldToNew;

            private static int[] map(final long[] weights) {
                final int[] newToOld = new int[weights.length];
                for (int i = 0; i < weights.length; ++i) {
                    newToOld[i] = i;
                }
                new InPlaceMergeSorter(){

                    @Override
                    protected void swap(int i, int j) {
                        int tmp = newToOld[i];
                        newToOld[i] = newToOld[j];
                        newToOld[j] = tmp;
                    }

                    @Override
                    protected int compare(int i, int j) {
                        return Long.compare(weights[newToOld[j]], weights[newToOld[i]]);
                    }
                }.sort(0, weights.length);
                return newToOld;
            }

            private static int[] inverse(int[] map) {
                int[] inverse = new int[map.length];
                for (int i = 0; i < map.length; ++i) {
                    inverse[map[i]] = i;
                }
                return inverse;
            }

            SegmentMap(long[] weights) {
                this.newToOld = SegmentMap.map(weights);
                this.oldToNew = SegmentMap.inverse(this.newToOld);
                assert (Arrays.equals(this.newToOld, SegmentMap.inverse(this.oldToNew)));
            }

            int newToOld(int segment) {
                return this.newToOld[segment];
            }

            int oldToNew(int segment) {
                return this.oldToNew[segment];
            }

            @Override
            public long ramBytesUsed() {
                return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.newToOld) + RamUsageEstimator.sizeOf(this.oldToNew);
            }
        }
    }
}

