/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.WriterConstants;
import org.objectweb.asm.commons.Method;

public class ScriptClassInfo {
    private final Class<?> baseClass;
    private final Method executeMethod;
    private final Definition.Type executeMethodReturnType;
    private final List<MethodArgument> executeArguments;
    private final List<Method> needsMethods;
    private final List<Method> getMethods;
    private final List<Definition.Type> getReturns;

    public ScriptClassInfo(Definition definition, Class<?> baseClass) {
        Class<?>[] types;
        this.baseClass = baseClass;
        java.lang.reflect.Method executeMethod = null;
        ArrayList<Method> needsMethods = new ArrayList<Method>();
        ArrayList<Method> getMethods = new ArrayList<Method>();
        ArrayList<Definition.Type> getReturns = new ArrayList<Definition.Type>();
        for (java.lang.reflect.Method m : baseClass.getMethods()) {
            if (m.isDefault()) continue;
            if (m.getName().equals("execute")) {
                if (executeMethod == null) {
                    executeMethod = m;
                } else {
                    throw new IllegalArgumentException("Painless can only implement interfaces that have a single method named [execute] but [" + baseClass.getName() + "] has more than one.");
                }
            }
            if (m.getName().startsWith("needs") && m.getReturnType().equals(Boolean.TYPE) && m.getParameterTypes().length == 0) {
                needsMethods.add(new Method(m.getName(), WriterConstants.NEEDS_PARAMETER_METHOD_TYPE.toMethodDescriptorString()));
            }
            if (!m.getName().startsWith("get") || m.getName().equals("getClass") || Modifier.isStatic(m.getModifiers())) continue;
            getReturns.add(ScriptClassInfo.definitionTypeForClass(definition, m.getReturnType(), componentType -> "[" + m.getName() + "] has unknown return type [" + componentType.getName() + "]. Painless can only support getters with return types that are whitelisted."));
            getMethods.add(new Method(m.getName(), MethodType.methodType(m.getReturnType()).toMethodDescriptorString()));
        }
        MethodType methodType = MethodType.methodType(executeMethod.getReturnType(), executeMethod.getParameterTypes());
        this.executeMethod = new Method(executeMethod.getName(), methodType.toMethodDescriptorString());
        this.executeMethodReturnType = ScriptClassInfo.definitionTypeForClass(definition, executeMethod.getReturnType(), componentType -> "Painless can only implement execute methods returning a whitelisted type but [" + baseClass.getName() + "#execute] returns [" + componentType.getName() + "] which isn't whitelisted.");
        LinkedHashSet<String> argumentNames = new LinkedHashSet<String>();
        ArrayList<MethodArgument> arguments = new ArrayList<MethodArgument>();
        String[] argumentNamesConstant = ScriptClassInfo.readArgumentNamesConstant(baseClass);
        if (argumentNamesConstant.length != (types = executeMethod.getParameterTypes()).length) {
            throw new IllegalArgumentException("[" + baseClass.getName() + "#ARGUMENTS] has length [2] but [" + baseClass.getName() + "#execute] takes [1] argument.");
        }
        for (int arg = 0; arg < types.length; ++arg) {
            arguments.add(this.methodArgument(definition, types[arg], argumentNamesConstant[arg]));
            argumentNames.add(argumentNamesConstant[arg]);
        }
        this.executeArguments = Collections.unmodifiableList(arguments);
        this.needsMethods = Collections.unmodifiableList(needsMethods);
        this.getMethods = Collections.unmodifiableList(getMethods);
        this.getReturns = Collections.unmodifiableList(getReturns);
    }

    public Class<?> getBaseClass() {
        return this.baseClass;
    }

    public Method getExecuteMethod() {
        return this.executeMethod;
    }

    public Definition.Type getExecuteMethodReturnType() {
        return this.executeMethodReturnType;
    }

    public List<MethodArgument> getExecuteArguments() {
        return this.executeArguments;
    }

    public List<Method> getNeedsMethods() {
        return this.needsMethods;
    }

    public List<Method> getGetMethods() {
        return this.getMethods;
    }

    public List<Definition.Type> getGetReturns() {
        return this.getReturns;
    }

    private MethodArgument methodArgument(Definition definition, Class<?> type, String argName) {
        Definition.Type defType = ScriptClassInfo.definitionTypeForClass(definition, type, componentType -> "[" + argName + "] is of unknown type [" + componentType.getName() + ". Painless interfaces can only accept arguments that are of whitelisted types.");
        return new MethodArgument(defType, argName);
    }

    private static Definition.Type definitionTypeForClass(Definition definition, Class<?> type, Function<Class<?>, String> unknownErrorMessageSource) {
        Definition.Struct struct;
        int dimensions = 0;
        Class<?> componentType = type;
        while (componentType.isArray()) {
            ++dimensions;
            componentType = componentType.getComponentType();
        }
        if (componentType.equals(Object.class)) {
            struct = Definition.DEF_TYPE.struct;
        } else {
            Definition.RuntimeClass runtimeClass = definition.getRuntimeClass(componentType);
            if (runtimeClass == null) {
                throw new IllegalArgumentException(unknownErrorMessageSource.apply(componentType));
            }
            struct = runtimeClass.getStruct();
        }
        return definition.getType(struct, dimensions);
    }

    private static String[] readArgumentNamesConstant(Class<?> iface) {
        Field argumentNamesField;
        try {
            argumentNamesField = iface.getField("PARAMETERS");
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Painless needs a constant [String[] PARAMETERS] on all interfaces it implements with the names of the method arguments but [" + iface.getName() + "] doesn't have one.", e);
        }
        if (!argumentNamesField.getType().equals(String[].class)) {
            throw new IllegalArgumentException("Painless needs a constant [String[] PARAMETERS] on all interfaces it implements with the names of the method arguments but [" + iface.getName() + "] doesn't have one.");
        }
        try {
            return (String[])argumentNamesField.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalArgumentException("Error trying to read [" + iface.getName() + "#ARGUMENTS]", e);
        }
    }

    public static class MethodArgument {
        private final Definition.Type type;
        private final String name;

        public MethodArgument(Definition.Type type, String name) {
            this.type = type;
            this.name = name;
        }

        public Definition.Type getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }
    }
}

