/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.SearchResponseSections;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.profile.ProfileShardResult;
import org.elasticsearch.search.profile.SearchProfileShardResults;
import org.elasticsearch.search.suggest.Suggest;

public class SearchResponse
extends ActionResponse
implements StatusToXContentObject {
    private static final ParseField SCROLL_ID = new ParseField("_scroll_id", new String[0]);
    private static final ParseField TOOK = new ParseField("took", new String[0]);
    private static final ParseField TIMED_OUT = new ParseField("timed_out", new String[0]);
    private static final ParseField TERMINATED_EARLY = new ParseField("terminated_early", new String[0]);
    private static final ParseField NUM_REDUCE_PHASES = new ParseField("num_reduce_phases", new String[0]);
    private SearchResponseSections internalResponse;
    private String scrollId;
    private int totalShards;
    private int successfulShards;
    private int skippedShards;
    private ShardSearchFailure[] shardFailures;
    private long tookInMillis;

    public SearchResponse() {
    }

    public SearchResponse(SearchResponseSections internalResponse, String scrollId, int totalShards, int successfulShards, int skippedShards, long tookInMillis, ShardSearchFailure[] shardFailures) {
        this.internalResponse = internalResponse;
        this.scrollId = scrollId;
        this.totalShards = totalShards;
        this.successfulShards = successfulShards;
        this.skippedShards = skippedShards;
        this.tookInMillis = tookInMillis;
        this.shardFailures = shardFailures;
        assert (skippedShards <= totalShards) : "skipped: " + skippedShards + " total: " + totalShards;
    }

    @Override
    public RestStatus status() {
        return RestStatus.status(this.successfulShards, this.totalShards, this.shardFailures);
    }

    public SearchHits getHits() {
        return this.internalResponse.hits();
    }

    public Aggregations getAggregations() {
        return this.internalResponse.aggregations();
    }

    public Suggest getSuggest() {
        return this.internalResponse.suggest();
    }

    public boolean isTimedOut() {
        return this.internalResponse.timedOut();
    }

    public Boolean isTerminatedEarly() {
        return this.internalResponse.terminatedEarly();
    }

    public int getNumReducePhases() {
        return this.internalResponse.getNumReducePhases();
    }

    public TimeValue getTook() {
        return new TimeValue(this.tookInMillis);
    }

    public int getTotalShards() {
        return this.totalShards;
    }

    public int getSuccessfulShards() {
        return this.successfulShards;
    }

    public int getSkippedShards() {
        return this.skippedShards;
    }

    public int getFailedShards() {
        return this.shardFailures.length;
    }

    public ShardSearchFailure[] getShardFailures() {
        return this.shardFailures;
    }

    public String getScrollId() {
        return this.scrollId;
    }

    public void scrollId(String scrollId) {
        this.scrollId = scrollId;
    }

    @Nullable
    public Map<String, ProfileShardResult> getProfileResults() {
        return this.internalResponse.profile();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.scrollId != null) {
            builder.field(SCROLL_ID.getPreferredName(), this.scrollId);
        }
        builder.field(TOOK.getPreferredName(), this.tookInMillis);
        builder.field(TIMED_OUT.getPreferredName(), this.isTimedOut());
        if (this.isTerminatedEarly() != null) {
            builder.field(TERMINATED_EARLY.getPreferredName(), this.isTerminatedEarly());
        }
        if (this.getNumReducePhases() != 1) {
            builder.field(NUM_REDUCE_PHASES.getPreferredName(), this.getNumReducePhases());
        }
        RestActions.buildBroadcastShardsHeader(builder, params, this.getTotalShards(), this.getSuccessfulShards(), this.getSkippedShards(), this.getFailedShards(), this.getShardFailures());
        this.internalResponse.toXContent(builder, params);
        return builder;
    }

    public static SearchResponse fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser::getTokenLocation);
        String currentFieldName = null;
        SearchHits hits = null;
        Aggregations aggs = null;
        Suggest suggest = null;
        SearchProfileShardResults profile = null;
        boolean timedOut = false;
        Boolean terminatedEarly = null;
        int numReducePhases = 1;
        long tookInMillis = -1L;
        int successfulShards = -1;
        int totalShards = -1;
        int skippedShards = 0;
        String scrollId = null;
        ArrayList<ShardSearchFailure> failures = new ArrayList<ShardSearchFailure>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (SCROLL_ID.match(currentFieldName)) {
                    scrollId = parser.text();
                    continue;
                }
                if (TOOK.match(currentFieldName)) {
                    tookInMillis = parser.longValue();
                    continue;
                }
                if (TIMED_OUT.match(currentFieldName)) {
                    timedOut = parser.booleanValue();
                    continue;
                }
                if (TERMINATED_EARLY.match(currentFieldName)) {
                    terminatedEarly = parser.booleanValue();
                    continue;
                }
                if (NUM_REDUCE_PHASES.match(currentFieldName)) {
                    numReducePhases = parser.intValue();
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            if ("hits".equals(currentFieldName)) {
                hits = SearchHits.fromXContent(parser);
                continue;
            }
            if ("aggregations".equals(currentFieldName)) {
                aggs = Aggregations.fromXContent(parser);
                continue;
            }
            if ("suggest".equals(currentFieldName)) {
                suggest = Suggest.fromXContent(parser);
                continue;
            }
            if ("profile".equals(currentFieldName)) {
                profile = SearchProfileShardResults.fromXContent(parser);
                continue;
            }
            if (RestActions._SHARDS_FIELD.match(currentFieldName)) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token.isValue()) {
                        if (RestActions.FAILED_FIELD.match(currentFieldName)) {
                            parser.intValue();
                            continue;
                        }
                        if (RestActions.SUCCESSFUL_FIELD.match(currentFieldName)) {
                            successfulShards = parser.intValue();
                            continue;
                        }
                        if (RestActions.TOTAL_FIELD.match(currentFieldName)) {
                            totalShards = parser.intValue();
                            continue;
                        }
                        if (RestActions.SKIPPED_FIELD.match(currentFieldName)) {
                            skippedShards = parser.intValue();
                            continue;
                        }
                        parser.skipChildren();
                        continue;
                    }
                    if (token == XContentParser.Token.START_ARRAY) {
                        if (RestActions.FAILURES_FIELD.match(currentFieldName)) {
                            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                failures.add(ShardSearchFailure.fromXContent(parser));
                            }
                            continue;
                        }
                        parser.skipChildren();
                        continue;
                    }
                    parser.skipChildren();
                }
                continue;
            }
            parser.skipChildren();
        }
        SearchResponseSections searchResponseSections = new SearchResponseSections(hits, aggs, suggest, timedOut, terminatedEarly, profile, numReducePhases);
        return new SearchResponse(searchResponseSections, scrollId, totalShards, successfulShards, skippedShards, tookInMillis, failures.toArray(new ShardSearchFailure[failures.size()]));
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.internalResponse = new InternalSearchResponse(in);
        this.totalShards = in.readVInt();
        this.successfulShards = in.readVInt();
        int size = in.readVInt();
        if (size == 0) {
            this.shardFailures = ShardSearchFailure.EMPTY_ARRAY;
        } else {
            this.shardFailures = new ShardSearchFailure[size];
            for (int i = 0; i < this.shardFailures.length; ++i) {
                this.shardFailures[i] = ShardSearchFailure.readShardSearchFailure(in);
            }
        }
        this.scrollId = in.readOptionalString();
        this.tookInMillis = in.readVLong();
        if (in.getVersion().onOrAfter(Version.V_5_6_0)) {
            this.skippedShards = in.readVInt();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.internalResponse.writeTo(out);
        out.writeVInt(this.totalShards);
        out.writeVInt(this.successfulShards);
        out.writeVInt(this.shardFailures.length);
        for (ShardSearchFailure shardSearchFailure : this.shardFailures) {
            shardSearchFailure.writeTo(out);
        }
        out.writeOptionalString(this.scrollId);
        out.writeVLong(this.tookInMillis);
        if (out.getVersion().onOrAfter(Version.V_5_6_0)) {
            out.writeVInt(this.skippedShards);
        }
    }

    public String toString() {
        return Strings.toString(this);
    }
}

