/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import java.io.IOException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.discovery.zen.PendingClusterStateStats;

public class DiscoveryStats
implements Writeable,
ToXContentFragment {
    @Nullable
    private final PendingClusterStateStats queueStats;

    public DiscoveryStats(PendingClusterStateStats queueStats) {
        this.queueStats = queueStats;
    }

    public DiscoveryStats(StreamInput in) throws IOException {
        this.queueStats = in.readOptionalWriteable(PendingClusterStateStats::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.queueStats);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("discovery");
        if (this.queueStats != null) {
            this.queueStats.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public PendingClusterStateStats getQueueStats() {
        return this.queueStats;
    }

    static final class Fields {
        static final String DISCOVERY = "discovery";

        Fields() {
        }
    }
}

