/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.lucene.BytesRefs;

public final class Uid {
    public static final char DELIMITER = '#';
    public static final byte DELIMITER_BYTE = 35;
    private final String type;
    private final String id;
    private static final int UTF8 = 255;
    private static final int NUMERIC = 254;
    private static final int BASE64_ESCAPE = 253;

    public Uid(String type, String id) {
        this.type = type;
        this.id = id;
    }

    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Uid uid = (Uid)o;
        if (this.id != null ? !this.id.equals(uid.id) : uid.id != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(uid.type) : uid.type != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Uid.createUid(this.type, this.id);
    }

    public BytesRef toBytesRef() {
        return Uid.createUidAsBytes(this.type, this.id);
    }

    public static Uid createUid(String uid) {
        int delimiterIndex = uid.indexOf(35);
        return new Uid(uid.substring(0, delimiterIndex), uid.substring(delimiterIndex + 1));
    }

    public static BytesRef createUidAsBytes(String type, String id) {
        return Uid.createUidAsBytes(new BytesRef((CharSequence)type), new BytesRef((CharSequence)id));
    }

    public static BytesRef createUidAsBytes(String type, BytesRef id) {
        return Uid.createUidAsBytes(new BytesRef((CharSequence)type), id);
    }

    public static BytesRef createUidAsBytes(BytesRef type, BytesRef id) {
        BytesRef ref = new BytesRef(type.length + 1 + id.length);
        System.arraycopy(type.bytes, type.offset, ref.bytes, 0, type.length);
        ref.offset = type.length;
        ref.bytes[ref.offset++] = 35;
        System.arraycopy(id.bytes, id.offset, ref.bytes, ref.offset, id.length);
        ref.offset = 0;
        ref.length = ref.bytes.length;
        return ref;
    }

    public static BytesRef[] createUidsForTypesAndId(Collection<String> types, Object id) {
        return Uid.createUidsForTypesAndIds(types, Collections.singletonList(id));
    }

    public static BytesRef[] createUidsForTypesAndIds(Collection<String> types, Collection<?> ids) {
        BytesRef[] uids = new BytesRef[types.size() * ids.size()];
        BytesRefBuilder typeBytes = new BytesRefBuilder();
        BytesRefBuilder idBytes = new BytesRefBuilder();
        int index = 0;
        for (String type : types) {
            typeBytes.copyChars((CharSequence)type);
            for (Object id : ids) {
                uids[index++] = Uid.createUidAsBytes(typeBytes.get(), BytesRefs.toBytesRef(id, idBytes));
            }
        }
        return uids;
    }

    public static String createUid(String type, String id) {
        return type + '#' + id;
    }

    static boolean isURLBase64WithoutPadding(String id) {
        int length = id.length();
        switch (length & 3) {
            case 0: {
                break;
            }
            case 1: {
                return false;
            }
            case 2: {
                char last = id.charAt(length - 1);
                if (last == 'A' || last == 'Q' || last == 'g' || last == 'w') break;
                return false;
            }
            case 3: {
                char last = id.charAt(length - 1);
                if (last == 'A' || last == 'E' || last == 'I' || last == 'M' || last == 'Q' || last == 'U' || last == 'Y' || last == 'c' || last == 'g' || last == 'k' || last == 'o' || last == 's' || last == 'w' || last == '0' || last == '4' || last == '8') break;
                return false;
            }
            default: {
                throw new AssertionError((Object)"Impossible case");
            }
        }
        for (int i = 0; i < length; ++i) {
            boolean allowed;
            char c = id.charAt(i);
            boolean bl = allowed = c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '-' || c == '_';
            if (allowed) continue;
            return false;
        }
        return true;
    }

    static boolean isPositiveNumeric(String id) {
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private static BytesRef encodeNumericId(String id) {
        byte[] b = new byte[1 + (id.length() + 1) / 2];
        b[0] = -2;
        for (int i = 0; i < id.length(); i += 2) {
            int b1 = id.charAt(i) - 48;
            int b2 = i + 1 == id.length() ? 15 : id.charAt(i + 1) - 48;
            b[1 + i / 2] = (byte)(b1 << 4 | b2);
        }
        return new BytesRef(b);
    }

    private static BytesRef encodeBase64Id(String id) {
        byte[] b = Base64.getUrlDecoder().decode(id);
        if (Byte.toUnsignedInt(b[0]) >= 253) {
            byte[] newB = new byte[b.length + 1];
            newB[0] = -3;
            System.arraycopy(b, 0, newB, 1, b.length);
            b = newB;
        }
        return new BytesRef(b, 0, b.length);
    }

    private static BytesRef encodeUtf8Id(String id) {
        byte[] b = new byte[1 + UnicodeUtil.maxUTF8Length((int)id.length())];
        b[0] = -1;
        int length = UnicodeUtil.UTF16toUTF8((CharSequence)id, (int)0, (int)id.length(), (byte[])b, (int)1);
        return new BytesRef(b, 0, length);
    }

    public static BytesRef encodeId(String id) {
        if (id.isEmpty()) {
            throw new IllegalArgumentException("Ids can't be empty");
        }
        if (Uid.isPositiveNumeric(id)) {
            return Uid.encodeNumericId(id);
        }
        if (Uid.isURLBase64WithoutPadding(id)) {
            return Uid.encodeBase64Id(id);
        }
        return Uid.encodeUtf8Id(id);
    }

    private static String decodeNumericId(byte[] idBytes) {
        assert (Byte.toUnsignedInt(idBytes[0]) == 254);
        int length = (idBytes.length - 1) * 2;
        char[] chars = new char[length];
        for (int i = 1; i < idBytes.length; ++i) {
            int b = Byte.toUnsignedInt(idBytes[i]);
            int b1 = b >>> 4;
            int b2 = b & 0xF;
            chars[(i - 1) * 2] = (char)(b1 + 48);
            if (i == idBytes.length - 1 && b2 == 15) {
                --length;
                break;
            }
            chars[(i - 1) * 2 + 1] = (char)(b2 + 48);
        }
        return new String(chars, 0, length);
    }

    private static String decodeUtf8Id(byte[] idBytes) {
        assert (Byte.toUnsignedInt(idBytes[0]) == 255);
        return new BytesRef(idBytes, 1, idBytes.length - 1).utf8ToString();
    }

    private static String decodeBase64Id(byte[] idBytes) {
        assert (Byte.toUnsignedInt(idBytes[0]) <= 253);
        if (Byte.toUnsignedInt(idBytes[0]) == 253) {
            idBytes = Arrays.copyOfRange(idBytes, 1, idBytes.length);
        }
        return Base64.getUrlEncoder().withoutPadding().encodeToString(idBytes);
    }

    public static String decodeId(byte[] idBytes) {
        if (idBytes.length == 0) {
            throw new IllegalArgumentException("Ids can't be empty");
        }
        int magicChar = Byte.toUnsignedInt(idBytes[0]);
        switch (magicChar) {
            case 254: {
                return Uid.decodeNumericId(idBytes);
            }
            case 255: {
                return Uid.decodeUtf8Id(idBytes);
            }
        }
        return Uid.decodeBase64Id(idBytes);
    }
}

