/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.completion;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.suggest.document.CompletionQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.mapper.CompletionFieldMapper;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.suggest.SuggestionSearchContext;
import org.elasticsearch.search.suggest.completion.CompletionSuggester;
import org.elasticsearch.search.suggest.completion.FuzzyOptions;
import org.elasticsearch.search.suggest.completion.RegexOptions;
import org.elasticsearch.search.suggest.completion.context.ContextMapping;
import org.elasticsearch.search.suggest.completion.context.ContextMappings;

public class CompletionSuggestionContext
extends SuggestionSearchContext.SuggestionContext {
    private CompletionFieldMapper.CompletionFieldType fieldType;
    private FuzzyOptions fuzzyOptions;
    private RegexOptions regexOptions;
    private Map<String, List<ContextMapping.InternalQueryContext>> queryContexts = Collections.emptyMap();

    protected CompletionSuggestionContext(QueryShardContext shardContext) {
        super(CompletionSuggester.INSTANCE, shardContext);
    }

    CompletionFieldMapper.CompletionFieldType getFieldType() {
        return this.fieldType;
    }

    void setFieldType(CompletionFieldMapper.CompletionFieldType fieldType) {
        this.fieldType = fieldType;
    }

    void setRegexOptions(RegexOptions regexOptions) {
        this.regexOptions = regexOptions;
    }

    void setFuzzyOptions(FuzzyOptions fuzzyOptions) {
        this.fuzzyOptions = fuzzyOptions;
    }

    void setQueryContexts(Map<String, List<ContextMapping.InternalQueryContext>> queryContexts) {
        this.queryContexts = queryContexts;
    }

    public FuzzyOptions getFuzzyOptions() {
        return this.fuzzyOptions;
    }

    public RegexOptions getRegexOptions() {
        return this.regexOptions;
    }

    public Map<String, List<ContextMapping.InternalQueryContext>> getQueryContexts() {
        return this.queryContexts;
    }

    CompletionQuery toQuery() {
        CompletionQuery query;
        CompletionFieldMapper.CompletionFieldType fieldType = this.getFieldType();
        if (this.getPrefix() != null) {
            query = this.createCompletionQuery(this.getPrefix(), fieldType);
        } else if (this.getRegex() != null) {
            if (this.fuzzyOptions != null) {
                throw new IllegalArgumentException("can not use 'fuzzy' options with 'regex");
            }
            if (this.regexOptions == null) {
                this.regexOptions = RegexOptions.builder().build();
            }
            query = fieldType.regexpQuery(this.getRegex(), this.regexOptions.getFlagsValue(), this.regexOptions.getMaxDeterminizedStates());
        } else if (this.getText() != null) {
            query = this.createCompletionQuery(this.getText(), fieldType);
        } else {
            throw new IllegalArgumentException("'prefix/text' or 'regex' must be defined");
        }
        if (fieldType.hasContextMappings()) {
            ContextMappings contextMappings = fieldType.getContextMappings();
            return contextMappings.toContextQuery(query, this.queryContexts);
        }
        return query;
    }

    private CompletionQuery createCompletionQuery(BytesRef prefix, CompletionFieldMapper.CompletionFieldType fieldType) {
        CompletionQuery query = this.fuzzyOptions != null ? fieldType.fuzzyQuery(prefix.utf8ToString(), Fuzziness.fromEdits(this.fuzzyOptions.getEditDistance()), this.fuzzyOptions.getFuzzyPrefixLength(), this.fuzzyOptions.getFuzzyMinLength(), this.fuzzyOptions.getMaxDeterminizedStates(), this.fuzzyOptions.isTranspositions(), this.fuzzyOptions.isUnicodeAware()) : fieldType.prefixQuery(prefix);
        return query;
    }
}

