/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.Debug;
import org.openide.nodes.Node;
import org.openide.util.WeakSet;
import org.openide.windows.TopComponent;

public final class RegistryImpl
implements TopComponent.Registry {
    private WeakReference<TopComponent> activatedTopComponent = new WeakReference<Object>(null);
    private WeakReference<TopComponent> previousActivated;
    private final Set<TopComponent> openSet = new WeakSet(30);
    private Node[] currentNodes;
    private Node[] activatedNodes;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private static final boolean DEBUG = Debug.isLoggable(RegistryImpl.class);

    public synchronized Set<TopComponent> getOpened() {
        return new SyncSet();
    }

    public TopComponent getActivated() {
        return (TopComponent)this.activatedTopComponent.get();
    }

    public Node[] getCurrentNodes() {
        return this.currentNodes;
    }

    public Node[] getActivatedNodes() {
        return this.activatedNodes == null ? new Node[]{} : this.activatedNodes;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    void topComponentActivated(TopComponent topComponent) {
        if (this.activatedTopComponent.get() == topComponent && this.activatedNodes != null) {
            return;
        }
        final TopComponent topComponent2 = (TopComponent)this.activatedTopComponent.get();
        if (topComponent2 != null && topComponent2.getActivatedNodes() != null) {
            this.previousActivated = new WeakReference<TopComponent>(topComponent2);
        }
        this.activatedTopComponent = new WeakReference<TopComponent>(topComponent);
        final TopComponent topComponent3 = (TopComponent)this.activatedTopComponent.get();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RegistryImpl.this.doFirePropertyChange("activated", topComponent2, topComponent3);
            }
        });
        this.selectedNodesChanged(topComponent3, topComponent3 == null ? null : topComponent3.getActivatedNodes());
    }

    public synchronized void topComponentOpened(TopComponent topComponent) {
        assert (null != topComponent);
        if (this.openSet.contains(topComponent)) {
            return;
        }
        HashSet<TopComponent> hashSet = new HashSet<TopComponent>(this.openSet);
        this.openSet.add(topComponent);
        this.doFirePropertyChange("tcOpened", null, topComponent);
        this.doFirePropertyChange("opened", hashSet, new HashSet<TopComponent>(this.openSet));
    }

    public synchronized void topComponentClosed(TopComponent topComponent) {
        Object[] objectArray;
        if (!this.openSet.contains(topComponent)) {
            return;
        }
        HashSet<TopComponent> hashSet = new HashSet<TopComponent>(this.openSet);
        this.openSet.remove(topComponent);
        this.doFirePropertyChange("tcClosed", null, topComponent);
        this.doFirePropertyChange("opened", hashSet, new HashSet<TopComponent>(this.openSet));
        if (this.activatedNodes != null && (objectArray = topComponent.getActivatedNodes()) != null && Arrays.equals(objectArray, this.activatedNodes)) {
            this.activatedNodes = null;
            this.doFirePropertyChange("activatedNodes", objectArray, null);
        }
    }

    public synchronized void addTopComponent(TopComponent topComponent) {
        assert (null != topComponent);
        this.openSet.add(topComponent);
    }

    public void selectedNodesChanged(TopComponent topComponent, Node[] nodeArray) {
        Object[] objectArray = this.currentNodes;
        if (topComponent != this.activatedTopComponent.get() && this.activatedNodes != null && !this.isProperPrevious(topComponent, nodeArray)) {
            return;
        }
        if (Arrays.equals(objectArray, nodeArray) && this.activatedNodes != null) {
            return;
        }
        this.currentNodes = nodeArray == null ? null : (Node[])nodeArray.clone();
        this.tryFireChanges((Node[])objectArray, this.currentNodes);
    }

    private boolean isProperPrevious(TopComponent topComponent, Node[] nodeArray) {
        if (this.previousActivated == null || nodeArray == null) {
            return false;
        }
        TopComponent topComponent2 = (TopComponent)this.previousActivated.get();
        if (topComponent2 == null || !topComponent2.equals(topComponent)) {
            return false;
        }
        TopComponent topComponent3 = (TopComponent)this.activatedTopComponent.get();
        return topComponent3 != null && topComponent3.getActivatedNodes() == null;
    }

    public static void cancelMenu(Window window) {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        for (int i = 0; i < menuElementArray.length; ++i) {
            Window window2 = SwingUtilities.windowForComponent(menuElementArray[i].getComponent());
            if (window2 == null || window2 != window && window2.getOwner() != window) continue;
            return;
        }
        if (menuElementArray.length > 0) {
            menuSelectionManager.clearSelectedPath();
        }
    }

    private void tryFireChanges(Node[] nodeArray, Node[] nodeArray2) {
        this.doFirePropertyChange("currentNodes", nodeArray, nodeArray2);
        if (nodeArray2 == null && this.activatedNodes == null) {
            nodeArray2 = new Node[]{};
        }
        if (nodeArray2 != null) {
            nodeArray = this.activatedNodes;
            this.activatedNodes = nodeArray2;
            this.support.firePropertyChange("activatedNodes", nodeArray, this.activatedNodes);
        }
    }

    private void doFirePropertyChange(final String string, final Object list, final Object list2) {
        if (DEBUG) {
            RegistryImpl.debugLog("");
            RegistryImpl.debugLog("Scheduling event firing: propName=" + string);
            RegistryImpl.debugLog("\toldValue=" + (list instanceof Object[] ? Arrays.asList((Object[])list) : list));
            RegistryImpl.debugLog("\tnewValue=" + (list2 instanceof Object[] ? Arrays.asList((Object[])list2) : list2));
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.support.firePropertyChange(string, list, list2);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RegistryImpl.this.support.firePropertyChange(string, list, list2);
                }
            });
        }
    }

    void clear() {
        this.activatedTopComponent.clear();
        this.openSet.clear();
        this.currentNodes = null;
        this.activatedNodes = null;
    }

    private static void debugLog(String string) {
        Debug.log(RegistryImpl.class, string);
    }

    private final class SyncSet
    implements Set<TopComponent> {
        private SyncSet() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            RegistryImpl registryImpl = RegistryImpl.this;
            synchronized (registryImpl) {
                return RegistryImpl.this.openSet.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            RegistryImpl registryImpl = RegistryImpl.this;
            synchronized (registryImpl) {
                return RegistryImpl.this.openSet.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object object) {
            RegistryImpl registryImpl = RegistryImpl.this;
            synchronized (registryImpl) {
                return RegistryImpl.this.openSet.contains(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<TopComponent> iterator() {
            RegistryImpl registryImpl = RegistryImpl.this;
            synchronized (registryImpl) {
                return new HashSet(RegistryImpl.this.openSet).iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            RegistryImpl registryImpl = RegistryImpl.this;
            synchronized (registryImpl) {
                return RegistryImpl.this.openSet.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] TArray) {
            RegistryImpl registryImpl = RegistryImpl.this;
            synchronized (registryImpl) {
                return RegistryImpl.this.openSet.toArray(TArray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> collection) {
            RegistryImpl registryImpl = RegistryImpl.this;
            synchronized (registryImpl) {
                return RegistryImpl.this.openSet.containsAll(collection);
            }
        }

        @Override
        public boolean add(TopComponent topComponent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends TopComponent> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

