/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

public class IntBitfield {
    public static final int UNIT_SIZE = 32;
    private static final long UNIT_SHIFT_L = 5L;
    private static final int UNIT_SHIFT_I = 5;
    private final int[] storage;
    private final long bitsCountL;
    private final int bitsCountI;

    public IntBitfield(long l) {
        int n = (int)Math.max(1L, l + 7L >>> 5);
        this.storage = new int[n];
        this.bitsCountL = (long)n << 5;
        this.bitsCountI = this.bitsCountL > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.bitsCountL;
    }

    public IntBitfield(int n) {
        int n2 = Math.max(1, n + 7 >>> 5);
        this.storage = new int[n2];
        this.bitsCountI = n2 << 5;
        this.bitsCountL = this.bitsCountI;
    }

    private final void check(long l) {
        if (0L > l || l >= this.bitsCountL) {
            throw new ArrayIndexOutOfBoundsException("Bitnum should be within [0.." + (this.bitsCountL - 1L) + "], but is " + l);
        }
    }

    private final void check(int n) {
        if (0 > n || n >= this.bitsCountI) {
            throw new ArrayIndexOutOfBoundsException("Bitnum should be within [0.." + (this.bitsCountI - 1) + "], but is " + n);
        }
    }

    public final long capacity() {
        return this.bitsCountL;
    }

    public final boolean get(long l) {
        this.check(l);
        int n = (int)(l >>> 5);
        int n2 = (int)(l - ((long)n << 5));
        return 0 != (this.storage[n] & 1 << n2);
    }

    public final boolean get(int n) {
        this.check(n);
        int n2 = n >>> 5;
        int n3 = n - (n2 << 5);
        return 0 != (this.storage[n2] & 1 << n3);
    }

    public final boolean put(long l, boolean bl) {
        boolean bl2;
        this.check(l);
        int n = (int)(l >>> 5);
        int n2 = (int)(l - ((long)n << 5));
        int n3 = 1 << n2;
        boolean bl3 = bl2 = 0 != (this.storage[n] & n3);
        if (bl2 != bl) {
            if (bl) {
                int n4 = n;
                this.storage[n4] = this.storage[n4] | n3;
            } else {
                int n5 = n;
                this.storage[n5] = this.storage[n5] & ~n3;
            }
        }
        return bl2;
    }

    public final boolean put(int n, boolean bl) {
        boolean bl2;
        this.check(n);
        int n2 = n >>> 5;
        int n3 = n - (n2 << 5);
        int n4 = 1 << n3;
        boolean bl3 = bl2 = 0 != (this.storage[n2] & n4);
        if (bl2 != bl) {
            if (bl) {
                int n5 = n2;
                this.storage[n5] = this.storage[n5] | n4;
            } else {
                int n6 = n2;
                this.storage[n6] = this.storage[n6] & ~n4;
            }
        }
        return bl2;
    }

    public static final int getBitCount(int n) {
        int n2 = n;
        n2 -= n >>> 1 & 0xDB6DB6DB;
        return ((n2 -= n >>> 2 & 0x49249249) + (n2 >>> 3) & 0xC71C71C7) % 63;
    }

    public long getBitCount() {
        long l = 0L;
        for (int i = this.storage.length - 1; i >= 0; --i) {
            l += (long)IntBitfield.getBitCount(this.storage[i]);
        }
        return l;
    }
}

