/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.compiled;

import java.util.ArrayList;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.compiled.ClassFileDecompilers;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.BinaryFileStubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.util.cls.ClsFormatException;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.indexing.FileContent;

public class ClassFileStubBuilder
implements BinaryFileStubBuilder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.compiled.ClassFileStubBuilder");
    public static final int STUB_VERSION = 19;
    private static final Comparator<Object> CLASS_NAME_COMPARATOR = Comparator.comparing(o -> o.getClass().getName());

    @Override
    public boolean acceptsFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClassFileStubBuilder", "acceptsFile"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StubElement buildStubTree(@NotNull FileContent fileContent) {
        if (fileContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContent", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClassFileStubBuilder", "buildStubTree"));
        }
        VirtualFile file = fileContent.getFile();
        byte[] content = fileContent.getContent();
        try {
            file.setPreloadedContentHint(content);
            ClassFileDecompilers.Decompiler decompiler = ClassFileDecompilers.find(file);
            if (decompiler instanceof ClassFileDecompilers.Full) {
                PsiFileStub<?> psiFileStub = ((ClassFileDecompilers.Full)decompiler).getStubBuilder().buildFileStub(fileContent);
                file.setPreloadedContentHint(null);
                return psiFileStub;
            }
        }
        catch (ClsFormatException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(file.getPath(), e);
            }
            LOG.info(file.getPath() + ": " + e.getMessage());
        }
        try {
            PsiJavaFileStub stub = ClsFileImpl.buildFileStub(file, content);
            if (stub != null) return stub;
            if (fileContent.getFileName().indexOf(36) >= 0) return stub;
            LOG.info("No stub built for file " + fileContent);
            return stub;
        }
        catch (ClsFormatException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(file.getPath(), e);
            } else {
                LOG.info(file.getPath() + ": " + e.getMessage());
            }
            file.setPreloadedContentHint(null);
            return null;
        }
    }

    @Override
    public int getStubVersion() {
        int version = 19;
        ArrayList<ClassFileDecompilers.Decompiler> decompilers = ContainerUtil.newArrayList(ClassFileDecompilers.EP_NAME.getExtensions());
        decompilers.sort(CLASS_NAME_COMPARATOR);
        for (ClassFileDecompilers.Decompiler decompiler : decompilers) {
            if (!(decompiler instanceof ClassFileDecompilers.Full)) continue;
            version = version * 31 + ((ClassFileDecompilers.Full)decompiler).getStubBuilder().getStubVersion() + decompiler.getClass().getName().hashCode();
        }
        return version;
    }
}

