/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.advanced;

import org.openstreetmap.josm.spi.preferences.Setting;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class PrefEntry
implements Comparable<PrefEntry> {
    private final String key;
    private Setting<?> value;
    private final Setting<?> defaultValue;
    private boolean isDefault;
    private boolean changed;

    public PrefEntry(String key, Setting<?> value, Setting<?> defaultValue, boolean isDefault) {
        CheckParameterUtil.ensureParameterNotNull(key);
        CheckParameterUtil.ensureParameterNotNull(value);
        CheckParameterUtil.ensureParameterNotNull(defaultValue);
        this.key = key;
        this.value = value;
        this.defaultValue = defaultValue;
        this.isDefault = isDefault;
    }

    public String getKey() {
        return this.key;
    }

    public Setting<?> getValue() {
        return this.value;
    }

    public Setting<?> getDefaultValue() {
        return this.defaultValue;
    }

    public void setValue(Setting<?> value) {
        this.value = value;
        this.changed = true;
        this.isDefault = false;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void markAsChanged() {
        this.changed = true;
    }

    public void reset() {
        this.value = this.defaultValue;
        this.changed = true;
        this.isDefault = true;
    }

    @Override
    public int compareTo(PrefEntry other) {
        return this.key.compareTo(other.key);
    }

    public int hashCode() {
        return 31 + (this.key == null ? 0 : this.key.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrefEntry other = (PrefEntry)obj;
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public String toString() {
        return this.value.toString();
    }
}

