/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import junit.framework.TestCase;
import org.python.indexer.AstCache;
import org.python.indexer.Def;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Ref;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public class TestBase
extends TestCase {
    protected static final Level LOGGING_LEVEL = Level.OFF;
    protected static final String TEST_DATA_DIR;
    protected static final String TEST_LIB_DIR;
    protected Indexer idx;

    private static void setUpLogging() {
        Logger indexerLogger = Logger.getLogger(Indexer.class.getCanonicalName());
        ConsoleHandler logHandler = new ConsoleHandler();
        logHandler.setFormatter(new SimpleFormatter());
        logHandler.setLevel(Level.FINEST);
        indexerLogger.addHandler(logHandler);
    }

    protected void setUp() throws Exception {
        this.idx = new Indexer();
        this.idx.getLogger().setLevel(LOGGING_LEVEL);
        this.idx.enableAggressiveAssertions(true);
        this.idx.setProjectDir(TEST_DATA_DIR);
        AstCache.get().clearDiskCache();
        AstCache.get().clear();
    }

    protected void includeStandardLibrary() throws Exception {
        this.idx.addPath(TEST_LIB_DIR);
    }

    protected String abspath(String file) {
        return this.getTestFilePath(file);
    }

    protected String getTestFilePath(String file) {
        return TEST_DATA_DIR + file;
    }

    protected String getSource(String file) throws Exception {
        String line;
        String path = this.getTestFilePath(file);
        StringBuilder sb = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(path)));
        while ((line = in.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        in.close();
        return sb.toString();
    }

    protected String makeModule(String ... lines) {
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line).append("\n");
        }
        return sb.toString();
    }

    protected String index(String filename, String ... lines) throws Exception {
        String src = this.makeModule(lines);
        this.idx.loadString(filename, src);
        this.idx.ready();
        return src;
    }

    protected int nthIndexOf(String s, String find, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        int index = -1;
        for (int i = 0; i < n; ++i) {
            if ((index = s.indexOf(find, index == -1 ? 0 : index + 1)) != -1) continue;
            throw new IllegalArgumentException();
        }
        return index;
    }

    public void testHandleExceptionLoggingNulls() throws Exception {
        try {
            this.idx.enableAggressiveAssertions(false);
            this.idx.getLogger().setLevel(Level.OFF);
            this.idx.handleException(null, new Exception());
            this.idx.handleException("oops", null);
        }
        catch (Throwable t) {
            TestBase.fail((String)("should not have thrown: " + t));
        }
    }

    public void testDataFileFindable() throws Exception {
        TestBase.assertTrue((String)"Test file not found", (boolean)new File(TEST_DATA_DIR).exists());
    }

    public void testLoadDataFile() throws Exception {
        String path = this.abspath("test-load.txt");
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(path)));
        TestBase.assertEquals((String)in.readLine().trim(), (String)"hello");
        in.close();
    }

    public void testGetSource() throws Exception {
        String src = this.getSource("testsrc.txt");
        TestBase.assertEquals((String)"one\ntwo\n\nthree\n", (String)src);
    }

    public void testStringModule() throws Exception {
        this.idx.loadString("test-string-module.py", this.makeModule("def foo():", "  pass"));
        this.idx.ready();
        this.assertFunctionBinding("test-string-module.foo");
    }

    public void testNthIndexOf() throws Exception {
        String s = "ab a b ab a\nb aab";
        TestBase.assertEquals((int)0, (int)this.nthIndexOf(s, "ab", 1));
        TestBase.assertEquals((int)7, (int)this.nthIndexOf(s, "ab", 2));
        TestBase.assertEquals((int)15, (int)this.nthIndexOf(s, "ab", 3));
        try {
            TestBase.assertEquals((int)-1, (int)this.nthIndexOf(s, "ab", 0));
            TestBase.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException ix) {
            TestBase.assertTrue((boolean)true);
        }
        try {
            TestBase.assertEquals((int)-1, (int)this.nthIndexOf(s, "ab", 4));
            TestBase.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException ix) {
            TestBase.assertTrue((boolean)true);
        }
    }

    public void testIndexerDefaults() throws Exception {
        this.includeStandardLibrary();
        TestBase.assertEquals((String)"wrong project dir", (String)TEST_DATA_DIR, (String)this.idx.projDir);
        TestBase.assertEquals((String)"unexpected load path entries", (int)1, (int)this.idx.path.size());
        TestBase.assertEquals((String)TEST_LIB_DIR, (String)this.idx.path.get(0));
    }

    public String buildIndex(String ... files) throws Exception {
        for (String f : files) {
            this.idx.loadFile(this.abspath(f));
        }
        this.idx.ready();
        return this.getSource(files[0]);
    }

    public NBinding getBinding(String qname) throws Exception {
        NBinding b = this.idx.lookupQname(qname);
        TestBase.assertNotNull((String)("no binding found for " + qname), (Object)b);
        return b;
    }

    public NBinding assertBinding(String qname, NBinding.Kind kind) throws Exception {
        NBinding b = this.getBinding(qname);
        TestBase.assertEquals((Object)((Object)kind), (Object)((Object)b.getKind()));
        return b;
    }

    public void assertNoBinding(String qname) throws Exception {
        NBinding b = this.idx.lookupQname(qname);
        TestBase.assertNull((String)("Should not have found binding for " + qname), (Object)b);
    }

    public NBinding assertAttributeBinding(String qname) throws Exception {
        return this.assertBinding(qname, NBinding.Kind.ATTRIBUTE);
    }

    public NBinding assertBuiltinBinding(String qname) throws Exception {
        NBinding b = this.getBinding(qname);
        TestBase.assertTrue((boolean)b.isBuiltin());
        return b;
    }

    public NBinding assertClassBinding(String qname) throws Exception {
        return this.assertBinding(qname, NBinding.Kind.CLASS);
    }

    public NBinding assertConstructorBinding(String qname) throws Exception {
        return this.assertBinding(qname, NBinding.Kind.CONSTRUCTOR);
    }

    public NBinding assertFunctionBinding(String qname) throws Exception {
        return this.assertBinding(qname, NBinding.Kind.FUNCTION);
    }

    public NBinding assertMethodBinding(String qname) throws Exception {
        return this.assertBinding(qname, NBinding.Kind.METHOD);
    }

    public NBinding assertModuleBinding(String qname) throws Exception {
        return this.assertBinding(qname, NBinding.Kind.MODULE);
    }

    public NBinding assertScopeBinding(String qname) throws Exception {
        return this.assertBinding(qname, NBinding.Kind.SCOPE);
    }

    public NBinding assertVariableBinding(String qname) throws Exception {
        return this.assertBinding(qname, NBinding.Kind.VARIABLE);
    }

    public NBinding assertParamBinding(String qname) throws Exception {
        return this.assertBinding(qname, NBinding.Kind.PARAMETER);
    }

    public void assertStaticSynthetic(NBinding b) {
        TestBase.assertTrue((boolean)b.isStatic());
        TestBase.assertTrue((boolean)b.isSynthetic());
    }

    public Def getDefinition(String qname, int offset, int length) throws Exception {
        NBinding b = this.getBinding(qname);
        TestBase.assertNotNull(b.getDefs());
        for (Def def : b.getDefs()) {
            if (offset != def.start() || length != def.end() - def.start()) continue;
            return def;
        }
        return null;
    }

    public void assertDefinition(String qname, int offset, int length) throws Exception {
        Def def = this.getDefinition(qname, offset, length);
        if (def == null) {
            TestBase.fail((String)("No definition for " + qname + " at " + offset + " of len " + length));
        }
    }

    public void assertNoDefinition(String msg, String qname, int pos, int len) throws Exception {
        Def def = this.getDefinition(qname, pos, len);
        TestBase.assertNull((String)msg, (Object)def);
    }

    public void assertDefinition(String qname, int offset) throws Exception {
        String[] names = qname.split("[.&@]");
        this.assertDefinition(qname, offset, names[names.length - 1].length());
    }

    public void assertDefinition(String qname, String name, int offset) throws Exception {
        this.assertDefinition(qname, offset, name.length());
    }

    public Ref getRefOrNull(String qname, int offset, int length) throws Exception {
        NBinding b = this.getBinding(qname);
        TestBase.assertNotNull((String)("Null refs list for " + qname), b.getRefs());
        for (Ref ref : b.getRefs()) {
            if (offset != ref.start() || length != ref.length()) continue;
            return ref;
        }
        return null;
    }

    public Ref getRefOrFail(String qname, int offset, int length) throws Exception {
        Ref ref = this.getRefOrNull(qname, offset, length);
        TestBase.assertNotNull((String)("No reference to " + qname + " at offset " + offset + " of length " + length), (Object)ref);
        return ref;
    }

    public void assertReference(String qname, int offset, int length) throws Exception {
        TestBase.assertTrue((boolean)this.getRefOrFail(qname, offset, length).isRef());
    }

    public void assertReference(String qname, int offset, String refname) throws Exception {
        this.assertReference(qname, offset, refname.length());
    }

    public void assertReference(String qname, int offset) throws Exception {
        String[] names = qname.split("[.&@]");
        this.assertReference(qname, offset, names[names.length - 1]);
    }

    public void assertNoReference(String msg, String qname, int pos, int len) throws Exception {
        TestBase.assertNull((String)msg, (Object)this.getRefOrNull(qname, pos, len));
    }

    public void assertCall(String qname, int offset, int length) throws Exception {
        TestBase.assertTrue((boolean)this.getRefOrFail(qname, offset, length).isCall());
    }

    public void assertCall(String qname, int offset, String refname) throws Exception {
        this.assertCall(qname, offset, refname.length());
    }

    public void assertCall(String qname, int offset) throws Exception {
        String[] names = qname.split("[.&@]");
        this.assertCall(qname, offset, names[names.length - 1]);
    }

    public void assertConstructed(String qname, int offset, int length) throws Exception {
        TestBase.assertTrue((boolean)this.getRefOrFail(qname, offset, length).isNew());
    }

    public void assertConstructed(String qname, int offset, String refname) throws Exception {
        this.assertConstructed(qname, offset, refname.length());
    }

    public void assertConstructed(String qname, int offset) throws Exception {
        String[] names = qname.split("[.&@]");
        this.assertConstructed(qname, offset, names[names.length - 1]);
    }

    public NType getTypeBinding(String typeQname) throws Exception {
        NType type = this.idx.lookupQnameType(typeQname);
        TestBase.assertNotNull((String)("No recorded type for " + typeQname), (Object)type);
        return type;
    }

    public NBinding assertBindingType(String bindingQname, String typeQname) throws Exception {
        NBinding b = this.getBinding(bindingQname);
        NType expected = this.getTypeBinding(typeQname);
        TestBase.assertEquals((String)"Wrong binding type", (Object)expected, (Object)NUnknownType.follow(b.getType()));
        return b;
    }

    public NBinding assertBindingType(String bindingQname, Class type) throws Exception {
        NBinding b = this.getBinding(bindingQname);
        NType btype = NUnknownType.follow(b.getType());
        TestBase.assertTrue((String)("Wrong type: expected " + type + " but was " + btype), (boolean)type.isInstance(btype));
        return b;
    }

    public void assertListType(String bindingQname) throws Exception {
        this.assertListType(bindingQname, null);
    }

    public void assertListType(String bindingQname, String eltTypeQname) throws Exception {
        NBinding b = this.getBinding(bindingQname);
        NType btype = b.followType();
        TestBase.assertTrue((boolean)btype.isListType());
        if (eltTypeQname != null) {
            NType eltType = this.getTypeBinding(eltTypeQname);
            TestBase.assertEquals((Object)eltType, (Object)NUnknownType.follow(btype.asListType().getElementType()));
        }
    }

    public void assertStringType(String bindingQname) throws Exception {
        this.assertBindingType(bindingQname, "__builtin__.str");
    }

    public void assertNumType(String bindingQname) throws Exception {
        this.assertBindingType(bindingQname, "__builtin__.float");
    }

    public void assertInstanceType(String bindingQname, String classQname) throws Exception {
        this.assertBindingType(bindingQname, classQname);
    }

    static {
        String home = System.getProperty("python.home", "dist");
        String test = System.getProperty("python.test.source.dir", "tests/java");
        File source = new File(test, "org/python/indexer");
        TEST_DATA_DIR = new File(source, "data").getAbsolutePath() + File.separator;
        TEST_LIB_DIR = new File(home, "Lib").getAbsolutePath() + File.separator;
        TestBase.setUpLogging();
    }
}

