/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer.data;

import java.awt.datatransfer.DataFlavor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.tools.CompositeList;

public final class PrimitiveTransferData
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final DataFlavor DATA_FLAVOR = new DataFlavor(PrimitiveTransferData.class, "OSM Primitives");
    private final ArrayList<PrimitiveData> direct;
    private final ArrayList<PrimitiveData> referenced;

    private PrimitiveTransferData(Collection<? extends OsmPrimitive> primitives, ReferenceGetter referencedGetter) {
        HashSet<? extends OsmPrimitive> visited = new HashSet<OsmPrimitive>(primitives);
        this.direct = new ArrayList(visited.size());
        this.referenced = new ArrayList();
        LinkedList<OsmPrimitive> toCheck = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : visited) {
            this.direct.add(osmPrimitive.save());
            toCheck.addAll(referencedGetter.getReferredPrimitives(osmPrimitive));
        }
        while (!toCheck.isEmpty()) {
            OsmPrimitive p = (OsmPrimitive)toCheck.poll();
            if (!visited.add(p)) continue;
            this.referenced.add(p.save());
            toCheck.addAll(referencedGetter.getReferredPrimitives(p));
        }
    }

    public Collection<PrimitiveData> getDirectlyAdded() {
        return Collections.unmodifiableList(this.direct);
    }

    public Collection<PrimitiveData> getReferenced() {
        return Collections.unmodifiableList(this.referenced);
    }

    public Collection<PrimitiveData> getAll() {
        return new CompositeList<PrimitiveData>(this.direct, this.referenced);
    }

    public static PrimitiveTransferData getData(Collection<? extends OsmPrimitive> primitives) {
        return new PrimitiveTransferData(primitives, primitive -> Collections.emptyList());
    }

    public static PrimitiveTransferData getDataWithReferences(Collection<? extends OsmPrimitive> primitives) {
        return new PrimitiveTransferData(primitives, new GetReferences());
    }

    public EastNorth getCenter() {
        BoundingXYVisitor visitor = new BoundingXYVisitor();
        for (PrimitiveData pd : this.getAll()) {
            if (!(pd instanceof NodeData) || pd.isIncomplete()) continue;
            visitor.visit((NodeData)pd);
        }
        ProjectionBounds bounds = visitor.getBounds();
        if (bounds == null) {
            return null;
        }
        return bounds.getCenter();
    }

    public boolean hasIncompleteData() {
        return this.getAll().stream().anyMatch(p -> p.isIncomplete() || !p.isVisible());
    }

    @FunctionalInterface
    private static interface ReferenceGetter {
        public Collection<? extends OsmPrimitive> getReferredPrimitives(OsmPrimitive var1);
    }

    private static final class GetReferences
    implements ReferenceGetter {
        private GetReferences() {
        }

        @Override
        public Collection<? extends OsmPrimitive> getReferredPrimitives(OsmPrimitive primitive) {
            if (primitive instanceof Way) {
                return ((Way)primitive).getNodes();
            }
            if (primitive instanceof Relation) {
                return ((Relation)primitive).getMemberPrimitivesList();
            }
            return Collections.emptyList();
        }
    }
}

