/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io.importexport;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.util.Map;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.StructUtils;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class WMSLayerImporter
extends FileImporter {
    public static final ExtensionFileFilter FILE_FILTER = new ExtensionFileFilter("wms", "wms", I18n.tr("WMS Files (*.wms)", new Object[0]));

    public WMSLayerImporter() {
        super(FILE_FILTER);
    }

    @Override
    public void importData(File file, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        EastNorth zoomTo;
        ImageryInfo info;
        block16: {
            CheckParameterUtil.ensureParameterNotNull(file, "file");
            info = null;
            try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));){
                int sfv = ois.readInt();
                if (sfv < 5) {
                    throw new InvalidClassException(I18n.tr("Unsupported WMS file version; found {0}, expected {1}", sfv, 5));
                }
                if (sfv == 5) {
                    ois.readInt();
                    ois.readInt();
                    zoomTo = null;
                    int imageSize = ois.readInt();
                    double pixelPerDegree = ois.readDouble();
                    String name = (String)ois.readObject();
                    String extendedUrl = (String)ois.readObject();
                    info = new ImageryInfo(name);
                    info.setExtendedUrl(extendedUrl);
                    info.setPixelPerDegree(pixelPerDegree);
                    info.setTileSize(imageSize);
                    break block16;
                }
                if (sfv == 6) {
                    zoomTo = (EastNorth)ois.readObject();
                    ImageryInfo.ImageryPreferenceEntry entry = StructUtils.deserializeStruct((Map)ois.readObject(), ImageryInfo.ImageryPreferenceEntry.class);
                    info = new ImageryInfo(entry);
                    break block16;
                }
                throw new InvalidClassException(I18n.tr("Unsupported WMS file version; found {0}, expected {1}", sfv, 6));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalDataException(e);
            }
        }
        ImageryLayer layer = ImageryLayer.create(info);
        GuiHelper.runInEDT(() -> {
            MainApplication.getLayerManager().addLayer(layer);
            if (zoomTo != null) {
                MainApplication.getMap().mapView.zoomTo(zoomTo);
            }
        });
    }
}

