/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import java.io.IOException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

public abstract class BaseDataReader {
    private static final Logger LOG = Logger.getInstance(BaseDataReader.class);
    protected final SleepingPolicy mySleepingPolicy;
    protected final Object mySleepMonitor = new Object();
    protected volatile boolean isStopped;
    private Future<?> myFinishedFuture;

    public BaseDataReader(SleepingPolicy sleepingPolicy) {
        this.mySleepingPolicy = sleepingPolicy != null ? sleepingPolicy : SleepingPolicy.SIMPLE;
    }

    @Deprecated
    protected void start() {
        this.start("");
    }

    protected void start(final @NotNull String presentableName2) {
        if (presentableName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/util/io/BaseDataReader", "start"));
        }
        if (StringUtil.isEmptyOrSpaces(presentableName2)) {
            LOG.warn(new Throwable("Must provide not-empty presentable name"));
        }
        if (this.myFinishedFuture == null) {
            this.myFinishedFuture = this.executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    if (StringUtil.isEmptyOrSpaces(presentableName2)) {
                        BaseDataReader.this.doRun();
                    } else {
                        ConcurrencyUtil.runUnderThreadName("BaseDataReader: " + presentableName2, new Runnable(){

                            @Override
                            public void run() {
                                BaseDataReader.this.doRun();
                            }
                        });
                    }
                }
            });
        }
    }

    protected boolean readAvailable() throws IOException {
        return this.mySleepingPolicy == SleepingPolicy.BLOCKING ? this.readAvailableBlocking() : this.readAvailableNonBlocking();
    }

    protected boolean readAvailableNonBlocking() throws IOException {
        throw new UnsupportedOperationException();
    }

    protected boolean readAvailableBlocking() throws IOException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected abstract Future<?> executeOnPooledThread(@NotNull Runnable var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doRun() {
        try {
            boolean stopSignalled = false;
            while (true) {
                boolean read2 = this.readAvailable();
                if (stopSignalled) return;
                if (this.mySleepingPolicy == SleepingPolicy.BLOCKING) {
                    return;
                }
                stopSignalled = this.isStopped;
                if (stopSignalled) continue;
                Object object = this.mySleepMonitor;
                synchronized (object) {
                    this.mySleepMonitor.wait(this.mySleepingPolicy.getTimeToSleep(read2));
                }
            }
        }
        catch (IOException e) {
            LOG.info(e);
            return;
        }
        catch (Exception e) {
            LOG.error(e);
            return;
        }
        finally {
            try {
                this.close();
            }
            catch (IOException e) {
                LOG.error("Can't close stream", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeReading() {
        Object object = this.mySleepMonitor;
        synchronized (object) {
            this.mySleepMonitor.notifyAll();
        }
    }

    protected abstract void close() throws IOException;

    public void stop() {
        this.isStopped = true;
        this.resumeReading();
    }

    public static interface SleepingPolicy {
        public static final SleepingPolicy SIMPLE = new SleepingPolicy(){

            @Override
            public int getTimeToSleep(boolean wasActive) {
                return wasActive ? 1 : 5;
            }
        };
        public static final SleepingPolicy BLOCKING = new SleepingPolicy(){

            @Override
            public int getTimeToSleep(boolean wasActive) {
                return 50;
            }
        };

        public int getTimeToSleep(boolean var1);
    }
}

