/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d.geom;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.lucene.spatial3d.geom.GeoComplexPolygon;
import org.apache.lucene.spatial3d.geom.GeoCompositePolygon;
import org.apache.lucene.spatial3d.geom.GeoConcavePolygon;
import org.apache.lucene.spatial3d.geom.GeoConvexPolygon;
import org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.lucene.spatial3d.geom.GeoPolygon;
import org.apache.lucene.spatial3d.geom.Plane;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.lucene.spatial3d.geom.SidedPlane;
import org.apache.lucene.spatial3d.geom.Vector;

public class GeoPolygonFactory {
    private GeoPolygonFactory() {
    }

    public static GeoPolygon makeGeoPolygon(PlanetModel planetModel, List<GeoPoint> pointList) {
        return GeoPolygonFactory.makeGeoPolygon(planetModel, pointList, null);
    }

    public static GeoPolygon makeGeoConcavePolygon(PlanetModel planetModel, List<GeoPoint> pointList) {
        return new GeoConcavePolygon(planetModel, pointList);
    }

    public static GeoPolygon makeGeoConvexPolygon(PlanetModel planetModel, List<GeoPoint> pointList) {
        return new GeoConvexPolygon(planetModel, pointList);
    }

    public static GeoPolygon makeGeoPolygon(PlanetModel planetModel, List<GeoPoint> pointList, List<GeoPolygon> holes) {
        return GeoPolygonFactory.makeGeoPolygon(planetModel, pointList, holes, 0.0);
    }

    public static GeoPolygon makeGeoConcavePolygon(PlanetModel planetModel, List<GeoPoint> pointList, List<GeoPolygon> holes) {
        return new GeoConcavePolygon(planetModel, pointList, holes);
    }

    public static GeoPolygon makeGeoConvexPolygon(PlanetModel planetModel, List<GeoPoint> pointList, List<GeoPolygon> holes) {
        return new GeoConvexPolygon(planetModel, pointList, holes);
    }

    public static GeoPolygon makeGeoPolygon(PlanetModel planetModel, List<GeoPoint> pointList, List<GeoPolygon> holes, double leniencyValue) {
        List<GeoPoint> firstFilteredPointList = GeoPolygonFactory.filterPoints(pointList);
        if (firstFilteredPointList == null) {
            return null;
        }
        List<GeoPoint> filteredPointList = GeoPolygonFactory.filterEdges(firstFilteredPointList, leniencyValue);
        if (filteredPointList == null) {
            return null;
        }
        Random generator = new Random(1234L);
        for (int counter = 0; counter < 1000000; ++counter) {
            GeoPoint pole = GeoPolygonFactory.pickPole(generator, planetModel, filteredPointList);
            Boolean isPoleInside = GeoPolygonFactory.isInsidePolygon(pole, filteredPointList);
            if (isPoleInside == null) continue;
            return GeoPolygonFactory.generateGeoPolygon(planetModel, filteredPointList, holes, pole, isPoleInside);
        }
        throw new IllegalArgumentException("cannot find a point that is inside the polygon " + filteredPointList);
    }

    public static GeoPolygon makeLargeGeoPolygon(PlanetModel planetModel, List<PolygonDescription> shapesList) {
        ArrayList<List<GeoPoint>> pointsList = new ArrayList<List<GeoPoint>>();
        BestShape testPointShape = null;
        for (PolygonDescription shape : shapesList) {
            testPointShape = GeoPolygonFactory.convertPolygon(pointsList, shape, testPointShape, true);
        }
        if (testPointShape == null) {
            throw new IllegalArgumentException("couldn't find a non-degenerate polygon for in-set determination");
        }
        Random generator = new Random(1234L);
        for (int counter = 0; counter < 1000000; ++counter) {
            GeoPoint pole = GeoPolygonFactory.pickPole(generator, planetModel, testPointShape.points);
            Boolean isPoleInside = GeoPolygonFactory.isInsidePolygon(pole, testPointShape.points);
            if (isPoleInside == null) continue;
            if (isPoleInside == testPointShape.poleMustBeInside) {
                return new GeoComplexPolygon(planetModel, pointsList, pole, isPoleInside);
            }
            return new GeoComplexPolygon(planetModel, pointsList, new GeoPoint(-pole.x, -pole.y, -pole.z), isPoleInside == false);
        }
        throw new IllegalArgumentException("cannot find a point that is inside the polygon " + testPointShape);
    }

    private static BestShape convertPolygon(List<List<GeoPoint>> pointsList, PolygonDescription shape, BestShape testPointShape, boolean mustBeInside) {
        List<GeoPoint> filteredPoints = GeoPolygonFactory.filterPoints(shape.points);
        if (filteredPoints == null) {
            return testPointShape;
        }
        if (shape.holes.size() == 0 && (testPointShape == null || testPointShape.points.size() > filteredPoints.size())) {
            testPointShape = new BestShape(filteredPoints, mustBeInside);
        }
        pointsList.add(filteredPoints);
        for (PolygonDescription polygonDescription : shape.holes) {
            testPointShape = GeoPolygonFactory.convertPolygon(pointsList, polygonDescription, testPointShape, !mustBeInside);
        }
        return testPointShape;
    }

    static GeoPolygon generateGeoPolygon(PlanetModel planetModel, List<GeoPoint> filteredPointList, List<GeoPolygon> holes, GeoPoint testPoint, boolean testPointInside) {
        GeoCompositePolygon rval = new GeoCompositePolygon();
        MutableBoolean seenConcave = new MutableBoolean();
        SidedPlane initialPlane = new SidedPlane((Vector)testPoint, (Vector)filteredPointList.get(0), filteredPointList.get(1));
        if (!GeoPolygonFactory.buildPolygonShape(rval, seenConcave, planetModel, filteredPointList, new BitSet(), 0, 1, initialPlane, holes, testPoint)) {
            if (testPointInside) {
                rval = new GeoCompositePolygon();
                seenConcave = new MutableBoolean();
                GeoPolygonFactory.buildPolygonShape(rval, seenConcave, planetModel, filteredPointList, new BitSet(), 0, 1, initialPlane, holes, null);
                return rval;
            }
            rval = new GeoCompositePolygon();
            seenConcave = new MutableBoolean();
            GeoPolygonFactory.buildPolygonShape(rval, seenConcave, planetModel, filteredPointList, new BitSet(), 0, 1, new SidedPlane(initialPlane), holes, null);
            return rval;
        }
        if (!testPointInside) {
            return rval;
        }
        rval = new GeoCompositePolygon();
        seenConcave = new MutableBoolean();
        GeoPolygonFactory.buildPolygonShape(rval, seenConcave, planetModel, filteredPointList, new BitSet(), 0, 1, new SidedPlane(initialPlane), holes, null);
        return rval;
    }

    static List<GeoPoint> filterPoints(List<? extends GeoPoint> input) {
        ArrayList<GeoPoint> noIdenticalPoints = new ArrayList<GeoPoint>(input.size());
        int startIndex = -1;
        GeoPoint comparePoint = input.get(0);
        for (int i = 0; i < input.size() - 1; ++i) {
            GeoPoint thePoint = input.get(GeoPolygonFactory.getLegalIndex(-i - 1, input.size()));
            if (thePoint.isNumericallyIdentical(comparePoint)) continue;
            startIndex = GeoPolygonFactory.getLegalIndex(-i, input.size());
            break;
        }
        if (startIndex == -1) {
            return null;
        }
        int currentIndex = startIndex;
        do {
            GeoPoint nextNonIdenticalPoint;
            GeoPoint currentPoint = input.get(currentIndex);
            noIdenticalPoints.add(currentPoint);
            while ((currentIndex = GeoPolygonFactory.getLegalIndex(currentIndex + 1, input.size())) != startIndex && (nextNonIdenticalPoint = input.get(currentIndex)).isNumericallyIdentical(currentPoint)) {
            }
        } while (currentIndex != startIndex);
        if (noIdenticalPoints.size() < 3) {
            return null;
        }
        return noIdenticalPoints;
    }

    static List<GeoPoint> filterEdges(List<GeoPoint> noIdenticalPoints, double leniencyValue) {
        for (int i = 0; i < noIdenticalPoints.size(); ++i) {
            SafePath startPath = new SafePath(null, noIdenticalPoints.get(i), i, null);
            SafePath resultPath = GeoPolygonFactory.findSafePath(startPath, noIdenticalPoints, GeoPolygonFactory.getLegalIndex(i + 1, noIdenticalPoints.size()), i, leniencyValue);
            if (resultPath == null || resultPath.previous == null) continue;
            ArrayList<GeoPoint> rval = new ArrayList<GeoPoint>(noIdenticalPoints.size());
            resultPath.fillInList(rval);
            return rval;
        }
        return null;
    }

    private static SafePath findSafePath(SafePath currentPath, List<GeoPoint> points, int pointIndex, int startPointIndex, double leniencyValue) {
        int considerPointIndex = pointIndex;
        while (true) {
            GeoPoint considerStartPoint = currentPath.lastPoint;
            GeoPoint considerEndPoint = points.get(considerPointIndex);
            int nextPointIndex = GeoPolygonFactory.getLegalIndex(considerPointIndex + 1, points.size());
            if (!considerStartPoint.isNumericallyIdentical(considerEndPoint)) {
                Plane considerPlane = new Plane((Vector)considerStartPoint, considerEndPoint);
                boolean isChoiceLegal = true;
                if (isChoiceLegal && currentPath.lastPlane != null) {
                    if (currentPath.lastPlane.evaluateIsZero(considerEndPoint)) {
                        isChoiceLegal = false;
                    } else if (considerPlane.evaluateIsZero(currentPath.previous.lastPoint)) {
                        isChoiceLegal = false;
                    } else {
                        Plane thirdPlane = new Plane((Vector)currentPath.previous.lastPoint, considerEndPoint);
                        if (thirdPlane.evaluateIsZero(considerStartPoint)) {
                            isChoiceLegal = false;
                        }
                    }
                }
                if (isChoiceLegal && considerPointIndex == startPointIndex) {
                    SafePath firstPlaneEndpoint = currentPath.findFirstEndpoint();
                    if (firstPlaneEndpoint == null) {
                        isChoiceLegal = false;
                    } else if (firstPlaneEndpoint.lastPlane.evaluateIsZero(considerStartPoint)) {
                        isChoiceLegal = false;
                    } else if (considerPlane.evaluateIsZero(firstPlaneEndpoint.lastPoint)) {
                        isChoiceLegal = false;
                    } else {
                        Plane thirdPlane = new Plane((Vector)considerStartPoint, firstPlaneEndpoint.lastPoint);
                        if (thirdPlane.evaluateIsZero(considerEndPoint)) {
                            isChoiceLegal = false;
                        }
                    }
                }
                if (isChoiceLegal) {
                    int checkIndex = GeoPolygonFactory.getLegalIndex(currentPath.lastPointIndex + 1, points.size());
                    while (checkIndex != considerPointIndex) {
                        if (Math.abs(considerPlane.evaluate(points.get(checkIndex))) >= 1.0E-12 + leniencyValue) {
                            return null;
                        }
                        checkIndex = GeoPolygonFactory.getLegalIndex(checkIndex + 1, points.size());
                    }
                }
                if (isChoiceLegal) {
                    if (considerPointIndex == startPointIndex) {
                        return currentPath;
                    }
                    SafePath newPath = new SafePath(currentPath, considerEndPoint, considerPointIndex, considerPlane);
                    SafePath result = GeoPolygonFactory.findSafePath(newPath, points, nextPointIndex, startPointIndex, leniencyValue);
                    if (result != null) {
                        return result;
                    }
                }
            }
            if (considerPointIndex == startPointIndex) break;
            considerPointIndex = nextPointIndex;
        }
        return null;
    }

    private static GeoPoint pickPole(Random generator, PlanetModel planetModel, List<GeoPoint> points) {
        int pointIndex = generator.nextInt(points.size());
        GeoPoint closePoint = points.get(pointIndex);
        double angle = generator.nextDouble() * Math.PI * 2.0 - Math.PI;
        double maxArcDistance = points.get(0).arcDistance(points.get(1));
        double trialArcDistance = points.get(0).arcDistance(points.get(2));
        if (trialArcDistance > maxArcDistance) {
            maxArcDistance = trialArcDistance;
        }
        double arcDistance = maxArcDistance - generator.nextDouble() * maxArcDistance;
        double x = Math.cos(arcDistance);
        double sinArcDistance = Math.sin(arcDistance);
        double y = Math.cos(angle) * sinArcDistance;
        double z = Math.sin(angle) * sinArcDistance;
        double sinLatitude = Math.sin(closePoint.getLatitude());
        double cosLatitude = Math.cos(closePoint.getLatitude());
        double sinLongitude = Math.sin(closePoint.getLongitude());
        double cosLongitude = Math.cos(closePoint.getLongitude());
        double x1 = x * cosLatitude - z * sinLatitude;
        double y1 = y;
        double z1 = x * sinLatitude + z * cosLatitude;
        double x2 = x1 * cosLongitude - y1 * sinLongitude;
        double y2 = x1 * sinLongitude + y1 * cosLongitude;
        double z2 = z1;
        return planetModel.createSurfacePoint(x2, y2, z2);
    }

    private static Boolean isInsidePolygon(GeoPoint point, List<GeoPoint> polyPoints) {
        double latitude = point.getLatitude();
        double longitude = point.getLongitude();
        double sinLatitude = Math.sin(latitude);
        double cosLatitude = Math.cos(latitude);
        double sinLongitude = Math.sin(longitude);
        double cosLongitude = Math.cos(longitude);
        double arcDistance = 0.0;
        Double prevAngle = null;
        for (GeoPoint polyPoint : polyPoints) {
            Double angle = GeoPolygonFactory.computeAngle(polyPoint, sinLatitude, cosLatitude, sinLongitude, cosLongitude);
            if (angle == null) {
                return null;
            }
            if (prevAngle != null) {
                double angleDelta = angle - prevAngle;
                if (angleDelta < -Math.PI) {
                    angleDelta += Math.PI * 2;
                }
                if (angleDelta > Math.PI) {
                    angleDelta -= Math.PI * 2;
                }
                if (Math.abs(angleDelta - Math.PI) < 3.141592653589793E-12) {
                    return null;
                }
                arcDistance += angleDelta;
            }
            prevAngle = angle;
        }
        if (prevAngle != null) {
            Double lastAngle = GeoPolygonFactory.computeAngle(polyPoints.get(0), sinLatitude, cosLatitude, sinLongitude, cosLongitude);
            if (lastAngle == null) {
                return null;
            }
            double angleDelta = lastAngle - prevAngle;
            if (angleDelta < -Math.PI) {
                angleDelta += Math.PI * 2;
            }
            if (angleDelta > Math.PI) {
                angleDelta -= Math.PI * 2;
            }
            if (Math.abs(angleDelta - Math.PI) < 3.141592653589793E-12) {
                return null;
            }
            arcDistance += angleDelta;
        }
        if (Math.abs(arcDistance) < 3.141592653589793E-12) {
            return null;
        }
        return arcDistance > 0.0;
    }

    private static Double computeAngle(GeoPoint point, double sinLatitude, double cosLatitude, double sinLongitude, double cosLongitude) {
        double y1 = -point.x * sinLongitude + point.y * cosLongitude;
        double y2 = y1;
        double x1 = point.x * cosLongitude + point.y * sinLongitude;
        double z1 = point.z;
        double z2 = -x1 * sinLatitude + z1 * cosLatitude;
        if (Math.sqrt(y2 * y2 + z2 * z2) < 1.0E-12) {
            return null;
        }
        return Math.atan2(z2, y2);
    }

    static boolean buildPolygonShape(GeoCompositePolygon rval, MutableBoolean seenConcave, PlanetModel planetModel, List<GeoPoint> pointsList, BitSet internalEdges, int startPointIndex, int endPointIndex, SidedPlane startingEdge, List<GeoPolygon> holes, GeoPoint testPoint) {
        Edge stoppingPoint;
        EdgeBuffer edgeBuffer = new EdgeBuffer(pointsList, internalEdges, startPointIndex, endPointIndex, startingEdge);
        Edge currentEdge = stoppingPoint = edgeBuffer.pickOne();
        while (currentEdge != null) {
            Boolean foundIt = GeoPolygonFactory.findConvexPolygon(planetModel, currentEdge, rval, edgeBuffer, holes, testPoint);
            if (foundIt == null) {
                return false;
            }
            if (foundIt.booleanValue()) {
                currentEdge = stoppingPoint = edgeBuffer.pickOne();
                continue;
            }
            if ((currentEdge = edgeBuffer.getNext(currentEdge)) != stoppingPoint) continue;
            break;
        }
        Iterator<Edge> checkIterator = edgeBuffer.iterator();
        while (checkIterator.hasNext()) {
            Edge checkEdge = checkIterator.next();
            SidedPlane flippedPlane = new SidedPlane(checkEdge.plane);
            Iterator<Edge> confirmIterator = edgeBuffer.iterator();
            while (confirmIterator.hasNext()) {
                GeoPoint thePoint;
                Edge confirmEdge = confirmIterator.next();
                if (confirmEdge == checkEdge || (thePoint = checkEdge.startPoint != confirmEdge.startPoint && checkEdge.endPoint != confirmEdge.startPoint && !flippedPlane.isWithin(confirmEdge.startPoint) ? confirmEdge.startPoint : (checkEdge.startPoint != confirmEdge.endPoint && checkEdge.endPoint != confirmEdge.endPoint && !flippedPlane.isWithin(confirmEdge.endPoint) ? confirmEdge.endPoint : null)) == null) continue;
                ArrayList<GeoPoint> thirdPartPoints = new ArrayList<GeoPoint>(3);
                BitSet thirdPartInternal = new BitSet();
                thirdPartPoints.add(checkEdge.startPoint);
                thirdPartInternal.set(0, checkEdge.isInternal);
                thirdPartPoints.add(checkEdge.endPoint);
                thirdPartInternal.set(1, true);
                thirdPartPoints.add(thePoint);
                assert (checkEdge.plane.isWithin(thePoint)) : "Point was on wrong side of complementary plane, so must be on the right side of the non-complementary plane!";
                GeoConvexPolygon convexPart = new GeoConvexPolygon(planetModel, thirdPartPoints, holes, thirdPartInternal, true);
                rval.addShape(convexPart);
                Edge loopEdge = edgeBuffer.getPrevious(checkEdge);
                ArrayList<GeoPoint> firstPartPoints = new ArrayList<GeoPoint>();
                BitSet firstPartInternal = new BitSet();
                int i = 0;
                while (true) {
                    firstPartPoints.add(loopEdge.endPoint);
                    if (loopEdge.endPoint == thePoint) break;
                    firstPartInternal.set(i++, loopEdge.isInternal);
                    loopEdge = edgeBuffer.getPrevious(loopEdge);
                }
                firstPartInternal.set(i, true);
                if (!GeoPolygonFactory.buildPolygonShape(rval, seenConcave, planetModel, firstPartPoints, firstPartInternal, firstPartPoints.size() - 1, 0, new SidedPlane((Vector)checkEdge.endPoint, false, checkEdge.startPoint, thePoint), holes, testPoint)) {
                    return false;
                }
                ArrayList<GeoPoint> secondPartPoints = new ArrayList<GeoPoint>();
                BitSet secondPartInternal = new BitSet();
                loopEdge = edgeBuffer.getNext(checkEdge);
                i = 0;
                while (true) {
                    secondPartPoints.add(loopEdge.startPoint);
                    if (loopEdge.startPoint == thePoint) break;
                    secondPartInternal.set(i++, loopEdge.isInternal);
                    loopEdge = edgeBuffer.getNext(loopEdge);
                }
                secondPartInternal.set(i, true);
                return GeoPolygonFactory.buildPolygonShape(rval, seenConcave, planetModel, secondPartPoints, secondPartInternal, secondPartPoints.size() - 1, 0, new SidedPlane((Vector)checkEdge.startPoint, false, checkEdge.endPoint, thePoint), holes, testPoint);
            }
        }
        return GeoPolygonFactory.makeConcavePolygon(planetModel, rval, seenConcave, edgeBuffer, holes, testPoint);
    }

    private static boolean makeConcavePolygon(PlanetModel planetModel, GeoCompositePolygon rval, MutableBoolean seenConcave, EdgeBuffer edgeBuffer, List<GeoPolygon> holes, GeoPoint testPoint) {
        GeoConcavePolygon testPolygon;
        if (edgeBuffer.size() == 0) {
            return true;
        }
        if (seenConcave.value) {
            throw new IllegalArgumentException("Illegal polygon; polygon edges intersect each other");
        }
        seenConcave.value = true;
        if (edgeBuffer.size() < 3) {
            throw new IllegalArgumentException("Illegal polygon; polygon edges intersect each other");
        }
        ArrayList<GeoPoint> points = new ArrayList<GeoPoint>(edgeBuffer.size());
        BitSet internalEdges = new BitSet(edgeBuffer.size() - 1);
        Edge edge = edgeBuffer.pickOne();
        boolean isInternal = false;
        for (int i = 0; i < edgeBuffer.size(); ++i) {
            points.add(edge.startPoint);
            if (i < edgeBuffer.size() - 1) {
                internalEdges.set(i, edge.isInternal);
            } else {
                isInternal = edge.isInternal;
            }
            edge = edgeBuffer.getNext(edge);
        }
        if (testPoint != null && holes != null && holes.size() > 0 && (testPolygon = new GeoConcavePolygon(planetModel, points, null, internalEdges, isInternal)).isWithin(testPoint)) {
            return false;
        }
        GeoConcavePolygon realPolygon = new GeoConcavePolygon(planetModel, points, holes, internalEdges, isInternal);
        if (testPoint != null && (holes == null || holes.size() == 0) && realPolygon.isWithin(testPoint)) {
            return false;
        }
        rval.addShape(realPolygon);
        return true;
    }

    private static Boolean findConvexPolygon(PlanetModel planetModel, Edge currentEdge, GeoCompositePolygon rval, EdgeBuffer edgeBuffer, List<GeoPolygon> holes, GeoPoint testPoint) {
        GeoConvexPolygon testPolygon;
        boolean returnIsInternal;
        Edge edge;
        Iterator<Edge> edgeIterator;
        boolean foundPointInside;
        SidedPlane returnBoundary;
        HashSet<Edge> includedEdges = new HashSet<Edge>();
        includedEdges.add(currentEdge);
        Edge firstEdge = currentEdge;
        Edge lastEdge = currentEdge;
        while (firstEdge.startPoint != lastEdge.endPoint) {
            Edge newLastEdge = edgeBuffer.getNext(lastEdge);
            if (!GeoPolygonFactory.isWithin(newLastEdge.endPoint, includedEdges)) break;
            returnBoundary = firstEdge.startPoint != newLastEdge.endPoint ? new SidedPlane((Vector)firstEdge.endPoint, (Vector)firstEdge.startPoint, newLastEdge.endPoint) : null;
            foundPointInside = false;
            edgeIterator = edgeBuffer.iterator();
            while (edgeIterator.hasNext()) {
                edge = edgeIterator.next();
                if (includedEdges.contains(edge) || edge == newLastEdge) continue;
                if (edge.startPoint != newLastEdge.endPoint && GeoPolygonFactory.isWithin(edge.startPoint, includedEdges, newLastEdge, returnBoundary)) {
                    foundPointInside = true;
                    break;
                }
                if (edge.endPoint == firstEdge.startPoint || !GeoPolygonFactory.isWithin(edge.endPoint, includedEdges, newLastEdge, returnBoundary)) continue;
                foundPointInside = true;
                break;
            }
            if (foundPointInside) break;
            includedEdges.add(newLastEdge);
            lastEdge = newLastEdge;
        }
        while (firstEdge.startPoint != lastEdge.endPoint) {
            Edge newFirstEdge = edgeBuffer.getPrevious(firstEdge);
            if (!GeoPolygonFactory.isWithin(newFirstEdge.startPoint, includedEdges)) break;
            returnBoundary = newFirstEdge.startPoint != lastEdge.endPoint ? new SidedPlane((Vector)lastEdge.startPoint, (Vector)lastEdge.endPoint, newFirstEdge.startPoint) : null;
            foundPointInside = false;
            edgeIterator = edgeBuffer.iterator();
            while (edgeIterator.hasNext()) {
                edge = edgeIterator.next();
                if (includedEdges.contains(edge) || edge == newFirstEdge) continue;
                if (edge.startPoint != lastEdge.endPoint && GeoPolygonFactory.isWithin(edge.startPoint, includedEdges, newFirstEdge, returnBoundary)) {
                    foundPointInside = true;
                    break;
                }
                if (edge.endPoint == newFirstEdge.startPoint || !GeoPolygonFactory.isWithin(edge.endPoint, includedEdges, newFirstEdge, returnBoundary)) continue;
                foundPointInside = true;
                break;
            }
            if (foundPointInside) break;
            includedEdges.add(newFirstEdge);
            firstEdge = newFirstEdge;
        }
        if (includedEdges.size() < 2) {
            return false;
        }
        ArrayList<GeoPoint> points = new ArrayList<GeoPoint>(includedEdges.size() + 1);
        BitSet internalEdges = new BitSet(includedEdges.size());
        if (firstEdge.startPoint == lastEdge.endPoint) {
            if (includedEdges.size() < 3) {
                return false;
            }
            Edge edge2 = firstEdge;
            points.add(edge2.startPoint);
            int k = 0;
            while (edge2 != lastEdge) {
                points.add(edge2.endPoint);
                internalEdges.set(k++, edge2.isInternal);
                edge2 = edgeBuffer.getNext(edge2);
            }
            returnIsInternal = lastEdge.isInternal;
            for (int i = 0; i < points.size(); ++i) {
                GeoPoint start = (GeoPoint)points.get(i);
                GeoPoint end = (GeoPoint)points.get(GeoPolygonFactory.getLegalIndex(i + 1, points.size()));
                Plane planeToFind = new Plane((Vector)start, end);
                int endPointIndex = -1;
                for (int j = 0; j < points.size(); ++j) {
                    int index = GeoPolygonFactory.getLegalIndex(j + i + 2, points.size());
                    if (planeToFind.evaluateIsZero((Vector)points.get(index))) continue;
                    endPointIndex = index;
                    break;
                }
                if (endPointIndex != -1) continue;
                return false;
            }
            edgeBuffer.clear();
        } else {
            SidedPlane returnSidedPlane = new SidedPlane((Vector)firstEdge.endPoint, false, firstEdge.startPoint, lastEdge.endPoint);
            Edge returnEdge = new Edge(firstEdge.startPoint, lastEdge.endPoint, returnSidedPlane, true);
            ArrayList<Edge> edges = new ArrayList<Edge>(includedEdges.size());
            returnIsInternal = true;
            Edge edge3 = firstEdge;
            points.add(edge3.startPoint);
            int k = 0;
            while (true) {
                points.add(edge3.endPoint);
                internalEdges.set(k++, edge3.isInternal);
                edges.add(edge3);
                if (edge3 == lastEdge) break;
                edge3 = edgeBuffer.getNext(edge3);
            }
            for (int i = 0; i < points.size(); ++i) {
                GeoPoint start = (GeoPoint)points.get(i);
                GeoPoint end = (GeoPoint)points.get(GeoPolygonFactory.getLegalIndex(i + 1, points.size()));
                Plane planeToFind = new Plane((Vector)start, end);
                int endPointIndex = -1;
                for (int j = 0; j < points.size(); ++j) {
                    int index = GeoPolygonFactory.getLegalIndex(j + i + 2, points.size());
                    if (planeToFind.evaluateIsZero((Vector)points.get(index))) continue;
                    endPointIndex = index;
                    break;
                }
                if (endPointIndex != -1) continue;
                return false;
            }
            edgeBuffer.replace(edges, returnEdge);
        }
        if (testPoint != null && holes != null && holes.size() > 0 && (testPolygon = new GeoConvexPolygon(planetModel, points, null, internalEdges, returnIsInternal)).isWithin(testPoint)) {
            return null;
        }
        GeoConvexPolygon realPolygon = new GeoConvexPolygon(planetModel, points, holes, internalEdges, returnIsInternal);
        if (testPoint != null && (holes == null || holes.size() == 0) && realPolygon.isWithin(testPoint)) {
            return null;
        }
        rval.addShape(realPolygon);
        return true;
    }

    private static boolean isWithin(GeoPoint point, Set<Edge> edgeSet, Edge extension, SidedPlane returnBoundary) {
        if (!extension.plane.isWithin(point)) {
            return false;
        }
        if (returnBoundary != null && !returnBoundary.isWithin(point)) {
            return false;
        }
        return GeoPolygonFactory.isWithin(point, edgeSet);
    }

    private static boolean isWithin(GeoPoint point, Set<Edge> edgeSet) {
        for (Edge edge : edgeSet) {
            if (edge.plane.isWithin(point)) continue;
            return false;
        }
        return true;
    }

    private static int getLegalIndex(int index, int size) {
        while (index < 0) {
            index += size;
        }
        while (index >= size) {
            index -= size;
        }
        return index;
    }

    static class MutableBoolean {
        public boolean value = false;

        MutableBoolean() {
        }
    }

    private static class SafePath {
        public final GeoPoint lastPoint;
        public final int lastPointIndex;
        public final Plane lastPlane;
        public final SafePath previous;

        public SafePath(SafePath previous, GeoPoint lastPoint, int lastPointIndex, Plane lastPlane) {
            this.lastPoint = lastPoint;
            this.lastPointIndex = lastPointIndex;
            this.lastPlane = lastPlane;
            this.previous = previous;
        }

        public SafePath findFirstEndpoint() {
            if (this.previous == null) {
                return null;
            }
            if (this.previous.previous == null) {
                return this;
            }
            return this.previous.findFirstEndpoint();
        }

        public void fillInList(List<GeoPoint> pointList) {
            if (this.previous != null) {
                this.previous.fillInList(pointList);
            }
            pointList.add(this.lastPoint);
        }
    }

    private static class EdgeBuffer {
        protected Edge oneEdge;
        protected final Set<Edge> edges = new HashSet<Edge>();
        protected final Map<Edge, Edge> previousEdges = new HashMap<Edge, Edge>();
        protected final Map<Edge, Edge> nextEdges = new HashMap<Edge, Edge>();

        public EdgeBuffer(List<GeoPoint> pointList, BitSet internalEdges, int startPlaneStartIndex, int startPlaneEndIndex, SidedPlane startPlane) {
            Edge startEdge;
            Edge currentEdge = startEdge = new Edge(pointList.get(startPlaneStartIndex), pointList.get(startPlaneEndIndex), startPlane, internalEdges.get(startPlaneStartIndex));
            int startIndex = startPlaneStartIndex;
            int endIndex = startPlaneEndIndex;
            while (true) {
                if (currentEdge.endPoint == startEdge.startPoint) break;
                startIndex = endIndex++;
                if (endIndex >= pointList.size()) {
                    endIndex -= pointList.size();
                }
                GeoPoint newPoint = pointList.get(endIndex);
                boolean isNewPointWithin = currentEdge.plane.isWithin(newPoint);
                GeoPoint pointToPresent = currentEdge.startPoint;
                SidedPlane newPlane = new SidedPlane((Vector)pointToPresent, isNewPointWithin, pointList.get(startIndex), newPoint);
                Edge newEdge = new Edge(pointList.get(startIndex), pointList.get(endIndex), newPlane, internalEdges.get(startIndex));
                this.previousEdges.put(newEdge, currentEdge);
                this.nextEdges.put(currentEdge, newEdge);
                this.edges.add(newEdge);
                currentEdge = newEdge;
            }
            this.previousEdges.put(startEdge, currentEdge);
            this.nextEdges.put(currentEdge, startEdge);
            this.edges.add(startEdge);
            this.oneEdge = startEdge;
        }

        public Edge getPrevious(Edge currentEdge) {
            return this.previousEdges.get(currentEdge);
        }

        public Edge getNext(Edge currentEdge) {
            return this.nextEdges.get(currentEdge);
        }

        public void replace(List<Edge> removeList, Edge newEdge) {
            Edge previous = this.previousEdges.get(removeList.get(0));
            Edge next = this.nextEdges.get(removeList.get(removeList.size() - 1));
            this.edges.add(newEdge);
            this.previousEdges.put(newEdge, previous);
            this.nextEdges.put(previous, newEdge);
            this.previousEdges.put(next, newEdge);
            this.nextEdges.put(newEdge, next);
            for (Edge edge : removeList) {
                if (edge == this.oneEdge) {
                    this.oneEdge = newEdge;
                }
                this.edges.remove(edge);
                this.previousEdges.remove(edge);
                this.nextEdges.remove(edge);
            }
        }

        public void clear() {
            this.edges.clear();
            this.previousEdges.clear();
            this.nextEdges.clear();
            this.oneEdge = null;
        }

        public int size() {
            return this.edges.size();
        }

        public Iterator<Edge> iterator() {
            return new EdgeBufferIterator(this);
        }

        public Edge pickOne() {
            return this.oneEdge;
        }
    }

    private static class EdgeBufferIterator
    implements Iterator<Edge> {
        protected final EdgeBuffer edgeBuffer;
        protected final Edge firstEdge;
        protected Edge currentEdge;

        public EdgeBufferIterator(EdgeBuffer edgeBuffer) {
            this.edgeBuffer = edgeBuffer;
            this.firstEdge = this.currentEdge = edgeBuffer.pickOne();
        }

        @Override
        public boolean hasNext() {
            return this.currentEdge != null;
        }

        @Override
        public Edge next() {
            Edge rval = this.currentEdge;
            if (this.currentEdge != null) {
                this.currentEdge = this.edgeBuffer.getNext(this.currentEdge);
                if (this.currentEdge == this.firstEdge) {
                    this.currentEdge = null;
                }
            }
            return rval;
        }

        @Override
        public void remove() {
            throw new RuntimeException("Unsupported operation");
        }
    }

    private static class Edge {
        public final SidedPlane plane;
        public final GeoPoint startPoint;
        public final GeoPoint endPoint;
        public final boolean isInternal;

        public Edge(GeoPoint startPoint, GeoPoint endPoint, SidedPlane plane, boolean isInternal) {
            this.startPoint = startPoint;
            this.endPoint = endPoint;
            this.plane = plane;
            this.isInternal = isInternal;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public boolean equals(Object o) {
            return o == this;
        }
    }

    private static class BestShape {
        public final List<GeoPoint> points;
        public boolean poleMustBeInside;

        public BestShape(List<GeoPoint> points, boolean poleMustBeInside) {
            this.points = points;
            this.poleMustBeInside = poleMustBeInside;
        }
    }

    public static class PolygonDescription {
        public final List<? extends GeoPoint> points;
        public final List<? extends PolygonDescription> holes;

        public PolygonDescription(List<? extends GeoPoint> points) {
            this(points, new ArrayList());
        }

        public PolygonDescription(List<? extends GeoPoint> points, List<? extends PolygonDescription> holes) {
            this.points = points;
            this.holes = holes;
        }
    }
}

