/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.analysis.FieldNameAnalyzer;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentMapperForType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.percolator.PercolateQuery;
import org.elasticsearch.percolator.PercolatorFieldMapper;

public class PercolateQueryBuilder
extends AbstractQueryBuilder<PercolateQueryBuilder> {
    public static final String NAME = "percolate";
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(ParseField.class));
    static final ParseField DOCUMENT_FIELD = new ParseField("document", new String[0]);
    private static final ParseField QUERY_FIELD = new ParseField("field", new String[0]);
    private static final ParseField DOCUMENT_TYPE_FIELD = new ParseField("document_type", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_INDEX = new ParseField("index", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_TYPE = new ParseField("type", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_ID = new ParseField("id", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_ROUTING = new ParseField("routing", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_PREFERENCE = new ParseField("preference", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_VERSION = new ParseField("version", new String[0]);
    private final String field;
    @Deprecated
    private final String documentType;
    private final BytesReference document;
    private final XContentType documentXContentType;
    private final String indexedDocumentIndex;
    private final String indexedDocumentType;
    private final String indexedDocumentId;
    private final String indexedDocumentRouting;
    private final String indexedDocumentPreference;
    private final Long indexedDocumentVersion;
    private final Supplier<BytesReference> documentSupplier;

    @Deprecated
    public PercolateQueryBuilder(String field, String documentType, BytesReference document) {
        this(field, documentType, document, XContentFactory.xContentType((BytesReference)document));
    }

    public PercolateQueryBuilder(String field, BytesReference document, XContentType documentXContentType) {
        this(field, null, document, documentXContentType);
    }

    @Deprecated
    public PercolateQueryBuilder(String field, String documentType, BytesReference document, XContentType documentXContentType) {
        if (field == null) {
            throw new IllegalArgumentException("[field] is a required argument");
        }
        if (document == null) {
            throw new IllegalArgumentException("[document] is a required argument");
        }
        this.field = field;
        this.documentType = documentType;
        this.document = document;
        this.documentXContentType = Objects.requireNonNull(documentXContentType);
        this.indexedDocumentIndex = null;
        this.indexedDocumentType = null;
        this.indexedDocumentId = null;
        this.indexedDocumentRouting = null;
        this.indexedDocumentPreference = null;
        this.indexedDocumentVersion = null;
        this.documentSupplier = null;
    }

    private PercolateQueryBuilder(String field, String documentType, Supplier<BytesReference> documentSupplier) {
        if (field == null) {
            throw new IllegalArgumentException("[field] is a required argument");
        }
        this.field = field;
        this.documentType = documentType;
        this.document = null;
        this.documentXContentType = null;
        this.documentSupplier = documentSupplier;
        this.indexedDocumentIndex = null;
        this.indexedDocumentType = null;
        this.indexedDocumentId = null;
        this.indexedDocumentRouting = null;
        this.indexedDocumentPreference = null;
        this.indexedDocumentVersion = null;
    }

    public PercolateQueryBuilder(String field, String indexedDocumentIndex, String indexedDocumentType, String indexedDocumentId, String indexedDocumentRouting, String indexedDocumentPreference, Long indexedDocumentVersion) {
        this(field, null, indexedDocumentIndex, indexedDocumentType, indexedDocumentId, indexedDocumentRouting, indexedDocumentPreference, indexedDocumentVersion);
    }

    @Deprecated
    public PercolateQueryBuilder(String field, String documentType, String indexedDocumentIndex, String indexedDocumentType, String indexedDocumentId, String indexedDocumentRouting, String indexedDocumentPreference, Long indexedDocumentVersion) {
        if (field == null) {
            throw new IllegalArgumentException("[field] is a required argument");
        }
        if (indexedDocumentIndex == null) {
            throw new IllegalArgumentException("[index] is a required argument");
        }
        if (indexedDocumentType == null) {
            throw new IllegalArgumentException("[type] is a required argument");
        }
        if (indexedDocumentId == null) {
            throw new IllegalArgumentException("[id] is a required argument");
        }
        this.field = field;
        this.documentType = documentType;
        this.indexedDocumentIndex = indexedDocumentIndex;
        this.indexedDocumentType = indexedDocumentType;
        this.indexedDocumentId = indexedDocumentId;
        this.indexedDocumentRouting = indexedDocumentRouting;
        this.indexedDocumentPreference = indexedDocumentPreference;
        this.indexedDocumentVersion = indexedDocumentVersion;
        this.document = null;
        this.documentXContentType = null;
        this.documentSupplier = null;
    }

    PercolateQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.field = in.readString();
        this.documentType = in.getVersion().before(Version.V_6_0_0_beta1) ? in.readString() : in.readOptionalString();
        this.indexedDocumentIndex = in.readOptionalString();
        this.indexedDocumentType = in.readOptionalString();
        this.indexedDocumentId = in.readOptionalString();
        this.indexedDocumentRouting = in.readOptionalString();
        this.indexedDocumentPreference = in.readOptionalString();
        this.indexedDocumentVersion = in.readBoolean() ? Long.valueOf(in.readVLong()) : null;
        this.document = in.readOptionalBytesReference();
        this.documentXContentType = this.document != null ? (in.getVersion().onOrAfter(Version.V_5_3_0) ? XContentType.readFrom((StreamInput)in) : XContentFactory.xContentType((BytesReference)this.document)) : null;
        this.documentSupplier = null;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        if (this.documentSupplier != null) {
            throw new IllegalStateException("supplier must be null, can't serialize suppliers, missing a rewriteAndFetch?");
        }
        out.writeString(this.field);
        if (out.getVersion().before(Version.V_6_0_0_beta1)) {
            out.writeString(this.documentType);
        } else {
            out.writeOptionalString(this.documentType);
        }
        out.writeOptionalString(this.indexedDocumentIndex);
        out.writeOptionalString(this.indexedDocumentType);
        out.writeOptionalString(this.indexedDocumentId);
        out.writeOptionalString(this.indexedDocumentRouting);
        out.writeOptionalString(this.indexedDocumentPreference);
        if (this.indexedDocumentVersion != null) {
            out.writeBoolean(true);
            out.writeVLong(this.indexedDocumentVersion.longValue());
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalBytesReference(this.document);
        if (this.document != null && out.getVersion().onOrAfter(Version.V_5_3_0)) {
            this.documentXContentType.writeTo(out);
        }
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(DOCUMENT_TYPE_FIELD.getPreferredName(), this.documentType);
        builder.field(QUERY_FIELD.getPreferredName(), this.field);
        if (this.document != null) {
            builder.rawField(DOCUMENT_FIELD.getPreferredName(), this.document);
        }
        if (this.indexedDocumentIndex != null || this.indexedDocumentType != null || this.indexedDocumentId != null) {
            if (this.indexedDocumentIndex != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_INDEX.getPreferredName(), this.indexedDocumentIndex);
            }
            if (this.indexedDocumentType != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_TYPE.getPreferredName(), this.indexedDocumentType);
            }
            if (this.indexedDocumentId != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_ID.getPreferredName(), this.indexedDocumentId);
            }
            if (this.indexedDocumentRouting != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_ROUTING.getPreferredName(), this.indexedDocumentRouting);
            }
            if (this.indexedDocumentPreference != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_PREFERENCE.getPreferredName(), this.indexedDocumentPreference);
            }
            if (this.indexedDocumentVersion != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_VERSION.getPreferredName(), this.indexedDocumentVersion);
            }
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static PercolateQueryBuilder fromXContent(XContentParser parser) throws IOException {
        PercolateQueryBuilder queryBuilder;
        XContentParser.Token token;
        float boost = 1.0f;
        String field = null;
        String documentType = null;
        String indexedDocumentIndex = null;
        String indexedDocumentType = null;
        String indexedDocumentId = null;
        String indexedDocumentRouting = null;
        String indexedDocumentPreference = null;
        Long indexedDocumentVersion = null;
        BytesReference source = null;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (DOCUMENT_FIELD.match(currentFieldName)) {
                    XContentBuilder builder = XContentFactory.jsonBuilder();
                    Throwable throwable = null;
                    try {
                        builder.copyCurrentStructure(parser);
                        builder.flush();
                        source = builder.bytes();
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (builder == null) continue;
                        if (throwable != null) {
                            try {
                                builder.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        builder.close();
                        continue;
                    }
                }
                throw new ParsingException(parser.getTokenLocation(), "[percolate] query does not support [" + token + "]", new Object[0]);
            }
            if (token.isValue() || token == XContentParser.Token.VALUE_NULL) {
                if (QUERY_FIELD.match(currentFieldName)) {
                    field = parser.text();
                    continue;
                }
                if (DOCUMENT_TYPE_FIELD.match(currentFieldName)) {
                    documentType = parser.textOrNull();
                    continue;
                }
                if (INDEXED_DOCUMENT_FIELD_INDEX.match(currentFieldName)) {
                    indexedDocumentIndex = parser.text();
                    continue;
                }
                if (INDEXED_DOCUMENT_FIELD_TYPE.match(currentFieldName)) {
                    indexedDocumentType = parser.text();
                    continue;
                }
                if (INDEXED_DOCUMENT_FIELD_ID.match(currentFieldName)) {
                    indexedDocumentId = parser.text();
                    continue;
                }
                if (INDEXED_DOCUMENT_FIELD_ROUTING.match(currentFieldName)) {
                    indexedDocumentRouting = parser.text();
                    continue;
                }
                if (INDEXED_DOCUMENT_FIELD_PREFERENCE.match(currentFieldName)) {
                    indexedDocumentPreference = parser.text();
                    continue;
                }
                if (INDEXED_DOCUMENT_FIELD_VERSION.match(currentFieldName)) {
                    indexedDocumentVersion = parser.longValue();
                    continue;
                }
                if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName)) {
                    boost = parser.floatValue();
                    continue;
                }
                if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName)) {
                    queryName = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[percolate] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[percolate] query does not support [" + token + "]", new Object[0]);
        }
        if (source != null) {
            queryBuilder = new PercolateQueryBuilder(field, documentType, source, XContentType.JSON);
        } else if (indexedDocumentId != null) {
            queryBuilder = new PercolateQueryBuilder(field, documentType, indexedDocumentIndex, indexedDocumentType, indexedDocumentId, indexedDocumentRouting, indexedDocumentPreference, indexedDocumentVersion);
        } else {
            throw new IllegalArgumentException("[percolate] query, nothing to percolate");
        }
        queryBuilder.queryName(queryName);
        queryBuilder.boost(boost);
        return queryBuilder;
    }

    protected boolean doEquals(PercolateQueryBuilder other) {
        return Objects.equals(this.field, other.field) && Objects.equals(this.documentType, other.documentType) && Objects.equals(this.document, other.document) && Objects.equals(this.indexedDocumentIndex, other.indexedDocumentIndex) && Objects.equals(this.indexedDocumentType, other.indexedDocumentType) && Objects.equals(this.documentSupplier, other.documentSupplier) && Objects.equals(this.indexedDocumentId, other.indexedDocumentId);
    }

    protected int doHashCode() {
        return Objects.hash(this.field, this.documentType, this.document, this.indexedDocumentIndex, this.indexedDocumentType, this.indexedDocumentId, this.documentSupplier);
    }

    public String getWriteableName() {
        return NAME;
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryShardContext) {
        if (this.document != null) {
            return this;
        }
        if (this.documentSupplier != null) {
            BytesReference source = this.documentSupplier.get();
            if (source == null) {
                return this;
            }
            return new PercolateQueryBuilder(this.field, this.documentType, source, XContentFactory.xContentType((BytesReference)source));
        }
        GetRequest getRequest = new GetRequest(this.indexedDocumentIndex, this.indexedDocumentType, this.indexedDocumentId);
        getRequest.preference("_local");
        getRequest.routing(this.indexedDocumentRouting);
        getRequest.preference(this.indexedDocumentPreference);
        if (this.indexedDocumentVersion != null) {
            getRequest.version(this.indexedDocumentVersion.longValue());
        }
        SetOnce documentSupplier = new SetOnce();
        queryShardContext.registerAsyncAction((client, listener) -> client.get(getRequest, ActionListener.wrap(getResponse -> {
            if (!getResponse.isExists()) {
                throw new ResourceNotFoundException("indexed document [{}/{}/{}] couldn't be found", new Object[]{this.indexedDocumentIndex, this.indexedDocumentType, this.indexedDocumentId});
            }
            if (getResponse.isSourceEmpty()) {
                throw new IllegalArgumentException("indexed document [" + this.indexedDocumentIndex + "/" + this.indexedDocumentType + "/" + this.indexedDocumentId + "] source disabled");
            }
            documentSupplier.set((Object)getResponse.getSourceAsBytesRef());
            listener.onResponse(null);
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))));
        return new PercolateQueryBuilder(this.field, this.documentType, () -> ((SetOnce)documentSupplier).get());
    }

    protected Query doToQuery(final QueryShardContext context) throws IOException {
        IndexSearcher docSearcher;
        ParsedDocument doc;
        DocumentMapper docMapper;
        context.nowInMillis();
        if (this.indexedDocumentIndex != null || this.indexedDocumentType != null || this.indexedDocumentId != null || this.documentSupplier != null) {
            throw new IllegalStateException("query builder must be rewritten first");
        }
        if (this.document == null) {
            throw new IllegalStateException("no document to percolate");
        }
        MappedFieldType fieldType = context.fieldMapper(this.field);
        if (fieldType == null) {
            throw new QueryShardException(context, "field [" + this.field + "] does not exist", new Object[0]);
        }
        if (!(fieldType instanceof PercolatorFieldMapper.FieldType)) {
            throw new QueryShardException(context, "expected field [" + this.field + "] to be of type [percolator], but is of type [" + fieldType.typeName() + "]", new Object[0]);
        }
        MapperService mapperService = context.getMapperService();
        if (context.getIndexSettings().isSingleType()) {
            Collection types = mapperService.types();
            if (types.size() != 1) {
                throw new IllegalStateException("Only a single type should exist, but [" + types.size() + " types exists");
            }
            String type = (String)types.iterator().next();
            if (this.documentType != null) {
                DEPRECATION_LOGGER.deprecated("[document_type] parameter has been deprecated because types have been deprecated", new Object[0]);
                if (!this.documentType.equals(type)) {
                    throw new IllegalArgumentException("specified document_type [" + this.documentType + "] is not equal to the actual type [" + type + "]");
                }
            }
            docMapper = mapperService.documentMapper(type);
            doc = docMapper.parse(SourceToParse.source((String)context.index().getName(), (String)type, (String)"_temp_id", (BytesReference)this.document, (XContentType)this.documentXContentType));
        } else {
            if (this.documentType == null) {
                throw new IllegalArgumentException("[percolate] query is missing required [document_type] parameter");
            }
            DocumentMapperForType docMapperForType = mapperService.documentMapperWithAutoCreate(this.documentType);
            docMapper = docMapperForType.getDocumentMapper();
            doc = docMapper.parse(SourceToParse.source((String)context.index().getName(), (String)this.documentType, (String)"_temp_id", (BytesReference)this.document, (XContentType)this.documentXContentType));
        }
        final FieldNameAnalyzer fieldNameAnalyzer = (FieldNameAnalyzer)docMapper.mappers().indexAnalyzer();
        DelegatingAnalyzerWrapper analyzer = new DelegatingAnalyzerWrapper(Analyzer.PER_FIELD_REUSE_STRATEGY){

            protected Analyzer getWrappedAnalyzer(String fieldName) {
                Analyzer analyzer = (Analyzer)fieldNameAnalyzer.analyzers().get(fieldName);
                if (analyzer != null) {
                    return analyzer;
                }
                return context.getIndexAnalyzers().getDefaultIndexAnalyzer();
            }
        };
        if (doc.docs().size() > 1) {
            assert (docMapper.hasNestedObjects());
            docSearcher = PercolateQueryBuilder.createMultiDocumentSearcher((Analyzer)analyzer, doc);
        } else {
            MemoryIndex memoryIndex = MemoryIndex.fromDocument((Iterable)doc.rootDoc(), (Analyzer)analyzer, (boolean)true, (boolean)false);
            docSearcher = memoryIndex.createSearcher();
            docSearcher.setQueryCache(null);
        }
        PercolatorFieldMapper percolatorFieldMapper = (PercolatorFieldMapper)docMapper.mappers().getMapper(this.field);
        boolean mapUnmappedFieldsAsString = percolatorFieldMapper.isMapUnmappedFieldAsText();
        QueryShardContext percolateShardContext = PercolateQueryBuilder.wrap(context);
        PercolatorFieldMapper.FieldType pft = (PercolatorFieldMapper.FieldType)fieldType;
        PercolateQuery.QueryStore queryStore = PercolateQueryBuilder.createStore(pft.queryBuilderField, percolateShardContext, mapUnmappedFieldsAsString);
        return pft.percolateQuery(queryStore, this.document, docSearcher);
    }

    public String getField() {
        return this.field;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public BytesReference getDocument() {
        return this.document;
    }

    XContentType getXContentType() {
        return this.documentXContentType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static IndexSearcher createMultiDocumentSearcher(Analyzer analyzer, ParsedDocument doc) {
        RAMDirectory ramDirectory = new RAMDirectory();
        try (IndexWriter indexWriter = new IndexWriter((Directory)ramDirectory, new IndexWriterConfig(analyzer));){
            indexWriter.addDocuments((Iterable)doc.docs());
            indexWriter.commit();
            DirectoryReader directoryReader = DirectoryReader.open((Directory)ramDirectory);
            assert (directoryReader.leaves().size() == 1) : "Expected single leaf, but got [" + directoryReader.leaves().size() + "]";
            IndexSearcher slowSearcher = new IndexSearcher((IndexReader)directoryReader){

                public Weight createNormalizedWeight(Query query, boolean needsScores) throws IOException {
                    BooleanQuery.Builder bq = new BooleanQuery.Builder();
                    bq.add(query, BooleanClause.Occur.MUST);
                    bq.add(Queries.newNestedFilter(), BooleanClause.Occur.MUST_NOT);
                    return super.createNormalizedWeight((Query)bq.build(), needsScores);
                }
            };
            slowSearcher.setQueryCache(null);
            IndexSearcher indexSearcher = slowSearcher;
            return indexSearcher;
        }
        catch (IOException e) {
            throw new ElasticsearchException("Failed to create index for percolator with nested document ", (Throwable)e, new Object[0]);
        }
    }

    static PercolateQuery.QueryStore createStore(MappedFieldType queryBuilderFieldType, QueryShardContext context, boolean mapUnmappedFieldsAsString) {
        Version indexVersion = context.indexVersionCreated();
        NamedWriteableRegistry registry = context.getWriteableRegistry();
        return ctx -> {
            LeafReader leafReader = ctx.reader();
            BinaryDocValues binaryDocValues = leafReader.getBinaryDocValues(queryBuilderFieldType.name());
            if (binaryDocValues == null) {
                return docId -> null;
            }
            if (indexVersion.onOrAfter(Version.V_6_0_0_beta2)) {
                return docId -> {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.getAnalysis(Method.java:520)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:351)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                };
            }
            return docId -> {
                if (binaryDocValues.advanceExact(docId.intValue())) {
                    BytesRef qbSource = binaryDocValues.binaryValue();
                    if (qbSource.length > 0) {
                        XContent xContent = PercolatorFieldMapper.QUERY_BUILDER_CONTENT_TYPE.xContent();
                        try (XContentParser sourceParser = xContent.createParser(context.getXContentRegistry(), qbSource.bytes, qbSource.offset, qbSource.length);){
                            Query query = PercolatorFieldMapper.parseQuery(context, mapUnmappedFieldsAsString, sourceParser);
                            return query;
                        }
                    }
                    return null;
                }
                return null;
            };
        };
    }

    static QueryShardContext wrap(final QueryShardContext shardContext) {
        return new QueryShardContext(shardContext){

            public BitSetProducer bitsetFilter(Query query) {
                return context -> {
                    IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext((IndexReaderContext)context);
                    IndexSearcher searcher = new IndexSearcher(topLevelContext);
                    searcher.setQueryCache(null);
                    Weight weight = searcher.createNormalizedWeight(query, false);
                    Scorer s = weight.scorer(context);
                    if (s != null) {
                        return new BitDocIdSet(BitSet.of((DocIdSetIterator)s.iterator(), (int)context.reader().maxDoc())).bits();
                    }
                    return null;
                };
            }

            public <IFD extends IndexFieldData<?>> IFD getForField(MappedFieldType fieldType) {
                IndexFieldData.Builder builder = fieldType.fielddataBuilder();
                IndexFieldDataCache.None cache = new IndexFieldDataCache.None();
                NoneCircuitBreakerService circuitBreaker = new NoneCircuitBreakerService();
                return (IFD)builder.build(shardContext.getIndexSettings(), fieldType, (IndexFieldDataCache)cache, (CircuitBreakerService)circuitBreaker, shardContext.getMapperService());
            }
        };
    }
}

