/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SimpleQueryStringFlag;
import org.elasticsearch.index.search.QueryParserHelper;
import org.elasticsearch.index.search.SimpleQueryStringQueryParser;

public class SimpleQueryStringBuilder
extends AbstractQueryBuilder<SimpleQueryStringBuilder> {
    public static final boolean DEFAULT_LENIENT = false;
    public static final boolean DEFAULT_ANALYZE_WILDCARD = false;
    public static final Operator DEFAULT_OPERATOR = Operator.OR;
    public static final int DEFAULT_FLAGS = SimpleQueryStringFlag.ALL.value;
    public static final String NAME = "simple_query_string";
    private static final ParseField MINIMUM_SHOULD_MATCH_FIELD = new ParseField("minimum_should_match", new String[0]);
    private static final ParseField ANALYZE_WILDCARD_FIELD = new ParseField("analyze_wildcard", new String[0]);
    private static final ParseField LENIENT_FIELD = new ParseField("lenient", new String[0]);
    private static final ParseField LOWERCASE_EXPANDED_TERMS_FIELD = new ParseField("lowercase_expanded_terms", new String[0]).withAllDeprecated("Decision is now made by the analyzer");
    private static final ParseField LOCALE_FIELD = new ParseField("locale", new String[0]).withAllDeprecated("Decision is now made by the analyzer");
    private static final ParseField FLAGS_FIELD = new ParseField("flags", new String[0]);
    private static final ParseField DEFAULT_OPERATOR_FIELD = new ParseField("default_operator", new String[0]);
    private static final ParseField ANALYZER_FIELD = new ParseField("analyzer", new String[0]);
    private static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    private static final ParseField FIELDS_FIELD = new ParseField("fields", new String[0]);
    private static final ParseField QUOTE_FIELD_SUFFIX_FIELD = new ParseField("quote_field_suffix", new String[0]);
    private static final ParseField ALL_FIELDS_FIELD = new ParseField("all_fields", new String[0]).withAllDeprecated("Set [fields] to `*` instead");
    private final String queryText;
    private Map<String, Float> fieldsAndWeights = new HashMap<String, Float>();
    private String analyzer;
    private Operator defaultOperator = DEFAULT_OPERATOR;
    private String minimumShouldMatch;
    private int flags = DEFAULT_FLAGS;
    private boolean lenientSet = false;
    private SimpleQueryStringQueryParser.Settings settings = new SimpleQueryStringQueryParser.Settings();

    public SimpleQueryStringBuilder(String queryText) {
        if (queryText == null) {
            throw new IllegalArgumentException("query text missing");
        }
        this.queryText = queryText;
    }

    public SimpleQueryStringBuilder(StreamInput in) throws IOException {
        super(in);
        this.queryText = in.readString();
        int size = in.readInt();
        HashMap<String, Float> fields = new HashMap<String, Float>();
        for (int i = 0; i < size; ++i) {
            String field = in.readString();
            Float weight = Float.valueOf(in.readFloat());
            fields.put(field, weight);
        }
        this.fieldsAndWeights.putAll(fields);
        this.flags = in.readInt();
        this.analyzer = in.readOptionalString();
        this.defaultOperator = Operator.readFromStream(in);
        if (in.getVersion().before(Version.V_5_1_1)) {
            in.readBoolean();
        }
        this.settings.lenient(in.readBoolean());
        if (in.getVersion().onOrAfter(Version.V_5_1_1)) {
            this.lenientSet = in.readBoolean();
        }
        this.settings.analyzeWildcard(in.readBoolean());
        if (in.getVersion().before(Version.V_5_1_1)) {
            in.readString();
        }
        this.minimumShouldMatch = in.readOptionalString();
        if (in.getVersion().onOrAfter(Version.V_5_1_1)) {
            Boolean useAllFields;
            this.settings.quoteFieldSuffix(in.readOptionalString());
            if (in.getVersion().before(Version.V_6_0_0_beta2) && (useAllFields = in.readOptionalBoolean()) != null && useAllFields.booleanValue()) {
                this.useAllFields(true);
            }
        }
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.queryText);
        out.writeInt(this.fieldsAndWeights.size());
        for (Map.Entry<String, Float> entry : this.fieldsAndWeights.entrySet()) {
            out.writeString(entry.getKey());
            out.writeFloat(entry.getValue().floatValue());
        }
        out.writeInt(this.flags);
        out.writeOptionalString(this.analyzer);
        this.defaultOperator.writeTo(out);
        if (out.getVersion().before(Version.V_5_1_1)) {
            out.writeBoolean(true);
        }
        out.writeBoolean(this.settings.lenient());
        if (out.getVersion().onOrAfter(Version.V_5_1_1)) {
            out.writeBoolean(this.lenientSet);
        }
        out.writeBoolean(this.settings.analyzeWildcard());
        if (out.getVersion().before(Version.V_5_1_1)) {
            out.writeString(Locale.ROOT.toLanguageTag());
        }
        out.writeOptionalString(this.minimumShouldMatch);
        if (out.getVersion().onOrAfter(Version.V_5_1_1)) {
            out.writeOptionalString(this.settings.quoteFieldSuffix());
            if (out.getVersion().before(Version.V_6_0_0_beta2)) {
                if (this.useAllFields().booleanValue()) {
                    out.writeOptionalBoolean(true);
                } else {
                    out.writeOptionalBoolean(null);
                }
            }
        }
    }

    public String value() {
        return this.queryText;
    }

    public SimpleQueryStringBuilder field(String field) {
        if (Strings.isEmpty(field)) {
            throw new IllegalArgumentException("supplied field is null or empty");
        }
        this.fieldsAndWeights.put(field, Float.valueOf(1.0f));
        return this;
    }

    public SimpleQueryStringBuilder field(String field, float boost) {
        if (Strings.isEmpty(field)) {
            throw new IllegalArgumentException("supplied field is null or empty");
        }
        this.fieldsAndWeights.put(field, Float.valueOf(boost));
        return this;
    }

    public SimpleQueryStringBuilder fields(Map<String, Float> fields) {
        Objects.requireNonNull(fields, "fields cannot be null");
        this.fieldsAndWeights.putAll(fields);
        return this;
    }

    public Map<String, Float> fields() {
        return this.fieldsAndWeights;
    }

    public SimpleQueryStringBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public String analyzer() {
        return this.analyzer;
    }

    @Deprecated
    public Boolean useAllFields() {
        return this.fieldsAndWeights.size() == 1 && this.fieldsAndWeights.keySet().stream().anyMatch(Regex::isMatchAllPattern);
    }

    @Deprecated
    public SimpleQueryStringBuilder useAllFields(Boolean useAllFields) {
        if (useAllFields != null && useAllFields.booleanValue()) {
            this.fieldsAndWeights = Collections.singletonMap("*", Float.valueOf(1.0f));
        }
        return this;
    }

    public SimpleQueryStringBuilder defaultOperator(Operator defaultOperator) {
        this.defaultOperator = defaultOperator != null ? defaultOperator : DEFAULT_OPERATOR;
        return this;
    }

    public Operator defaultOperator() {
        return this.defaultOperator;
    }

    public SimpleQueryStringBuilder flags(SimpleQueryStringFlag ... flags) {
        if (flags != null && flags.length > 0) {
            int value = 0;
            for (SimpleQueryStringFlag flag : flags) {
                value |= flag.value;
            }
            this.flags = value;
        } else {
            this.flags = DEFAULT_FLAGS;
        }
        return this;
    }

    SimpleQueryStringBuilder flags(int flags) {
        this.flags = flags;
        return this;
    }

    int flags() {
        return this.flags;
    }

    public SimpleQueryStringBuilder quoteFieldSuffix(String suffix) {
        this.settings.quoteFieldSuffix(suffix);
        return this;
    }

    public String quoteFieldSuffix() {
        return this.settings.quoteFieldSuffix();
    }

    public SimpleQueryStringBuilder lenient(boolean lenient) {
        this.settings.lenient(lenient);
        this.lenientSet = true;
        return this;
    }

    public boolean lenient() {
        return this.settings.lenient();
    }

    public SimpleQueryStringBuilder analyzeWildcard(boolean analyzeWildcard) {
        this.settings.analyzeWildcard(analyzeWildcard);
        return this;
    }

    public boolean analyzeWildcard() {
        return this.settings.analyzeWildcard();
    }

    public SimpleQueryStringBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    public String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        SimpleQueryStringQueryParser sqp;
        Map<String, Float> resolvedFieldsAndWeights;
        SimpleQueryStringQueryParser.Settings newSettings = new SimpleQueryStringQueryParser.Settings(this.settings);
        if (!this.fieldsAndWeights.isEmpty()) {
            resolvedFieldsAndWeights = QueryParserHelper.resolveMappingFields(context, this.fieldsAndWeights);
        } else {
            boolean isAllField;
            String defaultField = context.defaultField();
            if (!context.getMapperService().allEnabled() && "_all".equals(defaultField)) {
                defaultField = "*";
            }
            if (isAllField = Regex.isMatchAllPattern(defaultField)) {
                newSettings.lenient(this.lenientSet ? this.settings.lenient() : true);
            }
            resolvedFieldsAndWeights = QueryParserHelper.resolveMappingField(context, defaultField, 1.0f, false, !isAllField);
        }
        if (this.analyzer == null) {
            sqp = new SimpleQueryStringQueryParser(resolvedFieldsAndWeights, this.flags, newSettings, context);
        } else {
            NamedAnalyzer luceneAnalyzer = context.getIndexAnalyzers().get(this.analyzer);
            if (luceneAnalyzer == null) {
                throw new QueryShardException(context, "[simple_query_string] analyzer [" + this.analyzer + "] not found", new Object[0]);
            }
            sqp = new SimpleQueryStringQueryParser((Analyzer)luceneAnalyzer, resolvedFieldsAndWeights, this.flags, newSettings, context);
        }
        sqp.setDefaultOperator(this.defaultOperator.toBooleanClauseOccur());
        Query query = sqp.parse(this.queryText);
        return Queries.maybeApplyMinimumShouldMatch(query, this.minimumShouldMatch);
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(QUERY_FIELD.getPreferredName(), this.queryText);
        if (this.fieldsAndWeights.size() > 0) {
            builder.startArray(FIELDS_FIELD.getPreferredName());
            for (Map.Entry<String, Float> entry : this.fieldsAndWeights.entrySet()) {
                builder.value(entry.getKey() + "^" + entry.getValue());
            }
            builder.endArray();
        }
        if (this.analyzer != null) {
            builder.field(ANALYZER_FIELD.getPreferredName(), this.analyzer);
        }
        builder.field(FLAGS_FIELD.getPreferredName(), this.flags);
        builder.field(DEFAULT_OPERATOR_FIELD.getPreferredName(), this.defaultOperator.name().toLowerCase(Locale.ROOT));
        if (this.lenientSet) {
            builder.field(LENIENT_FIELD.getPreferredName(), this.settings.lenient());
        }
        builder.field(ANALYZE_WILDCARD_FIELD.getPreferredName(), this.settings.analyzeWildcard());
        if (this.settings.quoteFieldSuffix() != null) {
            builder.field(QUOTE_FIELD_SUFFIX_FIELD.getPreferredName(), this.settings.quoteFieldSuffix());
        }
        if (this.minimumShouldMatch != null) {
            builder.field(MINIMUM_SHOULD_MATCH_FIELD.getPreferredName(), this.minimumShouldMatch);
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static SimpleQueryStringBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        String queryBody = null;
        float boost = 1.0f;
        String queryName = null;
        String minimumShouldMatch = null;
        HashMap<String, Float> fieldsAndWeights = new HashMap<String, Float>();
        Operator defaultOperator = null;
        String analyzerName = null;
        int flags = SimpleQueryStringFlag.ALL.value();
        Boolean lenient = null;
        boolean analyzeWildcard = false;
        String quoteFieldSuffix = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (FIELDS_FIELD.match(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        String fField = null;
                        float fBoost = 1.0f;
                        char[] text = parser.textCharacters();
                        int end = parser.textOffset() + parser.textLength();
                        for (int i = parser.textOffset(); i < end; ++i) {
                            if (text[i] != '^') continue;
                            int relativeLocation = i - parser.textOffset();
                            fField = new String(text, parser.textOffset(), relativeLocation);
                            fBoost = Float.parseFloat(new String(text, i + 1, parser.textLength() - relativeLocation - 1));
                            break;
                        }
                        if (fField == null) {
                            fField = parser.text();
                        }
                        fieldsAndWeights.put(fField, Float.valueOf(fBoost));
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[simple_query_string] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token.isValue()) {
                if (QUERY_FIELD.match(currentFieldName)) {
                    queryBody = parser.text();
                    continue;
                }
                if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName)) {
                    boost = parser.floatValue();
                    continue;
                }
                if (ANALYZER_FIELD.match(currentFieldName)) {
                    analyzerName = parser.text();
                    continue;
                }
                if (DEFAULT_OPERATOR_FIELD.match(currentFieldName)) {
                    defaultOperator = Operator.fromString(parser.text());
                    continue;
                }
                if (FLAGS_FIELD.match(currentFieldName)) {
                    if (parser.currentToken() != XContentParser.Token.VALUE_NUMBER) {
                        flags = SimpleQueryStringFlag.resolveFlags(parser.text());
                        continue;
                    }
                    flags = parser.intValue();
                    if (flags >= 0) continue;
                    flags = SimpleQueryStringFlag.ALL.value();
                    continue;
                }
                if (LOCALE_FIELD.match(currentFieldName) || LOWERCASE_EXPANDED_TERMS_FIELD.match(currentFieldName)) continue;
                if (LENIENT_FIELD.match(currentFieldName)) {
                    lenient = parser.booleanValue();
                    continue;
                }
                if (ANALYZE_WILDCARD_FIELD.match(currentFieldName)) {
                    analyzeWildcard = parser.booleanValue();
                    continue;
                }
                if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName)) {
                    queryName = parser.text();
                    continue;
                }
                if (MINIMUM_SHOULD_MATCH_FIELD.match(currentFieldName)) {
                    minimumShouldMatch = parser.textOrNull();
                    continue;
                }
                if (QUOTE_FIELD_SUFFIX_FIELD.match(currentFieldName)) {
                    quoteFieldSuffix = parser.textOrNull();
                    continue;
                }
                if (ALL_FIELDS_FIELD.match(currentFieldName)) continue;
                throw new ParsingException(parser.getTokenLocation(), "[simple_query_string] unsupported field [" + parser.currentName() + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[simple_query_string] unknown token [" + (Object)((Object)token) + "] after [" + currentFieldName + "]", new Object[0]);
        }
        if (queryBody == null) {
            throw new ParsingException(parser.getTokenLocation(), "[simple_query_string] query text missing", new Object[0]);
        }
        SimpleQueryStringBuilder qb = new SimpleQueryStringBuilder(queryBody);
        ((SimpleQueryStringBuilder)((SimpleQueryStringBuilder)qb.boost(boost)).fields(fieldsAndWeights).analyzer(analyzerName).queryName(queryName)).minimumShouldMatch(minimumShouldMatch);
        qb.flags(flags).defaultOperator(defaultOperator);
        if (lenient != null) {
            qb.lenient(lenient);
        }
        ((SimpleQueryStringBuilder)qb.analyzeWildcard(analyzeWildcard).boost(boost)).quoteFieldSuffix(quoteFieldSuffix);
        return qb;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldsAndWeights, this.analyzer, this.defaultOperator, this.queryText, this.minimumShouldMatch, this.settings, this.flags);
    }

    @Override
    protected boolean doEquals(SimpleQueryStringBuilder other) {
        return Objects.equals(this.fieldsAndWeights, other.fieldsAndWeights) && Objects.equals(this.analyzer, other.analyzer) && Objects.equals(this.defaultOperator, other.defaultOperator) && Objects.equals(this.queryText, other.queryText) && Objects.equals(this.minimumShouldMatch, other.minimumShouldMatch) && Objects.equals(this.settings, other.settings) && this.flags == other.flags;
    }
}

