/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.seqno.GlobalCheckpointTracker;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.TransportRequest;

class RecoveryHandoffPrimaryContextRequest
extends TransportRequest {
    private long recoveryId;
    private ShardId shardId;
    private GlobalCheckpointTracker.PrimaryContext primaryContext;

    RecoveryHandoffPrimaryContextRequest() {
    }

    RecoveryHandoffPrimaryContextRequest(long recoveryId, ShardId shardId, GlobalCheckpointTracker.PrimaryContext primaryContext) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.primaryContext = primaryContext;
    }

    long recoveryId() {
        return this.recoveryId;
    }

    ShardId shardId() {
        return this.shardId;
    }

    GlobalCheckpointTracker.PrimaryContext primaryContext() {
        return this.primaryContext;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.recoveryId = in.readLong();
        this.shardId = ShardId.readShardId(in);
        this.primaryContext = new GlobalCheckpointTracker.PrimaryContext(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        this.primaryContext.writeTo(out);
    }

    public String toString() {
        return "RecoveryHandoffPrimaryContextRequest{recoveryId=" + this.recoveryId + ", shardId=" + this.shardId + ", primaryContext=" + this.primaryContext + '}';
    }
}

